pro eis_ccd_temp_header, lu
    printf, lu, 'start_date,end_date,ccda_min,ccda_max,ccda_avg,ccdb_min,ccdb_max,ccdb_avg'
end

;
; dir		(string)	['$HOME/data/status/2007/04/']
; log_file	(string)	['$HOME/work/localdata/log/status/trends/eis_ccd_temp_trend_200704.txt']
; hdr		(unused)
; screen_output	(unsued)
;
pro eis_ccd_temp_trend, dir, log=log_file, hdr=hdr, screen_output=screen_output
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories'
        return
    endif
    using_log = 0
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    if keyword_set(hdr) then begin
        if using_log then eis_ccd_temp_header, lu
    endif
    for d = 0, count-1 do begin
        search_dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(search_dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(search_dir + 'eis_sts1_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then eis_no_data_string, lu, 2
        endif else begin

            p1 = reform(eis_get_daily_data(files,'CCDA_TEMP',1,3,maxp2,minp2,stim,etim))
            p2 = reform(eis_get_daily_data(files,'CCDB_TEMP',2,3,maxp3,minp3))

            ccda_min = eis_convert_ccda_temperature([minp2])
            ccda_max = eis_convert_ccda_temperature([maxp2])
            ccdb_min = eis_convert_ccdb_temperature([minp3])
            ccdb_max = eis_convert_ccdb_temperature([maxp3])

            mom = moment(p1)
            ccda_avg = eis_convert_ccda_temperature([mom[0]])
            ccda_std = sqrt(mom[1])
            ccda_skew = mom[2]
            ccda_kurt = mom[3]
            mom = moment(p2)
            ccdb_avg = eis_convert_ccda_temperature([mom[0]])
            ccdb_std = sqrt(mom[1])
            ccdb_skew = mom[2]
            ccdb_kurt = mom[3]

            print,format='(2(A23," "),6(F8.2))', $
              stim,etim,ccda_min,ccda_max,ccda_avg,ccdb_min,ccdb_max,ccdb_avg

            if using_log then begin
                printf,lu,format='(2(A23,","),5(F8.2,","),F8.2)', $
                  stim,etim,ccda_min,ccda_max,ccda_avg,ccdb_min,ccdb_max,ccdb_avg
            endif
        endelse
skip:
    endfor

    if using_log then begin
        close, lu
        free_lun, lu
    endif

end

