pro eis_mhc_gp0_temp_header, lu
    printf, lu, 'start_date,end_date,mhc_gp0_t0_min,mhc_gp0_t0_max,mhc_gp0_t0_avg,mhc_gp0_t1_min,mhc_gp0_t1_max,mhc_gp0_t1_avg,mhc_gp0_t2_min,mhc_gp0_t2_max,mhc_gp0_t2_avg,mhc_gp0_t3_min,mhc_gp0_t3_max,mhc_gp0_t3_avg,mhc_gp0_t4_min,mhc_gp0_t4_max,mhc_gp0_t4_avg,mhc_gp0_t5_min,mhc_gp0_t5_max,mhc_gp0_t5_avg,mhc_gp0_t6_min,mhc_gp0_t6_max,mhc_gp0_t6_avg,mhc_gp0_t7_min,mhc_gp0_t7_max,mhc_gp0_t7_avg,mhc_gp0_t8_min,mhc_gp0_t8_max,mhc_gp0_t8_avg,mhc_gp0_t9_min,mhc_gp0_t9_max,mhc_gp0_t9_avg,mhc_gp0_t10_min,mhc_gp0_t10_max,mhc_gp0_t10_avg,mhc_gp0_t11_min,mhc_gp0_t11_max,mhc_gp0_t11_avg,mhc_gp0_t12_min,mhc_gp0_t12_max,mhc_gp0_t12_avg,mhc_ref_min,mhc_ref_max,mhc_ref_avg,mhc_cal_min,mhc_cal_max,mhc_cal_avg'
end

pro eis_mhc_gp0_temp_trend, dir, log=log_file, hdr=hdr, screen_output=screen_output
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories'
        return
    endif
    using_log = 0
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    if keyword_set(hdr) then begin
        if using_log then eis_mhc_gp0_temp_header, lu
    endif
    for d = 0, count-1 do begin
        search_dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(search_dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(search_dir + 'eis_sts3_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then eis_no_data_string,lu,15
        endif else begin

            p29 = reform(eis_get_daily_data(files, 'MHC_REF_THER_0', 3, 1, mxp0, mnp0, stime, etime))
            p30 = reform(eis_get_daily_data(files, 'MHC_CAL_THER_0', 4, 1, mxp0, mnp0))

            p0  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_DB_T0',          1, 4, mxp0, mnp0),  p29, p30)
            p1  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_BOX_T1',         2, 4, mxp1, mnp1),  p29, p30)
            p2  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_T2',          3, 4, mxp2, mnp2),  p29, p30)
            p3  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_T3',          4, 4, mxp3, mnp3),  p29, p30)
            p4  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_SLA_T4',         5, 4, mxp4, mnp4),  p29, p30)
            p5  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_SLA_T5',         6, 4, mxp5, mnp5),  p29, p30)
            p6  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_HARNESS_T6',     7, 4, mxp6, mnp6),  p29, p30)
            p7  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_BASE_T7',    8, 4, mxp7, mnp7),  p29, p30)
            p8  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_PZT_T8',     9, 4, mxp8, mnp8),  p29, p30)
            p9  = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_MIR_MOTOR_T9',  10, 4, mxp9, mnp9),  p29, p30)
            p10 = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_GRA_MOTOR_T10', 11, 4, mxp10, mnp10),p29, p30)
            p11 = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_GRA_ASM_T11',   12, 4, mxp11, mnp11),p29, p30)

            p12 = eis_convert_mhc_temperature(eis_get_daily_data(files, 'MHC_PB_D4_T12',     13, 4, mxp11, mnp11),p29, p30)

            p0_min = min(p0)
            p0_max = max(p0)
            mom = moment(p0)
;            p0_avg = (moment(p0))[0]
            p0_avg = mom[0]
            p0_std = sqrt(mom[1])
            p0_skew = mom[2]
            p0_kurt = mom[3]

            p1_min = min(p1)
            p1_max = max(p1)
            p1_avg = (moment(p1))[0]
            p2_min = min(p2)
            p2_max = max(p2)
            p2_avg = (moment(p2))[0]
            p3_min = min(p3)
            p3_max = max(p3)
            p3_avg = (moment(p3))[0]
            p4_min = min(p4)
            p4_max = max(p4)
            p4_avg = (moment(p4))[0]
            p5_min = min(p5)
            p5_max = max(p5)
            p5_avg = (moment(p5))[0]
            p6_min = min(p6)
            p6_max = max(p6)
            p6_avg = (moment(p6))[0]
            p7_min = min(p7)
            p7_max = max(p7)
            p7_avg = (moment(p7))[0]
            p8_min = min(p8)
            p8_max = max(p8)
            p8_avg = (moment(p8))[0]
            p9_min = min(p9)
            p9_max = max(p9)
            p9_avg = (moment(p9))[0]
            p10_min = min(p10)
            p10_max = max(p10)
            p10_avg = (moment(p10))[0]
            p11_min = min(p11)
            p11_max = max(p11)
            p11_avg = (moment(p11))[0]

            p12_min = min(p12)
            p12_max = max(p12)
            p12_avg = (moment(p12))[0]

            p29_min = min(p29)
            p29_max = max(p29)
            p29_avg = (moment(p29))[0]
            p30_min = min(p30)
            p30_max = max(p30)
            p30_avg = (moment(p30))[0]

;            print,format='(2(A23,","),41(F8.2,","),F8.2)', $
            print,format='(2(A23,","),44(F8.2,","),F8.2)', $
              stime,etime,p0_min,p0_max,p0_avg,p1_min,p1_max,p1_avg,p2_min,p2_max,p2_avg,p3_min,p3_max,p3_avg,$
              p4_min,p4_max,p4_avg,p5_min,p5_max,p5_avg,p6_min,p6_max,p6_avg,p7_min,p7_max,p7_avg,$
              p8_min,p8_max,p8_avg,p9_min,p9_max,p9_avg,p10_min,p10_max,p10_avg,p11_min,p11_max,p11_avg,$
              p12_min,p12_max,p12_avg,$
              p29_min,p29_max,p29_avg,p30_min,p30_max,p30_avg

            if using_log then begin
;                 printf,lu,format='(2(A23,","),41(F8.2,","),F8.2)', $
                 printf,lu,format='(2(A23,","),44(F8.2,","),F8.2)', $
                  stime,etime,p0_min,p0_max,p0_avg,p1_min,p1_max,p1_avg,p2_min,p2_max,p2_avg,p3_min,p3_max,p3_avg,$
                   p4_min,p4_max,p4_avg,p5_min,p5_max,p5_avg,p6_min,p6_max,p6_avg,p7_min,p7_max,p7_avg,$
                   p8_min,p8_max,p8_avg,p9_min,p9_max,p9_avg,p10_min,p10_max,p10_avg,p11_min,p11_max,p11_avg,$
                   p12_min,p12_max,p12_avg,$
                   p29_min,p29_max,p29_avg,p30_min,p30_max,p30_avg
            endif
        endelse
skip:
    endfor
    if using_log then begin
        close, lu
        free_lun, lu
    endif
end

