pro min_max, param,  p_min,  p_max,  p_avg,  p_std,  p_skew,  p_kurt
    p_min  = min(param)
    p_max  = max(param)

    mom = moment(param)
    p_avg  = mom[0]
    p_std  = mom[1]
    p_skew = mom[2]
    p_kurt = mom[3]

end

pro eis_mhc_psu_pwr_header, lu
    printf, lu, 'start_date,end_date,p5vd_min,p5vd_max,p5vd_avg,p15va_min,p15va_max,p15va_avg,n15va_min,n15va_max,n15v_avg,p5vdi_min,p5vdi_max,p5vdi_avg,p15vai_min,p15vai_max,p15vai_avg,n15vai_min,n15vai_max,n15vai_avg,p5vd_pwr_min,p5vd_pwr_max,p5vd_pwr_avg,p15va_pwr_min,p15va_pwr_max,p15va_pwr_avg,n15va_pwr_min,n15va_pwr_max,n15va_pwr_avg,sgo_min,sgo_max,sgo_avg,rdc_min,rdc_max,rdc_avg'
end

pro eis_mhc_psu_pwr_trend, dir, log=log_file, hdr=hdr, screen_output=screen_output
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories in ' + dir
        return
    endif
    using_log = 0
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    if keyword_set(hdr) then begin
        if using_log then eis_mhc_psu_pwr_header, lu
    endif
    for d = 0, count-1 do begin
        search_dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(search_dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(search_dir + 'eis_sts3_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then eis_no_data_string, lu, 11
        endif else begin

            p47 = eis_get_daily_data(files, 'MHC_GND_F_REF', 5, 1, mxp0, mnp0, stime, etime)
            p14 = eis_get_daily_data(files, 'MHC_GND_I_REF', 2, 1, mxp0, mnp0)

            v  = eis_convert_mhc_voltage_p5vdig(eis_get_daily_data(files, 'MHC_P5VD',   2, 2, mx1, mn1), p47)
            c  = eis_convert_mhc_current_p5vdig(eis_get_daily_data(files, 'MHC_P5V_DI', 1, 3, mx1, mn1), p14)
            pwr = abs(v * c)
            min_max, v,   v0_min,   v0_max,   v0_avg,   v0_std,   v0_skew,   v0_kurt
            min_max, c,   c0_min,   c0_max,   c0_avg,   c0_std,   c0_skew,   c0_kurt
            min_max, pwr, pwr0_min, pwr0_max, pwr0_avg, pwr0_std, pwr0_skew, pwr0_kurt

            v  = eis_convert_mhc_voltage_p15vana(eis_get_daily_data(files, 'MHC_P15V_A',  3, 2, mx1, mn1), p47)
            c  = eis_convert_mhc_current_p15vana(eis_get_daily_data(files, 'MHC_P15V_AI', 2, 3, mx2, mn2), p14)
            pwr = abs(v * c)
            min_max, v,   v1_min,   v1_max,   v1_avg,   v1_std,   v1_skew,   v1_kurt
            min_max, c,   c1_min,   c1_max,   c1_avg,   c1_std,   c1_skew,   c1_kurt
            min_max, pwr, pwr1_min, pwr1_max, pwr1_avg, pwr1_std, pwr1_skew, pwr1_kurt
            
            v = eis_convert_mhc_voltage_n15vana(eis_get_daily_data(files, 'MHC_N15V_A',  4, 2, mx1, mn1), p47)
            c = eis_convert_mhc_current_n15vana(eis_get_daily_data(files, 'MHC_N15V_AI', 3, 3, mx3, mn3), p14)
            pwr = abs(v * c)
            min_max, v,   v2_min,   v2_max,   v2_avg,   v2_std,   v2_skew,   v2_kurt
            min_max, c,   c2_min,   c2_max,   c2_avg,   c2_std,   c2_skew,   c2_kurt
            min_max, pwr, pwr2_min, pwr2_max, pwr2_avg, pwr2_std, pwr2_skew, pwr2_kurt

            v = eis_convert_mhc_strain_gauge_op(eis_get_daily_data(files, 'MHC_SG_OP', 1, 2, mx1, mn1), p47)
            c = eis_convert_mhc_current_rdc(eis_get_daily_data(files, 'MHC_RDC_I', 4, 3, mx4, mn4), p14)
            min_max, v,   v3_min,   v3_max,   v3_avg,   v3_std,   v3_skew,   v3_kurt
            min_max, c,   c3_min,   c3_max,   c3_avg,   c3_std,   c3_skew,   c3_kurt

            print,format='(2(A23," "),32(F8.2,","),F8.2)', $
              stime,etime,$
              v0_min,v0_max,v0_avg,v1_min,v1_max,v1_avg,v2_min,v2_max,v2_avg, $
              c0_min,c0_max,c0_avg,c1_min,c1_max,c1_avg,c2_min,c2_max,c2_avg, $
              pwr0_min,pwr0_max,pwr0_avg,pwr1_min,pwr1_max,pwr1_avg,pwr2_min,pwr2_max,pwr2_avg, $
              v3_min,v3_max,v3_avg,c3_min,c3_max,c3_avg

            if using_log then begin
                printf,lu,format='(2(A23,","),32(F8.2,","),F8.2)', $
                  stime,etime,$
                  v0_min,v0_max,v0_avg,v1_min,v1_max,v1_avg,v2_min,v2_max,v2_avg, $
                  c0_min,c0_max,c0_avg,c1_min,c1_max,c1_avg,c2_min,c2_max,c2_avg, $
                  pwr0_min,pwr0_max,pwr0_avg,pwr1_min,pwr1_max,pwr1_avg,pwr2_min,pwr2_max,pwr2_avg, $
                  v3_min,v3_max,v3_avg,abs(c3_min),abs(c3_max),abs(c3_avg)
            endif
        endelse
skip:
    endfor
    if using_log then begin
        close, lu
        free_lun, lu
    endif
end

