; filename		(string)	['$HOME/work/localdata/log/status/trends/eis_ccd_temp_trend_200704.txt']
; xtit (plot title)	(string)	['April 2007']
; output		(string)	['$HOME/work/localdata/log/status/trends/ccd_temp_200704']
pro eis_plot_mhc_psu_pwr_trend, filename, xtit, output=output

    ; Restore 'template'
    restore, '$HOME/work/idl/templates/eis_mhc_psu_template.sav'
    data = read_ascii(filename, template=template)

    ytit = 'Volts'
    eis_plot_trend_data, '+5 Digital', xtit, output + '_voltages',  data.p5vd_min,  data.p5vd_max,  data.p5vd_avg,  ytit, /start
    eis_plot_trend_data, '+15 Analog', xtit, output + '', data.p15va_min, data.p15va_max, data.p15va_avg, ytit
    ; Reverse min and max as all values are negative...
    eis_plot_trend_data, '-15 Analog', xtit, output + '', data.n15va_min, data.n15va_max, data.n15va_avg, ytit
    ; ... or get eis_plot_trend_data to do it
;    eis_plot_trend_data, '-15 Analog', xtit, output + 'n15va', data.n15va_min, n15va_max, n15va_avg, ytit, /reverse
    eis_plot_trend_data, 'MHC -15v analog',  xtit, output+'',  data.n15va_min,  data.n15va_max,  data.n15va_avg,  ytit
    eis_plot_trend_data, 'STRAIN GAUGE',     xtit, output+'', data.sgo_min, data.sgo_max, data.sgo_avg, ytit, /finish

    ytit = 'Amps'
    eis_plot_trend_data, '+5v current',      xtit, output+'_currents',  data.p5vdi_min,  data.p5vdi_max,  data.p5vdi_avg,  ytit, /start
    eis_plot_trend_data, '+15 VOLT CURRENT', xtit, output+'', data.p15vai_min, data.p15vai_max, data.p15vai_avg, ytit
    eis_plot_trend_data, '-15 VOLT CURRENT', xtit, output+'', data.n15vai_min, data.n15vai_max, data.n15vai_avg, ytit
    eis_plot_trend_data, '+RDC',             xtit, output+'', data.rdc_min, data.rdc_max, data.rdc_avg, ytit, /finish

    ytit = 'Watts'
    eis_plot_trend_data, '+5 VOLT POWER',  ptit, output+'_power',  data.p5vd_pwr_min,  data.p5vd_pwr_max,  data.p5vd_pwr_avg,  ytit, /start
    eis_plot_trend_data, '+15 VOLT POWER', ptit, output+'', data.p15va_pwr_min, data.p15va_pwr_max, data.p15va_pwr_avg, ytit
    eis_plot_trend_data, '-15 VOLT POWER', ptit, output+'', data.n15va_pwr_min, data.n15va_pwr_max, data.n15va_pwr_avg, ytit, /finish

;    cs=1.6
;
;    nel = n_elements(data.start_date)
;    x   = bindgen(nel)
;    x = x + 1
;
;    set_plot,'ps'
;    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output + '_mhc_psu.ps'
;    !p.multi=[0,1,3]
;
;    ytit='Volts'
;    plot,  x, data.p5vd_min, xrange=[1, nel], yrange=[min(data.p5vd_min),max(data.p5vd_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='+5v Digital', xtitle=xtit, ytitle=ytit, charsize=cs
;    oplot, x, data.p5vd_min, psym=2, min_value=-65534., max_value=65535.
;    oplot, x, data.p5vd_max, psym=10
;    oplot, x, data.p5vd_max, psym=4, min_value=-65534., max_value=65535.
;    oplot, x, data.p5vd_avg, psym=10
;    oplot, x, data.p5vd_avg, psym=7, min_value=-65534., max_value=65535.
;
;    plot,  x, data.p15va_min, xrange=[1, nel], yrange=[min(data.p15va_min),max(data.p15va_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='+15v Analog', xtitle=xtit, ytitle=ytit, charsize=cs
;    oplot, x, data.p15va_min, psym=2, min_value=-65534., max_value=65535.
;    oplot, x, data.p15va_max, psym=10
;    oplot, x, data.p15va_max, psym=4, min_value=-65534., max_value=65535.
;    oplot, x, data.p15va_avg, psym=10
;    oplot, x, data.p15va_avg, psym=7, min_value=-65534., max_value=65535.
;
;    p15va_diff = data.p15va_max - data.p15va_min
;    p15va_min = min(p15va_diff)
;    p15va_max = max(p15va_diff)
;    plot,  x, p15va_diff, xrange=[1, nel], yrange=[min(p15va_diff),max(p15va_diff)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='+15v Analog Range', xtitle=xtit, ytitle=ytit, charsize=cs
;    oplot, x, p15va_diff, psym=2, min_value=-65534., max_value=65535.
;
;    plot,  x, data.n15va_min, xrange=[1, nel], yrange=[min(data.n15va_min),max(data.n15va_max)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='-15v Analog', xtitle=xtit, ytitle=ytit, charsize=cs
;    oplot, x, data.n15va_min, psym=2, min_value=-65534., max_value=65535.
;    oplot, x, data.n15va_max, psym=10
;    oplot, x, data.n15va_max, psym=4, min_value=-65534., max_value=65535.
;    oplot, x, data.n15va_avg, psym=10
;    oplot, x, data.n15va_avg, psym=7, min_value=-65534., max_value=65535.
;
;    n15va_diff = data.n15va_max - data.n15va_min
;print,n15va_diff
;    n15va_min = max(p15va_diff)
;    n15va_max = min(p15va_diff)
;    plot,  x, n15va_diff, xrange=[1, nel], yrange=[min(p15va_diff),max(p15va_diff)], min_value=-65534., max_value=65535., xstyle=3, psym=10, title='-15v Analog Range', xtitle=xtit, ytitle=ytit, charsize=cs
;    oplot, x, n15va_diff, psym=2, min_value=-65534., max_value=65535.
;
;    ytit='Amps'
;
;    device,/close
;    set_plot,'X'
;    !p.multi=0

end
