pro eis_str_temp_header, lu
    printf, lu, 'start_date,end_date,htra_min,htra_max,htra_avg,htrb_min,htrb_max,htrb_avg,htrc_min,htrc_max,htrc_avg,icu1_min,icu1_max,icu1_avg,icu2_min,icu2_max,icu2_avg,str1_min,str1_max,str1_avg,str2_min,str2_max,str2_avg,str3_min,str3_max,str3_avg,str4_min,str4_max,str4_avg,str5_min,str5_max,str5_avg,str6_min,str6_max,str6_avg,str7_min,str7_max,str7_avg'
end

pro eis_str_temp_trend, dir, log=log_file, hdr=hdr, screen_output=screen_output
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories'
        return
    endif
    using_log = 0
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    if keyword_set(hdr) then begin
        if using_log then eis_str_temp_header, lu
    endif
    for d = 0, count-1 do begin
        search_dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(search_dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(search_dir + 'eis_hk1_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then eis_no_data_string, lu, 12
        endif else begin

            htr_a = reform(eis_get_daily_data(files, 'HK1_EIS_A_HTR_TMP', 1, 1, mx0, mn0, stime, etime))
            htr_b = reform(eis_get_daily_data(files, 'HK1_EIS_B_HTR_TMP', 2, 1, mx1, mn1))
            htr_c = reform(eis_get_daily_data(files, 'HK1_EIS_C_HTR_TMP', 3, 1, mx2, mn2))

            icu_1 = reform(eis_get_daily_data(files, 'HK1_EIS_ICU_1_TEMP', 4, 1, mx3, mn3))
            icu_2 = reform(eis_get_daily_data(files, 'HK1_EIS_ICU_2_TEMP', 5, 1, mx4, mn4))

            str_1 = reform(eis_get_daily_data(files, 'HK1_EIS_STR_1_TEMP',  6, 1, mx5, mn5))
            str_2 = reform(eis_get_daily_data(files, 'HK1_EIS_STR_2_TEMP',  7, 1, mx6, mn6))
            str_3 = reform(eis_get_daily_data(files, 'HK1_EIS_STR_3_TEMP',  8, 1, mx7, mn7))
            str_4 = reform(eis_get_daily_data(files, 'HK1_EIS_STR_4_TEMP',  9, 1, mx8, mn8))
            str_5 = reform(eis_get_daily_data(files, 'HK1_EIS_STR_5_TEMP', 10, 1, mx9, mn9))
            str_6 = reform(eis_get_daily_data(files, 'HK1_EIS_STR_6_TEMP', 11, 1, mx10, mn10))
            str_7 = reform(eis_get_daily_data(files, 'HK1_EIS_STR_7_TEMP', 12, 1, mx11, mn11))

            ; htr_x min max values need to be swapped around due to conversion factor
            htr_a_min = eis_convert_hk1_htra_temp([mx0])
            htr_a_max = eis_convert_hk1_htra_temp([mn0])
            htr_b_min = eis_convert_hk1_htrb_temp([mx1])
            htr_b_max = eis_convert_hk1_htrb_temp([mn1])
            htr_c_min = eis_convert_hk1_htrc_temp([mx2])
            htr_c_max = eis_convert_hk1_htrc_temp([mn2])

            icu_1_min = eis_convert_hk1_icu1_temp([mn3])
            icu_1_max = eis_convert_hk1_icu1_temp([mx3])
            icu_2_min = eis_convert_hk1_icu2_temp([mn4])
            icu_2_max = eis_convert_hk1_icu2_temp([mx4])

            str_1_min = eis_convert_hk1_str1_temp([mn5])
            str_1_max = eis_convert_hk1_str1_temp([mx5])
            str_2_min = eis_convert_hk1_str2_temp([mn6])
            str_2_max = eis_convert_hk1_str2_temp([mx6])
            str_3_min = eis_convert_hk1_str3_temp([mn7])
            str_3_max = eis_convert_hk1_str3_temp([mx7])
            str_4_min = eis_convert_hk1_str4_temp([mn8])
            str_4_max = eis_convert_hk1_str4_temp([mx8])
            str_5_min = eis_convert_hk1_str5_temp([mn9])
            str_5_max = eis_convert_hk1_str5_temp([mx9])
            str_6_min = eis_convert_hk1_str6_temp([mn10])
            str_6_max = eis_convert_hk1_str6_temp([mx10])
            str_7_min = eis_convert_hk1_str7_temp([mn11])
            str_7_max = eis_convert_hk1_str7_temp([mx11])

            mom = moment(htr_a)
            htr_a_avg = eis_convert_hk1_htra_temp([mom[0]])
            mom = moment(htr_b)
            htr_b_avg = eis_convert_hk1_htrb_temp([mom[0]])
            mom = moment(htr_c)
            htr_c_avg = eis_convert_hk1_htrc_temp([mom[0]])

            mom = moment(icu_1)
            icu_1_avg = eis_convert_hk1_icu1_temp([mom[0]])
            mom = moment(icu_2)
            icu_2_avg = eis_convert_hk1_icu2_temp([mom[0]])

            mom = moment(str_1)
            str_1_avg = eis_convert_hk1_str1_temp([mom[0]])
            mom = moment(str_2)
            str_2_avg = eis_convert_hk1_str2_temp([mom[0]])
            mom = moment(str_3)
            str_3_avg = eis_convert_hk1_str3_temp([mom[0]])
            mom = moment(str_4)
            str_4_avg = eis_convert_hk1_str4_temp([mom[0]])
            mom = moment(str_5)
            str_5_avg = eis_convert_hk1_str5_temp([mom[0]])
            mom = moment(str_6)
            str_6_avg = eis_convert_hk1_str6_temp([mom[0]])
            mom = moment(str_7)
            str_7_avg = eis_convert_hk1_str7_temp([mom[0]])

            print,format='(2(A23," "),36(F6.2))', $
              stime,etime,htr_a_min,htr_a_max,htr_a_avg,htr_b_min,htr_b_max,htr_b_avg,$
              icu_1_min,icu_1_max,icu_1_avg,icu_2_min,icu_2_max,icu_2_avg,$
              str_1_min,str_1_max,str_1_avg,str_2_min,str_2_max,str_2_avg,str_3_min,str_3_max,str_3_avg,$
              str_4_min,str_4_max,str_4_avg,str_5_min,str_5_max,str_5_avg,str_6_min,str_6_max,str_6_avg,$
              str_7_min,str_7_max,str_7_avg

             if using_log then begin
                printf,lu,format='(2(A23,","),35(F8.2,","),F8.2)', $
                  stime,etime,htr_a_min,htr_a_max,htr_a_avg,htr_b_min,htr_b_max,htr_b_avg,htr_c_min,htr_c_max,htr_c_avg,$
                  icu_1_min,icu_1_max,icu_1_avg,icu_2_min,icu_2_max,icu_2_avg,$
                  str_1_min,str_1_max,str_1_avg,str_2_min,str_2_max,str_2_avg,str_3_min,str_3_max,str_3_avg,$
                  str_4_min,str_4_max,str_4_avg,str_5_min,str_5_max,str_5_avg,str_6_min,str_6_max,str_6_avg,$
                  str_7_min,str_7_max,str_7_avg
            endif
        endelse
skip:
    endfor
    if using_log then begin
        close, lu
        free_lun, lu
    endif
end

