package Ccsds::Packet;

#use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib";
#use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib/Ccsds";

use Ccsds;

use vars qw(@ISA @EXPORT);

use Exporter;
@EXPORT = qw();
@ISA = qw(Exporter Ccsds);

my %endianString = ("big"   => "n3",
		    		"small" => "v3");

my %timeEndianString = ("big"   => "n2",
						"small" => "v2");

sub BEGIN {
#    print STDOUT "Ccsds BEGIN\n";
#    $numberOfPackets = 0;
}

sub new {
    my ($class) = @_;
    my $self = {
	_primaryHeaderLength      => 6,
	_secondaryHeaderLength    => 4,

	_rawData				  => "",
	
	_primaryHeader            => "",
	_secondaryHeader          => "",
	_userData                 => "",

#	_spacecraftTime => undef,
	_endian                   => "big",

	_packetVersion            => undef,
	_packetType               => undef,
	_packetSecHdr             => undef,
	_packetApid               => undef,
	_packetSeqFlag            => undef,
	_packetSeqCount           => undef,
	_packetLength             => undef,

	_isStartPacketOfSequence  => 0,
	_isMiddlePacketOfSequence => 0,
	_isLastPacketOfSequence   => 0,
	_isStandAlonePacket       => 0,

#	_mark                     => 0,

	};
    bless $self, $class; 
    return $self;
}

sub init {
    my $self = shift;
    print "StartPacket = ", $startPacket, "\n";
}

sub primaryHeader {
    return $_[0]->{_primaryHeader};
}

sub apid {
    return $_[0]->{_packetApid};
}

sub userData {
    my $self = shift;
    return $self->{_userData};
}

sub packetSeqCount {
	return $_[0]->{_packetSeqCount};
}

sub packetSeqFlag {
	return $_[0]->{_packetSeqFlag};
}

sub rawData {
	return $_[0]->{_rawData};
}

sub decodeHeader {
    my $self = shift;
    my @data;

    @data = unpack($endianString{$self->{_endian}},
		   $self->{_primaryHeader});
    $self->{_packetVersion}  = ($data[0] >> 13);
    $self->{_packetType}     = ($data[0] >> 12);
    $self->{_packetSecHdr}   = ($data[0] >> 11);
    $self->{_packetApid}     = ($data[0] & 0x7FF);
    $self->{_packetSeqFlag}  = sprintf "%u", ($data[1] >> 14);
    $self->{_packetSeqCount} = ($data[1] & 0x3FFF);
    $self->{_packetLength}   = sprintf "%u", $data[2];

    $self->{_isStartPacketOfSequence}  = ($self->{_packetSeqFlag} == $startPacket)        ? 1 : 0;
    $self->{_isMiddlePacketOfSequence} = ($self->{_packetSeqFlag} == $continuationPacket) ? 1 : 0;
    $self->{_isLastPacketOfSequence}   = ($self->{_packetSeqFlag} == $lastPacket)         ? 1 : 0;
    $self->{_isStandAlonePacket}       = ($self->{_packetSeqFlag} == $standalonePacket)   ? 1 : 0;

#    $self->tmpPrintHeader();
}

sub isStartPacketOfSequence {
#    print "START: ", $_[0]->{_isStartPacketOfSequence}, "\n";
    return $_[0]->{_isStartPacketOfSequence};
}

sub isMiddlePacketOfSequence {
    return $_[0]->{_isMiddlePacketOfSequence};
}

sub isLastPacketOfSequence {
#    print "LAST: ", $_[0]->{_isLastPacketOfSequence}, "\n";
    return $_[0]->{_isLastPacketOfSequence};
}

sub isStandalonePacket {
    return $_[0]->{_isStandalonePacket};
}

sub tmpPrintHeader {
    my $self = shift;

    print "Version: ", $self->{_packetVersion}, "\n";
    print "Type   : ", $self->{_packetType}, "\n";
    print "SecHdr : ", $self->{_packetSecHdr}, "\n";
    print "APID   : ", $self->{_packetApid}, "\n";
    print "Flag   : ", $self->{_packetSeqFlag}, "\n";
    print "Count  : ", $self->{_packetSeqCount}, "\n";
    print "Length : ", $self->{_packetLength}, "\n";
}

# Put into writer
# change to setHeaderInfo
sub setData {
    my $self = shift;
    my $apid = shift;
    my $seq_count = shift;
    my $flag = shift;
    my $len = shift;
    my $buf;
    my @data;

    $len += 3;

#    $data[0] = 1;
#    $data[1] = 2;
#    $data[2] = 3;
#    $data[3] = 4;
#    $data[4] = 5;
#    $data[5] = 6;
## Spacecraft time
#    $data[6] = 7;
#    $data[7] = 8;
#    $data[8] = 9;
#    $data[9] = 10;

    $data[0] = (8 | (($apid & 0x7FF) >> 8));
    $data[1] = ($apid & 0xFF);
    $data[2] = (($flag << 6) | (($seq_count & 0x3F00) >> 8));
    $data[3] = ($seq_count & 0xFF);
    $data[4] = (($len & 0xFF00) >> 8);
    $data[5] = ($len & 0xFF);
## Spacecraft time
    $data[6] = 1;
    $data[7] = 2;
    $data[8] = 3;
    $data[9] = 4;

    $self->{_header} = pack "C10", @data;
}

sub normalizedPacketLength {
    my $self = shift;
    return ($self->{_packetLength}) - 3;
}

1;
