package Ccsds::Packet::Reader;

#use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib";
###use lib "/Users/matt/Work/Hinode/EisCcsdsLib/Ccsds";
###use lib "/Users/matt/Work/Hinode/EisCcsdsLib/Ccsds/Packet";
#use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib/Ccsds/Reader";

###use Ccsds;
#use EisCcsdsLib::Ccsds;
#use Reader;

###use Packet;
#use Ccsds;
#use Ccsds::Packet;

use FileHandle;
use strict;

use vars qw(@ISA @EXPORT $VERSION);

use Exporter;
$VERSION = 1.00;
@ISA = qw(Exporter Ccsds::Packet);

#@EXPORT = qw(Ccsds::Packet::Reader::readPacket);
#@EXPORT = qw();

#my $ifh;

sub BEGIN {
}

sub new {
    my $classname = shift;
    my $self = $classname->SUPER::new(@_);
    $self->_init(@_);
    return $self;
}

sub _init {
    $_[0]->{_inputFileHandle}  = undef;
    $_[0]->{_error}            = 0;
    $_[0]->{_numberOfPackets}  = 0;
    $_[0]->{_hasReadPrimary}   = 0;
    $_[0]->{_hasReadSecondary} = 0;
    $_[0]->{_hasReadUserData}  = 0;
}

sub init {
    my $self = shift;

    $self->{_error} = 0;
}

sub numberOfPackets {
	return $_[0]->{_numberOfPackets};
}

sub setInput {
    my $self = shift;
    my $input = shift;
    my $fh = FileHandle->new();
    if(sysopen(IFH, $input, O_RDONLY)) {
		print "CcsdsReader: opening $input\n";
		$self->{_inputFileHandle} = *IFH;
		print "Filehandle = ", $self->{_inputFileHandle}, "\n";
		$self->{_error} = 0;
    }
    else {
		$self->{_error} = 1;
		print "CcsdsReader: can't open $input: $!\n";
    }
}

sub prepareToReadPacket {
    my $self = shift;
    $self->{_hasReadPrimary} = 0;
    $self->{_hasReadSecondary} = 0;
    $self->{_hasReadUserData} = 0;
    $self->{_packetValid} = 0;
}

sub validateRead {
    my $self = shift;
    $self->{_packetValid} = $self->{_hasReadPrimary}   &&
    						$self->{_hasReadSecondary} &&
    						$self->{_hasReadUserData};
}

sub readPacket {
    my $self = shift;
    my $res = 0;

    $self->prepareToReadPacket();
    return 0 unless $self->readPrimaryHeader();
	return 0 unless $self->readSecondaryHeader();
	return 0 unless $self->readUserData();
#	$self->validateRead();
	++$self->{_numberOfPackets};
#	$self->{_rawData} = $self->{_primaryHeader}   .
#						$self->{_secondaryHeader} .
#						$self->{_userData}
#	print "Read packet: ", $self->{_numberOfPackets}, "\n";
	$self->{_rawData} = $self->{_primaryHeader} . $self->{_secondaryHeader} . $self->{_userData};
	return sprintf("%u", $self->{_packetApid});

#    $self->readPrimaryHeader();
#    $self->readSecondaryHeader() if $self->{_hasReadPrimary};
#    $self->readUserData()        if $self->{_hasReadSecondary};
#    $self->validateRead()		 if $self->{_hasReadUserData};
#    if($self->{_packetValid}) {
#		++$self->{_numberOfPackets};
#		print "Read packet: ", $self->{_numberOfPackets}, "\n";
#		return sprintf("%u", $self->{_packetApid});
#    }
#    return 0;
}

sub readPrimaryHeader {
    my $self = shift;
    my $res = sysread($self->{_inputFileHandle},
		      $self->{_primaryHeader},
		      $self->{_primaryHeaderLength});
    if($res != 0) {
		$self->{_hasReadPrimary} = 1;
		$self->decodeHeader();
    }
    $self->{_error} = 2;
    return $self->{_hasReadPrimary};
}

sub readSecondaryHeader {
    my $self = shift;
    my $res = sysread($self->{_inputFileHandle},
		      $self->{_secondaryHeader},
		      $self->{_secondaryHeaderLength});
    $self->{_hasReadSecondary} = ($res != 0);
#    $self->{_error} = 3;
    return $self->{_hasReadSecondary};
}

sub readUserData {
    my $self = shift;
    my $len = $self->normalizedPacketLength();
    my $res = sysread($self->{_inputFileHandle},
		      $self->{_userData},
		      $len);
    $self->{_hasReadUserData} = ($res == $len);
#    $self->{_error} = 4;
    return $self->{_hasReadUserData};
}

# Return the whole packet
#sub packet {
#    my $self = shift;
#    return $self->{_packet};
#}

sub cleanUp {
    my $self = shift;
    print "CcsdsReader: closing filehanle\n";
    if(defined($self->{_inputFileHandle})) {
		close $self->{_inputFileHandle};
    }
    else {
		print "CcsdsReader: _inputFileHandle not defined\n";
    }
}

1;
