package Ccsds::Packet::GapReader;

#use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib";
#use lib "/Users/matt/Work/Hinode/EisCcsdsLib/Ccsds";
#use lib "/Users/matt/Work/Hinode/EisCcsdsLib/Ccsds/Packet";
#use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib/Ccsds";

#use Ccsds;
#use EisCcsdsLib::Ccsds;
use Ccsds;
use Ccsds::Packet;
use Ccsds::Packet::Reader;

#use Packet;
use FileHandle;
use strict;

use vars qw(@ISA @EXPORT $VERSION);

use Exporter;
$VERSION = 1.00;
@ISA = qw(Exporter Ccsds::Packet::Reader);

sub BEGIN {
}

sub new {
    my $classname = shift;
    my $self = $classname->SUPER::new(@_);
    $self->init(@_);
    return $self;
}

sub init {
    $_[0]->{_first}          = 1;
    $_[0]->{_numberOfGaps}   = 0;
    $_[0]->{_currentCount}   = 0;
    $_[0]->{_nextCount}      = 0;
    $_[0]->{_packetsMissing} = 0;
}

sub reStart {
    $_[0]->{_numberOfGaps}   = 0;
    $_[0]->{_currentCount}   = 0;
    $_[0]->{_nextCount}      = 0;
    $_[0]->{_packetsMissing} = 0;
}

sub numberOfGaps {
	return $_[0]->{_numberOfGaps};
}

sub packetsMissing {
	return $_[0]->{_packetsMissing};
}

sub currentCount {
	return $_[0]->{_currentCount};
}

sub nextCount {
	return $_[0]->{_nextCount};
}

sub readPacket {
    my $self = shift;
    my $res = 0;

	return 0 unless $res = $self->SUPER::readPacket();
	if($self->{_first}) {
		$self->{_first} = 0;
		$self->{_currentCount} = $self->{_packetSeqCount};
		$self->adjustNextCount($self->{_currentCount});
		print "GapReader: done first\n";
		return $res;
	}
	$self->{_currentCount} = $self->{_packetSeqCount};
	if($self->{_currentCount} != $self->{_nextCount}) {
		print "GapReader: found gap at ", $self->{_numberOfPackets}, "\n";
		++$self->{_numberOfGaps};
		$self->countPacketsMissing();
	}
	$self->adjustNextCount($self->{_currentCount});
	return $res;
}

sub adjustNextCount {
	$_[0]->{_nextCount} = $_[1] + 1;
	$_[0]->{_nextCount} &= 0x7FFF;
}

sub countPacketsMissing {
	my $self = shift;
	$self->{_packetsMissing} += ($self->{_currentCount} > $self->{_nextCount}) ?
#	$self->{_packetsMissing} += ($self->{_currentCount} < $self->{_nextCount}) ?
#		$self->{_nextCount} - $self->{_currentCount}                          :
#		(($self->{_currentCount} + 0x8000) - $self->{_nextCount}) - 1;
		$self->{_currentCount} - $self->{_nextCount}                          :
		(($self->{_nextCount} + 0x8000) - $self->{_currentCount}) - 1;
}

1;
