package MdHeader;

#use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib";

#use CcsdsInterface;
use strict;

use vars qw(@ISA @EXPORT $VERSION);

use Exporter;
$VERSION = 1.00;
@ISA = qw(Exporter);

@EXPORT = qw();

sub BEGIN {
#    print STDOUT "Ccsds BEGIN\n";
#    $numberOfPackets = 0;
}

sub new {
    my ($class) = shift;
    my $self = {

	_headerBytes => [],

	_byte0 => 0,
	_byte1 => 0,
	_byte2 => 0,
	_byte3 => 0,
	_byte4 => 0,
	_byte5 => 0,
	_byte6 => 0,
	_byte7 => 0,

	_dataType => 0,
	_packetSize => 0,
	_serialPacketNumber => 0,
	_mainId => 0,
	_mainSequenceFlag => 0,
	_mainSequenceCount => 0,
	_mdPacketsPerExposure => 0,
	_imagePerFrame => 0,
	_subId => 0,
	_subSequenceFlag => 0,
	_subSequenceCount => 0,
	_fullImageSizeX => 0,
	_fullImageSizeY => 0,
	_partialImageSizeX => 0,
	_partialImageSizeY => 0,
	_basePointX => 0,
	_basePointY => 0,
	_bitCompressionMode => 0,
	_imageCompressionMode => 0,
	_imageCompressionParameters => 0,
	_ti1 => 0,
	_ti2 => 0,
	_mhcDuration => 0,
	_exposureDuration => 0,
	_sequenceNumber => 0,
	_linelistNumber => 0,
	_sequenceId => 0,
	_rasterId => 0,
	_numberOfWindows => 0,
	_ccdXLength => 0,
	_Xws => 0,
	_Xw => 0,
	_Yws => 0,
	_Yw => 0,
# Windows
	_coarseMirrorPosition => 0,
	_fineMirrorPosition => 0,
	_slitNumber => 0,
	_xOcb => 0,
	_yOcb => 0,
	_rastersRequired => 0,
	_rastersCounter => 0,
	_rasterRepeatsRequired => 0,
	_rasterRepeatsPerformed => 0,
	_sequenceRepeatsRequired => 0,
	_sequenceRepeatsPerformed => 0,
	_ccdReadoutNode => 0,
	_HSLStatus => 0,
	_scienceOp => 0,
	_xrtFlareFlag => 0,
	_xrtFlareFlagX => 0,
	_xrtFlareFlagY => 0,
	_AECHepc => 0,
	_AECLepc => 0,
	_EISXRTX => 0,
	_EISXRTY => 0,
	_fineMirrorStrainGauge => 0,
	_EISFlareX => 0,
	_EISFlareY => 0,
	_EISEventX => 0,
	_EISEventY => 0,
	_ASRCStatus => 0,
	_ASRCSkip => 0,
	_exposuresPerRasterPosition => 0,
	_FMIRStepSize => 0,

    };
    bless $self, $class; 
    return $self;
}

sub init {
    print "MdHeader init\n";
    $_[0]->populate_header($_[1]);
}

sub populateHeader {
    my $self = shift;
    my $data = shift;
    my @data;
    my $temp;

#    $self->{_headerBytes} = $data;

    @data = unpack "C*", $data;
    $self->{_headerBytes} = @data;

#    $temp = scalar(@data);
#    if($temp != 264) {
#	print "BAD HEADER ($temp)\n";
#	return;
#    }

    $self->{_byte0} = sprintf "%02X", $data[0];
    $self->{_byte1} = sprintf "%02X", $data[1];
    $self->{_byte2} = sprintf "%02X", $data[2];
    $self->{_byte3} = sprintf "%02X", $data[3];
    $self->{_byte4} = sprintf "%02X", $data[4];
    $self->{_byte5} = sprintf "%02X", $data[5];
    $self->{_byte6} = sprintf "%02X", $data[6];
    $self->{_byte7} = sprintf "%02X", $data[7];

    $self->{_dataType}                  = sprintf "%02X", $data[8];
    $temp                               = sprintf "%08X", (($data[9] << 16) | ($data[10] << 8));
    $self->{_packetSize}                = sprintf "%08X", ($data[11] | hex($temp));
    $temp                               = sprintf "%08X", (($data[12] << 24) | ($data[13] << 16) | ($data[14] << 8));
    $self->{_serialPacketNumber}        = sprintf "%08X", ($data[15] | hex($temp));

    $self->{_mainId}                    = sprintf "%04X", (($data[16] << 8) | $data[17]);
    $self->{_mainSequenceFlag}          = sprintf "%u", ($data[18] >> 6);
    $self->{_mainSequenceCount}         = sprintf "%04X", (($data[18] & 0x3F) | $data[19]);

    $self->{_mdPacketsPerExposure}      = sprintf "%02X", ( (($data[20] & 0x3F) << 2) | ($data[21] >> 6));
    $self->{_imagePerFrame}             = sprintf "%02X", ($data[21] & 0x3F);

    $self->{_subId}                     = sprintf "%04X", (($data[22] << 8) | $data[23]);
    $self->{_subSequenceFlag}           = sprintf "%u", ($data[24] >> 6);
    $self->{_subSequenceCount}          = sprintf "%04X", (($data[24] & 0x3F) | $data[25]);
    $self->{_fullImageSizeX}            = sprintf "%04X", (($data[26] << 8) | $data[27]);
    $self->{_fullImageSizeY}            = sprintf "%04X", (($data[28] << 8) | $data[29]);
    $self->{_basePointX}                = sprintf "%04X", (($data[30] << 8) | $data[31]);
    $self->{_basePointY}                = sprintf "%04X", (($data[32] << 8) | $data[33]);
    $self->{_partialImageSizeX}         = sprintf "%04X", (($data[34] << 8) | $data[35]);
    $self->{_partialImageSizeY}         = sprintf "%04X", (($data[36] << 8) | $data[37]);

    $self->{_compression}               = sprintf "%04X", (($data[38] << 8) | $data[39]);
    $self->{_bitCompressionMode}        = sprintf "%02X", (($data[38] & 0x7F) >> 3);
    $self->{_imageCompressionMode}      = sprintf "%02X", ($data[38] & 0x7);
    $self->{_huffmanAC}                 = sprintf "%02X", (($data[39] & 0x7F) >> 5);
    $self->{_huffmanDC}                 = sprintf "%02X", (($data[39] >> 3) & 0x3);
    $self->{_quantization}              = sprintf "%02X", ($data[39] & 0x7);

    $temp                               = sprintf "%08X", (($data[40] << 24) | $data[41] << 16);
    $self->{_ti1}                       = sprintf "%08X", (($data[42] << 8) | ($data[43]) | hex($temp));

    $temp                               = sprintf "%08X", (($data[44] << 24) | $data[45] << 16);
    $self->{_ti2}                       = sprintf "%08X", (($data[46] << 8) | ($data[47]) | hex($temp));

    $temp                               = sprintf "%08X", (($data[48] << 24) | $data[49] << 16);
    $self->{_mhcDuration}               = sprintf "%08X", (($data[50] << 8) | ($data[51]) | hex($temp));

    $self->{_exposureDuration}          = sprintf "%04X", (($data[52] << 8) | $data[53]);
    $self->{_sequenceNumber}            = sprintf "%03u", $data[54];
    $self->{_linelistNumber}            = sprintf "%02u", $data[55];
    $self->{_sequenceId}                = sprintf "%04X", (($data[56] << 8) | $data[57]);
    $self->{_rasterId}                  = sprintf "%04X", (($data[58] << 8) | $data[59]);
    
    $self->{_numberOfWindows}           = sprintf "%02u", ($data[60] >> 3);
#	$self->{_ccdXLength};
#	$self->{_Xws};
#	$self->{_Xw};
#	$self->{_Yws};
#	$self->{_Yw};
# Windows

    $self->{_coarseMirrorPosition}      = sprintf "%04X", (($data[168] << 8) | $data[169]);

    $self->{_fineMirrorPosition}        = sprintf "%04X", (($data[170] << 8) | $data[171]);
    $self->{_slitNumber}                = sprintf "%04X", (($data[172] << 8) | $data[173]);
    $self->{_xOcb}                      = sprintf "%04X", $data[174];
    $self->{_yOcb}                      = sprintf "%04X", $data[175];

    $temp                               = sprintf "%04X", (($data[176] << 24) | ($data[177] << 16));
    $self->{_rastersRequired}           = sprintf "%08X", ((($data[178] << 8) | $data[179]) | hex($temp));

    $temp                               = sprintf "%04X", (($data[180] << 24) | ($data[181] << 16));
    $self->{_rastersCounter}            = sprintf "%08X", ((($data[182] << 8) | $data[183]) | hex($temp));

    $self->{_rasterRepeatsRequired}     = sprintf "%04X", (($data[184] << 4) | ($data[185] >> 4));
    $self->{_rasterRepeatsPerformed}    = sprintf "%04X", ((($data[185] & 0xF) << 8) | ($data[186]));

    $self->{_sequenceRepeatsRequired}   = sprintf "%02X", $data[187];
    $self->{_sequenceRepeatsPerformed}  = sprintf "%02X", $data[188];

    $self->{_ccdReadoutNode}            = sprintf "%02X", $data[189];
    $self->{_HSLStatus}                 = sprintf "%04X", (($data[190] << 8) | $data[191]);

    $self->{_scienceOp}                 = sprintf "%02X", $data[192];
    $self->{_xrtFlareFlag}              = sprintf "%02X", $data[193];
    $self->{_xrtFlareFlagX}             = sprintf "%02X", $data[194];
    $self->{_xrtFlareFlagY}             = sprintf "%02X", $data[195];
    $temp                               = sprintf "%08X", (($data[196] << 24) | ($data[197] << 16));
    $self->{_AECHepc}                   = sprintf "%08X", ((($data[198] << 8) | $data[199]) | hex($temp));
    $temp                               = sprintf "%08X", (($data[200] << 24) | ($data[201] << 16));
    $self->{_AECLepc}                   = sprintf "%08X", ((($data[202] << 8) | $data[203]) | hex($temp));
    $self->{_EISXRTX}                   = sprintf "%04X", (($data[204] << 8) | $data[205]);
    $self->{_EISXRTY}                   = sprintf "%04X", (($data[206] << 8) | $data[207]);
    $self->{_fineMirrorStrainGauge}     = sprintf "%04X", (($data[208] << 8) | $data[209]);
    $self->{_EISFlareX}                 = sprintf "%04X", (($data[210] << 8) | $data[211]);
    $self->{_EISFlareY}                 = sprintf "%04X", (($data[212] << 8) | $data[213]);
    $self->{_EISEventX}                 = sprintf "%04X", (($data[214] << 8) | $data[215]);
    $self->{_EISEventY}                 = sprintf "%04X", (($data[216] << 8) | $data[217]);

    $self->{_ASRCStatus}                = sprintf "%02X", $data[218];
    $self->{_ASRCSkip}                  = sprintf "%02X", $data[219];
    $self->{_exposuresPerRasterPosition} = sprintf "%02X", $data[220];
    $self->{_FMIRStepSize}              = sprintf "%04X", (($data[221] << 8) | $data[222]);
}

sub hslStat {
    my $self = shift;
    return $self->{_HSLStatus};
}

# Don't need methods below...?

sub isFirstExposurePacket {
    my $self = shift;

    return
	(($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 1)) ||
	(($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 3)) ||
	(($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 1)) ||
	(($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 3));
}

sub isFirstExposurePacket1 {
    my $self = shift;

    return (($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 1)) ||
	(($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 1)) ||
	(($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 3));

}

sub isMiddleExposurePacket {
    my $self = shift;
    return $self->{_mainSequenceFlag} == 0;
#    return (($self->{_mainSequenceFlag} == 0) && ($self->{_subSequenceFlag} == 1));
}

sub isLastExposurePacket {
    my $self = shift;
    return ($self->{_subSequenceFlag} == 2);
#    return (($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 1));
}

sub isLastExposurePacket1 {
    my $self = shift;
    return (($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 2)) ||
	(($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 2)) ||
	(($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 3));

#    return (($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 1));
}

sub isStandAloneExposurePacket {
    my $self = shift;
    return $self->{_mainSequenceFlag} == 3;
#    return ((($self->{_mainSequenceFlag} == 3) || ($self->{_mainSequenceFlag} == 1)) && ($self->{_subSequenceFlag} == 3));
}

sub sequenceFlags {
    my $self = shift;
    return($self->{_mainSequenceFlag}, $self->{_subSequenceFlag});
}

sub isEndExposurePacket {
    my $self = shift;
    return(isLastExposurePacket($self) || isStandAloneExposurePacket($self));
}

#sub isCompressed {
#    my $self = shift;
#
#    return $self->{_compression};
#}


sub data_type {
    my $self = shift;
    return $self->{_dataType};
}

sub packetSize {
    my $self = shift;
    return $self->{_packetSize};
}

sub spn {
    my $self = shift;
    return sprintf "%u", hex($self->{_serialPacketNumber});
}

sub setSpn {
    my $self = shift;
    my $spn  = shift;
    $self->{_serialPacketNumber} = $spn;
}

sub mid {
    my $self = shift;
    return $self->{_mainId};
}

sub mainSequenceFlag {
    my $self = shift;
    return $self->{_mainSequenceFlag};
}

sub setMainSequenceFlag {
    my $self = shift;
    my $mid = shift;
    $self->{_mainSequenceFlag} = $mid;
}

sub mainSequenceCount {
    my $self = shift;
    return $self->{_mainSequenceCount};
}

sub setMainSequenceCount {
    my $self = shift;
    my $msc = shift;
    $self->{_mainSequenceCount} = $msc;
}

sub ppe {
    my $self = shift;
    return $self->{_mdPacketsPerExposure};
}

sub imagePerFrame {
    return $_[0]->{_imagePerFrame};
}

sub sid {
    my $self = shift;
    return $self->{_subId};
}

sub setSid {
    my $self = shift;
    my $sid = shift;
    $self->{_subId} = $sid;
}

sub subSequenceFlag {
    my $self = shift;
    return $self->{_subSequenceFlag};
}

sub sstSubSequenceFlag {
    my $self = shift;
    my $ssf = shift;
    $self->{_subSequenceFlag} = $ssf;
}

sub subSequenceCount {
    my $self = shift;
    return $self->{_subSequenceCount};
}

sub setSubSequenceCount {
    my $self = shift;
    my $ssc = shift;
    $self->{_subSequenceCount} = $ssc;
}

sub fx {
    return $_[0]->{_fullImageSizeX};
}

sub setFx {
    $_[0]->{_fullImageSizeX} = $_[1];
}

sub fy {
    return $_[0]->{_fullImageSizeY};
}

sub setFy {
    $_[0]->{_fullImageSizeY} = $_[1];
}

sub px {
    return $_[0]->{_partialImageSizeX};
}

sub setPx {
    $_[0]->{_partialImageSizeX} = $_[1];
}

sub py {
    return $_[0]->{_partialImageSizeY};
}

sub setPy {
    $_[0]->{_partialImageSizeY} = $_[1];
}

sub bx {
    return $_[0]->{_basePointX};
}

sub setBx {
    $_[0]->{_basePointX} = $_[1];
}

sub by {
    return $_[0]->{_basePointY};
}

sub setBy {
    $_[0]->{_basePointY} = $_[1];
}

sub bitCompressionMode {
    my $self = shift;

    return $self->{_bitCompressionMode};
}

sub imageCompressionMode {
    return $_[0]->{_imageCompressionMode};
}

sub imageCompressionParameters {
    return $_[0]->{_imageCompressionParameters};
}

sub ti1 {
    return $_[0]->{_ti1};
}

sub setTi1 {
   $_[0]->{_ti1} = $_[1];
}

sub ti2 {
    return $_[0]->{_ti2};
}

sub setTi2 {
    $_[0]->{_ti2} = $_[1];
}

sub mhcDuration {
    return $_[0]->{_mhcDuration};
}

sub exposureDuration {
    return $_[0]->{_exposureDuration};
}

sub sequenceNumber {
    return $_[0]->{_sequenceNumber};
}

sub linelistNumber {
    return $_[0]->{_linelistNumber};
}

sub sequenceId {
    return $_[0]->{_sequenceId};
}

sub rasterId {
    return $_[0]->{_rasterId};
}

sub fineMirrorPosition {
    return $_[0]->{_fineMirrorPosition};
}

sub setFineMirrorPosition {
    $_[0]->{_fineMirrorPosition} = $_[1];
}

sub exposuresRequird {
    return $_[0]->{_rastersRequired};
}

sub exposuresPerformed {
    return $_[0]->{_rastersCounter};
}

sub setExposuresPerformed {
    $_[0]->{_rastersCounter} = $_[1];
}

sub rasterRepeatsRequird {
    return $_[0]->{_rasterRepeatsRequired};
}

sub rasterRepeatsPerformed {
    return $_[0]->{_rasterRepeatsPerformed};
}

sub setRasterRepeatsPerformed {
    $_[0]->{_rasterRepeatsPerformed} = $_[1];
}

sub fineMirrorStrainGauge {
    return $_[0]->{_fineMirrorStrainGauge};
}

sub setFineMirrorStrainGauge {
    $_[0]->{_fineMirrorStrainGauge} = $_[1];
}

sub exposuresPerRasterPosition {
    return $_[0]->{_exposuresPerRasterPosition};
}

sub fineMirrorStepSize {
    return $_[0]->{_FMIRStepSize};
}

#sub data {
#    return $_[0]->{_data};
#}

#sub setData {
##    $_[0]->populate_header($_[0], $_[1]);
#    $_[0]->populate_header($_[1]);
#}

#sub appendData {
#    $_[0]->{_data} .= $_[1];
#}

sub header {
    return $_[0];
}

sub headerBytes {
    return $_[0]->{_headerBytes};
}

sub tableInfo {
    my $self = shift;
    my $ret;
    
    $ret = pack "C*", hex($self->{_byte0}),hex($self->{_byte1}),hex($self->{_byte2}),hex($self->{_byte3}),hex($self->{_byte4}),hex($self->{_byte5}),hex($self->{_byte6}),hex($self->{_byte7});
    return $ret;
#    return ($self->{_byte0} . $self->{_byte1} . $self->{_byte2} . $self->{_byte3} . $self->{_byte4} . $self->{_byte5} . $self->{_byte6} . $self->{_byte7});
}


#sub setCompression {
#    my $self = shift;
#    my $comp = shift;
#
#    $self->{_compression} = sprintf "%04X", hex($comp);
#}

1;
