package MdHeaderReport;

use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib";

use MdHeader;
use strict;

use vars qw(@ISA @EXPORT $VERSION);

use Exporter;
$VERSION = 1.00;
@ISA = qw(Exporter MdHeader);

@EXPORT = qw();

sub BEGIN {
#    print STDOUT "Ccsds BEGIN\n";
#    $numberOfPackets = 0;
}

sub new {
    my ($class) = shift;
    my $self = {
    };
    bless $self, $class; 
    return $self;
}

sub header_summary {
    my $self = shift;

    print STDOUT "type: ", $self->{_dataType}, " size: ", $self->{_packetSize}, " num: ", $self->{_serialPacketNumber}," ";
    print STDOUT "mid: ", $self->{_mainId}, " msf: ", $self->{_mainSequenceFlag}, " msc: ", $self->{_mainSequenceCount}, " sid: ", $self->{_subId}, " ssf: ", $self->{_subSequenceFlag}, " ssc: ", $self->{_subSequenceCount}, " ";
    print STDOUT "seq: ", $self->{_sequenceNumber}, " ll: ", $self->{_linelistNumber}, " seqid: ", $self->{_sequenceId}, " rasid:", $self->{_rasterId}, " ";
    print STDOUT "comp: ", $self->{_compression}, "\n";
}

sub header_summary1 {
    my $self = shift;

    print STDOUT "type: ", $self->{_dataType}, " size: ", $self->{_packetSize}, " num: ", $self->{_serialPacketNumber}," ";
    print STDOUT "mid: ", $self->{_mainId}, " msf: ", $self->{_mainSequenceFlag}, " msc: ", $self->{_mainSequenceCount}, " sid: ", $self->{_subId}, " ssf: ", $self->{_subSequenceFlag}, " ssc: ", $self->{_subSequenceCount}, " ";
    print STDOUT "seq: ", $self->{_sequenceNumber}, " ll: ", $self->{_linelistNumber}, " seqid: ", $self->{_sequenceId}, " rasid:", $self->{_rasterId}, " ";
    print STDOUT "comp: ", $self->{_compression}, "\n";
#################    print STDOUT "TI1: ", $self->{_ti1}, " TI2: ", $self->{_ti2}, "\n";
}

sub header_times {
    my $self = shift;

    print STDOUT "type: ", $self->{_dataType}, " size: ", $self->{_packetSize}, " num: ", $self->{_serialPacketNumber}," ";
    print STDOUT "mid: ", $self->{_mainId}, " msf: ", $self->{_mainSequenceFlag}, " msc: ", $self->{_mainSequenceCount}, " sid: ", $self->{_subId}, " ssf: ", $self->{_subSequenceFlag}, " ssc: ", $self->{_subSequenceCount}, " ";
    print STDOUT "seq: ", $self->{_sequenceNumber}, " ll: ", $self->{_linelistNumber}, " seqid: ", $self->{_sequenceId}, " rasid:", $self->{_rasterId}, " ";
    print STDOUT "TI1: ", $self->{_ti1}, " TI2: ", $self->{_ti2}, "\n";
}

sub header_report_header {
    my $self = shift;
    print "Type     Size   Number  MID MSF  MSC PE IF  SID SSF  SSC   FX   FY   BX   BY   PX   PY COMP      TI1      TI2      MHC  DUR SEQ LL  SiD  Rid #w CMIR FMIR SLA# OCBX OCBY   RasReq  RasDone RRep RRep Seq Seq RO  HSL OP XRT XRTX XRTY  AECHepc  AECLepc EXRTX EXRTY FMSG EFLX EFLY EEVX EEVY ASRC ASRC EP FMSS\n";
}

sub header_report1 {
    my $self = shift;

    format = 
@>>>@>>>>>>>>@>>>>>>>>@>>>> @>>@>>>>@>>@>>@>>>> @>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>>>>>@>>>>>>>>@>>>>>>>>@>>>>@>>>@>>@>>>>@>>>>@>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>>>>>@>>>>>>>>@>>>>@>>>>@>>>@>>>@>>@>>>>@>>@>>>@>>>>@>>>>@>>>>>>>>@>>>>>>>>@>>>>>@>>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>@>>>>
$self->{_dataType}, $self->{_packetSize}, $self->{_serialPacketNumber} $self->{_mainId} $self->{_mainSequenceFlag} $self->{_mainSequenceCount} $self->{_mdPacketsPerExposure} $self->{_imagePerFrame} $self->{_subId} $self->{_subSequenceFlag} $self->{_subSequenceCount} $self->{_fullImageSizeX} $self->{_fullImageSizeY} $self->{_basePointX} $self->{_basePointY} $self->{_partialImageSizeX} $self->{_partialImageSizeY} $self->{_compression} $self->{_ti1} $self->{_ti2} $self->{_mhcDuration} $self->{_exposureDuration} $self->{_sequenceNumber} $self->{_linelistNumber} $self->{_sequenceId} $self->{_rasterId} $self->{_numberOfWindows} $self->{_coarseMirrorPosition} $self->{_fineMirrorPosition} $self->{_slitNumber} $self->{_xOcb} $self->{_yOcb} $self->{_rastersRequired} $self->{_rastersCounter} $self->{_rasterRepeatsRequired} $self->{_rasterRepeatsPerformed} $self->{_sequenceRepeatsRequired} $self->{_sequenceRepeatsPerformed} $self->{_ccdReadoutNode} $self->{_HSLStatus} $self->{_scienceOp} $self->{_xrtFlareFlag} $self->{_xrtFlareFlagX} $self->{_xrtFlareFlagY} $self->{_AECHepc} $self->{_AECLepc} $self->{_EISXRTX} $self->{_EISXRTY} $self->{_fineMirrorStrainGauge} $self->{_EISFlareX} $self->{_EISFlareY} $self->{_EISEventX} $self->{_EISEventY} $self->{_ASRCStatus} $self->{_ASRCSkip} $self->{_exposurePerRasterPosition} $self->{_FMIRStepSize}
.
    write;
}

sub header_report {
    my $self = shift;

    if($self->{_isasArchive}) {
	print STDOUT "\nComp table: ", $self->{_byte0}, " ", $self->{_byte1}, " ", $self->{_byte2}, " ", $self->{_byte3}, " ", $self->{_byte4}, " ", $self->{_byte5}, " ", $self->{_byte6}, " ", $self->{_byte7}, "\n";
    }

    print STDOUT "type: ", $self->{_dataType}, "\tsize: ", $self->{_packetSize}, "\tpkt num: ", $self->{_serialPacketNumber}, "\n";
    print STDOUT "mid:  ", $self->{_mainId}, "\tmsf:  ", $self->{_mainSequenceFlag}, "\t\tmsc:     ", $self->{_mainSequenceCount}, "\nsid:  ", $self->{_subId}, "\tssf:  ", $self->{_subSequenceFlag}, "\t\tssc:     ", $self->{_subSequenceCount}, "\n";

    print STDOUT "Pkts/exposure: ". $self->{_mdPacketsPerExposure}, " i/f: ", $self->{_imagePerFrame}, "\n";

    if($self->{_isasArchive}) {
	print STDOUT "Compression: ", $self->{_compression}, "\t";
    }
    print STDOUT "Bit comp: ", $self->{_bitCompressionMode}, " Im comp par: ", $self->{_imageCompressionMode}, " Huf AC: ", $self->{_huffmanAC}, " Huf DC: ", $self->{_huffmanDC}, " Quant: ", $self->{_quantization}, "\n";

    print STDOUT "Ti1: ", $self->{_ti1}, " ti2: ", $self->{_ti2},
    " MHC: ", $self->{_mhcDuration}, " exp: ", $self->{_exposureDuration}, "\n";
    print STDOUT "seq num: ", $self->{_sequenceNumber}, " ll: ", $self->{_linelistNumber},
    " seq id: ", $self->{_sequenceId}, " ras id:", $self->{_rasterId}, "\n";
    print STDOUT "win: ", $self->{_numberOfWindows}, "\n";
    print STDOUT "coarse: ", $self->{_coarseMirrorPosition}, " fine: ", $self->{_fineMirrorPosition}, " slit: ", $self->{_slitNumber}, "\n";
    print STDOUT "Xocb: ", $self->{_xOcb}, " Yocb: ", $self->{_yOcb}, "\n";
    print STDOUT "exp req: ", $self->{_rastersRequired}, " exp cnt: ", $self->{_rastersCounter}, "\n";
    print STDOUT "ras reps req: ", $self->{_rasterRepeatsRequired}, " Ras rep done: ", $self->{_rasterRepeatsPerformed}, "\n";
    print STDOUT "seq reps req: ", $self->{_sequenceRepeatsRequired}, " Seq rep done: ", $self->{_sequenceRepeatsPerformed}, "\n";
    print STDOUT "ro: ", $self->{_ccdReadoutNode}, " HSL: ", $self->{_HSLStatus}, " sci: ", $self->{_scienceOp}, "\n";
    print STDOUT "XRT flare: ", $self->{_xrtFlareFlag}, " XRT X: ", $self->{_xrtFlareFlagX}, " XRT Y: ", $self->{_xrtFlareFlagY}, "\n";
    print STDOUT "Hepc: ", $self->{_AECHepc}, " Lepc: ", $self->{_AECLepc}, "\n";
    print STDOUT "Eis XRTX: ", $self->{_EISXRTX}, " Eis XRTY: ", $self->{_EISXRTY}, "\n";
    print STDOUT "Fmir: ", $self->{_fineMirrorStrainGauge}, "\n";
    print STDOUT "Eis Flare X: ", $self->{_EISFlareX}, " Eis Flare Y: ", $self->{_EISFlareY}, "\n";
    print STDOUT "Eis Event X: ", $self->{_EISEventX}, " Eis Event Y: ", $self->{_EISEventY}, "\n";
    print STDOUT "ASRC stat: ", $self->{_ASRCStatus}, " ASRC skip: ", $self->{_ASRCSkip}, " Exp/pos: ", $self->{_exposurePerRasterPosition}, " fmir step: ", $self->{_FMIRStepSize}, "\n";
    print STDOUT "\n";
}

#sub report {
#    my $self = shift;
#    print STDOUT "(Sts1 ", $self->{_numberOfSts1Packets}, ")\n";
#}

sub tableInfo {
    my $self = shift;
    my $ret;
    
    $ret = pack "C*", hex($self->{_byte0}),hex($self->{_byte1}),hex($self->{_byte2}),hex($self->{_byte3}),hex($self->{_byte4}),hex($self->{_byte5}),hex($self->{_byte6}),hex($self->{_byte7});
    return $ret;
#    return ($self->{_byte0} . $self->{_byte1} . $self->{_byte2} . $self->{_byte3} . $self->{_byte4} . $self->{_byte5} . $self->{_byte6} . $self->{_byte7});
}

1;
