package MdInterface;

#use lib "/home/matt/solarb/util/lib/CcsdsLib2";

#use CcsdsInterface;
use strict;

use vars qw(@ISA @EXPORT $VERSION);

use Exporter;
$VERSION = 1.00;
@ISA = qw(Exporter CcsdsInterface);

@EXPORT = qw(setEndian nextPacket printPrimaryHeader);

sub BEGIN {
#    print STDOUT "Ccsds BEGIN\n";
#    $numberOfPackets = 0;
}

sub new {
    my $classname = shift;
    my $self = $classname->SUPER::new(@_);
    $self->_init(@_);
    return $self;
}

sub _init {
    my $self = shift;

    $self->{_isasArchive} = 0,
    $self->{_byte0} = 0,
    $self->{_byte1} = 0,
    $self->{_byte2} = 0,
    $self->{_byte3} = 0,
    $self->{_byte4} = 0,
    $self->{_byte5} = 0,
    $self->{_byte6} = 0,
    $self->{_byte7} = 0,

    $self->{_dataType} = 0,
    $self->{_packetSize} = 0,
    $self->{_serialPacketNumber},
    $self->{_mainId} = 0,
    $self->{_mainSequenceFlag},
    $self->{_mainSequenceCount},
    $self->{_mdPacketsPerExposure},
    $self->{_imagePerFrame},
    $self->{_subId},
    $self->{_subSequenceFlag},
    $self->{_subSequenceCount},
    $self->{_fullImageSizeX},
    $self->{_fullImageSizeY},
    $self->{_partialImageSizeX},
    $self->{_partialImageSizeY},
    $self->{_basePointX},
    $self->{_basePointY},
    $self->{_bitCompressionMode},
    $self->{_imageCompressionMode},
    $self->{_imageCompressionParameters},
    $self->{_ti1},
    $self->{_ti2},
    $self->{_mhcDuration},
    $self->{_exposureDuration},
    $self->{_sequenceNumber},
    $self->{_linelistNumber},
    $self->{_sequenceId},
    $self->{_rasterId},
    $self->{_numberOfWindows},
    $self->{_ccdXLength},
    $self->{_Xws},
    $self->{_Xw},
    $self->{_Yws},
    $self->{_Yw},
# Windows
    $self->{_coarseMirrorPosition},
    $self->{_fineMirrorPosition},
    $self->{_slitNumber},
    $self->{_xOcb},
    $self->{_yOcb},
    $self->{_rastersRequired},
    $self->{_rastersCounter},
    $self->{_rasterRepeatsRequired},
    $self->{_rasterRepeatsPerformed},
    $self->{_sequenceRepeatsRequired},
    $self->{_sequenceRepeatsPerformed},
    $self->{_ccdReadoutNode},
    $self->{_HSLStatus},
    $self->{_scienceOp},
    $self->{_xrtFlareFlag},
    $self->{_xrtFlareFlagX},
    $self->{_xrtFlareFlagY},
    $self->{_AECHepc},
    $self->{_AECLepc},
    $self->{_EISXRTX},
    $self->{_EISXRTY},
    $self->{_fineMirrorStrainGauge},
    $self->{_EISFlareX},
    $self->{_EISFlareY},
    $self->{_EISEventX},
    $self->{_EISEventY},
    $self->{_ASRCStatus},
    $self->{_ASRCSkip},
    $self->{_exposurePerRasterPosition},
    $self->{_FMIRStepSize},
}

sub get_bigendian_header_packet() {
    my $self = shift;
    my $res;

    $res = nextPacket($self);
    return 0 if($res == 0);
    if(($self->{_packetApid} == 0x01CA) || ($self->{_packetApid} == 0x01CB)) {
	if($self->{_packetLength} != 267) {
#	    print STDERR "BAD HEADER LENGTH (", $self->{_packetLength}, ")\n";
	    return 0;
	}

#	$self->{_isasArchive} = 1 if($self->{_packetLength} == 267);	
#	if($self->{_isasArchive}) {
	decode_bigendian_isas_header($self);
#	}
#	else {
#	    decode_bigendian_header($self);
#	}
	$res = sprintf("%u", hex($self->{_dataType}));
#	if(($self->{_dataType} == 0xC3) || ($self->{_dataType} == 0xC2)) {
	if(($res == 0xC3) || ($res == 0xC2)) {
	    ++$self->{_numberOfMdPackets};
	    ++$self->{_numberOfMdHeaders};
	    return 1;
	}
    }
    return 0;
}

sub get_header_packet() {
    my $self = shift;
    my $res;

    $res = nextPacket($self);
    return 0 if($res == 0);
    if(($self->{_packetApid} == 0x01CA) || ($self->{_packetApid} == 0x01CB)) {
	++$self->{_numberOfMdPackets};
	++$self->{_numberOfMdHeaders};

	$self->{_isasArchive} = 1 if($self->{_packetLength} == 267);	
	if($self->{_isasArchive}) {
	    decode_isas_header($self);
	}
	else {
	    decode_mssl_header($self);
	}
	return 1;
    }
    return 0;
}

sub getHeader {
    my $self = shift;
    return $self->{_userData};
}

sub getDecodedHeader {
    return $_[0];
}

sub decode_bigendian_isas_header {
    my $self = shift;
    my @data;
    my $temp;

#    print STDOUT "ISAS Bigendian\n";

    @data = unpack "C*", $self->{_userData};

#    $temp = scalar(@data);
#    if($temp != 264) {
#	print "BAD HEADER ($temp)\n";
#	return;
#    }

    $self->{_byte0} = sprintf "%02X", unpack("x0C", $self->{_userData});
    $self->{_byte1} = sprintf "%02X", unpack("x1C", $self->{_userData});
    $self->{_byte2} = sprintf "%02X", unpack("x2C", $self->{_userData});
    $self->{_byte3} = sprintf "%02X", unpack("x3C", $self->{_userData});
    $self->{_byte4} = sprintf "%02X", unpack("x4C", $self->{_userData});
    $self->{_byte5} = sprintf "%02X", unpack("x5C", $self->{_userData});
    $self->{_byte6} = sprintf "%02X", unpack("x6C", $self->{_userData});
    $self->{_byte7} = sprintf "%02X", unpack("x7C", $self->{_userData});

    $self->{_dataType}                  = sprintf "%02X", $data[8];
    $temp                               = sprintf "%08X", (($data[9] << 16) | ($data[10] << 8));
    $self->{_packetSize}                = sprintf "%08X", ($data[11] | hex($temp));
    $temp                               = sprintf "%08X", (($data[12] << 24) | ($data[13] << 16) | ($data[14] << 8));
    $self->{_serialPacketNumber}        = sprintf "%08X", ($data[15] | hex($temp));

    $self->{_mainId}                    = sprintf "%04X", (($data[16] << 8) | $data[17]);
    $self->{_mainSequenceFlag}          = sprintf "%u", ($data[18] >> 6);
    $self->{_mainSequenceCount}         = sprintf "%04X", (($data[18] & 0x3F) | $data[19]);

    $self->{_mdPacketsPerExposure}      = sprintf "%02X", ( (($data[20] & 0x3F) << 2) | ($data[21] >> 6));
    $self->{_imagePerFrame}             = sprintf "%02X", ($data[21] & 0x3F);

    $self->{_subId}                     = sprintf "%04X", (($data[22] << 8) | $data[23]);
    $self->{_subSequenceFlag}           = sprintf "%u", ($data[24] >> 6);
    $self->{_subSequenceCount}          = sprintf "%04X", (($data[24] & 0x3F) | $data[25]);
    $self->{_fullImageSizeX}            = sprintf "%04X", (($data[26] << 8) | $data[27]);
    $self->{_fullImageSizeY}            = sprintf "%04X", (($data[28] << 8) | $data[29]);
    $self->{_basePointX}                = sprintf "%04X", (($data[30] << 8) | $data[31]);
    $self->{_basePointY}                = sprintf "%04X", (($data[32] << 8) | $data[33]);
    $self->{_partialImageSizeX}         = sprintf "%04X", (($data[34] << 8) | $data[35]);
    $self->{_partialImageSizeY}         = sprintf "%04X", (($data[36] << 8) | $data[37]);

    $self->{_compression}               = sprintf "%04X", (($data[38] << 8) | $data[39]);
    $self->{_bitCompressionMode}        = sprintf "%02X", (($data[38] & 0x7F) >> 3);
    $self->{_imageCompressionMode}      = sprintf "%02X", ($data[38] & 0x7);
    $self->{_huffmanAC}                 = sprintf "%02X", (($data[39] & 0x7F) >> 5);
    $self->{_huffmanDC}                 = sprintf "%02X", (($data[39] >> 3) & 0x3);
    $self->{_quantization}              = sprintf "%02X", ($data[39] & 0x7);

    $temp                               = sprintf "%08X", (($data[40] << 24) | $data[41] << 16);
    $self->{_ti1}                       = sprintf "%08X", (($data[42] << 8) | ($data[43]) | hex($temp));

    $temp                               = sprintf "%08X", (($data[44] << 24) | $data[45] << 16);
    $self->{_ti2}                       = sprintf "%08X", (($data[46] << 8) | ($data[47]) | hex($temp));

    $temp                               = sprintf "%08X", (($data[48] << 24) | $data[49] << 16);
    $self->{_mhcDuration}               = sprintf "%08X", (($data[50] << 8) | ($data[51]) | hex($temp));

    $self->{_exposureDuration}          = sprintf "%04X", (($data[52] << 8) | $data[53]);
    $self->{_sequenceNumber}            = sprintf "%03u", $data[54];
    $self->{_linelistNumber}            = sprintf "%02u", $data[55];
    $self->{_sequenceId}                = sprintf "%04X", (($data[56] << 8) | $data[57]);
    $self->{_rasterId}                  = sprintf "%04X", (($data[58] << 8) | $data[59]);
    
    $self->{_numberOfWindows}           = sprintf "%02u", ($data[60] >> 3);
#	$self->{_ccdXLength};
#	$self->{_Xws};
#	$self->{_Xw};
#	$self->{_Yws};
#	$self->{_Yw};
# Windows

    $self->{_coarseMirrorPosition}      = sprintf "%04X", (($data[168] << 8) | $data[169]);

    $self->{_fineMirrorPosition}        = sprintf "%04X", (($data[170] << 8) | $data[171]);
    $self->{_slitNumber}                = sprintf "%04X", (($data[172] << 8) | $data[173]);
    $self->{_xOcb}                      = sprintf "%04X", $data[174];
    $self->{_yOcb}                      = sprintf "%04X", $data[175];

    $temp                               = sprintf "%04X", (($data[176] << 24) | ($data[177] << 16));
    $self->{_rastersRequired}           = sprintf "%08X", ((($data[178] << 8) | $data[179]) | hex($temp));

    $temp                               = sprintf "%04X", (($data[180] << 24) | ($data[181] << 16));
    $self->{_rastersCounter}            = sprintf "%08X", ((($data[182] << 8) | $data[183]) | hex($temp));

    $self->{_rasterRepeatsRequired}     = sprintf "%04X", (($data[184] << 4) | ($data[185] >> 4));
    $self->{_rasterRepeatsPerformed}    = sprintf "%04X", ((($data[185] & 0xF) << 8) | ($data[186]));

    $self->{_sequenceRepeatsRequired}   = sprintf "%02X", $data[187];
    $self->{_sequenceRepeatsPerformed}  = sprintf "%02X", $data[188];

    $self->{_ccdReadoutNode}            = sprintf "%02X", $data[189];
    $self->{_HSLStatus}                 = sprintf "%04X", (($data[190] << 8) | $data[191]);

    $self->{_scienceOp}                 = sprintf "%02X", $data[192];
    $self->{_xrtFlareFlag}              = sprintf "%02X", $data[193];
    $self->{_xrtFlareFlagX}             = sprintf "%02X", $data[194];
    $self->{_xrtFlareFlagY}             = sprintf "%02X", $data[195];
    $temp                               = sprintf "%08X", (($data[196] << 24) | ($data[197] << 16));
    $self->{_AECHepc}                   = sprintf "%08X", ((($data[198] << 8) | $data[199]) | hex($temp));
    $temp                               = sprintf "%08X", (($data[200] << 24) | ($data[201] << 16));
    $self->{_AECLepc}                   = sprintf "%08X", ((($data[202] << 8) | $data[203]) | hex($temp));
    $self->{_EISXRTX}                   = sprintf "%04X", (($data[204] << 8) | $data[205]);
    $self->{_EISXRTY}                   = sprintf "%04X", (($data[206] << 8) | $data[207]);
    $self->{_fineMirrorStrainGauge}     = sprintf "%04X", (($data[208] << 8) | $data[209]);
    $self->{_EISFlareX}                 = sprintf "%04X", (($data[210] << 8) | $data[211]);
    $self->{_EISFlareY}                 = sprintf "%04X", (($data[212] << 8) | $data[213]);
    $self->{_EISEventX}                 = sprintf "%04X", (($data[214] << 8) | $data[215]);
    $self->{_EISEventY}                 = sprintf "%04X", (($data[216] << 8) | $data[217]);

    $self->{_ASRCStatus}                = sprintf "%02X", $data[218];
    $self->{_ASRCSkip}                  = sprintf "%02X", $data[219];
    $self->{_exposurePerRasterPosition} = sprintf "%02X", $data[220];
    $self->{_FMIRStepSize}              = sprintf "%04X", (($data[221] << 8) | $data[222]);
}

sub return_decoded_bigendian_isas_header {
    my $self = shift;
    my @data;
    my $temp;

#    print STDOUT "ISAS Bigendian\n";

    @data = unpack "C*", $self->{_userData};

#    $temp = scalar(@data);
#    if($temp != 264) {
#	print "BAD HEADER ($temp)\n";
#	return;
#    }

    $self->{_byte0} = sprintf "%02X", unpack("x0C", $self->{_userData});
    $self->{_byte1} = sprintf "%02X", unpack("x1C", $self->{_userData});
    $self->{_byte2} = sprintf "%02X", unpack("x2C", $self->{_userData});
    $self->{_byte3} = sprintf "%02X", unpack("x3C", $self->{_userData});
    $self->{_byte4} = sprintf "%02X", unpack("x4C", $self->{_userData});
    $self->{_byte5} = sprintf "%02X", unpack("x5C", $self->{_userData});
    $self->{_byte6} = sprintf "%02X", unpack("x6C", $self->{_userData});
    $self->{_byte7} = sprintf "%02X", unpack("x7C", $self->{_userData});

    $self->{_dataType}                  = sprintf "%02X", $data[8];
    $temp                               = sprintf "%08X", (($data[9] << 16) | ($data[10] << 8));
    $self->{_packetSize}                = sprintf "%08X", ($data[11] | hex($temp));
    $temp                               = sprintf "%08X", (($data[12] << 24) | ($data[13] << 16) | ($data[14] << 8));
    $self->{_serialPacketNumber}        = sprintf "%08X", ($data[15] | hex($temp));

    $self->{_mainId}                    = sprintf "%04X", (($data[16] << 8) | $data[17]);
    $self->{_mainSequenceFlag}          = sprintf "%u", ($data[18] >> 6);
    $self->{_mainSequenceCount}         = sprintf "%04X", (($data[18] & 0x3F) | $data[19]);

    $self->{_mdPacketsPerExposure}      = sprintf "%02X", ( (($data[20] & 0x3F) << 2) | ($data[21] >> 6));
    $self->{_imagePerFrame}             = sprintf "%02X", ($data[21] & 0x3F);

    $self->{_subId}                     = sprintf "%04X", (($data[22] << 8) | $data[23]);
    $self->{_subSequenceFlag}           = sprintf "%u", ($data[24] >> 6);
    $self->{_subSequenceCount}          = sprintf "%04X", (($data[24] & 0x3F) | $data[25]);
    $self->{_fullImageSizeX}            = sprintf "%04X", (($data[26] << 8) | $data[27]);
    $self->{_fullImageSizeY}            = sprintf "%04X", (($data[28] << 8) | $data[29]);
    $self->{_basePointX}                = sprintf "%04X", (($data[30] << 8) | $data[31]);
    $self->{_basePointY}                = sprintf "%04X", (($data[32] << 8) | $data[33]);
    $self->{_partialImageSizeX}         = sprintf "%04X", (($data[34] << 8) | $data[35]);
    $self->{_partialImageSizeY}         = sprintf "%04X", (($data[36] << 8) | $data[37]);

    $self->{_compression}               = sprintf "%04X", (($data[38] << 8) | $data[39]);
    $self->{_bitCompressionMode}        = sprintf "%02X", (($data[38] & 0x7F) >> 3);
    $self->{_imageCompressionMode}      = sprintf "%02X", ($data[38] & 0x7);
    $self->{_huffmanAC}                 = sprintf "%02X", (($data[39] & 0x7F) >> 5);
    $self->{_huffmanDC}                 = sprintf "%02X", (($data[39] >> 3) & 0x3);
    $self->{_quantization}              = sprintf "%02X", ($data[39] & 0x7);

    $temp                               = sprintf "%08X", (($data[40] << 24) | $data[41] << 16);
    $self->{_ti1}                       = sprintf "%08X", (($data[42] << 8) | ($data[43]) | hex($temp));

    $temp                               = sprintf "%08X", (($data[44] << 24) | $data[45] << 16);
    $self->{_ti2}                       = sprintf "%08X", (($data[46] << 8) | ($data[47]) | hex($temp));

    $temp                               = sprintf "%08X", (($data[48] << 24) | $data[49] << 16);
    $self->{_mhcDuration}               = sprintf "%08X", (($data[50] << 8) | ($data[51]) | hex($temp));

    $self->{_exposureDuration}          = sprintf "%04X", (($data[52] << 8) | $data[53]);
    $self->{_sequenceNumber}            = sprintf "%03u", $data[54];
    $self->{_linelistNumber}            = sprintf "%02u", $data[55];
    $self->{_sequenceId}                = sprintf "%04X", (($data[56] << 8) | $data[57]);
    $self->{_rasterId}                  = sprintf "%04X", (($data[58] << 8) | $data[59]);
    
    $self->{_numberOfWindows}           = sprintf "%02u", ($data[60] >> 3);
#	$self->{_ccdXLength};
#	$self->{_Xws};
#	$self->{_Xw};
#	$self->{_Yws};
#	$self->{_Yw};
# Windows

    $self->{_coarseMirrorPosition}      = sprintf "%04X", (($data[168] << 8) | $data[169]);

    $self->{_fineMirrorPosition}        = sprintf "%04X", (($data[170] << 8) | $data[171]);
    $self->{_slitNumber}                = sprintf "%04X", (($data[172] << 8) | $data[173]);
    $self->{_xOcb}                      = sprintf "%04X", $data[174];
    $self->{_yOcb}                      = sprintf "%04X", $data[175];

    $temp                               = sprintf "%04X", (($data[176] << 24) | ($data[177] << 16));
    $self->{_rastersRequired}           = sprintf "%08X", ((($data[178] << 8) | $data[179]) | hex($temp));

    $temp                               = sprintf "%04X", (($data[180] << 24) | ($data[181] << 16));
    $self->{_rastersCounter}            = sprintf "%08X", ((($data[182] << 8) | $data[183]) | hex($temp));

    $self->{_rasterRepeatsRequired}     = sprintf "%04X", (($data[184] << 4) | ($data[185] >> 4));
    $self->{_rasterRepeatsPerformed}    = sprintf "%04X", ((($data[185] & 0xF) << 8) | ($data[186]));

    $self->{_sequenceRepeatsRequired}   = sprintf "%02X", $data[187];
    $self->{_sequenceRepeatsPerformed}  = sprintf "%02X", $data[188];

    $self->{_ccdReadoutNode}            = sprintf "%02X", $data[189];
    $self->{_HSLStatus}                 = sprintf "%04X", (($data[190] << 8) | $data[191]);

    $self->{_scienceOp}                 = sprintf "%02X", $data[192];
    $self->{_xrtFlareFlag}              = sprintf "%02X", $data[193];
    $self->{_xrtFlareFlagX}             = sprintf "%02X", $data[194];
    $self->{_xrtFlareFlagY}             = sprintf "%02X", $data[195];
    $temp                               = sprintf "%08X", (($data[196] << 24) | ($data[197] << 16));
    $self->{_AECHepc}                   = sprintf "%08X", ((($data[198] << 8) | $data[199]) | hex($temp));
    $temp                               = sprintf "%08X", (($data[200] << 24) | ($data[201] << 16));
    $self->{_AECLepc}                   = sprintf "%08X", ((($data[202] << 8) | $data[203]) | hex($temp));
    $self->{_EISXRTX}                   = sprintf "%04X", (($data[204] << 8) | $data[205]);
    $self->{_EISXRTY}                   = sprintf "%04X", (($data[206] << 8) | $data[207]);
    $self->{_fineMirrorStrainGauge}     = sprintf "%04X", (($data[208] << 8) | $data[209]);
    $self->{_EISFlareX}                 = sprintf "%04X", (($data[210] << 8) | $data[211]);
    $self->{_EISFlareY}                 = sprintf "%04X", (($data[212] << 8) | $data[213]);
    $self->{_EISEventX}                 = sprintf "%04X", (($data[214] << 8) | $data[215]);
    $self->{_EISEventY}                 = sprintf "%04X", (($data[216] << 8) | $data[217]);

    $self->{_ASRCStatus}                = sprintf "%02X", $data[218];
    $self->{_ASRCSkip}                  = sprintf "%02X", $data[219];
    $self->{_exposurePerRasterPosition} = sprintf "%02X", $data[220];
    $self->{_FMIRStepSize}              = sprintf "%04X", (($data[221] << 8) | $data[222]);
    return $self;
}

sub hslStat {
    my $self = shift;
    return $self->{_HSLStatus};
}

sub header_summary {
    my $self = shift;

    print STDOUT "type: ", $self->{_dataType}, " size: ", $self->{_packetSize}, " num: ", $self->{_serialPacketNumber}," ";
    print STDOUT "mid: ", $self->{_mainId}, " msf: ", $self->{_mainSequenceFlag}, " msc: ", $self->{_mainSequenceCount}, " sid: ", $self->{_subId}, " ssf: ", $self->{_subSequenceFlag}, " ssc: ", $self->{_subSequenceCount}, " ";
    print STDOUT "seq: ", $self->{_sequenceNumber}, " ll: ", $self->{_linelistNumber}, " seqid: ", $self->{_sequenceId}, " rasid:", $self->{_rasterId}, " ";
    print STDOUT "comp: ", $self->{_compression}, "\n";
}

sub header_summary1 {
    my $self = shift;

    print STDOUT "type: ", $self->{_dataType}, " size: ", $self->{_packetSize}, " num: ", $self->{_serialPacketNumber}," ";
    print STDOUT "mid: ", $self->{_mainId}, " msf: ", $self->{_mainSequenceFlag}, " msc: ", $self->{_mainSequenceCount}, " sid: ", $self->{_subId}, " ssf: ", $self->{_subSequenceFlag}, " ssc: ", $self->{_subSequenceCount}, " ";
    print STDOUT "seq: ", $self->{_sequenceNumber}, " ll: ", $self->{_linelistNumber}, " seqid: ", $self->{_sequenceId}, " rasid:", $self->{_rasterId}, " ";
    print STDOUT "comp: ", $self->{_compression}, "\n";
#################    print STDOUT "TI1: ", $self->{_ti1}, " TI2: ", $self->{_ti2}, "\n";
}

sub header_times {
    my $self = shift;

    print STDOUT "type: ", $self->{_dataType}, " size: ", $self->{_packetSize}, " num: ", $self->{_serialPacketNumber}," ";
    print STDOUT "mid: ", $self->{_mainId}, " msf: ", $self->{_mainSequenceFlag}, " msc: ", $self->{_mainSequenceCount}, " sid: ", $self->{_subId}, " ssf: ", $self->{_subSequenceFlag}, " ssc: ", $self->{_subSequenceCount}, " ";
    print STDOUT "seq: ", $self->{_sequenceNumber}, " ll: ", $self->{_linelistNumber}, " seqid: ", $self->{_sequenceId}, " rasid:", $self->{_rasterId}, " ";
    print STDOUT "TI1: ", $self->{_ti1}, " TI2: ", $self->{_ti2}, "\n";
}

sub header_report_header {
    my $self = shift;
    print "Type     Size   Number  MID MSF  MSC PE IF  SID SSF  SSC   FX   FY   BX   BY   PX   PY COMP      TI1      TI2      MHC  DUR SEQ LL  SiD  Rid #w CMIR FMIR SLA# OCBX OCBY   RasReq  RasDone RRep RRep Seq Seq RO  HSL OP XRT XRTX XRTY  AECHepc  AECLepc EXRTX EXRTY FMSG EFLX EFLY EEVX EEVY ASRC ASRC EP FMSS\n";
}

sub header_report1 {
    my $self = shift;

    format = 
@>>>@>>>>>>>>@>>>>>>>>@>>>> @>>@>>>>@>>@>>@>>>> @>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>>>>>@>>>>>>>>@>>>>>>>>@>>>>@>>>@>>@>>>>@>>>>@>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>>>>>@>>>>>>>>@>>>>@>>>>@>>>@>>>@>>@>>>>@>>@>>>@>>>>@>>>>@>>>>>>>>@>>>>>>>>@>>>>>@>>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>>>@>>@>>>>
$self->{_dataType}, $self->{_packetSize}, $self->{_serialPacketNumber} $self->{_mainId} $self->{_mainSequenceFlag} $self->{_mainSequenceCount} $self->{_mdPacketsPerExposure} $self->{_imagePerFrame} $self->{_subId} $self->{_subSequenceFlag} $self->{_subSequenceCount} $self->{_fullImageSizeX} $self->{_fullImageSizeY} $self->{_basePointX} $self->{_basePointY} $self->{_partialImageSizeX} $self->{_partialImageSizeY} $self->{_compression} $self->{_ti1} $self->{_ti2} $self->{_mhcDuration} $self->{_exposureDuration} $self->{_sequenceNumber} $self->{_linelistNumber} $self->{_sequenceId} $self->{_rasterId} $self->{_numberOfWindows} $self->{_coarseMirrorPosition} $self->{_fineMirrorPosition} $self->{_slitNumber} $self->{_xOcb} $self->{_yOcb} $self->{_rastersRequired} $self->{_rastersCounter} $self->{_rasterRepeatsRequired} $self->{_rasterRepeatsPerformed} $self->{_sequenceRepeatsRequired} $self->{_sequenceRepeatsPerformed} $self->{_ccdReadoutNode} $self->{_HSLStatus} $self->{_scienceOp} $self->{_xrtFlareFlag} $self->{_xrtFlareFlagX} $self->{_xrtFlareFlagY} $self->{_AECHepc} $self->{_AECLepc} $self->{_EISXRTX} $self->{_EISXRTY} $self->{_fineMirrorStrainGauge} $self->{_EISFlareX} $self->{_EISFlareY} $self->{_EISEventX} $self->{_EISEventY} $self->{_ASRCStatus} $self->{_ASRCSkip} $self->{_exposurePerRasterPosition} $self->{_FMIRStepSize}
.
    write;
}

sub header_report {
    my $self = shift;

    if($self->{_isasArchive}) {
	print STDOUT "\nComp table: ", $self->{_byte0}, " ", $self->{_byte1}, " ", $self->{_byte2}, " ", $self->{_byte3}, " ", $self->{_byte4}, " ", $self->{_byte5}, " ", $self->{_byte6}, " ", $self->{_byte7}, "\n";
    }

    print STDOUT "type: ", $self->{_dataType}, "\tsize: ", $self->{_packetSize}, "\tpkt num: ", $self->{_serialPacketNumber}, "\n";
    print STDOUT "mid:  ", $self->{_mainId}, "\tmsf:  ", $self->{_mainSequenceFlag}, "\t\tmsc:     ", $self->{_mainSequenceCount}, "\nsid:  ", $self->{_subId}, "\tssf:  ", $self->{_subSequenceFlag}, "\t\tssc:     ", $self->{_subSequenceCount}, "\n";

    print STDOUT "Pkts/exposure: ". $self->{_mdPacketsPerExposure}, " i/f: ", $self->{_imagePerFrame}, "\n";

    if($self->{_isasArchive}) {
	print STDOUT "Compression: ", $self->{_compression}, "\t";
    }
    print STDOUT "Bit comp: ", $self->{_bitCompressionMode}, " Im comp par: ", $self->{_imageCompressionMode}, " Huf AC: ", $self->{_huffmanAC}, " Huf DC: ", $self->{_huffmanDC}, " Quant: ", $self->{_quantization}, "\n";

    print STDOUT "Ti1: ", $self->{_ti1}, " ti2: ", $self->{_ti2},
    " MHC: ", $self->{_mhcDuration}, " exp: ", $self->{_exposureDuration}, "\n";
    print STDOUT "seq num: ", $self->{_sequenceNumber}, " ll: ", $self->{_linelistNumber},
    " seq id: ", $self->{_sequenceId}, " ras id:", $self->{_rasterId}, "\n";
    print STDOUT "win: ", $self->{_numberOfWindows}, "\n";
    print STDOUT "coarse: ", $self->{_coarseMirrorPosition}, " fine: ", $self->{_fineMirrorPosition}, " slit: ", $self->{_slitNumber}, "\n";
    print STDOUT "Xocb: ", $self->{_xOcb}, " Yocb: ", $self->{_yOcb}, "\n";
    print STDOUT "exp req: ", $self->{_rastersRequired}, " exp cnt: ", $self->{_rastersCounter}, "\n";
    print STDOUT "ras reps req: ", $self->{_rasterRepeatsRequired}, " Ras rep done: ", $self->{_rasterRepeatsPerformed}, "\n";
    print STDOUT "seq reps req: ", $self->{_sequenceRepeatsRequired}, " Seq rep done: ", $self->{_sequenceRepeatsPerformed}, "\n";
    print STDOUT "ro: ", $self->{_ccdReadoutNode}, " HSL: ", $self->{_HSLStatus}, " sci: ", $self->{_scienceOp}, "\n";
    print STDOUT "XRT flare: ", $self->{_xrtFlareFlag}, " XRT X: ", $self->{_xrtFlareFlagX}, " XRT Y: ", $self->{_xrtFlareFlagY}, "\n";
    print STDOUT "Hepc: ", $self->{_AECHepc}, " Lepc: ", $self->{_AECLepc}, "\n";
    print STDOUT "Eis XRTX: ", $self->{_EISXRTX}, " Eis XRTY: ", $self->{_EISXRTY}, "\n";
    print STDOUT "Fmir: ", $self->{_fineMirrorStrainGauge}, "\n";
    print STDOUT "Eis Flare X: ", $self->{_EISFlareX}, " Eis Flare Y: ", $self->{_EISFlareY}, "\n";
    print STDOUT "Eis Event X: ", $self->{_EISEventX}, " Eis Event Y: ", $self->{_EISEventY}, "\n";
    print STDOUT "ASRC stat: ", $self->{_ASRCStatus}, " ASRC skip: ", $self->{_ASRCSkip}, " Exp/pos: ", $self->{_exposurePerRasterPosition}, " fmir step: ", $self->{_FMIRStepSize}, "\n";
    print STDOUT "\n";
}

#sub report {
#    my $self = shift;
#    print STDOUT "(Sts1 ", $self->{_numberOfSts1Packets}, ")\n";
#}

sub flags_1_1 {
    my $self = shift;
    return (($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 1));
}

sub flags_1_3 {
    my $self = shift;
    return (($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 3));
}

sub flags_3_1 {
    my $self = shift;
    return (($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 1));
}

sub flags_3_3 {
    my $self = shift;
    return (($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 3));
}

# Don't need methods below...?

sub isFirstExposurePacket {
    my $self = shift;

    return (($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 1)) ||
	(($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 1));

#    return (($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 1)) ||
#	(($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 1)) ||
#	    (($self->{_mainSequenceFlag} == 0) && ($self->{_subSequenceFlag} == 1)) ||
#		(($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 1));
}

sub isFirstExposurePacket1 {
    my $self = shift;

    return (($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 1)) ||
	(($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 1)) ||
	(($self->{_mainSequenceFlag} == 1) && ($self->{_subSequenceFlag} == 3));

}

sub isMiddleExposurePacket {
    my $self = shift;
    return $self->{_mainSequenceFlag} == 0;
#    return (($self->{_mainSequenceFlag} == 0) && ($self->{_subSequenceFlag} == 1));
}

sub isLastExposurePacket {
    my $self = shift;
    return ($self->{_subSequenceFlag} == 2);
#    return (($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 1));
}

sub isLastExposurePacket1 {
    my $self = shift;
    return (($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 2)) ||
	(($self->{_mainSequenceFlag} == 3) && ($self->{_subSequenceFlag} == 2)) ||
	(($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 3));

#    return (($self->{_mainSequenceFlag} == 2) && ($self->{_subSequenceFlag} == 1));
}

sub isStandAloneExposurePacket {
    my $self = shift;
#    return $self->{_mainSequenceFlag} == 3;
    return ((($self->{_mainSequenceFlag} == 3) || ($self->{_mainSequenceFlag} == 1)) && ($self->{_subSequenceFlag} == 3));
}

sub sequenceFlags {
    my $self = shift;
    return($self->{_mainSequenceFlag}, $self->{_subSequenceFlag});
}

sub subSequenceFlag {
    my $self = shift;
    return $self->{_subSequenceFlag};
}

sub isEndExposurePacket {
    my $self = shift;
    return(isLastExposurePacket($self) || isStandAloneExposurePacket($self));
}

sub ccsdsHeaders {
    my $self = shift;

    return $self->{_primaryHeader} . $self->{_secondaryHeader};
}

sub userData {
    my $self = shift;
    return $self->{_userData};
}

sub firstSequenceCount {
    my $self = shift;

    return $self->{_packetSeq_count};
}

sub packetSize {
    my $self = shift;
    return $self->{_packetSize};
}

sub isCompressed {
    my $self = shift;

    return $self->{_compression};
}

sub compression {
    my $self = shift;

    return $self->{_compression};
}

sub mid {
    my $self = shift;
    return $self->{_mainId};
}

sub sid {
    my $self = shift;
    return $self->{_subId};
}

sub spn {
    my $self = shift;
    return $self->{_serialPacketNumber};
}

sub data_type {
    my $self = shift;
    return $self->{_dataType};
}

sub raster_id {
    my $self = shift;
    return $self->{_rasterId};
}

sub tableInfo {
    my $self = shift;
    my $ret;
    
    $ret = pack "C*", hex($self->{_byte0}),hex($self->{_byte1}),hex($self->{_byte2}),hex($self->{_byte3}),hex($self->{_byte4}),hex($self->{_byte5}),hex($self->{_byte6}),hex($self->{_byte7});
    return $ret;
#    return ($self->{_byte0} . $self->{_byte1} . $self->{_byte2} . $self->{_byte3} . $self->{_byte4} . $self->{_byte5} . $self->{_byte6} . $self->{_byte7});
}

1;
