package CcsdsInterface;

use lib "/nasA_solar1/home/sbukeis/lib/egse_sw_lib/perllib/EisCcsdsLib";

use IO::Handle;

use strict;

use vars qw(@ISA @EXPORT $VERSION);

use Exporter;
$VERSION = 1.00;
@ISA = qw(Exporter);

@EXPORT = qw(setEndian nextPacket printPrimaryHeader);

my %endianString = ("big"   => "n3",
		    "small" => "v3");

my %timeEndianString = ("big"   => "n2",
			"small" => "v2");

sub BEGIN {
#    print STDOUT "Ccsds BEGIN\n";
#    $numberOfPackets = 0;
}

sub new {
    my ($class) = @_;
    my $self = {
	_primaryHeaderLength      => 6,
	_secondaryHeaderLength    => 4,

	_primaryHeader            => undef,
	_secondaryHeader          => undef,
	_userData                 => undef,

#	_spacecraftTime => undef,
	_endian                   => "big",

	_packetVersion            => undef,
	_packetType               => undef,
	_packetSecHdr             => undef,
	_packetApid               => undef,
	_packetSeqFlag            => undef,
	_packetSeqCount           => undef,
	_packetLength             => undef,

	_startPacketOfSequence    => 1,
	_middlePacketOfSequence   => 0,
	_lastPacketOfSequence     => 2,
	_standAlonePacket         => 3,

	_isStartPacketOfSequence  => 0,
	_isMiddlePacketOfSequence => 0,
	_isLastPacketOfSequence   => 0,
	_isStandAlonePacket       => 0,

#	_packetIsValid            => 0,

	_mark                     => 0,

	};
    bless $self, $class; 
    return $self;
}

#sub packetIsValid {
#    my $self = shift;
#    return $self->{_packetValid};
#}

sub setEndian {
    my $self = shift;
    my $endianess = shift;

    $self->{_endian} = $endianess if(($endianess eq "big") || ($endianess eq "small"));
#    print STDERR "ENDIAN : ", $self->{_endian}, "\n";
}

#sub openForReading {
#    my $self = shift;
#    my $file = shift;
#
#    if(open(FILE_HANDLE, "< $file")) {
#	$self->{_fileHandle} = *FILE_HANDLE;
#	$self->{_numberOfPackets} = 0;
#	$self->{_mark} = 1;
#	return 1;
#    }
#    else {
#	return 0;
#    }
#}

#sub openForWriting {
#
#    my $self = shift;
#    my $file = shift;
#
#    if(open(OFILE_HANDLE, "> $file")) {
#	$self->{_outFileHandle} = *OFILE_HANDLE;
#	return 1;
#    }
#    else {
#	return 0;
#    }
#}

sub primaryHeaderLength {
    return $_[0]->{_primaryHeaderLength};
}

sub setPrimaryHeaderLength {
    my $self = shift;
    my $len = shift;
    $self->{_primaryHeaderLength} = $len if($len > 0);
}

#sub readPrimaryHeader {
#    my $self = shift;
#    my $res = read($self->{_fileHandle},
#		   $self->{_primaryHeader},
#		   $self->{_primaryHeaderLength});
#    if(!defined($res)) {
#	print STDERR "Bad header read\n";
#	return 0;
#    }
#    return 0 if($res == 0);
#    header_decode($self);
#    return 1;
#}
#
#sub hasMorePackets {
#}
# 

sub secondaryHeaderLength {
    return $_[0]->{_secondaryHeaderLength};
}

sub setSecondaryHeaderLength {
    my $self = shift;
    my $len = shift;
    $self->{_secondaryHeaderLength} = $len if($len > 0);
}

#sub nextPacket {
#    my $self = shift;
#
#    $self->{_readPrimary} = 0;
#    $self->{_readSecondary} = 0;
#    $self->{_readUserData} = 0;
#
#    if(readPrimaryHeader($self)) {
#	$self->{_readPrimary} = 1;
#	if(readSecondaryHeader($self)) {
#	    $self->{_readSecondary} = 1;
#	    if(readUserData($self)) {
#		$self->{_readUserData} = 1;
#		++$self->{_numberOfPackets};
#		$self->{_packetValid} = 1;
#		return sprintf("%u", $self->{_packetApid});
##		return 1;
#	    }
#	}
#    }
#    $self->{_packetValid} = 0;
#    return 0;
#}

#sub hasReadPrimary {
#    my $self = shift;
#    return $self->{_readPrimary};
#}

#sub hasReadSecondary {
#    my $self = shift;
#    return $self->{_readSecondary};
#}

#sub hasReadUserData {
#    my $self = shift;
#    return $self->{_readUserData};
#}

#sub getPrimaryHeader {
#    my $self = shift;
#    return $self->{_primaryHeader};
#}

#sub getSecondaryHeader {
#    my $self = shift;
#    return $self->{_secondaryHeader};
#}

#sub getPacketData {
#    my $self = shift;
#    return $self->{_userData};
#}

sub getHeaders {
    my $self = shift;
    return $self->{_primaryHeader} . $self->{_secondaryHeader};
}

sub printPrimaryHeader {
    my $self = shift;
    my $tmp;
 
    print STDOUT "Version [", $self->{_packetVersion}, "] ";
    print STDOUT "Type [", $self->{_packetType}, "] ";
    print STDOUT "Sec  [", $self->{_packetSec_hdr}, "] ";
    $tmp = sprintf("0x%04X", $self->{_packetApid});
    print STDOUT "APID [$tmp] ";
    print STDOUT "Seq flg [", $self->{_packetSeq_flag}, "] ";
    $tmp = sprintf("0x%04X", $self->{_packetSeq_count});
    print STDOUT "Seq cnt [$tmp] ";
    print STDOUT "Len [", $self->{_packetLength}, "]\n";
#    $tmp = sprintf("0x%08X", $header->{'sc_time'});
#    print STDOUT "Sc time [$tmp]\n";
}

sub printPrimaryHeaderSummary {
    my $self = shift;
    my $tmp;
    print STDOUT $self->{_packetVersion}, ",";
    print STDOUT $self->{_packetType}, ",";
    print STDOUT $self->{_packetSec_hdr}, ",";
    print STDOUT $self->{_packetApid}, ",";
#    $tmp = sprintf("%04X", $self->{_packetApid});
#    print STDOUT "$tmp,";
    print STDOUT $self->{_packetSeq_flag}, ",";
    print STDOUT $self->{_packetSeq_count},",";
#    $tmp = sprintf("%04X", $self->{_packetSeq_count});
#    print STDOUT "$tmp,";
    print STDOUT $self->{_packetLength}, "\n";
#    $tmp = sprintf("0x%08X", $header->{'sc_time'});
#    print STDOUT "Sc time [$tmp]\n";
}

sub apid {
    my $self = shift;

    return $self->{_packetApid};
}

sub printHeaders {
    my $self = shift;

    print STDOUT "S/c time [", $self->{_spacecraftTime}, "] ";
    printPrimaryHeader($self);
}

sub printHeadersSummary {
    my $self = shift;
    print STDOUT $self->{_spacecraftTime}, ",";
    printPrimaryHeaderSummary($self);
}

sub printSecondaryHeader {
    my $self = shift;

    print STDOUT $self->{_spacecraftTime}, "\n";
}

sub report {
    my $self = shift;
    print STDOUT $self->{_numberOfPackets}, " ccsds packets\n";
}

#sub numberOfPackets {
#    my $self = shift;
#    return $self->{_numberOfPackets};
#}

sub decodeHeader {
    my $self = shift;
    my @data;

    @data = unpack($endianString{$self->{_endian}},
		   $self->{_primaryHeader});
    $self->{_packetVersion}   = ($data[0] >> 13);
    $self->{_packetType}      = ($data[0] >> 12);
    $self->{_packetSec_hdr}   = ($data[0] >> 11);
    $self->{_packetApid}      = ($data[0] & 0x7FF);
#    $self->{_packetApid}      = sprintf("%04X", ($data[0] & 0x7FF));
    $self->{_packetSeq_flag}  = ($data[1] >> 14);
    $self->{_packetSeq_count} = ($data[1] & 0x3FFF);
#    $self->{_packetSeq_count} = sprintf("%04X", ($data[1] & 0x3FF));
    $self->{_packetLength}    = $data[2];

    $self->{_startPacketOfSequence} = 0;
    $self->{_isStartPacketOfSequence} = 0;
    $self->{_middlePacketOfSequence} = 0;
    $self->{_lastPacketOfSequence} = 0;
    $self->{_isLastPacketOfSequence} = 0;
    $self->{_standAlonePacket} = 0;

    if(($self->{_packetSeq_flag} == 1) && ($self->{_mark} == 1)) {
	$self->{_startPacketOfSequence} = 1;
	$self->{_isStartPacketOfSequence} = 1;
	$self->{_mark} = 0;
    }
    $self->{_middlePacketOfSequence} = 1 if($self->{_packetSeq_flag} == 0);
    $self->{_isLastPacketOfSequence} = 1 if($self->{_packetSeq_flag} == 2);
    $self->{_lastPacketOfSequence} = $self->{_packetSeq_flag};
    $self->{_standAlonePacket} = 1 if($self->{_packetSeq_flag} == 3);
}

sub isFirstPacketOfSequence {
    my $self = shift;
    return $self->{_isStartPacketOfSequence};
}

sub firstPacketOfSequence {
    my $self = shift;
    return $self->{_startPacketOfSequence};
}

sub isMiddlePacketOfSequence {
    my $self = shift;
    return $self->{_middlePacketOfSequence};
}

sub isLastPacketOfSequence {
    my $self = shift;
    return $self->{_isLastPacketOfSequence};
}

sub lastPacketOfSequence {
    my $self = shift;
    return $self->{_lastPacketOfSequence};
}

sub isStandAlonePacketOfSequence {
    my $self = shift;
    return $self->{_standAlonePacket};
}

sub time_decode {
    my $self = shift;
    my @data = unpack($timeEndianString{$self->{_endian}},
		      $self->{_secondaryHeader});
#    $self->{_spacecraftTime} = sprintf "%08X", (($data[0] << 16) | $data[1]);
    $self->{_spacecraftTime} = sprintf "%10u", (($data[0] << 16) | $data[1]);
}

sub getSequenceCount {
    my $self = shift;
    return($self->{_packetSeq_count});
}

sub getTime {
	my $self = shift;
	return $self->{_spacecraftTime};
}

sub create_header_from_packet {
    my $self = shift;
    my $data = shift;
    my @data;

    @data = unpack($endianString{$self->{_endian}}, $data);
    $self->{_packetVersion}   = ($data[0] >> 13);
    $self->{_packetType}      = ($data[0] >> 12);
    $self->{_packetSec_hdr}   = ($data[0] >> 11);
    $self->{_packetApid}      = ($data[0] & 0x7FF);
#    $self->{_packetApid}      = sprintf("%04X", ($data[0] & 0x7FF));
    $self->{_packetSeq_flag}  = ($data[1] >> 14);
    $self->{_packetSeq_count} = ($data[1] & 0x3FF);
#    $self->{_packetSeq_count} = sprintf("%04X", ($data[1] & 0x3FF));
    $self->{_packetLength}    = $data[2];

    return($self->{_packetSeq_count});
}

sub create_header {
    my $self = shift;
    my $count = shift;
    my $flag = shift;
    my $len = shift;
    my @data;
    my $data;

    $len += 3;
    $data[0] = ($self->{_packetVersion} << 5);
    $data[0] |= ($self->{_packetType} << 4);
    $data[0] |= ($self->{_packetSec_hdr} << 3);   
    $data[0] |= (($self->{_packetApid} >> 8) & 0xFF);
    $data[1] = ($self->{_packetApid} & 0xFF);
    $data[2] = ($flag << 6);
    $data[2] |= ($count >> 8);
    $data[3] = ($count & 0xFF);
    $data[4] = ($len >> 8);
    $data[5] = ($len & 0xFF);
    $data[6] = $data[7] = $data[8] = $data[9] = 0;
    $data = pack("C10", @data);
    return($data);
}

sub write {
    my $self = shift;
    my $data = shift;
    my $res;

    $res = syswrite($self->{_outFileHandle},
		    $data,
		    length $data);
    return $res;
}

1;
