package Raster;

use Exposure;
use strict;

use vars qw(@ISA @EXPORT $VERSION);

use Exporter;
$VERSION = 1.00;
@ISA = qw(Exporter);

@EXPORT = qw(initialHeaders addHeaders openOutput openInput writeFirstExposureHeader writeFirstExposureData writeNextExposureHeader writeNextExposureData);

my @exposureList = ();

#my $full_ccsds_packet = 2032;

sub BEGIN {
}

sub new {
    my ($classname) = @_;
    my $self = {
	_outputFileHandle => undef,
	_inputFileHandle => undef,
	_header => CcsdsPacket::new(@_),
	_apid => undef,
	_sequenceCount => undef,
    };
    bless $self, $classname;
    return $self;
}

#sub new {
#    my $classname = shift;
#    my $self = $classname->SUPER::new(@_);
#    $self->_init(@_);
##    print "NEW\n";
#    return $self;
#}

sub _init {
    my $self = shift;

    $self->{_outputFileHandle} => undef,
    $self->{_inputFileHandle} => undef,
}

sub storeHeaders {
    my $self = shift;
    my $ccsdsHeaders = shift;
    my $mdHeader = shift;
    my $count = shift;
    my $size = shift;
    my $tmp;

    print STDOUT "Raster : storeHeaders\t";
    push @ccsdsPacketList, $ccsdsHeaders;
    push @mdHeaderList, $mdHeader;
    push @countList, $count;

    $tmp = @mdHeaderList;
    print STDOUT "mdHeaderList = ", $tmp, "\t";
    print STDOUT "SIZE $size\n";
}

sub openOutput {
    my $self = shift;
    my $file = shift;
    my $suffix = shift;

    print STDOUT "OUTPUT FILE $file$suffix\n";
    if(open(O_FILE_HANDLE, ">$file$suffix")) {
	$self->{_outputFileHandle} = *O_FILE_HANDLE;
	return 1;
    }
    else {
	return 0;
    }
}

sub openInput {
    my $self = shift;
    my $file = shift;
    my $suffix = shift;

    print STDOUT "INPUT FILE $file$suffix\n";
    if(open(FILE_HANDLE, "<$file$suffix")) {
	$self->{_inputFileHandle} = *FILE_HANDLE;
	return 1;
    }
    else {
	return 0;
    }
}

sub closeInputFile {
    my $self = shift;

    close $self->{_inputFileHandle};
#    $self->{_inputFileHandle} => undef;
}

sub writeExposureHeader {
    my $self = shift;
    my $ccsdsPacket;
    my $mdHeader;
    my $c_len;
    my $m_len;
    my $tmp;
    print "Raster : writeExposureHeader\t";
    $ccsdsPacket = shift @ccsdsPacketList;
    $mdHeader = shift @mdHeaderList;
    $c_len = length $ccsdsPacket;
    $m_len = length $mdHeader;
    print STDOUT "LENGTH : $c_len, $m_len\t";
    $tmp = syswrite($self->{_outputFileHandle}, $ccsdsPacket, $c_len);
    ++$self->{_sequenceCount};
    if($tmp) {
	print STDOUT "Wrote $tmp bytes, ";
    }
    else {
	print STDOUT "ERROR : $! ";
    }
    $tmp = syswrite($self->{_outputFileHandle}, $mdHeader, $m_len);
    print STDOUT "Wrote $tmp bytes\t";
    $tmp = @mdHeaderList;
    print STDOUT "mdHeaderList = ", $tmp, "\n";
}

# Reads full_ccsds_packet packets of data from the input file and writes them to output file
sub writeExposureData {
    my $self = shift;
    my $buffer;
    my $seq_flag;
    my $read_len;
    my $res;

    print STDOUT "writeExposureData\t";
    while(1) {
	$read_len = sprintf "%u", read($self->{_inputFileHandle}, $buffer, $full_ccsds_packet);
	last if $read_len == 0;
	$seq_flag = ($read_len == $full_ccsds_packet) ? 0 : 2;
	$self->{_header}->setData($self->{_apid}, $self->{_sequenceCount}, $seq_flag, $read_len);
	++$self->{_sequenceCount};
	$res = syswrite $self->{_outputFileHandle}, $self->{_header}->data(), 10;
	$res = syswrite $self->{_outputFileHandle}, $buffer, $read_len;
    }
    print STDOUT "finished\n";
}

sub ccsdsStuff {
    my $self = shift;
    $self->{_apid} = shift;
    $self->{_seqeunceCount} = shift;
}

1;
