#!/usr/bin/perl

use lib "/home/matt/perllib/CcsdsLib";

#require "MdInterface.pl";
use MdInterface;

#use MdHeader;
use File::Basename;

$num_args = $#ARGV;
if($num_args == 0) {
    $filename = $ARGV[0];
}
else {
    if($num_args == 1) {
	$filename = $ARGV[1];
	$verbose = $ARGV[0];
	if($verbose ne "-v") {
	    print STDERR "verbose flag is $verbose\n";
	    exit;
	}
    }
    else {
	print STDERR "Too many arguments\n"; write_log($filename, "Too many args"); exit;
    }
}

$thing = MdInterface->new();
$thing->setEndian("small");

#$outputDir = "/tmp/";
#$outputFile = basename($filename);
#$outputFilenameBase = $outputDir . $outputFile;
print STDOUT "\nFile: $filename (big-endian)\n";

# msf,ssf
#
# 1,1 -> (1,0) -> 1,2 -> 0,1 -> (0,0) -> 0,2 -> 2,1 -> (2,0) -> 2,2
### 1,1 -> 1,2 -> 0,1 -> 0,2 -> 2,1 -> 2,2 ???
# 1,1 -> (1,0) -> 1,2 -> 2,1 -> (2,0) -> 2,2
### 1,1 -> 1,2 -> 2,1 -> 2,2 ???
#
# 1,3 -> (0,3) -> 2,3
# 1,3 -> 2,3
#
# 3,1 -> (3,0) -> 3,2
# 3,1 -> 3,2
#
# 3,3
$md_headers = 0;
if($thing->openForReading($filename)) {
    while(1) {
#	if($thing->get_bigendian_header_packet()) {
	if($thing->get_header_packet()) {
	    $thing->printHeaders() if $verbose;
###	    $thing->printPrimaryHeader() if $verbose;
	    print STDOUT "HDR $md_headers ";
	    ++$md_headers;
#	    $thing->header_report();
#########	    $thing->header_summary();
	    $thing->header_times();
	    while($thing->nextPacket()) {
#		$thing->printPrimaryHeader() if $verbose;
		last if($thing->isLastPacketOfSequence());
	    }
	}
	else {
#	    print STDERR "Last packet\n";
	    last;
	}
    }
    $thing->report();
}
else {
    print STDERR "Failed to open file\n";
}
exit(0);


if($thing->openForReading($filename)) {
###    if($thing->get_bigendian_header_packet()) {
    if($thing->get_header_packet()) {
#	if($thing->{_compresion}) {
	    $processed = 0;
	    process_1_1() if($thing->flags_1_1());
	    process_1_3() if($thing->flags_1_3());
	    process_3_1() if($thing->flags_3_1());
	    process_3_3() if($thing->flags_3_3());
	    processing_error() if($processed <= 0);
#	}
#	else {
#	    write_log($filename, "Not processed (uncompressed data)");
#	}
    }
}
else {
#    print STDERR "Failed to open file\n";
    write_log($filename, "Error opening file : $!");
}
exit;

sub write_log {
    my $filename = shift;
    my $message = shift;

    print STDOUT "$filename : $message\n";
}

sub process_1_1 {
    print STDOUT "process_1_1\n";
    print STDOUT "MULTIPACKET\n";
    $num_packets = $thing->{_mdPacketsPerExposure};
    $header_packet_counter = 0;
    while($header_packet_counter < $num_packets) {
	print STDOUT "\n\nHEADER: $header_packet_counter\n\n";
	$thing->header_report();
	while($thing->nextPacket()) {
	    $thing->printPrimaryHeader();
	    last if($thing->isLastPacketOfSequence());
	}
	$thing->get_header_packet();
	++$header_packet_counter;
    }

    $processed = 11;
}

sub process_1_3 {
    print STDOUT "process_1_3\n";
    $processed = 13;
}

# Open a file for each exposure packet (should be for 1,1 packets only?)
sub process_3_1 {
    my $exposure = 0;
    print STDOUT "process_3_1\n";
    print STDOUT "MULTIPACKET\n";
#    open FILE, '>', $outputFilenameBase . '_' . $exposure;
    $num_packets = $thing->{_mdPacketsPerExposure};
    $header_packet_counter = 0;
    while($header_packet_counter < $num_packets) {
	print STDOUT "\n\nHEADER: $header_packet_counter\n\n";
	$thing->header_report();
	while($thing->nextPacket()) {
	    $thing->printPrimaryHeader();
#	    syswrite FILE, $thing->{_userData};
	    last if($thing->isLastPacketOfSequence());
	}
	$thing->get_header_packet();
	++$header_packet_counter;
    }
#    close FILE;
    $processed = 31;
}

sub process_3_3 {
    $thing->header_report();
#    open FILE, '>', $outputFilenameBase;
    while($thing->nextPacket()) {
	$thing->printPrimaryHeader();
#	syswrite FILE, $thing->{_userData};
	last if($thing->isLastPacketOfSequence());
    }
#    close FILE;
    $processed = 33;
}


sub no_header {
    print STDOUT "Didn't get header\n";
    print STDOUT "Sub Sequence Flag = ", $thing->subSequenceFlag(), "\n";
#    if(($thing->isLastExposurePacket()) || ($thing->isStandAloneExposurePacket)) {
    if($thing->isLastExposurePacket()) {
	print STDOUT "End of raster\n";
    }
    else {
	print STDOUT "Raster aborted\n";
    }
}

sub processing_error {
    print "Error\n";
}
