#!/usr/bin/perl -W

use lib "/home/solarb/perllib/CcsdsLib";

use MdInterface;
use File::Basename;

$num_args = $#ARGV;
if($num_args == 0) {
    $filename = $ARGV[0];
}
else {
    if($num_args == 1) {
	$filename = $ARGV[1];
	$verbose = $ARGV[0];
	if($verbose ne "-v") {
	    print STDERR "verbose flag is $verbose\n";
	    exit;
	}
    }
    else {
	print STDERR "Too many arguments\n"; write_log($filename, "Too many args"); exit;
    }
}
print STDOUT "\nFile: $filename\n";

my $pixels;
my @pixels;
my @tmp;

$thing = MdInterface->new();
$md_headers = 0;
if($thing->openForReading($filename)) {
    while(1) {
	if($thing->get_bigendian_header_packet()) {
	    $thing->printPrimaryHeader() if $verbose;
	    print STDOUT "HDR $md_headers ";
	    ++$md_headers;
	    $thing->header_summary();
	    while($thing->nextPacket()) {
		$tmp = $thing->getPacketData();
		@pixels = unpack "n*", $tmp;
		foreach $p (@pixels) {
		    $p &= 0x3FFF;
		    push @tmp, $p;
		}
		print STDOUT pack "n*", @tmp;
		last if($thing->isLastPacketOfSequence());
	    }
	}
	else {
	    last;
	}
    }
}
