#!/usr/bin/perl -W

use lib "/Users/matt/Work/Hinode/EisCcsdsLib";

use lib "/Users/matt/Work/Hinode/EisCcsdsLib/Ccsds";
use lib "/Users/matt/Work/Hinode/EisCcsdsLib/Ccsds/Packet";
use Ccsds;
use Packet;
use MdHeader;
use Ccsds::Packet::GapReader;
use File::Basename;

#use Env qw(EGSE_SW_LIB);

#do "$EGSE_SW_LIB/date_calc.pl" || warn "Can't do date_calc.pl: $!\n";
#do "$EGSE_SW_LIB/pipeline_defs.pl" || die "Can't do pipeline_defs.pl: $!\n";

if($#ARGV == 0) {
    $filename = $ARGV[0];
}
else {
    print STDOUT "Supply filename to process\n";
#    write_log($filename, "No file supplied");
    exit;
}

$outputDir = "/Users/matt/tmp/";
$outputFile = basename($filename);
$outputFilename = "$outputDir" . "$outputFile";
print STDOUT "Files: $filename, $outputFilename\n";

#die "Can't open output file: $!" unless open(OUT, "> $outputFilename");

$r = Ccsds::Packet::Reader->new();
$r->init();
$r->setInput($filename);
@data = ();
$md_out_count = 0;
$currentMdHeader = MdHeader->new();
$dummyMdHeader = MdHeader->new();
# Read in first md packet
while(1) {
	last unless $r->readPacket();
	push @data, $r->rawData();
	if($r->isStartPacketOfSequence()) {
		print "First packet\n";
		++$md_headers;
		$currentMdHeader->populateHeader($r->userData());
#		$currentSpn = $currentMdHeader->spn();
		next;
	}
	if($r->isLastPacketOfSequence()) {
		++$md_count;
		$num_ccsds_pkts += $r->numberOfPackets();
		print "Last packet\n";
#		print OUT @data;
#		++$md_out_count;
#		@data = ();
		last;
	}
}

# Either write out first packet or write out dummy packets
# then first packet
		$currentSpn = $currentMdHeader->spn();
		print "SPN: $currentSpn\t";
		print "MSF: ", $currentMdHeader->mainSequenceFlag(), "\t";
		print "SSF: ", $currentMdHeader->subSequenceFlag(), "\n";
#		print OUT @data;
#		++$md_out_count;
#		@data = ();

# Process the rest of the md packets
while(1) {
	last unless $r->readPacket();
	push @data, $r->rawData();
	if($r->isStartPacketOfSequence()) {
		print "First packet\n";
		++$md_headers;
		$currentMdHeader->populateHeader($r->userData());
		$currentSpn = $currentMdHeader->spn();
		print "SPN: $currentSpn\t";
		print "MSF: ", $currentMdHeader->mainSequenceFlag(), "\t";
		print "SSF: ", $currentMdHeader->subSequenceFlag(), "\n";
		next;
	}
	if($r->isLastPacketOfSequence()) {
		++$md_count;
		$num_ccsds_pkts += $r->numberOfPackets();
		print "Last packet\n";
#		print OUT @data;
		++$md_out_count;
		@data = ();
		next;
	}
}


print "Number of md packets read: $md_headers, $md_count, written: $md_out_count, ccsds: $num_ccsds_pkts\n";
$r->cleanUp();
#close OUT;
