; $Id: eis_hdr__define.pro,v 1.9 2009/05/05 13:42:41 gardini Exp $
;+
; NAME:
;       EIS_HDR__DEFINE
;
; PURPOSE:
;       eis_hdr__define defines the class structure 'eis_hdr'.
;       An object of class 'eis_hdr' contains the header on SOLAR B EIS
;       data packets sent to the ground. (Only first packets of an
;       exposureon has the EIS header).)
;
; CATEGORY:
;       Hansteen/Wikstol Data analysis SW
;
; CALLING SEQUENCE:
;       The EIS_HDR__DEFINE procedure is not called directly. An
;       object of class EIS_HDR is created with the following
;       statement:
;                   eis_hdr = obj_new('eis_hdr')
;       To fill the object with information use the following statement:
;                     eis_hdr-> read
;
; INPUTS:
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;       Objects of type EIS_HDR
;
; CALLS:
;
; COMMON BLOCKS:
;
;
; PROCEDURE:
;       The procedure opens an object of class EIS_HDR. The EIS_HDR
;       class inherits the superclass HW_HDR, that defines the general
;       structure of header classes used by the HW data analysis SW.
;       This procedure also includes various functions (methods of
;       class  'eis_hdr' whose purpose is to get the different fields of the
;       header. For example, if you want to know the packet_size:
;               print, eis_hdr-> getpacket_size()
;
;
; RESTRICTIONS:
;
;
; MODIFICATION HISTORY:
;       01-Feb-2001: Oivind Wikstol.
;       26-Sep-2001: Oivind Wikstol. Added documentation.
;       09-Nov-2004: Oivind Wikstol - Updated with new header information.
;       11-Jan-2005: ivind Wikstl - Added HSL keyword 
;                                   (all of them put together in one
;                                   integer)
;       15-Feb-2005: ivind Wikstl - Added new hdr parameters
;       03-Mar-2005: ivind Wikstl - Added new hdr parameters.
;       10-Feb-2007: Viggo Hasnteen - Added help methods.
;       29-Nov-2007: A. Gardini     - Cleaned dangling references.
;        4-Jul-2008: A. Gardini     - Added HELP and INIT_METHODS methods.
;        5-May-2009: A. Gardini     - Added the getdate_obs method.
;
; $Id: eis_hdr__define.pro,v 1.9 2009/05/05 13:42:41 gardini Exp $
;
;-
function eis_hdr::init
  self->init_methods ; initialization of the help method
  self.help=obj_new('hw_help')
  self.title='EIS Header'
  self.nccd = 2
  self.serial_packet_no=ptr_new('NaN')
  return,1
end

pro eis_hdr::cleanup
  obj_destroy,self.help
  ptr_free,self.serial_packet_no
end

pro eis_hdr::display_all,init=init
  if n_elements(init) eq 1 then return
  self.help->display_all
  return
end

pro eis_hdr::display_methods,init=init
  if n_elements(init) eq 1 then return
  self.help->display_methods
  return
end

function eis_hdr::getraw,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.raw
end

function eis_hdr::getdatatype,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.datatype
end

function eis_hdr::getpacket_size,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.packet_size
end

function eis_hdr::getserial_packet_no,init=init
  if n_elements(init) eq 1 then return, -1
  return, *self.serial_packet_no
end

pro eis_hdr::setserial_packet_no,serial_packet_no,init=init
  if n_elements(init) eq 1 then return
  *self.serial_packet_no=serial_packet_no
end

function eis_hdr::getmain_id,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.main_id
end

pro eis_hdr::setmain_id,main_id,init=init
  if n_elements(init) eq 1 then return
  self.main_id=main_id
end

function eis_hdr::getmain_seq_flag,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.main_seq_flag
end

function eis_hdr::getmain_seq_count,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.main_seq_count
end  

function eis_hdr::getnr_of_packets,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.nr_of_packets
end

pro eis_hdr::setnr_of_packets,nr_of_packets,init=init
  if n_elements(init) eq 1 then return
  self.nr_of_packets=nr_of_packets
end

function eis_hdr::getimg_type,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.img_type
end

function eis_hdr::getsub_id,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.sub_id
end

function eis_hdr::getsub_seq_flag,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.sub_seq_flag
end

function eis_hdr::getsub_seq_count,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.sub_seq_count
end

function eis_hdr::getx_f,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.x_f
end

function eis_hdr::gety_f,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.y_f
end

function eis_hdr::getb_x,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.b_x
end

function eis_hdr::getb_y,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.b_y
end

function eis_hdr::getx_p,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.x_p
end

function eis_hdr::gety_p,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.y_p
end

function eis_hdr::getbit_compr_mode,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.bit_compr_mode
end

pro eis_hdr::setbit_compr_mode,bit_compr_mode,init=init
  if n_elements(init) eq 1 then return
  self.bit_compr_mode=bit_compr_mode
end

function eis_hdr::getimg_compr_mode,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.img_compr_mode
end

pro eis_hdr::setimg_compr_mode,img_compr_mode,init=init
  if n_elements(init) eq 1 then return
  self.img_compr_mode=img_compr_mode
end

function eis_hdr::gethuffman_ac,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.huffman_ac
end

pro eis_hdr::sethuffman_ac,huffman_ac,init=init
  if n_elements(init) eq 1 then return
  self.huffman_ac=huffman_ac
end

function eis_hdr::gethuffman_dc,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.huffman_dc
end

pro eis_hdr::sethuffman_dc,huffman_dc,init=init
  if n_elements(init) eq 1 then return
  self.huffman_dc=huffman_dc
end

function eis_hdr::getquant_tab,init=init
  if n_elements(init) eq 1 then return, -1
  return, self.quant_tab
end

pro eis_hdr::setquant_tab,quant_tab,init=init
  if n_elements(init) eq 1 then return
  self.quant_tab=quant_tab
end

function eis_hdr::getexp_info,init=init
  if n_elements(init) eq 1 then return, -1
  return,self.exp_info
end

pro eis_hdr::setexp_info,exp_info,init=init
  if n_elements(init) eq 1 then return
  self.exp_info=exp_info
end
 
function eis_hdr::getcorrupt,init=init
  if n_elements(init) eq 1 then return,-1
  return,self.corrupt
end

pro eis_hdr::setcorrupt,corrupt,init=init
  if n_elements(init) eq 1 then return
  self.corrupt=corrupt
end

function eis_hdr::getvar,varno,init=init
  if n_elements(init) eq 1 then return, -1
  case varno of
  0: begin
       exp_info=self->getexp_info()
       return, exp_info.fmirr_pos
     end
  1: return, self->getmain_seq_count()
  2: begin
       exp_info=self->getexp_info()
       return, exp_info.exp_mhc/10.
     end
  3: begin
       exp_info=self->getexp_info()
       return, exp_info.mhc_fmirr_sg
     end
  else:
  endcase
  return,-99
end

; The following method is used to initialize the eis_cal object during the
; reformatting, but the actual date_obs is not known and not used there.
function eis_hdr::getdate_obs,init=init
  if n_elements(init) eq 1 then return, -1
  message,"WARNING Observation time not set: using current time.",/informational
  get_utc, time_obs
  return, time_obs
end

function eis_hdr::getinfo,tag,init=init
  if n_elements(init) eq 1 then return, -1
  message,"WARNING Tag not set: returning 0.",/info
  return, 0
end

pro eis_hdr::help
  help,self,/obj
  return
end

pro eis_hdr::init_methods

  self->init_hw_methods
  self->display_all,/init
  self->display_methods,/init
  a=self->getraw(/init)
  a=self->getdatatype(/init)
  a=self->getpacket_size(/init)
  a=self->getserial_packet_no(/init)
  self->setserial_packet_no,/init
  self->setmain_id,/init
  a=self->getmain_seq_flag(/init)
  a=self->getmain_seq_count(/init)
  a=self->getnr_of_packets(/init)
  self->setnr_of_packets,/init
  a=self->getimg_type(/init)
  a=self->getsub_id(/init)
  a=self->getsub_seq_flag(/init)
  a=self->getsub_seq_count(/init)
  a=self->getx_f(/init)
  a=self->gety_f(/init)
  a=self->getb_x(/init)
  a=self->getb_y(/init)
  a=self->getx_p(/init)
  a=self->gety_p(/init) 
  a=self->getbit_compr_mode(/init)
  a=self->getimg_compr_mode(/init)
  a=self->gethuffman_ac(/init)
  a=self->gethuffman_dc(/init)
  a=self->getquant_tab(/init)
  a=self->getexp_info(/init)
  self->setbit_compr_mode,/init
  self->setimg_compr_mode,/init
  self->sethuffman_ac,/init
  self->sethuffman_dc,/init
  self->setquant_tab,/init
  self->setexp_info,/init
  a=self->getvar(/init)
  self->setcorrupt,/init
  a=self->getcorrupt(/init)
  a=self->getdate_obs(/init)
;  self->display,/init
  self->read,/init

  return
end

pro eis_hdr__define
struct={eis_hdr, $
        raw:bytarr(256), $
        corrupt:0, $
        datatype:0B, $
        packet_size:0UL, $
        serial_packet_no:ptr_new(), $
        main_id:0U, $
        main_seq_flag:0B, $
        main_seq_count:0U, $
        reserved_1:0B, $                ; 2 bits reserved (spare)
        nr_of_packets:0B, $
        img_type:0B, $
        sub_id:0U, $
        sub_seq_flag:0B, $
        sub_seq_count:0U, $
        x_f:0U, $                       ; full image size x
        y_f:0U, $                       ; full image size y
        b_x:0U, $                       ; x-coord of upper left corner of img
        b_y:0U, $                       ; y-coord of upper left corner of img
        x_p:0U, $                       ; partial image size (x)
        y_p:0U, $                       ; partial image size (y)
        reserved_3:0B, $
        bit_compr_mode:0B, $            ; bit compression mode
        img_compr_mode:0B, $            ; image compression mode
        reserved_4:0B, $
        huffman_ac:0B, $                ; Huffman AC table No.
        huffman_dc:0B, $                ; Huffman DC table No.
        quant_tab:0B, $                 ; Quantization table
; next we define a struct including  all exposure information.
; (see Khalid Al Janabi "EIS mission data structure" for detailed info
;  on each variable)
        exp_info:create_struct(name='exp_info', $
                                    'ti_1', 0UL, $
                                    'ti_2', 0UL, $
                                    'exp_mhc', 0UL, $
                                    'exp_dur', 0U, $
                                    'seq_nr', 0B, $
                                    'll_nr', 0B, $
                                    'seq_id', 0U, $
                                    'rast_id', 0U, $
                                    'nwin', 0B, $
                                    'ccd_sides', 0B, $
                                    'ccd_length', 0U, $
                                    'xws', 0U, $
                                    'xw', 0U, $
                                    'yws', 0U, $
                                    'yw', 0U, $
                                    'win_hdr', bytarr(25), $
                                    'ccd_nr', bytarr(25), $
                                    'x_s', uintarr(25), $
                                    'x_l', uintarr(25), $
                                    'cmirr_pos', 0U, $
                                    'fmirr_pos_mode',0B, $
                                    'fmirr_pos', 0U, $
                                    'slit_nr', 0U, $
                                    'x_ocb', 0B, $
                                    'y_ocb', 0B, $
                                    'nexp', 0UL, $
                                    'nexpc', 0UL, $
                                    'nrepr', 0U, $
                                    'nrepp', 0U, $
                                    'nseqr', 0B, $
                                    'nseqp', 0B, $
                                    'ron_ccdar', 0B, $
                                    'ron_ccdal', 0B, $
                                    'ron_ccdbr', 0B, $
                                    'ron_ccdbl', 0B, $
                                    'hsl', 0U, $
                                    'hsl_ccdbl', 0B, $
                                    'hsl_ccdbr', 0B, $
                                    'hsl_ccdal', 0B, $
                                    'hsl_ccdar', 0B, $
                                    'hsl_ccdbank', 0B, $
                                    'hsl_link_err', 0B, $
                                    'hsl_eof', 0B, $
                                    'hsl_last', 0B, $
                                    'xrt_fltr_st', 0B, $
                                    'eis_aec_st', 0B, $
                                    'eis_evtr_st', 0B, $
                                    'eis_fltr_st', 0B, $
                                    'xrt_flfl', 0B, $
                                    'xrt_fl_x', 0B, $
                                    'xrt_fl_y', 0B, $
                                    'aec_npix_h',0UL, $
                                    'aec_npix_l', 0UL, $
                                    'eis_x_sign', 0B, $
                                    'eis_xrt_fl_x', 0U, $
                                    'eis_y_sign', 0B, $
                                    'eis_xrt_fl_y', 0U, $
                                    'mhc_fmirr_sg', 0U, $
                                    'eis_fltr_x', 0U, $
                                    'eis_fltr_y', 0U, $
                                    'eis_evtr_x', 0U, $
                                    'eis_evtr_y', 0U,  $
                                    'asrc_dir', 0B, $
                                    'asrc_nr', 0B, $
                                    'asrc_skip', 0B, $
                                    'exp_prp', 0B, $
                                    'fmir_step',0U), $
        inherits hw_hdr }
end

