package Base;

use strict;
use warnings;

our (@ISA, @EXPORT, $VERSION);

@ISA = qw(Exporter);
@EXPORT = ();
$VERSION = 1.00;

sub BEGIN {
    print "BEGIN Base/Base\n";
}

my $FH = undef;

sub new {
#    my ($class) = @_;
    my $class = shift;
#    my $ver = $_[1];

#    $ver = "???" unless defined($ver);
#    print "Base new version = $ver\n";
    my $self = {
	_debug         => 0,
	_status        => 0,
	_error         => 0,
	_error_string  => "",
	_trace_flag    => 0,
	_verbose       => 0,
	_save_to_file  => 0,
	_filename      => "",
	_base_version  => "1.0",
#	_child_version => sprintf( "%1.2f", $ver),
#	_child_version => "$ver",
	_child_version => "",
	_child_object  => "$class",
    };
    bless $self, $class;
    $self->trace("Base::new $class");
    return $self;
}

sub debug {
    my $self = shift;
    print STDOUT "*** Base/Base::debug start ***\n";
    print STDOUT "\tstatus        : ", $self->{_status}, "\n";
    print STDOUT "\terror         : ", $self->{_error}, "\n";
    print STDOUT "\terror_string  : '$self->{_error_string}'\n";
    print STDOUT "\ttrace_flag    : $self->{_trace_flag}\n";
    print STDOUT "\tverbose       : $self->{_verbose}\n";
    print STDOUT "\tbase version  : $self->{_base_version}\n";
    print STDOUT "\tchild object  : '$self->{_child_object}'\n";
    print STDOUT "\tchild version : $self->{_child_version}\n";
    print STDOUT "--- Base/Base::debug end ---\n";
}

sub set_debug {
    my $self = shift;

    $self->{_debug} = 1;
}

sub debug_on {
    my $self = shift;

    $self->set_debug();
}

sub debug_off {
    my $self = shift;

    $self->{_debug} = 0;
}

sub debug_print {
    my $self = shift;
    my $msg = shift;

    print "\tDebug: $msg" if $self->{_debug};
}

sub status {
    my $self = shift;
    return $self->{_status};
}

sub set_status {
    my $self = shift;
    my $stat = shift;
    $self->{_status} = $stat;
}

sub error {
    my $self = shift;
    return $self->{_error};
}

sub set_error {
    my $self = shift;
    my $err = shift;
    $self->{_error} = $err;
}

sub error_string {
    my $self = shift;
    return $self->{_error_string};
}

sub set_error_string {
    my $self = shift;
    my $err = shift;
    $self->{_error_string} = $err;
}

sub trace_flag {
    my $self = shift;
    return $self->{_trace_flag};
}

sub set_trace_flag {
    my $self = shift;
    my $flag = shift;
    $self->{_trace_flag} = $flag;
}

sub save_to_file {
    my $self = shift;
    return $self->{_save_to_file};
}

sub set_save_to_file {
    my $self = shift;
    my $file = shift;
    if ($file ne "") {
	$self->{_filename} = $file;
	open($FH, ">>", $file) or die "Can't open $file: $!";
	$self->{_save_to_file} = 1;
#	print STDERR "$file OPENED\n";
    }
    else {
	$self->{_save_to_file} = 0;
    }
}

sub trace_on {
    my $self = shift;

    $self->set_trace_flag(1);
}

sub trace_off {
    my $self = shift;

    $self->set_trace_flag(0);
}

sub verbose {
    my $self = shift;
    return $self->{_verbose};
}

sub set_verbose {
    my $self = shift;
    my $flag = shift;
    $self->{_verbose} = $flag;
}

sub trace {
    my $self = shift;
    my $msg = shift;
    if ($self->save_to_file()) {
	select *FH;
	print "<<< $msg >>>\n" if $self->{_trace_flag};
	select STDOUT;
    }
    print "<<< $msg >>>\n" if $self->{_trace_flag};
}

sub base_version {
    my $self = shift;
    return $self->{_base_version};
}

sub version {
    my $self = shift;
    return $self->{_child_version};
}

sub set_version {
    my $self = shift;
    my $version = shift;
    $self->{_child_version} = $version;
}

sub child_object {
    my $self = shift;
    return $self->{_child_object};
}

sub set_child_object {
    my $self = shift;
    my $object = shift;
    $self->{_child_object} = $object;
}

sub subclassResponsibility {
    my $self = shift;
    my $method = shift;
    die "Subclass resposibility: $method";
}

1;
