package Args;

#print "HINODE/EIS/EISPIPELINE/ARGS.PM\n";

#use v5.10;
#use feature "switch";

use strict;
use warnings;

use Getopt::Long qw(:config pass_through);
use Pod::Usage;

use Trace::Trace;

use Hinode::EIS::EisPipeline::Pipeline;
use Hinode::EIS::EisPipeline::System;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/Args\n";
}

our $command_line = "";

# expt
my $man = 0;
my $help = 0;
my $pod = 0;
my $verbose = '';
my $all = '';
our $junk;

my %options = ();

sub handler {
    my ($opt_name, $opt_value) = @_;

    Trace::trace((caller(0))[3]);

    print "Option name is $opt_name and value is $opt_value\n";
}

sub catchall {
    my ($opt_name, $opt_value) = @_;

    Trace::trace((caller(0))[3]);

    if (! defined($opt_value)) {
        print "catchall : option name is $opt_name\n";
    }
    else {
	print "catchall : option name is $opt_name and value is $opt_value\n";
    }
    $junk = $opt_name;
}

sub arg_check {
    my @ARGV = @_;
    my @ARGV_COPY = ();

#    Trace::trace(__PACKAGE__."::arg_check");
    Trace::trace((caller(0))[3]);

#    my $junk;
    GetOptions('help|?'     => \$help,
	       man          => \$man,
	       pod          => \$pod,
	       'verbose'    => \$verbose,
	       'all'        => \$all,
	       'cron'       => \$Flags::cron,
	       'c'          => \$Flags::cron,
               'p|pending'  => \sub { $Flags::cron_pending = 1; $Flags::cron = 1; },
	       TEST         => \$Flags::TESTING,
#               'just_fits'  => \$Flags::JUST_FITS_FLAG,
               'just_fits'  => sub { $Flags::JUST_FITS_FLAG = 1; Flags::set_flag('just_fits_flag'); },
	       'no_fetch'   => \$Flags::NO_FETCH_FLAG,
               'fetch_only' => \$Flags::FETCH_ONLY_FLAG,
               'fits_only'  => \$Flags::FITS_ONLY_FLAG,
               'DPRINT'     => \$System::DEBUG_PRINT,
	       'SPECIAL'    => sub { $flags::SPECIAL = 'special'; },
	       'v1'         => sub { $Flags::REFORMAT_VERSION = 'v1'; },
               'v2'         => sub { $Flags::REFORMAT_VERSION = 'v2'; },
#               'v2'         => \&handler,
	       'sdate=s'    => \$Dates::sdate,
               'edate=s'    => \$Dates::edate,
#               'no_soda'    => \$junk,
	       '<>'         => \&catchall);
#    print "Args : FLAGS = $Flags::cron, $Flags::cron_pending, $Flags::REFORMAT_VERSION\n";
    pod2usage($0) if $pod;
    pod2usage(-exitval => 1, -input => "../help.txt") if $help;
    pod2usage(-exitval => 0, -verbose => 2) if $man;

    @ARGV_COPY = @ARGV;

    my $temp = $0;
    $temp =~ s/^\.\///;
    $command_line = "$temp @ARGV";
#    $System::program_name = $temp;
#    print "Args::arg_check : command_line = $command_line\n";
#    print "Args::arg_check : \@ARGV = @ARGV\n";
#    print "Args::arg_check : \$#ARGV = $#ARGV\n";

    Pipeline::pipeline()->arg_check(@ARGV);
}

=pod
    goto expt;
    die;

    my @ARGV_COPY = ();
    
    if($#ARGV > -1) {
	while(@ARGV) {
	    my $flag = shift @ARGV;	# = [-c|fetch|fits_only|...]
#	    print "FLAG = $flag\n";
	    System::dprint("ARGS flag = $flag");
	    $Flags::cron                   = 1 if $flag eq "-c";
	    $Flags::cron_pending           = 1 if $flag eq "-p";
	    $Flags::TESTING                = 1 if $flag eq "TEST";
	    $Flags::JUST_FITS_FLAG         = 1 if $flag eq "just_fits";
	    $Flags::FETCH_ONLY_FLAG        = 1 if $flag eq "fetch_only";
	    $Flags::FITS_ONLY_FLAG         = 1 if $flag eq "fits_only";
	    $System::DEBUG_PRINT           = 1 if $flag eq "DPRINT";
	    $Flags::REFORMAT_VERSION       = $flag if $flag eq "v1";
#########	    $Flags::SPECIAL                = "special" if (($flag eq "special") or ($flag ne "-c"));
	    $Flags::SPECIAL                = "special" if ($flag eq "special");

	    if ($flag =~ /(\d)(\d)(\d)(\d)/) {
		unshift @ARGV, $flag;
		last;
	    }
	    else {
		push @ARGV_COPY, $flag;
	    }
	}
    }
    else {
	print "No args\n";
	$Flags::cron = 1;
    }

    $Flags::cron = 1 if $Flags::cron_pending;
expt:    
    print "Args: ARGV_COPY = @ARGV_COPY\n";
    
###    Pipeline::pipeline()->arg_check(@ARGV_COPY, @ARGV);
    Pipeline::pipeline()->arg_check(@ARGV);
}
=cut

=pod
            given($flag) {
                when("-c")              { $Flags::cron = $Flags::cron_pending = 1; Flags::set_flag_value('cron', 1); print "EISPIPELINE/EISSTATUS\n"}
                when("TEST")            { $Flags::TESTING = 1; }
                when("just_fits")       { $Flags::JUST_FITS_FLAG = 1; }
                when("fetch_only")      { $Flags::FETCH_ONLY_FLAG = 1; }
                when("fits_only")       { $Flags::FITS_ONLY_FLAG = 1; }
                when("no_update")       { $Flags::NO_UPDATE_DARTS_TRENDS = 1; }
                when("v1")              { $Flags::REFORMAT_VERSION = $flag; }
                when("v2")              { $Flags::REFORMAT_VERSION = $flag; }
                when("DPRINT")          { $System::DEBUG_PRINT = 1; }
                default                 { print "Unknown flag ($flag)\n"; }
            }
=cut

=pod
            switch($flag) {
                case "-c"               { $Flags::cron = $Flags::cron_pending = 1; }
                case "TEST"             { $Flags::TESTING = 1; }
                case "just_fits"        { $Flags::JUST_FITS_FLAG = 1; }
                case "fetch_only"       { $Flags::FETCH_ONLY_FLAG = 1; }
                case "fits_only"        { $Flags::FITS_ONLY_FLAG = 1; }
                case "no_update"        { $Flags::NO_UPDATE_DARTS_TRENDS = 1; }
                case "v1"               { $Flags::REFORMAT_VERSION = $flag; }
                case "DPRINT"           { $System::DEBUG_PRINT = 1; }
                else                    { print "Unknown flag ($flag)\n"; }
            }
=cut

1;

__END__                                                                                                                             
                                                                                                                                    
=head1 NAME                                                                                                                         
                                                                                                                                    
sample - Using Getopt::Long and Pod::Usage                                                                                          
                                                                                                                                    
=head1 SYNOPSIS                                                                                                                     
                                                                                                                                    
sample [options] [file ...]                                                                                                         
                                                                                                                                    
 Options:                                                                                                                           
   -help            brief help message                                                                                              
   -man             full documentation                                                                                              
                                                                                                                                    
=head1 OPTIONS                                                                                                                      
                                                                                                                                    
=over 8                                                                                                                             
                                                                                                                                    
=item B<-help>                                                                                                                      
                                                                                                                                    
Print a brief help message and exits.

                                                                                                                                    
=item B<-man>                                                                                                                       
                                                                                                                                    
Prints the manual page and exits.                                                                                                   
                                                                                                                                    
=back                                                                                                                               
                                                                                                                                    
=head1 DESCRIPTION                                                                                                                  
                                                                                                                                    
B<This program> will read the given input file(s) and do something                                                                  
useful with the contents thereof.                                                                                                   
                                                                                                                                    
=cut                                                                                                                                
