package Data;

#print "HINODE/EIS/EISPIPELINE/DATA.PM\n";

use strict;
use warnings;

use File::Basename;

use Trace::Trace;

use Hinode::EIS::EisPipeline::Filesystem;
#use Hinode::EIS::EisPipeline::Common;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/Data\n";
}

# Remove any junk left over from previous pipeline execution
sub clean {
    Trace::trace((caller(0))[3]);

###    Dates::foo_test();
    
###    return if $Flags::RECOVER_TEST_FLAG;

#    if ($Flags::RECOVER_TEST_FLAG) {
#	&$System::log("Skipping stage due to RECOVER_TEST_FLAG is set");
#	return;
#    }

#    if ($Flags::JUST_FITS_FLAG) {
#	&$System::log("Skipping stage due to JUST_FITS_FLAG is set");
#	return;
#    }

    # This is done by System::run_stage if called that way
######    &$System::stage_title("Data::clean : Removing old data");

    # Remove old ccsds compressed files
    &$System::stage_step("Remove old ccsds files if any");
    &$System::perform("/bin/cd $Filesystem::MERGE_DIR && /bin/rm -f eis_md_*");
    &$System::perform("/bin/cd $Filesystem::MERGE_DIR && /bin/rm -f eis_sts*");
    &$System::perform("/bin/cd $Filesystem::MERGE_DIR && /bin/rm -f eis_dmp*");
    
    # Remove old fits files
    &$System::stage_step("Remove old fits files");
    &$System::perform("/bin/cd $Filesystem::LOCALDATA_FITS_DIR && /bin/rm -f eis_l0*");
    &$System::perform("/bin/cd $Filesystem::TEMP_FITS_DIR && /bin/rm -f eis_l0*");

    # Remove old log files
    &$System::stage_step("Remove old log files");
#    &$System::perform("/bin/rm $Filesystem::LOCAL_LOG_MERGE_DIR" . "/*");
#    &$System::perform("/bin/rm -f $Filesystem::LOCAL_LOG_MERGE_TMP_DIR" ."/*");

    # Give the specialized pipeline a chance to clean
    Pipeline::pipeline()->clean();
    
    &$System::perform("unset noclobber");
    
    System::dprint("Done Pipeline Data clean\n");

}

1;
