package Dates;

#print "HINODE/EIS/EISPIPELINE/DATES.PM\n";

use strict;
use warnings;

use Time::Local;
use Date::Calc qw/Delta_Days Add_Delta_Days/;

use Trace::Trace;

#use Hinode::EIS::EisPipeline::Constants;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/Dates\n";
}

my @months = ('','January','February','March','April','May','June','July','August','September','October','November','December');

my %month_to_number = (
    Jan => "01",
    Feb => "02",
    Mar => "03",
    Apr => "04",
    May => "05",
    Jun => "06",
    Jul => "07",
    Aug => "08",
    Sep => "09",
    Oct => "10",
    Nov => "11",
    Dec => "12",
    );

our $sdate = "";
our $edate = "";	# yyyymmdd

# Move to EisMission?
our $stime = "";
our $etime = "";	# hhmm

our ($year,   $month,   $day);
our ($syear,  $smonth,  $sday);
our ($syear1, $smonth1, $sday1);

our @today;
our $start_date_string;

our $eyear;  # = 2019;
our $emonth; # = "08";
our $eday;   # = 27;

our $date_path_string;


sub convert_plan_date {
    Trace::trace((caller(0))[3]);

    my $plan_date = shift;

    my ($day, $month, $year) = split(/-/, $plan_date);
    print "convert_plan_date: '$day', '$month', '$year'\n";
    return sprintf "%04u%02u%02u", $year, $month_to_number{$month}, $day;
}

sub dump_dates {
    Trace::trace((caller(0))[3]);

    print "sdate = $sdate\n";
    print "edate = $edate\n";
}


sub date_to_days {
    my $marker = shift;

#    Trace::trace(__PACKAGE__."::date_to_days");
    Trace::trace((caller(0))[3]);

    return Date::Calc::Date_to_Days($syear, $smonth, $sday) if $marker eq "start";
    return Date::Calc::Date_to_Days($eyear, $emonth, $eday) if $marker eq "end";
}

# $start = "yyyymmdd"
sub add_day {
    my $start = shift;

#    Trace::trace(__PACKAGE__."::add_day");
    Trace::trace((caller(0))[3]);

    my $n = 1; #shift;
    my $y = substr($start, 0, 4);
    my $m = substr($start, 4, 2);
    my $d = substr($start, 6, 2);
    
    ($y, $m, $d) = add_days($y, $m, $d, $n);
    my $mm = sprintf "%02u", $m;
    my $dd = sprintf "%02u", $d;
    return "$y$mm$dd";
}

# This returns ($year, $month, $day)
sub add_days {
    my $start_year = shift;
    my $start_month = shift;
    my $start_day = shift;
    my $diff = shift;

#    Trace::trace(__PACKAGE__."::add_days");
    Trace::trace((caller(0))[3]);

    return Date::Calc::Add_Delta_Days($start_year,$start_month,$start_day, $diff);
}

sub set_date_path_string {
#    Trace::trace(__PACKAGE__."::set_date_path_string");
    Trace::trace((caller(0))[3]);

    $date_path_string = "$year/$month";
}

sub set_date_string {
#    Trace::trace(__PACKAGE__."::set_date_string");
    Trace::trace((caller(0))[3]);

    # Split the start date into constituent parts
    $year  = substr $sdate, 0, 4;
    $month = substr $sdate, 4, 2;
    $day   = substr $sdate, 6, 2;
    
    $start_date_string = "$year$month$day";
}

sub dates_set_check {
    Trace::trace((caller(0))[3]);

    my $ret = 1;
    $ret = 0 if $sdate eq "";
    $ret = 0 if $edate eq "";
    $ret = 0 if $stime eq "";
    $ret = 0 if $etime eq "";
    return $ret;
}

sub day_difference {
#    Trace::trace(__PACKAGE__."::day_difference");
    Trace::trace((caller(0))[3]);

#    print("day_difference:\n");
#    print("$syear1, $smonth1, $sday1, $today[5], $today[4], $today[3]\n");
    return Date::Calc::Delta_Days($syear1,$smonth1,$sday1,$today[5],$today[4],$today[3]);
}

sub is_saturday {
#    Trace::trace(__PACKAGE__."::is_saturday");
    Trace::trace((caller(0))[3]);

    return $today[6] == 6;
}

sub is_sunday {
#    Trace::trace(__PACKAGE__."::is_sunday");
    Trace::trace((caller(0))[3]);

    return $today[6] == 0;
}

# Get today's date in the local timezone
# Adjust month and year to correct values
sub today {
#    Trace::trace(__PACKAGE__."::today");
    Trace::trace((caller(0))[3]);

#    return (localtime)[0..6];

    my($s,$m,$h,$d,$M,$y,$w) = (localtime)[0..6];
    ++$M;
    $y += 1900;
    @today = ($s,$m,$h,$d,$M,$y,$w);
    #return ($s,$m,$h,$d,$M,$y,$w);
    ############    return @today;
}

sub update_dates {
#    Trace::trace(__PACKAGE__."::update_dates");
    Trace::trace((caller(0))[3]);

    $syear  = substr($sdate, 0, 4);
    $smonth = substr($sdate, 4, 2);
    $sday   = substr($sdate, 6, 2);
#    print "SYEAR, SMONTH, SDAY = $syear, $smonth, $sday\n";
    $year = $syear;
    $month = $smonth;
    $day = $sday;

    $syear1  = sprintf "%04u", $syear;
    $smonth1 = sprintf "%04u", $smonth;
    $sday1   = sprintf "%04u", $sday;

    $eyear  = substr($edate, 0, 4);
    $emonth = substr($edate, 4, 2);

    $eday   = substr($edate, 6, 2);

    $start_date_string = $sdate;
}

=pod
# Move to EisMission Dates.pm
sub update_mission_dates {
    Trace::trace(__PACKAGE__."::update_mission_dates $sdate");
#    Trace::trace((caller(0))[3]);

    $syear  = substr($sdate, 0, 4);
    $smonth = substr($sdate, 4, 2);
    $sday   = substr($sdate, 6, 2);
    System::dprint("syear, smonth, sday : $syear $smonth $sday");

    $year = $syear;
    $month = $smonth;
    $day = $sday;

    $syear1  = sprintf "%04u", $syear;
    $smonth1 = sprintf "%04u", $smonth;
    $sday1   = sprintf "%04u", $sday;

    $eyear  = substr($edate, 0, 4);
    $emonth = substr($edate, 4, 2);
    $eday   = substr($edate, 6, 2);

#    $start_date_string = $sdate;
}
=cut

sub set_start_end_dates {
    my $starting_date = shift;
    my $ending_date = shift;

#    Trace::trace(__PACKAGE__."::set_start_end_dates ($starting_date $ending_date)");
    Trace::trace((caller(0))[3] . " ($starting_date $ending_date)");

    $sdate = $starting_date;
    $edate = $ending_date;

#    update_dates();
}

sub set_start_end_times {
    my $starting_time = shift;
    my $ending_time = shift;

#    Trace::trace(__PACKAGE__."::set_start_end_times ($starting_time $ending_time");
    Trace::trace((caller(0))[3] . " ($starting_time $ending_time");

    $stime = $starting_time;
    $etime = $ending_time;

#    update_dates();
}

=pod
sub set_mission_dates_interactive {
    my $starting_date = shift;
    my $ending_date = shift;

    Trace::trace(__PACKAGE__."::set_mission_dates_interactive $starting_date");

    $sdate = $starting_date;
    $edate = $ending_date;

    update_mission_dates();
}
=cut

sub set_dates_cron {
    my $starting_date = shift;

#    Trace::trace(__PACKAGE__."::set_dates_cron");
    Trace::trace((caller(0))[3]);

    System::dprint("set_dates_cron: $starting_date");

    $sdate = $starting_date;
    $edate = add_day($starting_date);
    System::dprint("edate = $edate");
#    update_dates();
}

# Given a date array and an offset return a new date array with the
# offset added or subtracted depending on the sign of the offset
sub other_date {
#    Trace::trace(__PACKAGE__."::other_date");
    Trace::trace((caller(0))[3]);

    my $diff = shift;
    my %options = @_;

#    my @now  = @_;
    my @now  = @today;
###    my $diff = $now[-1];
    my @new_date;

    my $y1 = $now[5];
    my $m1 = $now[4];
    my $d1 = $now[3];

    my($y2, $m2, $d2) = Date::Calc::Add_Delta_Days($y1, $m1, $d1, $diff);
    @now[3..5] = ($d2, $m2, $y2);
    @new_date = @now[0..6];

    if (defined($options{'as_string'})) {
        return sprintf "%4s%02s%02s", $y2, $m2, $d2;
    }
    return @new_date;
}

# Input format  = hh:mm:ss
# Output format = hhmm
sub format_time {
    my $time = shift;
    
    Trace::trace((caller(0))[3]);

    return substr($time, 0, 2) . substr($time, 3, 2);
}

sub check_time {
    my $time = shift;

    Trace::trace((caller(0))[3]);

#    [0][0-9] [0-5][0-9]                                                                                          
#    [1][0-9] [0-5][0-9]                                                                                          
#    [2][0-3] [0-5][0-9]                                                                                          

    return 0 if ($time eq "");
    return 1 if ($time =~ /[0-1][0-9][0-5][0-9]/);
    return 1 if ($time =~ /[2][0-3][0-5][0-9]/);
    return 0;
}

sub check_date {
    my $date = shift;

#    Trace::trace(__PACKAGE__."::check_date");
    Trace::trace((caller(0))[3]);

    return 1 if (($date ne "") && ($date =~ /^\d{4}/));
    return 0;
}

sub date_to_natural_lang {
#    Trace::trace(__PACKAGE__."::date_to_natural_lang");
    Trace::trace((caller(0))[3]);

    return "$months[$smonth] " . "$syear";
}

=pod
sub init_status {
    Trace::trace(__PACKAGE__."::init_status");

    set_date_string();
    update_dates();    
    today();
}
sub init_mission {
    set_date_string();
    update_mission_dates();    
    today();
}
=cut

1;
