package Ccsds;

#print "HINODE/EIS/EISPIPELINE/EISMISSION/CCSDS.PM\n";

use strict;
use warnings;
use English;

use File::Basename;

use Trace::Trace;

use LibCcsds::LibCcsds;
use LibCcsds::CcsdsReader;
use LibCcsds::GapCcsdsReader;
#use LibCcsds::CcsdsPacket::EisCcsdsPacket;

use Hinode::EIS::EisCcsds::EisCcsdsPacket;
use Hinode::EIS::EisMissionData::MdPacket::MdPacketReader;

use Hinode::EIS::EisPipeline::EisMission::Filesystem;
use Hinode::EIS::EisPipeline::EisMission::Html;
use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::Pipeline;
use Hinode::EIS::EisPipeline::System;
use Hinode::EIS::EisRasters::Rasters;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisMission/Ccsds\n";
}

our @received_files;
our @joined_files;
our @incomplete_files;
our @headless_files;
our @tailless_files;
our @engineering_files;

our %summary;

our $INCOMPLETE = (1 << 0);
our $HEADLESS   = (1 << 1);
our $TAILLESS   = (1 << 2);

our %filenames;
our %eng_filenames; #  = ("eis_md_20230301" => "/home/sbukeis/work/localdata/sdtp/merge/eis_md_20230301_0421208582:Flat Oscn");

our %md_hdr_dump;

my %headless;
my %incomplete;
my %compressed;

my %files_seq_counts; # = ("eis_md_20230301" => [100,200,1,2,1000,50,10]);

my $verbose;
my $file;

# Also performs packet integrity checks.
# Derived from the original file: pipeline_ccsds_check -> ../src/pipeline_ccsds_check.pl (?)
sub ccsds_packet_dump {
    my $dirname = shift;
    my $log = shift;

    Trace::trace((caller(0))[3]);

    &$System::stage_step("Open the ccsds packet dump log");
    if (! open(FH, ">$log")) {
	&$Pipeline_::pipeline_warn("Can't open ccsds packet dump log: $!");
	return;
    }

    my $reader = CcsdsReader->new(packet_type => 'Eis');

    my @files = `/bin/ls $dirname | $Program::GREP eis_md`;
    
    #foreach my $file (@Data::joined_files) {
    foreach $file (@files) {
	&$System::stage_step("Dump $file");

	chomp $file;
	my $path = "$Filesystem::JOIN_DIR/$file";

	if(! $reader->openForReading("$dirname/$file")) {
	    &$Pipeline::pipeline_warn("Failed to open file $file : $!");
	    next;
	}
	
	if(! $reader->nextPacket()) {
	    &$Pipeline::pipeline_warn("Failed to get first packet");
	    $reader->closeInput();
	    next;
	}

	my $missing_count = 0;
	my $gaps          = 0;
	my $first         = 1;
	my $packet_count  = 0;

	print FH "\n$dirname/$file\n";
	print FH "Time, Version, Type, Sec, APID, Flg, Count, Len\n";
	
	$reader->printHeadersSummary(\*::FH); # This goes to STDOUT unless a filehandle glob is passed in

	my $seq_count = $reader->getSequenceCount();
	my $first_seq_count = $seq_count if $first;
	$first = 0;
	my $first_flag = $reader->firstPacketOfSequence();

	#$headless{$file} = 'Headless packet' unless $reader->isFirstPacketOfSequence();
	$filenames{$file} |= $HEADLESS unless $reader->isFirstPacketOfSequence();
	push @headless_files, $file unless $reader->isFirstPacketOfSequence();

	while($reader->nextPacket()) {
	    ++$packet_count;
	    my $next_seq_count = $reader->getSequenceCount();
	    if($next_seq_count != (($seq_count + 1) & 0x3FFF)) {
		if(!(($next_seq_count == 0) and ($seq_count == 0x3FFF))) {
		    ++$gaps;
		    # Get count of number of missing packets
		    my $missing = $next_seq_count - $seq_count - 1;
		    # Adjust for wrap around
		    $missing = 16384 + $missing if $missing < 0;
		    # Add to total
		    my $missing_count += $missing;
		    print FH "*** Missing packets: $missing\n";
		    #$filenames{$file} = 'Missing packets';
		}
	    }
	    $seq_count = $next_seq_count;
	    $reader->printHeadersSummary(\*::FH);
	}

	push @incomplete_files, $file if $gaps;
	$filenames{$file} |= $INCOMPLETE if $gaps;

	# Check whether last packet's flag is 2
	# $filenames{$file} = 'Missing packets' unless $reader->isLastPacketOfSequence();
	my $last_flag = $reader->lastPacketOfSequence();
	$incomplete{$file} = 'Incomplete packets' unless $reader->isLastPacketOfSequence();
	++$gaps unless $reader->isLastPacketOfSequence();
	$filenames{$file} |= $TAILLESS unless $reader->isLastPacketOfSequence();
	push @tailless_files, $file unless $reader->isLastPacketOfSequence();

	$reader->report(\*::FH);
	&$system::log("$file: Number of gaps: $gaps\tNumber of packets missing: $missing_count");

	$summary{$file} = [$packet_count, $gaps, $missing_count];

	#
	# Record filename & first, last sequence count
	#
	$files_seq_counts{$file} = [$first_seq_count, $seq_count, $first_flag, $last_flag, $reader->numberOfPackets(), $missing_count, $gaps];

	$reader->closeInput();
    }

    my $hash    = "Missing ";
    my $message = "filenames hash has ";
    my $result  = "something";
    if(%filenames) {
	&$system::comment($hash . $message . $result);
        print STDERR "Missing filenames hash has something\n";
        open(SUMMARY, "> $dirname/missing_packets.txt") || print STDERR "Can't open $dirname/missing_packets.txt : $!\n";
	print SUMMARY "Missing\n";
        foreach my $key (keys %filenames) {
	    if($filenames{$key} eq 'Missing packets') {
                print SUMMARY "$key\n";
            }
        }
	print SUMMARY "\n";
        close SUMMARY;
    }
    else {
        $result = "NOTHING";
        &$System::comment($hash . $message . $result);
        print STDERR "Missing filenames hash has NOTHING\n";
    }

    $hash   = "Headless ";
    $result = "something";
    if(%headless) {
        &$System::comment($hash . $message . $result);
        print STDERR "Headless filenames hash has something\n";
        open(SUMMARY, "> $dirname/headless_packets.txt") || print STDERR "Can't open $dirname/headless_packets.txt : $!\n";
        print SUMMARY "Headless\n";
        foreach my $key (sort keys %headless) {
            if($headless{$key} eq 'Headless packet') {
                print SUMMARY "$key\n";
            }
        }
	print SUMMARY "\n";
        close SUMMARY;
    }
    else {
	$result = "NOTHING";
        &$System::comment($hash . $message . $result);
        print STDERR "Headless filenames hash has NOTHING\n";
    }

    $hash   = "Incomplete ";
    $result = "something";
    if(%incomplete) {
        &$System::comment($hash . $message . $result);
        print STDERR "Incomplete filenames hash has something\n";
        open(SUMMARY, "> $dirname/incomplete_packets.txt") || print STDERR "Can't open $dirname/incomplete_packets.txt : $!\n";
        print SUMMARY "Incomplete\n";
        foreach my $key (sort keys %incomplete) {
            if($incomplete{$key} eq 'Incomplete packets') {
                print SUMMARY "$key\n";
            }
        }
        print SUMMARY "\n";
        close SUMMARY;
    }
    else {
        $result = "NOTHING";
        &$System::comment($hash . $message . $result);
        print STDERR "Incomplete filenames hash has NOTHING\n";
    }

    if(open(COUNTS, "> $dirname/sequence_counts.txt")) {
        ###print COUNTS "Filename                    Seq1  Seq2 Flg1 Flg2    Rec   Miss  Gaps\n"
        my $previous_fh = select COUNTS;
        $^ = 'SEQ_HDR';
        $~ = 'SEQ';
        foreach my $f (sort keys %files_seq_counts) {
            my $seq1 = sprintf "%5u", $files_seq_counts{$f}[0];
            my $seq2 = sprintf "%5u", $files_seq_counts{$f}[1];
            my $flg1 = sprintf "%4u", $files_seq_counts{$f}[2];
            my $flg2 = sprintf "%4u", $files_seq_counts{$f}[3];
            my $crec = sprintf "%6u", $files_seq_counts{$f}[4];
            my $miss = sprintf "%6u", $files_seq_counts{$f}[5];
            my $gapn = sprintf "%5u", $files_seq_counts{$f}[6];
            #print COUNTS "$f $seq1 $seq2 $flg1 $flg2 $crec $miss $gapn\n";
            #print STDERR "$f $seq1 $seq2 $flg1 $flg2 $crec $miss $gapn\n";
            write;

            format SEQ_HDR =
Filename                       Seq1     Seq2   Flg1  Flg2        Rec     Miss   Gaps
.

            format SEQ =
@<<<<<<<<<<<<<<<<<<<<<<<<<< @###### @###### @###### @#### @######### @####### @#####
$f, $seq1, $seq2, $flg1, $flg2, $crec, $miss, $gapn
.

        }
        close COUNTS;
        #$~ = "STDOUT";
        select $previous_fh;
    }

}

# Derived from the original file: bin/pipeline_md_hdr_dump -> ../src/ccsds_md_hdr_dump1.pl
sub ccsds_md_packet_dump {
    my $dir = shift;
    my $log = shift;

    Trace::trace((caller(0))[3]);
    my $filename;

    # open log
    #open(FH, ">$log") or die "Can't open ccsds md packet dump log: $!";
    if (open(FH, "> $log")) {
        &$System::comment("Opened $log ok");
    }
    else {
        &$Pipeline::pipeline_warn("Can't open ccsds md packet dump log ($log): $!");
	return;
    }

    #open(SHUT, ">> $Filesystem::LOCAL_SHUTTER_LOG") || print STDERR "Can't open shutter log.txt : $!\n";
    if (open(SHUT, ">> $Filesystem::LOCAL_SHUTTER_LOG")) {
        &$System::comment("Opened $Filesystem::LOCAL_SHUTTER_LOG ok");
    }
    else {
        print STDERR "Can't open shutter log ($Filesystem::LOCAL_SHUTTER_LOG): $!\n";
        return;
    }

    my $reader = MdPacketReader->new();
    my @files = `/bin/ls $dir | $Program::GREP eis_md`;

    print FH Html::html_header("Hinode EIS Mission Header Dump");
    print FH "<body>\n";
    print FH "<pre>\n";

    my $archive;
    my $filen;
    foreach $filen (@files) {
	#chomp $filen;
	my $last_file = $filen;
	my $file = "$dir/$filen";
	my $short_name = substr $file, -26, 26;

	my $done = 0;
	my $md_headers = 0;
	if(! ($reader->open($file))) {
	    print STDERR "Failed to open file\n";
	    &$System::comment("Failed to open file ($file): $!");
	    next;
	}
	print FH "\n$file\n";
	$reader->header_report_header(\*::FH);

	my $eng1;
	my $compressed;
	my $raster_id;
	my $ppe;
	my $ras_req;
	my $ep;

	while(1) {
	    if($reader->readPacket()) {
		++$md_headers;
		$reader->header_report1(\*::FH);	# STDOUT
		
		($compressed, $raster_id, $ppe, $ras_req, $ep) = $reader->packet_details();

#	    my $compressed = $reader->is_compressed();
#	    my $raster_id = $reader->raster_id();
#	    my $ppe = $reader->mdPacketsPerExposure();
#	    $ras_req = $reader->rasters_required();
#	    $ep = $reader->exposures_per_position();

		my($eng, $type) = Rasters::eng($raster_id);
		$eng1 = $eng;
                #	    $filenames{$file} = $type if $eng;
		$filenames{$file} = $type;
		$eng_filenames{$file} = $type if $eng;
		#push @engineering_files, $file if $eng1;
		$compressed{$file} = $compressed;
#		while($reader->nextPacket()) {
		last if($reader->isLastPacketOfSequence());
#	    }
	    }
	    else {
		last if($reader->{_packetValid} == 0);
		print FH "Pixel data\n";
		$done = 1;
	    }
	}

	$reader->closeInput();

	print FH "$md_headers headers\n";
######!?!?!	    $reader->report(\*::FH);	# STDOUT
	my $shutter_move = 0;
	$shutter_move = sprintf("%5u", ($ras_req * $ep * 2)) if $eng1 == 0;
	print SHUT "$short_name : ", $shutter_move, "\n";
#$shutter_move = sprintf("%5u", (($md_headers * 2) / $ppe)) if $eng == 0;
###print SHUT "$short_name : ", sprintf("%5u", ($md_headers * 2)), "\n";
    }

    close SHUT;

    print FH "</pre>\n";
    print FH Html::html_end();

    close(FH);

    if(%eng_filenames) {
	print STDERR "Data summary filenames hash has something\n";
	open(SUMMARY, "> $Filesystem::ENGINEERING_LOG") || print STDERR "Can't open engineering.txt : $!\n";
	print SUMMARY "Engineering\n";

	foreach my $key (keys %eng_filenames) {
	    if($filenames{$key} =~ m/^Eng/) {
		my $val = $eng_filenames{$key};
		$val =~ s/Eng //;
		print SUMMARY "$key:$val\n";
	    }
	}
	print SUMMARY "\n";
	close SUMMARY;
    }
    else {
	print STDERR "Data summary filenames hash has NOTHING\n";
    }

# ????
# $last_file has the name of the last file processed.
# Extract the date and hhmm portion of the filename
# and save to a file, ready for the next time the
# pipeline runs it can start with the last file of
# the previous run in case that file was truncated.
# Filename: eis_md_yyyymmdd_hhmmsstthh

#    my $date  = substr($last_file, 7, 8);
#    my $stime = substr($last_file, 16, 4);

}

sub check_start_flags {
    my $reader = shift;

    Trace::trace((caller(0))[3]);
    return 1 if($reader->isFirstExposurePacket());
    return 0;
}

sub check_end_flags {
    my $reader = shift;

    Trace::trace((caller(0))[3]);
    if($reader->isEndExposurePacket()) {
	my $flags = $reader->sequenceFlags();
	return 1 if($flags == 2);
	return 0;
    }
}


our %missing;

sub record_filename {
    my $line = shift;

    Trace::trace((caller(0))[3]);

    my $filename = substr $line, -26, 26;
}

sub record_total {
    my $line = shift;

    Trace::trace((caller(0))[3]);

    my ($tmp, @junk) = split / /, $line;
    my $total_ccsds_packets = sprintf "%u", $tmp;
    return $total_ccsds_packets;
}

#sub record_total1 {
#    my $line = shift;
#    my @tmp;
#    @tmp = split / /, $line;
#    return sprintf "%u", $tmp[1];
#}

sub record_gaps {
    my $line = shift;

    Trace::trace((caller(0))[3]);

    my @tmp = split / /, $line;
    my $gaps = sprintf "%u", $tmp[-1];
    return $gaps;
}

sub record_missing {
    my $line = shift;

    Trace::trace((caller(0))[3]);

    my @tmp = split / /, $line;
    my $missing =  sprintf "%u", $tmp[-1];    
    #    $missing{$filename} = [$total_ccsds_packets, $missing, $gaps];
    return $missing;
}

# Reads the ccsds_hdrs.yyyymmdd.txt file produced by...
# CCSDS_MISSING_SUMMARY
# This function replaces the above function (packets_missing)
sub missing_summary {
    my $file = shift;

    Trace::trace((caller(0))[3]);

    my $filename = "";
    my $missing = 0;
    my $gaps    = 0;
    my $total   = 0;
    my $nfiles  = 0;

    return ($total, $missing, $gaps, $nfiles) unless open FH, "<$file";

    #$date = "No date";
    #    if($#ARGV != -1) {
    ####    $date = $ARGV[0];
    #    $date = shift;
    ##    print "$date\n";
    #    }
    
    #    print "Filename\t\t      Rec    Miss  Gaps    $date\n";
    
    while(<FH>) {
	next if /^Dirname/;
	next if /^$/;
	next if /^Time/;
	chomp;
	#	record_filename($_) if /^\/nasA/;
	#	record_filename($_) if /^\/san_solar/;
	++$nfiles if ((/^\/nasA/) || (/^\/san_solar/));
	$total   += record_total($_)   if /ccsds packets/;
	#	$total   = record_total1($_)   if /^Read/;
	$gaps    += record_gaps($_)    if /Number of gaps/;
	$missing += record_missing($_) if /Number of packets missing/;
    }
    close FH;
    return ($total, $missing, $gaps, $nfiles);
}

####### exposures_missing_packets.pl
our %exposures;

# Derived from the original file: src/exposures_missing_packets.pl
sub exposures_missing_packets {
    my $file = shift;
    
    Trace::trace((caller(0))[3]);

    return unless open FH, "<$file";

    my $previous_fh = select FH;
    $^ = 'MISSING_HDR';
    $~ = 'MISSING';

    <FH>;
    <FH>;

    my $fname = "";
    my $exposure_count = 0;
    my $in_exposure = 0;
    my $missing = 0;
    my $md_header_count;
    while(<FH>) {
	if(/eis_md/) {
	    chomp;
	    $fname = $_;
	    $fname = substr $fname, -26, 26;
	    $in_exposure = 0;
	    $missing = 0;
	    $exposure_count = 0;
	    next;
	}
	next if /^Time/;
	my @hdr = split(/,/, $_);
	if($hdr[5] == 1) {
	    $in_exposure = 1;
	    $missing = 0;
	    next;
	}
	if(/Missing packets:/) {
	    $missing = 1;
	    next;
	}
	if($hdr[5] == 2) {
	    ++$exposure_count if $missing == 0;
	    $missing = 0;
	    $in_exposure = 0;
	    next;
	}
	if(/^$/) {
	    print "$fname\t$exposure_count\n";
	    $exposures{$fname} = $exposure_count;
	    next;
	}
	next if /ccsds/;
	next if /^Number/;
    }
    close FH;
    write;

    select $previous_fh;

    format MISSING_HDR =                                                                                          
Filename              Header count                                                                                
.                                                                                                                 

    format MISSING =                                                                                              
@<<<<<<<<<<<<<<<<<<<<<<<<<    @######                                                                             
$fname, $md_header_count                                                                                          
.                                                                                                                 

}
#####

# sequence_count_continuity_check.pl

# sequence_counts file
#eis_md_20080610_1046593040 6309 7876

# Derived from the original file: src/sequence_count_continuity_check.pl
my $filename;
my $previous_start;
my $previous_end;
my $diff;
my $num_received;
sub sequence_count_continuity_check {
    my $input_file  = shift;
    my $output_file = shift;

    Trace::trace((caller(0))[3]);

    return unless open IFH, "<$input_file";
    return unless open OFH, ">$output_file";

    my $first_time = 1;

#    select((select(SEQ),
#	    $~ = "STDOUT",
#	    #	    $^ = "My_Top_Format"
#	   )[0]);
    my $previous_fh = select OFH;
    $^ = 'SEQS_HDR';
    $English::Format_Name = 'SEQS';             # $~ = SEQS;                                                      
##    $~ = "SEQ";                                                                                                 
#    $~ = 0;

#    print "Filename\t\t    Start    End   Diff\t   Rec\n";
    $filename = "FILENAME";
    $previous_start = 0;
    $previous_end = 100;
    $diff = 1;
    $num_received = 22;
    write;
    while(<FH>) {
	next if /Filename/;
	chomp;
	my ($filen, $start, $end, $sf, $ef, $r, $m, $g) = split;
	if($first_time) {
	    $first_time = 0;
	    $filename = $filen;
#	    $previous_file = $filen;
	    $previous_end = $end;
	    $previous_start = $start;
	    $num_received = ($end - $start)  if $end > $start;
	    $num_received = ($end + 0x4000)  - $start if $end <= $start;
	    ++$num_received;
	    $diff = 0;
###	    write STDOUT;
	    write;
	    #print "$filename, $start, $end, $sf, $ef, $r, $m, $g\n";
	    next;
	}
	$num_received = ($end - $start)  if $end > $start;
	$num_received = ($end + 0x4000)  - $start if $end <= $start;
	++$num_received;
	$diff = $start - ($previous_end + 1);
	if($diff != 0) {
	    if($diff < 0) {
		$start += 0x4000;
		$diff = $start - ($previous_end + 1);
	    }
	}
	#print "$filename, $start, $end, $sf, $ef, $r, $m, $g\n";
	###    write STDOUT;
#	$previous_file = $filename;
	$previous_end = $end;
	$previous_start = $start;
###	write STDOUT;
	write;
    }

    close IFH;
    close OFH;

    select $previous_fh;

    format SEQS_HDR =
Filename             Start       End     Diff       Rec
.

    format SEQS =
@<<<<<<<<<<<<<<<<<<<<<<<<< @>>>>> @>>>>> @>>>>> @>>>>>
$filename, $previous_start, $previous_end, $diff, $num_received
.

}


1;
