package Dates;

#print "HINODE/EIS/EISPIPELINE/EISMISSION/DATES.PM\n";

use strict;
use warnings;

use Trace::Trace;

use Hinode::EIS::EisPipeline::Dates;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisMission/Dates\n";
}

sub convert_plan_time {
    Trace::trace((caller(0))[3]);

    my $plan_time = shift;

    my ($h, $m, $s) = split(/:/, $plan_time);
    print "convert_plan_time: '$h', '$m', '$s'\n";
    return sprintf "%02u%02u", $h, $m;
}

sub dump_dates_and_times {
    Trace::trace((caller(0))[3]);

    Dates::dump_dates();
    print "stime = $Dates::stime\n";
    print "etime = $Dates::etime\n";
}

sub set_mission_dates_interactive {
    my $starting_date = shift;
    my $ending_date = shift;

    Trace::trace(__PACKAGE__."::set_mission_dates_interactive $starting_date");

    $Dates::sdate = $starting_date;
    $Dates::edate = $ending_date;

    update_mission_dates();
}

sub init_mission {
    Trace::trace((caller(0))[3]);

    Dates::set_date_string();
    Dates::update_mission_dates();    
    # Now in Pipeline::create
###    Dates::today();
}

sub update_mission_dates {
#    Trace::trace(__PACKAGE__."::update_mission_dates $sdate");                                                                       
    Trace::trace((caller(0))[3]);

    $Dates::syear  = substr($Dates::sdate, 0, 4);
    $Dates::smonth = substr($Dates::sdate, 4, 2);
    $Dates::sday   = substr($Dates::sdate, 6, 2);
    System::dprint("syear, smonth, sday : $Dates::syear $Dates::smonth $Dates::sday");

    $Dates::year = $Dates::syear;
    $Dates::month = $Dates::smonth;
    $Dates::day = $Dates::sday;

    $Dates::syear1  = sprintf "%04u", $Dates::syear;
    $Dates::smonth1 = sprintf "%04u", $Dates::smonth;
    $Dates::sday1   = sprintf "%04u", $Dates::sday;

    $Dates::eyear  = substr($Dates::edate, 0, 4);
    $Dates::emonth = substr($Dates::edate, 4, 2);
    $Dates::eday   = substr($Dates::edate, 6, 2);

#    $start_date_string = $sdate;                                                                                                     
}

1;
