package Filesystem;

#print "HINODE/EIS/EISPIPELINE/EISMISSION/FILESYSTEM.PM\n";

use strict;
use warnings;

use Hinode::EIS::EisPipeline::System;
use Hinode::EIS::EisPipeline::Filesystem;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisMission/Filesystem\n";
}


# Directories
#my  $SODA         = $Filesystem::HOME . "/soda/hinode/eis";					# /soda/hinode/eis
my  $SODA         = "/soda/hinode/eis";								# /soda/hinode/eis
our $SODA_DIR     = $SODA     . "/level0";							# /soda/hinode/eis/level0
our $SODA_CAL_DIR = $SODA_DIR . "/cal";								# /soda/hinode/eis/level0/cal


our $DARTS_STAGING_MISSION_QUICKLOOK = "DARTS_STAGING_MISSION_QUICKLOOK";
our $LOCAL_MISSION_QUICKLOOK         = "LOCAL_MISSION_QUICKLOOK";
our $LOCAL_MISSION_QUICKLOOK_FITS    = "LOCAL_MISSION_QUICKLOOK_FITS";

our $DARTS_DIR             = $Filesystem::DATA_DIR              . "/mission";			# $HOME/data/mission
#our $DATA_MISSION_DIR      = $DATA_DIR                   . "/mission";				# $HOME/data/mission
our $DARTS_MISSION         = $DARTS_DIR;							# $HOME/data/mission
#my  $DATA_QL_MISSION_DIR             = $DATA_QUICKLOOK_DIR  . "/mission";			# $HOME/data/quicklook/mission
#our $DARTS_STAGING_MISSION_QUICKLOOK = $DATA_QL_MISSION_DIR;					# $HOME/data/quicklook/mission
our $ORL_DIR               = $Filesystem::DATA_STAGING_DIR      . "/orl";			# $HOME/data/staging/orl
our $PLAN_DIR              = $Filesystem::DATA_STAGING_DIR      . "/eis_plan";			# $HOME/data/staging/eis_plan
our $DARTS_STAGING_LOGS    = $Filesystem::DATA_STAGING_LOGS_DIR . "/data_loss";			# $HOME/data/staging/logs/data_loss
our $DARTS_MISSION_LOG_DIR = $Filesystem::DATA_STAGING_LOGS_DIR . "/pipeline_mission";		# $HOME/data/staging/logs/pipeline_mission
our $DARTS_SHUTTER_LOG_DIR = $Filesystem::DATA_STAGING_LOGS_DIR . "/shutter";			# $HOME/data/staging/logs/shutter

###my  $LOCAL_LOG_DIR             = $Filesystem::LOCAL_LOG_DIR;					# $HOME/work/localdata/log
my  $DECOMPRESSION_LOG_DIR          = $Filesystem::LOCALDATA_LOG_DIR      . "/decompression";	# $HOME/work/localdata/log/decompression
												# $HOME/work/localdata/log/decompression/factors
												# $HOME/work/localdata/log/decompression/monthly
												# $HOME/work/localdata/log/decompression/monthly/records
												# $HOME/work/localdata/log/decompression/monthly/track
												# $HOME/work/localdata/log/mission
our $MD_FETCH_LOG_DIR               = $Filesystem::LOCALDATA_LOG_DIR      . "/pipeline";	# $HOME/work/localdata/log/pipeline
												# $HOME/work/localdata/log/real
our $REFORMAT_LOG_DIR               = $Filesystem::LOCALDATA_LOG_DIR      . "/reformat";	# $HOME/work/localdata/log/reformat
												# $HOME/work/localdata/log/rescue
our $LOCALDATA_SHUTTER_LOG_DIR      = $Filesystem::LOCALDATA_LOG_DIR      . "/shutter";		# $HOME/work/localdata/log/shutter
our $LOCALDATA_PIPELINE_MISSION_DIR = $Filesystem::LOCALDATA_PIPELINE_DIR . "/mission";		# $HOME/work/localdata/pipeline/mission ???
#our $TEMP_IDL                       = $LOCALDATA_PIPELINE_MISSION_DIR . "/idl";		# $HOME/work/localdata/pipeline/mission/idl ???
#my  $LOCALDATA_SDTP_FITS_MISSION_DIR = $LOCALDATA_SDTP_FITS_DIR . "/mission";			# $HOME/work/localdata/sdtp/fits/mission
#our $LOCAL_MISSION_QUICKLOOK_FITS    = $LOCAL_QUICKLOOK         . "/fits/mission";		# $HOME/work/localdata/sdtp/fits/mission
#our $LOCAL_MISSION_QUICKLOOK         = $LOCAL_QUICKLOOK         . "/md";			# $HOME/work/localdata/sdtp/md
our $DECOMPRESSED_DIR               = $Filesystem::MERGE_DIR              . "/decompressed";	# $HOME/work/localdata/sdtp/merge/decompressed
our $INCOMPLETE_DIR                 = $Filesystem::MERGE_DIR              . "/incomplete";	# $HOME/work/localdata/sdtp/merge/incomplete
our $JOIN_DIR                       = $Filesystem::MERGE_DIR              . "/join";		# $HOME/work/localdata/sdtp/merge/join
our $NURSERY_DIR                    = $Filesystem::MERGE_DIR              . "/nursery";		# $HOME/work/localdata/sdtp/merge/nursery
our $NURSERY_RESCUED_DIR            = $NURSERY_DIR                        . "/rescued";		# $HOME/work/localdata/sdtp/merge/nursery/rescued
our $RESCUE_DECOMPRESSED_DIR        = $NURSERY_DIR                        . "/decompressed";	# $HOME/work/localdata/sdtp/merge/nursery/decompressed
our $RESCUE_FITS_DIR                = $NURSERY_DIR                        . "/fits";		# $HOME/work/localdata/sdtp/merge/nursery/fits
our $ORPHANS_DIR                    = $Filesystem::MERGE_DIR              . "/orphans";		# $HOME/work/localdata/sdtp/merge/orphans
our $RESCUE_DIR                     = $Filesystem::MERGE_DIR              . "/rescue";		# $HOME/work/localdata/sdtp/merge/rescue
#our $SPLIT_DIR                 = $Filesystem::MERGE_DIR   . "/split/tmp";			# $HOME/work/localdata/sdtp/merge/split
our $HOOLIGANS_DIR                  = $Filesystem::MERGE_DIR              . "/hooligans";               # $HOME/work/localdata/sdtp/merge/hooligans

my  $SAT_ROT_DIR     = $Filesystem::TRACK_DIR . "/sat_rot";                                     # $HOME/track/sat_rot
our $SAT_ROT_CSV_DIR = $SAT_ROT_DIR . "/csv";                                                   # $HOME/track/sat_rot/csv

# Files
our $LOCAL_ENGINEERING_FILE = $Filesystem::MERGE_DIR . "/engineering.txt";                      # $HOME/work/localdata/sdtp/merge/engineering.txt

our $CHECK_TABLE_DIR = "CHECK_TABLE_DIR";
our $DARTS_STAGING_CHECK_TABLE_DUMP  = $Filesystem::DATA_STAGING_LOGS_DIR . "/check_tables/dumps/chk_";		# $HOME/data/staging/logs/check_tables/dumps/chk_
our $DARTS_STAGING_CHECK_TABLE_STORE = $Filesystem::DATA_STAGING_LOGS_DIR . "/check_tables/tables/chk_";	# $HOME/data/staging/logs/check_tables/tables/chk_

our $CRON_SCHEDULE_FILE    = $Filesystem::TRACK_DIR . "/cron_mission_start_schedule.txt";	# $HOME/track/cron_mission_start_schedule.txt
our $MISSION_REFORMAT_FILE = $Filesystem::TRACK_DIR . "/latest_mission_reformat.txt";		# $HOME/track/latest_status_reformat.txt
our $MISSION_PENDING_FILE  = $Filesystem::TRACK_DIR . "/mission_pending.txt";			# $HOME/track/mission_pending.txt

our $CCSDS_PACKET_CHECK_LOG   = $Filesystem::LOCALDATA_LOG_DIR . "/ccsds_hdr_check.txt";	# $HOME/work/localdata/log/ccsds_hdr_check.txt
our $CCSDS_PACKET_DUMP_FILE   = $Filesystem::LOCALDATA_LOG_DIR . "/ccsds_hdr_check.txt";	# $HOME/work/localdata/log/ccsds_hdr_check.txt
our $DECOMPRESSION_RECORD_LOG = $DECOMPRESSION_LOG_DIR         . "/merge_decomp_record.txt";	# $HOME/work/localdata/log/decompression/merge_decomp_record.txt
our $LOCAL_DECOMPRESSION_LOG  = $DECOMPRESSION_LOG_DIR         . "/md_decompress_";		# $HOME/work/localdata/log/decompression/md_decompress_
our $HEADLESS_PACKETS_LOG     = $Filesystem::LOCALDATA_LOG_DIR . "/headless_packets.txt";	# $HOME/work/localdata/log/headless_packets.txt
our $INCOMPLETE_PACKETS_LOG   = $Filesystem::LOCALDATA_LOG_DIR . "/incomplete_packets.txt";	# $HOME/work/localdata/log/incomplete_packets.txt
our $JOINED_FILES_LOG         = $Filesystem::LOCALDATA_LOG_DIR . "/joined_files.txt";		# $HOME/work/localdata/log/joined_files.txt
#our $MD_HEADER_CHECK_LOG      = $Filesystem::LOCALDATA_LOG_DIR . "/md_hdr_check.txt";		# $HOME/work/localdata/log/md_hdr_check.txt
our $MD_HEADER_DUMP_FILE      = $Filesystem::LOCALDATA_LOG_DIR  . "/md_hdr_check.txt";		# $HOME/work/localdata/log/md_hdr_check.txt
our $MD_SPLIT_CHECK_LOG       = $Filesystem::LOCALDATA_LOG_DIR . "/md_split_check.txt";		# $HOME/work/localdata/log/md_split_check.txt
our $MISSING_PACKETS_LOG      = $Filesystem::LOCALDATA_LOG_DIR . "/missing_packets.txt";	# $HOME/work/localdata/log/missing_packets.txt
our $MISSION_LOG              = $Filesystem::LOCALDATA_LOG_DIR . "/pipeline_mission_log_v2_";	# $HOME/work/localdata/log/pipeline_mission_log_
our $RECEIVED_FILES_LOG       = $Filesystem::LOCALDATA_LOG_DIR . "/received_files.txt";		# $HOME/work/localdata/log/received_files.txt
our $SEQUENCE_COUNTS_LOG      = $Filesystem::LOCALDATA_LOG_DIR . "/sequence_counts.txt";	# $HOME/work/localdata/log/sequence_counts.txt
our $LOCAL_FITS_DUMP_LOG      = $Filesystem::PIPELINE_LOG_DIR  . "/fits_dump_";			# $HOME/work/localdata/log/pipeline/fits_dump_
our $DARTS_FITS_DUMP_LOG      = $Filesystem::PIPELINE_LOG_DIR  . "/fits_dump_";			# $HOME/work/localdata/log/pipeline/fits_dump_ !!! CHANGE
our $LOCAL_FITS_HEADERS_LOG   = $Filesystem::PIPELINE_LOG_DIR  . "/fits_headers_";		# $HOME/work/localdata/log/pipeline/fits_headers_
our $LOCAL_MD_TRANSLATION_LOG = $REFORMAT_LOG_DIR              . "/md_translation_";		# $HOME/work/localdata/log/reformat/md_translation_
our $LOCAL_STS_REFORMAT_LOG   = $REFORMAT_LOG_DIR              . "/sts_reformat_";		# $HOME/work/localdata/log/reformat/sts_reformat_
our $LOCAL_SHUTTER_LOG        = $Filesystem::LOCALDATA_LOG_DIR . "/shutter.txt";		# $HOME/work/localdata/log/shutter/shutter.txt

our $DATA_LOSS_LOG = "???";

our $DARTS_MD_CHECK_LOG = "";

our $ENG_RASTER_DUMP_FILE = $Filesystem::DATA_STAGING_DIR . "/dump/eng_raster_dump.txt";
our $RASTER_DB_DUMP_FILE  = $Filesystem::DATA_STAGING_DIR . "/dump/raster_db_dump.txt";
our $STUDY_DB_DUMP_FILE   = $Filesystem::DATA_STAGING_DIR . "/dump/study_db_dump.txt";

our $PACKETS_PER_EXPOSURE_FILE = $Filesystem::TMP_DIR . "/packets_per_exposure.txt";
our $LOCAL_CCSDS_MISSING_FILE  = $Filesystem::TMP_DIR . "/missing.txt";

#our $mission_log_open = 0;

my @n = qw(SODA_DIR SODA_CAL_DIR DARTS_DIR DECOMPRESSED_DIR INCOMPLETE_DIR JOIN_DIR NURSERY_DIR NURSERY_RESCUED_DIR RESCUE_DECOMPRESSED_DIR RESCUE_FITS_DIR ORPHANS_DIR RESCUE_DIR ORL_DIR PLAN_DIR DARTS_SHUTTER_LOG_DIR MD_FETCH_LOG_DIR LOCALDATA_SHUTTER_LOG_DIR REFORMAT_LOG_DIR HOOLIGANS_DIR);

my @files = qw(LOCAL_SHUTTER_LOG MISSION_LOG MISSION_REFORMAT_FILE MISSION_PENDING_FILE CRON_SCHEDULE_FILE CCSDS_PACKET_CHECK_LOG CCSDS_PACKET_DUMP_FILE HEADLESS_PACKETS_LOG INCOMPLETE_PACKETS_LOG JOINED_FILES_LOG MD_HEADER_DUMP_FILE MD_SPLIT_CHECK_LOG MISSING_PACKETS_LOG RECEIVED_FILES_LOG SEQUENCE_COUNTS_LOG DECOMPRESSION_RECORD_LOG LOCAL_DECOMPRESSION_LOG LOCAL_FITS_DUMP_LOG DARTS_FITS_DUMP_LOG LOCAL_FITS_HEADERS_LOG LOCAL_MD_TRANSLATION_LOG DATA_LOSS_LOG LOCAL_STS_REFORMAT_LOG DARTS_STAGING_CHECK_TABLE_DUMP DARTS_STAGING_CHECK_TABLE_STORE ENG_RASTER_DUMP_FILE RASTER_DB_DUMP_FILE STUDY_DB_DUMP_FILE PACKETS_PER_EXPOSURE_FILE LOCAL_CCSDS_MISSING_FILE);

our $dir;
our $status;
our $name;

sub mission_file_dump {
    my %h;

    select((select(MISSION),
	    $~ = "STDOUT",
	    #	    $^ = "My_Top_Format"
	   )[0]);
    
    foreach my $f (@files) {
	$h{$f} = eval "\$" . $f;
	#$h{$f} = eval $f;
    }
    foreach my $f (sort keys %h) {
	my $stat = "ERROR";
	$dir = $h{$f} || "Unknown";
	$name = $f;
###	print "$f $dir\n";
	$stat = "OK" if ((-d $dir) || (-e $dir) || (-f $dir));
	$status = $stat;
	#write STDOUT;
	write;
    }

}

sub mission_path_dump {
    my %h;

    select((select(MISSION),
	    $~ = "STDOUT",
	    #	    $^ = "My_Top_Format"
	   )[0]);
    
    foreach my $f (@n) {
	$h{$f} = eval "\$" . $f;
	#$h{$f} = eval $f;
    }
    foreach my $f (sort keys %h) {
	my $stat = "ERROR";
	$dir = $h{$f} || "Unknown";
	$name = $f;
###	print "$f $dir\n";
	$stat = "OK" if ((-d $dir) || (-e $dir) || (-f $dir));
	$status = $stat;
	#write STDOUT;
	write;
    }

}

format MISSION =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @>>>>
$name, $dir, $status
.


1;

