ackage Fits;

print "HINODE/EIS/EISPIPELINE/EISMISSION/FITS.PM\n";
                                                                                                                  
use strict;                                                                                                       
use warnings;
                                                                                                                  
use File::Basename;
                                                                                                                  
use Trace::Trace;
                                                                                                                  
use Hinode::EIS::EisPipeline::EisMission::Filesystem;                                                             
use Hinode::EIS::EisPipeline::Filesystem;                                                                         
use Hinode::EIS::EisPipeline::Pipeline;                                                                           
use Hinode::EIS::EisPipeline::System;

our @received_files;
our @joined_files;
our @incomplete_files;
our @headless_files;
our @tailless_files;
our @engineering_files;

our %summary;

our $INCOMPLETE = (1 << 0);
our $HEADLESS   = (1 << 1);
our $TAILLESS   = (1 << 2);

my %filenames;

my %headless;
my %incomplete;
my %compressed;
my %files_seq_counts;

my $verbose;

# Generate the file listing the fits files produced
sub generate_fits_file_listing {
    Trace::trace((caller(0))[3]);

    my @fits_files = &$System::list($Filesystem::TEMP_FITS_DIR, "eis_l0*");
    if (@fits_files) {
#
# Write out all the fits file names
#
if(open(FOO, ">$merge_dir/fits_files.txt")) {
    print FOO "Processed on: $todays_date\n";
    print FOO "Plan duration: $sdate $edate $stime $etime\n";
    print FOO @fits_files;
    print FOO "\n";
    close FOO;
    &$System::comment("Wrote $merge_dir/fits_files.txt:");
#    log_msg(*LOG, $state, "Wrote $merge_dir/fits_files.txt:");
}
else {
    &$System::comment("Wrote $merge_dir/fits_files.txt:");
    log_msg(*LOG, $state, "Can't open $merge_dir/fits_files.txt: $!");
}

#if ($cron or $pending) {
    if (open(FOO, ">>$latest_fits_files")) {
	print FOO "Processed on: $todays_date\n";
	print FOO "Plan duration: $sdate $edate $stime $etime\n";
	print FOO @fits_files;
	print FOO "\n";
	close FOO;
	&$System::comment("Wrote $merge_dir/fits_files.txt:");
	log_msg(*LOG, $state, "Wrote $darts_mission/latest_fits_files.txt");
	perform(*LOG, $state, "/bin/mv $merge_dir/fits_files.txt $darts_mission/$year/$month/packet_check/fits_files.$year$month$day.txt");
	&$System::perform("$Program::MV $Filesystem::MERGE_DIR/* > $fits_dump_log");
    }
    else {
	&$System::comment("Wrote $merge_dir/fits_files.txt:");
        log_msg(*LOG, $state, "Can't open $darts_mission/latest_fits_files.txt: $!");
    }
#}

    }
}

# Generate the FITS header dump
sub fits_header_dump {
    Trace::trace((caller(0))[3]);

#    my @cl = caller();                                                                                           
#    my @cl1 = caller(0);                                                                                         
#    print "CALLER : @cl\n";                                                                                      
#    print "CALLER : @cl1\n";                                                                                     

#    &$System::stage_title("Data::fits_header_dump : Generating fits header dump");                               

    my $fits_dump_log = $Filesystem::LOCAL_FITS_DUMP_LOG . $Dates::start_date_string . ".txt";
    my $fits_headers_log = $Filesystem::LOCAL_FITS_HEADERS_LOG . $Dates::start_date_string . ".txt";
    my $fits_headers_log_gzip = $fits_headers_log . ".gz";

    &$System::stage_step("Do fits dump");
    &$System::perform("$Program::FITS_STUDY_METRIC $Filesystem::TEMP_FITS_DIR/* > $fits_dump_log");

    # mcrw 20130918 - needs fixing                                                                                
    &$System::stage_step("Do fits headers dump");
    &$System::perform("$Program::FITS_HEADER_DUMP $Filesystem::TEMP_FITS_DIR/* >> $fits_headers_log");

    # Changed cp to mv                                                                                            
    &$System::stage_step("Move logs to DARTS and gzip");
    &$System::perform("/bin/mv $fits_dump_log " . $Filesystem::DARTS_FITS_DUMP_LOG . "/$Dates::year");
    &$System::perform("gzip -f $fits_headers_log");
#???    &$System::perform("/bin/mv $fits_headers_log_gzip " . $System::DARTS_STAGING_FITS_HEADERS . "/$Dates::year");
}

# Perform the data loss checks
sub blank_pixel_check {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Data::blank_pixel_check : Generating blank pixel data");                              

    my $data_loss_log = $Filesystem::DARTS_STAGING_LOGS . "/$Dates::start_date_string" . "_data_loss.txt";

    # As the IDL appends to the log file remove it before running the idl                                         
    &$System::stage_step("Remove data loss log as IDL appends to it");
    &$System::perform("if [ -e $data_loss_log ] ; then /bin/rm $data_loss_log; fi");

    &$System::comment("(IDL) data_loss, '$Filesystem::TEMP_FITS_DIR',log_file='$data_loss_log'");

    my $output = ".comp $Filesystem::LOCAL_IDL/data_loss\n";
    $output .= "data_loss,'$Filesystem::TEMP_FITS_DIR',log_file='$data_loss_log'\n";

    &$System::stage_step("Create IDL file");
    open(DL, "> $Program::DATA_LOSS");
    print DL $output;
    close DL;

    &$System::comment("IDL file:\n$output");

    &$System::stage_step("Run IDL");
    &$System::perform("$Program::SSWIDL < $Program::DATA_LOSS");

    &$System::stage_step("Copy log to DARTS");
    &$System::perform("/bin/rm $Program::DATA_LOSS");
}

# Dump the check tables to DARTS                                                                                  
sub check_table_dump {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Data::check_table_dump : Generating check table dump");                               

    my $chk_table_dump_file = $Filesystem::DARTS_STAGING_CHECK_TABLE_DUMP . $Dates::sdate . "_" . $Dates::eday . ".txt";
    my $chk_table_dump_store = $Filesystem::DARTS_STAGING_CHECK_TABLE_STORE . $Dates::sdate . "_" . $Dates::eday;

    &$System::comment("(IDL) dump_all_chk_files,log_file='$chk_table_dump_file'");

    my $output = ".comp $Filesystem::LOCAL_IDL/chk_file_dump\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/dump_all_chk_files\n";
    $output .= "dump_all_chk_files,LOG_FILE='$chk_table_dump_file'\n";

    &$System::stage_step("Write to IDL file");
    open(IDL, "> $Program::CHECK_DUMP");
    print IDL $output;
    close IDL;

    &$System::comment("IDL file:\n$output");

    &$System::stage_step("Run IDL");
    &$System::perform("$Program::SSWIDL < $Program::CHECK_DUMP");

    &$System::stage_step("Remove IDL file");
    &$System::perform("/bin/rm $Program::CHECK_DUMP");

    &$System::stage_step("Gzip table files");
    &$System::perform("gzip -f $Filesystem::CHECK_TABLE_DIR/eis_md*"); #???!!! FIXME                              

    &$System::stage_step("Move table files to DARTS");
    &$System::perform("/bin/mkdir $chk_table_dump_store");
    &$System::perform("/bin/mv $Filesystem::CHECK_TABLE_DIR/eis_md* $chk_table_dump_store");
    &$System::perform("gzip -f $chk_table_dump_store/*");
}

# Compress the FITS files                                                                                         
sub compress_fits {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Data::compress_fits : Gzip fits files");                                              

    &$System::stage_step("Gzip");
    &$System::perform("/bin/cd $Filesystem::TEMP_FITS_DIR && gzip -f *");
}

sub populate_calibration_data {
    Trace::trace((caller(0))[3]);

    ### Alternative                                                                                               
    if (%Ccsds::eng_filenames) {
        foreach my $key (sort keys %Ccsds::eng_filenames) {
            my ($path, $type) = split(/:/, $Ccsds::eng_filenames{$key});
            print "$key => $path, $type\n";
        }
    }
    else {
        print "No filenames in Ccsds::eng_filenames\n";
    }

###    &$System::stage_title("Mission::populate_calibration_data : Move engineering files to calibration area");  
    if(-e "$Filesystem::LOCAL_ENGINEERING_FILE") {
        &$System::comment("Engineering summary exists ($Filesystem::LOCAL_ENGINEERING_FILE)");
	if(open(ENG_LOG, "< $Filesystem::LOCAL_ENGINEERING_FILE")) {
            &$System::comment("Engineering summary opened OK");
            #my $line = <ENG_LOG>;                              # Read title                                      
            while(my $line = <ENG_LOG>) {                       # Read ccsds packet filename                      
                last if $line =~ /^$/;                          # Finish on a blank line                          
                next if $line =~ /^Engineering/;                # Ignore header line                              
		chomp $line;
                my ($path, $type) = split(/:/, $line);          # Get filename and type of engineering study      
		&$System::comment_msg("(path,type) = ($path, $type)");
                my @path = split(/\//, $path);                  # Split up filename path                          
                my $ccsds_file = $path[-1];                     # Get the ccsds filename                          

		my $fits_file = $Data::translate{$ccsds_file};  # Get fits filename from ccsds filename           
                #my $fits_file = $temp{$ccsds_file};            # Get fits filename from ccsds filename           
                #               $ok_fits = $etrans{$ccsds_file};        # Get fits filename from ccsds filename   
                #               $rescued_fits = $temp{$ccsds_file};     # Get fits filename from ccsds filename   

		#               $fits_file = $ok_fits if $ok_fits;                                                
                #               $fits_file = $rescued_fits if $rescued_fits;                                      

                # Must set source directory accordingly (if ok or rescued)                                        

		if($fits_file) {
                    ###$eng_dbase{$fits_file} = $type if $eng_dbase;    # Update engineering database             
                    my $destination = Rasters::eng_path($type);         # Get where to copy the fits file and copy it
		    my $source = $System::TEMP_FITS_DIR . "/" . $fits_file . ".gz";
                    if($destination ne "") {
			my $dest1 = "$Filesystem::DARTS_MISSION" . $destination;
                        my $dest2 = "$Filesystem::SODA_CAL_DIR"  . $destination;
                        &$System::comment("Moving $source to $dest1 and $dest2");
                        # mcrw 25/07/07 - Move instead of copy so engineering files don't appear in science area  
                        # mcrw 19/09/08 - Copy them now, not move                                                 
                        &$System::perform("/bin/cp $source $dest1");
			&$System::perform("/bin/cp $source $dest2");
                    }
                    else {
                        &$System::comment("No destination found for $fits_file ($type)");
                    }
                }
                else {
                    &$System::comment("No translation found for $ccsds_file");
                }
            }
            close(ENG_LOG);

        &$System::perform("/bin/mv $Filesystem::LOCAL_ENGINEERING_FILE $Filesystem::DARTS_MISSION/$Dates::year/$Dates::month/packet_check/engineering.$Dates::year$Dates::month$Dates::day.txt");
        #                                                                                                         
        # Generate cal study summary file from fits here?                                                         
        #  ./fits_cal_study.pl > ~/work/localdata/log/mission/cal_studies_list.txt                                
            #                                                                                                     
        }
    }
    else {
        &$System::comment("No engineering summary file ($Filesystem::LOCAL_ENGINEERING_FILE) : $!");
    }
    # Copy the engineering database to the staging area even if it was not updated                                
    #log_msg(*LOG, $state, "/bin/cp $pipeline_log/engineering_name_dbase $darts_staging/logs/");                  

###    &$System::perform("/bin/cp $pipeline_log/engineering_name_dbase $System::DARTS_STAGING_LOGS");             

}

sub populate_mission_data {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Mission::populate_mission_data : Moving mission data files to soda");                 

    if ($Flags::NO_SODA_FLAG or $Flags::TESTING or ($Flags::SPECIAL eq "special")) {
	&$System::comment("Not moving mission data files to /soda due to flags set");
        return;
    }

    &$System::run_stage(\&Fits::populate_calibration_data, "Fits::populate_calibration_data : Move engineering fi\
les to calibration area");
    &$System::run_stage(\&Fits::populate_soda, "Fits::populate_soda : Moving mission data files to soda");
#    populate_calibration_data();                                                                                 
#    populate_soda();                                                                                             
}

# Move this to fits?
sub populate_soda {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Mission::populate_soda : Moving mission data files to soda");                         

    #                                                                                                             
    # Filenames:                                                                                                  
    #   eis_l0_yyyymmdd_hhmmss.fits                                                                               
    #                                                                                                             

    &$System::stage_step("List the files in $Filesystem::TEMP_FITS_DIR");
###    my @files = `/bin/ls $System::TEMP_FITS_DIR`;                                                              
    my @fits_files = &$System::list($Filesystem::TEMP_FITS_DIR, "eis_l0*");
    if (@fits_files) {
	&$System::stage_step("Move files to $Filesystem::SODA_DIR");
        foreach my $file (@fits_files) {
            next if !($file =~ /l0/);
            chomp $file;
            # Match destination directory with filename                                                           
            my $year  = substr $file,  7, 4;
            my $month = substr $file, 11, 2;
            my $day   = substr $file, 13, 2;

            # DEBUG                                                                                               
            $year = 2019;
            $month = 10;
            $day = 22;

            ###    log_msg(*LOG, $state,  "/bin/cp $temp_fits/$file $darts_mission/$darts_year/$darts_month/$darts_day/");
            #    system("/bin/cp $temp_fits/$file $darts_mission/$darts_year/$darts_month/$darts_day/");          
            #    system("/bin/cp $temp_fits/$file $soda_darts_mission/$darts_year/$darts_month/$darts_day/");     

            if (! -d $Filesystem::SODA_DIR/$year) {
                &$System::perform("/bin/mkdir $Filesystem::SODA_DIR/$year");
            }
            if (! -d $Filsystem::SODA_DIR/$year/$month) {
                &$System::perform("/bin/mkdir $Filesystem::SODA_DIR/$year/$month");
            }
            if (! -d $Filsystem::SODA_DIR/$year/$month/$day) {
&$System::perform("/bin/mkdir $Filesystem::SODA_DIR/$year/$month/$day");
            }

########            &$System::perform("/bin/cp $System::TEMP_FITS_DIR/$file $System::SODA_DIR/$year/$month/$day/");
            &$System::perform("/bin/cp $file $Filesystem::SODA_DIR/$year/$month/$day/");
        }

        # ???? $file is out of scope here...                                                                      
###&$System::perform("/bin/cp $System::TEMP_FITS/$file $System::DARTS_STAGING/mission/special") if $Flags::SPECIAL eq "special";
    }
    else {
        &$System::comment("No fits files to move");
    }
}

sub remove_quicklook {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Mission::remove_quicklook : Removing quicklook mission data for $Dates::start_date_string");

    my $start_days = Dates::date_to_days("start");
    my $end_days   = Dates::date_to_days("end");
#    &$System::comment("start_days = $start_days, end_days = $end_days");                                         
#    my $start_days = Date::Calc::Date_to_Days($syear, $smonth, $sday);                                           
#    my $end_days = Date::Calc::Date_to_Days($eyear, $emonth, $eday);                                             

    &$System::stage_step("Remove quicklook data from $Dates::syear/$Dates::smonth/$Dates::sday to $Dates::eyear/$Dates::emonth/$Dates::eday");

###    foreach my $diff (-1 .. $end_days - $start_days - 1) {                                                     
    foreach my $diff (0 .. $end_days - $start_days) {
        my ($nyear, $nm, $nd) = Dates::add_days($Dates::syear,$Dates::smonth,$Dates::sday, $diff);
#       my ($nyear, $nm, $nd) = Date::Calc::Add_Delta_Days($syear,$smonth,$sday, $diff);                          
        my $nmonth = sprintf "%02u", $nm;
        my $nday = sprintf "%02u", $nd;
        print "Doing $diff -> $nyear, $nmonth, $nday\n";

        # Remove directory in DARTS if it exists                                                                  
        my $ql_dir = $Filesystem::DARTS_STAGING_MISSION_QUICKLOOK . "/$nyear/$nmonth/$nday";
        &$System::comment("Removing $ql_dir");
	if(-e "$ql_dir") {
            &$System::perform("/bin/rm -rf $ql_dir");
        }
        else {
            &$System::comment("Directory $ql_dir does not exist");
	}

        # Remove md directory in sdtp if it exists                                                                
	$ql_dir = $Filesystem::LOCAL_MISSION_QUICKLOOK . "/$nyear/$nmonth/$nday";
        &$System::comment("Removing $ql_dir");
        if(-e "$ql_dir") {
            &$System::perform("/bin/rm -rf $ql_dir");
        }
        else {
            &$System::comment("Directory $ql_dir does not exist");
        }

        # Remove md fits directory in sdtp if it exists                                                           
        $ql_dir = $Filesystem::LOCAL_MISSION_QUICKLOOK_FITS . "/$nyear/$nmonth/$nday";
        &$System::comment("Removing $ql_dir");
	if(-e "$ql_dir") {
            &$System::perform("/bin/rm -rf $ql_dir");
        }
        else {
            &$System::comment("Directory $ql_dir does not exist");
	}
    }
}

1;

__END__
