package Hk;

#print "HINODE/EIS/EISPIPELINE/EISMISSION/HK.PM\n";

use strict;
use warnings;

use Trace::Trace;

use Hinode::EIS::EisPipeline::System;
use Hinode::EIS::EisPipeline::Pipeline;
use Hinode::EIS::EisPipeline::Dates;
use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::Common;
use Hinode::EIS::EisPipeline::EisMission::Mission;
use Hinode::EIS::EisPipeline::EisMission::Filesystem;
use Hinode::EIS::EisPipeline::Errors;
use Hinode::EIS::EisPipeline::Program;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisMission/Hk\n";
}

#sub check_availability {
#    my $status_outstanding = 0;
#    if ($status_outstanding) {
#	Pipeline::pipeline_die(30, "Reformat period not completely covered by HK");
#    }
#    else {
#	print "Status ok\n";
#    }
#}

# Check that the hk for the plan time period has been reformatted already.
my $status_outstanding = 0;
my %status;

=pod
    my $step1 = sub {
    &$System::stage_step("Read status pending file ($Common::STATUS_PENDING_FILE)");
    if (open(FH, "< $Common::STATUS_PENDING_FILE")) {
        while(<FH>) {
            chomp;
            my ($status_start, $status_end) = split;
            $status{$status_start} = $status_end;
        }
        close FH;
        $status_outstanding = (defined($status{$Dates::sdate})) || (defined($status{$Dates::edate}));
        &$System::comment("Status outstanding after reading pending file is $status_outstanding");
    }
    else {
        &$System::comment("Failed to open $Common::STATUS_PENDING_FILE : $!");
    }
};

my $step2 = sub {
    &$System::stage_step("Read status reformat log file ($Common::STATUS_REFORMAT_FILE)");
    if (open(FH, "< $Common::STATUS_REFORMAT_FILE")) {
        my $latest_status_reformat = <FH>;
        chomp $latest_status_reformat;
        close FH;
        $status_outstanding ||= ($Dates::edate gt $latest_status_reformat);
        &$System::comment("Status outstanding after reading reformat file is $status_outstanding");
    }
    else {
        &$System::comment("Failed to open $Common::STATUS_REFORMAT_FILE : $!");
    }
};

my $step3 = sub {
    &$System::stage_step("Check if status data is available for reformat period");
    if ($status_outstanding) {
        &$System::comment("Reformat period not completely covered by HK ($Dates::sdate, $Dates::edate)");
        Pipeline::main_log_message("Status data not complete for reformat period - quitting.\n");

        # Does the current date already exist in the controller file?                                                             
        # Not really necessary as the kick program uses a hash...
        &$System::stage_step("Check whether reformat dates are already in mission pending file");
        my $exists = `/bin/grep '$Dates::sdate $Dates::edate' $Filesystem::MISSION_PENDING_FILE`;

        &$System::stage_step("Update mission pending log if not");
        `/bin/echo -p $Dates::sdate $Dates::edate $Dates::stime $Dates::etime >> $Filesystem::MISSION_PENDING_FILE` if $exists eq "";

        &$System::stage_step("Copy mission pending log to staging");
        &$System::perform("/bin/cp $Filesystem::MISSION_PENDING_FILE $Filesystem::DATA_STAGING_LOGS_DIR");

        ###Pipeline::pipeline_die(100, "Status data not available for reformat period.");
        Pipeline::pipeline_warn($Errors::STATUS_OUTSTANDING_CODE, $Errors::STATUS_OUTSTANDING_MSG);
        #Pipeline::pipeline_warn($Errors::STATUS_OUTSTANDING_ERROR);
    }
    else {
        &$System::comment("Status coverage OK");
    }
};
=cut

sub check_availability {
    Trace::trace((caller(0))[3]);
#    &$System::stage_title("Hk::check_availability : Status coverage check");

#    my $foobar = system("/bin/grep foofoo  $Filesystem::MISSION_PENDING_FILE");                                        
#    print "FOOBAR = $foobar\n";                                                                                        
#    # 256 if no match, 0 if match                                                                                      

    if ($Flags::TESTING || $Flags::FORCE_REFORMAT || ($Flags::SPECIAL eq "special") || $Flags::SKIP_HK) {
	&$System::comment("Skipping hk check due to flag(s) set (TESTING ($Flags::TESTING), FORCE_REFORMAT ($Flags::FORCE_REFORMAT), SPECIAL ($Flags::SPECIAL), SKIP_HK ($Flags::SKIP_HK))");
	return;
    }

#    &$step1();

    &$System::stage_step("Read status pending file ($Common::STATUS_PENDING_FILE)");
    # What happens if this file is empty? %status is empty...
    if (open(FH, "< $Common::STATUS_PENDING_FILE")) {
	while(<FH>) {
	    chomp;
	    my ($status_start, $status_end) = split;
	    $status{$status_start} = $status_end;
	}
	close FH;
	$status_outstanding = (defined($status{$Dates::sdate})) || (defined($status{$Dates::edate}));
	&$System::comment("Status outstanding after reading pending file is $status_outstanding");
    }
    else {
	&$System::comment("Failed to open $Common::STATUS_PENDING_FILE : $!");
    }

#    &$step2();

    &$System::stage_step("Read status reformat log file ($Common::STATUS_REFORMAT_FILE)");
    if (open(FH, "< $Common::STATUS_REFORMAT_FILE")) {
	my $latest_status_reformat = <FH>;
	chomp $latest_status_reformat;
	close FH;
	$status_outstanding ||= ($Dates::edate gt $latest_status_reformat);
	&$System::comment("Status outstanding after reading reformat file is $status_outstanding");
    }
    else {
	&$System::comment("Failed to open $Common::STATUS_REFORMAT_FILE : $!");
    }	

#    &$step3();

    &$System::stage_step("Check if status data is available for reformat period");
    if ($status_outstanding) {
	&$System::comment("Reformat period not completely covered by HK ($Dates::sdate, $Dates::edate)");
	Pipeline::main_log_message("Status data not complete for reformat period - quitting.\n");

	# Does the current date already exist in the controller file?
	# Not really necessary as the kick program uses a hash...
	&$System::stage_step("Check whether reformat dates are already in mission pending file");
	my $exists = `/bin/grep '$Dates::sdate $Dates::edate' $Filesystem::MISSION_PENDING_FILE`;

	&$System::stage_step("Update mission pending log if not");
	`/bin/echo -p $Dates::sdate $Dates::edate $Dates::stime $Dates::etime >> $Filesystem::MISSION_PENDING_FILE` if $exists eq "";

	&$System::stage_step("Copy mission pending log to staging");
	&$System::perform("/bin/cp $Filesystem::MISSION_PENDING_FILE $Filesystem::DATA_STAGING_LOGS_DIR");

	###Pipeline::pipeline_die(100, "Status data not available for reformat period.");
	Pipeline::pipeline_warn($Errors::STATUS_OUTSTANDING_CODE, $Errors::STATUS_OUTSTANDING_MSG);
	#Pipeline::pipeline_warn($Errors::STATUS_OUTSTANDING_ERROR);
    }
    else {
	&$System::comment("Status coverage OK");
    }
}

sub check_sat_rot {
    Trace::trace((caller(0))[3]);

    if ($Flags::IGNORE_SATROT) {
        &$System::comment("Ignore sat rot flag set, not checking for full sat rot coverage");
        return;
    }

=pod
    my $start_days = Date::Calc::Date_to_Days($Dates::syear, $Dates::smonth, $Dates::sday);
    my $end_days = Date::Calc::Date_to_Days($eyear, $emonth, $eday);
    &$System::comment("Satrot: end_days = $end_days, start_days = $start_days, (0 .. " . ($end_days - $start_days) . ")");
    my $ok = 1;
    foreach $diff (0 .. ($end_days - $start_days)) {
        my ($nyear, $nm, $nd) = Date::Calc::Add_Delta_Days($Dates::syear,$Dates::smonth,$Dates::sday, $diff);
        my $nmonth = sprintf "%02u", $nm;
        my $nday = sprintf "%02u", $nd;
        &$System::comment("Checking diff ($diff) : $nyear, $nmonth, $nday ($sat_rot_csv_dir/$nyear$nmonth$nday.csv)");
        next if -e "$sat_rot_csv_dir/$nyear$nmonth$nday.csv";

        &$System::comment("$sat_rot_csv_dir/$nyear$nmonth$nday.csv missing");
        $ok = 0;
    }
    if ($ok == 0) {
        &$System::comment("Sat rot file(s) missing between $sdate, $edate. Rescheduling");
        #####   $exists = `grep '$sdate $edate' ~/track/mission_pending.txt`;
        open(FH, ">>$HOME/track/mission_pending.txt") || pipeline_exit("mission", 300);
        if(Delta_Days($syear1, $smonth1, $sday1, $today[5], $today[4], $today[3] ) < 3) {
            # Write out start/end date to controlling file if not
            #perform(*LOG, $state, "echo -p $sdate $edate $stime $etime >> ~/track/mission_pending.txt") if $exists eq "";
            ###         `echo -p $sdate $edate $stime $etime >> $HOME/track/mission_pending.txt` if ($exists eq "");
            print FH "-p $sdate $edate $stime $etime\n";
            Pipeline::main_log_message("\tScheduling reformat of plan for $sdate $edate $stime $etime");
        }
        else {
            #perform(*LOG, $state, "echo -p ignore_satrot $sdate $edate $stime $etime >> ~/track/mission_pending.txt") if $exists eq "";
            ###         `echo -p ignore_satrot $sdate $edate $stime $etime >> $HOME/track/mission_pending.txt` if ($exists eq "");
            ###         my $junk = `echo -p ignore_satrot $sdate $edate $stime $etime >> ~/track/mission_pending.txt`;
            print FH "-p ignore_satrot $sdate $edate $stime $etime\n";
            Pipeline::main_log_message("\t*** Scheduling reformat of plan for $sdate $edate $stime $etime to ignore sat_rot check ***");
        }
        close FH;
        &$System::log("/bin/cp $HOME/track/mission_pending.txt $HOME/data/staging/logs/");
        &$System::log("Sat rot data not complete for reformat period - quitting.\n");
        Pipeline::main_log_message("\tSat rot data not complete for reformat period - quitting.");
        Pipeline::pipeline_exit("mission", 200);
    }
=cut
    Pipeline::main_log_message("Sat rot coverage good");
}

1;
