package Html;

#print "HINODE/EIS/EISPIPELINE/EISMISSION/HTML.PM\n";

use strict;
use warnings;

use Trace::Trace;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisMission/Html\n";
}

sub html_header {
    my $title = shift;

    Trace::trace((caller(0))[3]);
    my $hdr;

    $hdr = <<HERE;
    <!--
    <?xml version="1.0" encoding="ISO-8859-1" ?>
    -->
      
    <!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
      
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
      
    <head>
    <meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
    <!--
    <script type="text/javascript" src="stripe.js"></script>
    -->
    <title>
    $title
    </title>

    </head>
HERE
    return $hdr;
}

sub html_end {
    Trace::trace((caller(0))[3]);
    #print "</body>\n</html>\n";
    return "</body>\n</html>\n";
}

our %packets_per_exposure = (
    );

our %exposure_count = ();

my %ra_db;

sub exposure_count {
    my $html_file = shift;
    my $FH = shift;

    Trace::trace((caller(0))[3]);

    return 0 unless open(FD, '<', $html_file);

    print "# Filename                  Ppe  Num exps  Tl_id Reps_req Reps_done   Rid   Mid full_x full_y   ExpPerPos  Data_vol   Raster acronym\n";

    my $old_fh = select $FH if $FH;
    #my $old_fh = STDOUT;                                                                                         
#    print "OLD CHANNEL: $old_channel\n";                                                                         
    $~ = 'STD_OUT';
    $^ = 'STD_OUT_HDR';

#    if(open RD, "< $HOME/data/staging/dump/raster_db_dump.txt") {                                                
    if(open RD, "< $Pipeline::RASTER_DB_DUMP_FILE") {
        while(<RD>) {
            next if /Id/;
            chomp;
            my ($id, $acr, $type, $nexps) = split;
            my $rid = sprintf "%u", $id;
            $ra_db{$rid} = [$acr, $type, $nexps];
        }
        close RD;
    }

    if(open RD, "< $Pipeline::ENG_RASTER_DB_DUMP_FILE") {
        while(<RD>) {
            next if /Id/;
            chomp;
            my ($id, $acr, $type, $nexps, $pe) = split;
            my $rid = sprintf "%u", $id;
            $ra_db{$rid} = [$acr, $type, $nexps, $pe];
        }
        close RD;
    }


#    my $packets_per_exposure;
    my $fname;
    my $done = 0;

    while(<FD>) {
	last if /^\<pre\>/;
    }
    
    while(<FD>) {
	while(<FD>) {
	    #next if /^$/;
	    if (/^$/) {
		$done = 0;
		next;
	    }
	    last if /eis_md/;
	}
	
	chomp;
	$fname = $_;
	$fname = substr $fname, -26, 26;
	
	while(<FD>) {
	    next if /^Type/;
	    next if /^Pixel data/;
	    last if /^Read/;
	    last if /headers/;
	    last if /ccsds/;
	    next if $done;
	    if ($done == 0) {
		my @data = split;
		my $packets_per_exposure = sprintf "%u", $data[6];
		my $number_of_exposures  = sprintf "%u", hex($data[32]);
                my $timeline_id          = sprintf "%u", hex($data[24]);

                #                                                                                                 
                # Before final reformat change this so it copes with the early data.                              
                # This is for the timeline id wrap around which occurred on 20190108...                           
		#                                                                                                 
                if ($timeline_id < 65000) {
                    $timeline_id += 65536;
		}

                my $raster_reps_req      = sprintf "%u", hex($data[34]);
                my $raster_reps_done     = sprintf "%u", hex($data[35]);
                my $rid                  = sprintf "%u", hex($data[25]);
                my $ra_acronym           = ra_acr($rid);
                my $mid                  = sprintf "%u", hex($data[3]);
                my $full_x               = sprintf "%u", hex($data[11]);
                my $full_y               = sprintf "%u", hex($data[12]);
		my $exp_per_pos          = sprintf "%u", $data[55];
                my $data_volume = $full_x * $full_y;
                $done = 1;

                write if ($fname ne "");

                if($fname ne "") {
                    $packets_per_exposure{$fname} = $packets_per_exposure * $exp_per_pos;
                    $exposure_count{$fname} = [$packets_per_exposure, $number_of_exposures, $timeline_id, $raster_reps_req, $raster_reps_done, $rid, $mid, $full_x, $full_y, $exp_per_pos, $data_volume, $ra_acronym];
                }

		format STD_OUT_HDR =
 Filename                  Ppe  Num exps  Tl_id Reps_req Reps_done   Rid   Mid full_x full_y   ExpPerPos  Data_vol  Raster acronym
.

                format STD_OUT =
@<<<<<<<<<<<<<<<<<<<<<<<<< @### @########  @####    @####     @#### @>>>> @>>>>  @####  @####          @# @######## @>>>>>>>>>>>>>>>>>>>>>>>>>
$fname, $packets_per_exposure, $number_of_exposures, $timeline_id, $raster_reps_req, $raster_reps_done, $rid, $mid, $full_x, $full_y, $exp_per_pos, $data_volume, $ra_acronym
.

	    }
	    last if /^<\/pre>/;
	}
	close FD;
    }
    select $old_fh if $FH;
}

sub ra_acr {
    my $key = shift;
#    print "Looking for [$key]\n";
#    print "FOO = ", $ra_db{100}, "\n";
#    foreach $k (sort keys %ra_db) {
#       my @l = @{$ra_db{$key}};
#       print "[$key] = ", $l[0], "\n";
#    }
#    exit;
###    if(defined($ra_db{$rid})) {
    if(defined($ra_db{$key})) {
        my @list = @{$ra_db{$key}};
#    print "list = ", @list, "\n";
        return $list[0];
    }
    return "Unknown";
}

sub total_exposures_expected {
    my $total = 0;
    foreach my $file (sort keys %packets_per_exposure) {
        $total += $packets_per_exposure{$file};
    }
    return $total;
}

1;
