package Logger;

print "HINODE/EIS/EISPIPELINE/EISMISSION/LOGGER.PM\n";

use strict;
use warnings;

use Hinode::EIS::Pipeline::Mission::System;
use Hinode::EIS::Pipeline::Mission::Pipeline;

my $MAIN_LOG;
my $LOCAL_LOG;

#sub open_mission_log {
#
#    $mission_log .= $Globals::sdate . '_' . $Globals::edate;
##    pipeline_die("mission", 20, "Can't open $mission_log for writing: $!");
#}

#sub pipeline_die {
#    my $pipeline = shift;
#    my $code = shift;
#    my $message = shift;
#
#    print "DIE: $pipeline $code ($message)\n";
#    die;
#}

sub open_pipeline_log {

}

sub open_local_log {

}

# Generate filehandle closure
sub gen_fh {
    my $fh = shift;
    return sub { $fh; };
}

# Logger closure
sub logger {
    my $stdout = shift;
    my $fh = shift;
    if($stdout == 1) {
	return sub {
	    my $msg = shift;
	    if ($local_log_open) {
		print STDOUT "$msg\n";
		print $fh "$msg\n";
	    }
	};
    }
    return sub {
	my $msg = shift;
	print $fh "$msg\n" if $local_log_open;
    };
}

# Stage closure
sub start_stage {
    my $stage = 0;
    return sub { $stage++ };
}

# Stage steps closures
my $step = 0;
sub next_step {
    return sub { $step++ };
}
sub reset_step {
    return sub { $step = 0; };
}

# Return the (log, perform, title) closures for interactive or cron modes
sub init_logger {
    my $filehandle = shift;
    my $state      = shift;
    my $fh         = gen_fh($filehandle);
    my $out_fh     = ($state eq "interactive") ? 1 : 0;
    my $log_it     = logger($out_fh, $filehandle);
    my $next_stage = start_stage();
    my $step       = next_step();
    my $step_reset = reset_step();
    $local_log_open = 1;
    return (

	# log
	sub {
	    my $msg = shift;
#	    &$log_it("\t" . $msg);
	    &$log_it($msg);
	},
	
	# comment
	sub {
	    my $msg = shift;
	    &$log_it("\t# " . $msg);
	},
	
	# code log
	sub {
	    my $msg = shift;
	    &$log_it("\t" . $msg);
	},
	
	# perform
	sub {
	    my $cmd = shift;
	    &$log_it("\t" . $cmd);
###	    system($cmd);
	},

	# Perform with title message
	#	     sub {
	#	         my $title = shift;
	#		 my $cmd = shift;
	#		 &$log_it("\t# " . $title);
	#		 &$log_it("\t" . $cmd);
	#		 system($cmd);
	#	     },
	
	# Step
	sub {
	    my $msg = shift;
	    &$log_it("\t# Step " . $step->() . " - $msg")
	},

	# reset
	sub {
	    $step_reset->();
	},

	# stage_title
	sub {
	    my $title = shift;
	    my $ct  = scalar(localtime);
	    my $cts = "$ct (JST) - ";
	    my $ntitle = "$cts Stage " . $next_stage->() . " : $title";
	    &$log_it("\n--------------------------------\n");
	    &$log_it($ntitle);
	    &$step_reset();
	}

    );
}

sub init_logger1 {
    return (
	sub {
	    my $function = shift;
	    my $message = shift;
	    print "RUN_STAGE: $message\n";
	    &$System::stage_title($message);
	    &$function();
	});
}

sub init_debug {
    return (
	sub {
	    my $message = shift;
	    print "<<< $message >>>\n";
	});
}

sub init {
    my $filehandle = shift;
    my $state      = shift;

    print "Logger::init\n";
    our ($log, $comment, $code_log, $perform, $stage_step, $zero_steps, $stage_title) = init_logger($filehandle, $state);
    our $run_stage = init_logger1();
    our $debug = init_debug();
}
    
1;
