package Mission;

#print "HINODE/EIS/EISPIPELINE/MISSION.PM\n";

use strict;
use warnings;
#use Time::Local;
#use Date::Calc qw(Add_Delta_Days);

use Getopt::Long qw(GetOptionsFromArray);

use Trace::Trace;

use Hinode::EIS::EisPipeline::Dates;
use Hinode::EIS::EisPipeline::EisMission::Constants;
use Hinode::EIS::EisPipeline::EisMission::Dates;
use Hinode::EIS::EisPipeline::EisMission::Filesystem;
use Hinode::EIS::EisPipeline::EisMission::Html;
#use Hinode::EIS::EisPipeline::EisMission::Plan;
use Hinode::EIS::EisPipeline::EisMission::Program;
use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::Flags;
use Hinode::EIS::EisPipeline::Program;
use Hinode::EIS::EisPipeline::Pipeline;
use Hinode::EIS::EisPipeline::System;
use Hinode::EIS::EisPlan::Plan;
use Hinode::EIS::EisRasters::Rasters;

sub BEGIN {
    print "BEGIN Hinode/EIS/EisPipeline/EisMission/Mission\n";
}

my $eis_plan_found = 0;
my $plan_file      = "";

our $start_orl_file = "";
our $end_orl_file = "";

my $mission_log;
my $mission_log_open = 0;


# Parse mission data pipeline specific command line arguments.
sub arg_check {
    my @ARGV = @_;

    Trace::trace((caller(0))[3]);

    my $package = shift @ARGV;
    print "Mission::arg_check : ARGV = @ARGV\n";

    my $ret = GetOptionsFromArray(\@ARGV,
                                  'no_soda'       => \$Flags::NO_SODA_FLAG,
                                  'recover_test'  => \$Flags::RECOVER_TEST_FLAG,
                                  'no_rescue'     => \$Flags::NO_RESCUE_FLAG,
                                  'old_plan'      => \$Flags::OLD_SEQ_FLAG,
                                  'skip_hk'       => \$Flags::SKIP_HK,
                                  'ignore_satrot' => \$Flags::IGNORE_SATROT,
                                  'stime=s'       => \$Dates::stime,
				  'etime=s'       => \$Dates::etime,
                                  'louisa'        => sub {$Flags::IGNORE_SATROT = 1; },
				  '<>'            => \&Args::catchall);

    print "no_soda = $Flags::NO_SODA_FLAG, stime = $Dates::stime\n";
    
=pod    
    my $n_args = @ARGV;
##    print "Number of args = $#ARGV\n";
#    print "4 Number of args = $n_args\n";
#    $n_args = $#ARGV;   # This contains the real number of arguments
#    print "5 Number of args = $n_args\n";
#    print "6 Args : @ARGV ($ARGV[0])\n";
#    shift @ARGV;
#    $n_args = @ARGV;
#    print "7 Number of args = $#ARGV\n";
#    print "8 Number of args = $n_args\n";
#    $n_args = $#ARGV;   # This contains the real number of arguments
#    print "9 Number of args = $n_args\n";
#    print "10 Args : @ARGV ($ARGV[0])\n";

    my $args = join ' ', @ARGV;

    while (@ARGV) {
	my $flag = shift @ARGV;	# = [-c|fetch|fits_only|...]
	print "flag = $flag\n";
	System::dprint("flag = $flag");
	$Flags::RECOVER_TEST_FLAG = 1 if $flag eq "recover_test";
	$Flags::NO_RESCUE_FLAG    = 1 if $flag eq "no_rescue";
	$Flags::NO_SODA_FLAG      = 1 if $flag eq "no_soda";
	$Flags::OLD_SEQ_FLAG      = 1 if $flag eq "old_plan";
	$Flags::SKIP_HK           = 1 if $flag eq "skip_hk";
	if ($flag =~ /(\d)(\d)(\d)(\d)/) {
	    unshift @ARGV, $flag;
	    last;
	}
    }
    
    if ( ($Flags::cron) || ($Flags::cron_pending) || ($args eq "") ) {
        print "CRON - $args\n";
        cron_check(@ARGV);
    }
    else {
        interactive_check(@ARGV);
    }
=cut

    if (($Flags::cron) || ($Flags::cron_pending)) {
        print "CRON\n";
        cron_check(@ARGV);
    }
    else {
        interactive_check(@ARGV);
    }

    Dates::init_mission();
    Pipeline::check_pipeline();

}

sub interactive_check {
    my @ARGV = @_;

    Trace::trace((caller(0))[3]);

    my @command_line = @ARGV;    

    print "MISSION interactive_check: @ARGV\n";
    
    ($Pipeline::kick_string, $Pipeline::state) = ($Flags::cron) ? ("by cron from tracking file", "cron") : ("manually", "interactive");
    Pipeline::announce();
    Pipeline::main_log_message($Args::command_line);
    
    Pipeline::pipeline_die(10, "No start date") unless Dates::check_date($Dates::sdate);
    Pipeline::pipeline_die(11, "No end date")   unless Dates::check_date($Dates::edate);
    Pipeline::pipeline_die(12, "No start time") unless Dates::check_time($Dates::stime);
    Pipeline::pipeline_die(13, "No end time")   unless Dates::check_time($Dates::etime);

#    Dates::set_start_end_dates($sdate, $edate);
#    Dates::set_start_end_times($stime, $etime);

###    $Dates::etime = $stime if ! Dates::check_time($etime);
    
    Pipeline::open_local_log();
    Pipeline::main_log_message("Logging to $mission_log");
    Pipeline::local_announce();	
}
=pod
else {
    $Pipeline::kick_string = ($Flags::cron) ? "by cron from tracking file" : "manually";
    $Pipeline::state = ($Flags::cron) ? "cron" : "interactive";
    Pipeline::announce();
    Pipeline::main_log_message("$0 @command_line");
    Pipeline::pipeline_die(-10, "Not enough arguments");
}
}
=cut

sub cron_check {
    my @ARGV = @_;

    Trace::trace((caller(0))[3]);

    my @command_line = @ARGV;
    my $ok_to_run = 0;

    print "MISSION cron_check: @ARGV\n";
    
    if ($Flags::cron_pending) {
        print "PENDING\n";
	
        $Pipeline::kick_string = ($Flags::cron) ? "by cron from tracking file" : "manually";
        $Pipeline::state = ($Flags::cron) ? "cron" : "interactive";
        Pipeline::announce();

	Pipeline::pipeline_die(10, "No start date") unless Dates::check_date($Dates::sdate);
	Pipeline::pipeline_die(11, "No end date")   unless Dates::check_date($Dates::edate);
	Pipeline::pipeline_die(12, "No start time") unless Dates::check_time($Dates::stime);
	Pipeline::pipeline_die(13, "No end time")   unless Dates::check_time($Dates::etime);

    }
    else {
	$Pipeline::kick_string = "by cron";
	$Pipeline::state = "cron";    
	Pipeline::announce();

	my ($prev_start_date, $prev_end_date, $prev_start_time, $prev_end_time);

#	if ($Flags::REFORMAT_VERSION eq "v1") {
#	    read_orl_file();
#	}
#	else {
#	    read_schedule_file();
#	}

#       print "schedule_reader...\n";                                                                             
        $ok_to_run = &{$Program::schedule_reader{$Flags::REFORMAT_VERSION}};
	
        ### DEBUG!!!                                                                                                    
#        $ok_to_run = 1;
#	$Dates::sdate = '20210101';
#	$Dates::edate = '20210103';
#	$Dates::stime = '0912';
#	$Dates::etime = '1034';
    }

    Pipeline::main_log_message($Args::command_line);
    if ($ok_to_run) {
	Pipeline::open_local_log();
	Pipeline::main_log_message("Logging to $mission_log");
	my $str = "Using plan $plan_file: $Dates::sdate $Dates::edate $Dates::stime $Dates::etime";
	Pipeline::local_announce();
    }
    else {
	Pipeline::pipeline_die(2000, "No plan file found");
        die;
    }

#    &$System::log("\tORL start file : $start_orl_file");
#    &$System::log("\tORL end   file : $end_orl_file");

}

=pod

    ###!!!!!!!!!!
    # Form start date string
    #
    $Dates::sdate = "$syear$smonth$sday";
    $Dates::edate = "$eyear$emonth$eday";
    
    $stime_str = "1000";
    $etime_str = "1000";

    &$System::log("Started " . scalar(localtime) . " (JST)");
    &$System::log("Start time $stime_str on $Dates::sdate");
    &$System::log("End   time $etime_str on $Dates::edate");
    
    #
    # Addition when using parse_orl
    #
    $Dates::stime = $stime_str;
    $Dates::etime = $etime_str;

    #
    # Update master log and off we go
    #
    #    print MLOG "\tdaily_merge_mission1 $sdate $edate $stime $etime\n";
    #    print MLOG "\tLogging to $pipeline_mission_log\n";
    Pipeline::main_log_message("daily_merge_mission1 $Dates::sdate $Dates::edate $Dates::stime $Dates::etime");
    Pipeline::main_log_message("Logging to $Pipeline::mission_log");
    
    #####!!!!!!!

=cut

### Mission Pipeline ###

# Remove any junk left over from previous pipeline execution
sub clean {
    Trace::trace((caller(0))[3]);

    return if $Flags::RECOVER_TEST_FLAG;

    # This is done by System::run_stage if called that way
#    &$System::stage_title("Data::clean : Removing all old data from previous runs");

    # Remove old ccsds compressed files
    &$System::stage_step("Remove old joined ccsds files");
    &$System::perform("/bin/cd $Filesystem::JOIN_DIR && /bin/rm -f eis_md*");
    
    # Remove old decompressed ccsds packets
    &$System::stage_step("Remove old decompressed ccsds files");
    &$System::perform("/bin/cd $Filesystem::DECOMPRESSED_DIR && /bin/rm -f eis_md*");

    # Remove any old temporary program files
    &$System::stage_step("Remove old temporary program files");
    &$System::perform("/bin/rm -f $Program::MD_DECOMP");
    &$System::perform("/bin/rm -f $Program::MD_REFORMAT");
    &$System::perform("/bin/rm -f $Program::DATA_LOSS");
    &$System::perform("/bin/rm -f $Program::CHECK_DUMP");

    # Move any files in the rescue directory out of the way
    &$System::stage_step("Move old rescue files from $Filesystem::NURSERY_DIR to $Filesystem::ORPHANS_DIR");
    my @rfiles = &$System::list($Filesystem::NURSERY_DIR, "eis_md*");
    foreach my $file (@rfiles) {
	&$System::perform("/bin/mv $file $Filesystem::ORPHANS_DIR");
    }
    my $nfiles = @rfiles;
    my $files_str = ($nfiles == 1) ? "file" : "files";
    &$System::comment("$nfiles $files_str moved");

    print "Done EisMission clean\n";
}

sub clean_up {
    Trace::trace((caller(0))[3]);

    &$System::stage_title("Mission::clean_up : Cleaning up");
#    Pipeline::clean_up();
}

# Replaced by find_eis_plan
=pod
sub get_eis_plan {
    Trace::trace((caller(0))[3]);

    my $plan_file = "$Filesystem::DARTS_STAGING_DIR/eis_plan/eis_plan_$Dates::start_date_string.txt";
    my $eis_plan_found_msg = "EIS plan found";

    my $eis_plan_found = stat $plan_file;
    $eis_plan_found_msg = "No " . $eis_plan_found_msg unless $eis_plan_found;
    &$System::comment($eis_plan_found_msg);
    return ($eis_plan_found, $plan_file);
}
=cut

my $HOME = "";

sub init {
    print "Mission init\n";
    Filesystem::mission_path_dump();
    print "\n";
    print "Mission init\n";
    Filesystem::mission_file_dump();
    $HOME = Filesystem::home();
    print "Mission HOME = $HOME\n";
}

sub get_expected_number_of_rasters {
    my $plan_found = shift;
    my $plan_file = shift;

    Trace::trace((caller(0))[3]);

###    my $plan_file = "$Filesystem::DARTS_STAGING_DIR/eis_plan/eis_plan_$Dates::start_date_string.txt";
    my $expected_number_of_rasters = 0;

    if($plan_found) {
        $expected_number_of_rasters = Plan::estimate_rasters($plan_file);
	&$System::perform("$Program::ESTIMATE_RASTERS $plan_file > ~/tmp/rasters_for_plan.txt");        # ???
    }

    return $expected_number_of_rasters;
}

=pod
sub populate_calibration_data {
    Trace::trace((caller(0))[3]);

    &$System::stage_title("Mission::populate_calibration_data : Move engineering files to calibration area");

    if(open(ENG_LOG, "< $Filesystem::MERGE_DIR/engineering.txt")) {
	my $line = <ENG_LOG>;				# Read title
	while($line = <ENG_LOG>) {			# Read ccsds packet filename
	    last if $line =~ /^$/;			# Finish on a blank line
	    chop $line;				# Remove \n
	    my ($path, $type) = split(/:/, $line);	# Get filename and type of engineering study
	    &$System::comment_msg("(path,type) = ($path, $type)");
	    my @path = split(/\//, $path);		# Split up filename path
	    my $ccsds_file = $path[-1];		# Get the ccsds filename
	    
	    my $fits_file = $Data::translate{$ccsds_file};	# Get fits filename from ccsds filename
	    #my $fits_file = $temp{$ccsds_file};	# Get fits filename from ccsds filename
	    #		$ok_fits = $etrans{$ccsds_file};	# Get fits filename from ccsds filename
	    #		$rescued_fits = $temp{$ccsds_file};	# Get fits filename from ccsds filename
	    
	    #		$fits_file = $ok_fits if $ok_fits;
	    #		$fits_file = $rescued_fits if $rescued_fits;
	    
	    # Must set source directory accordingly (if ok or rescued)
	    
	    if($fits_file) {
		###$eng_dbase{$fits_file} = $type if $eng_dbase;	# Update engineering database
		my $destination = Rasters::eng_path($type);		# Get where to copy the fits file and copy it
		my $source = $System::TEMP_FITS_DIR . "/"  . $fits_file . ".gz";
		if($destination ne "") {
		    my $dest1 = "$Filesystem::DARTS_MISSION" . $destination;
		    my $dest2 = "$Filesystem::SODA_CAL_DIR"  . $destination;
		    &$System::comment("Moving $source to $dest1 and $dest2");
		    # mcrw 25/07/07 - Move instead of copy so engineering files don't appear in science area
		    # mcrw 19/09/08 - Copy them now, not move
		    &$System::perform("/bin/cp $source $dest1");
		    &$System::perform("/bin/cp $source $dest2");
		}
		else {
		    &$System::comment("No destination found for $fits_file ($type)");
		}
	    }
	    else {
		&$System::comment("No translation found for $ccsds_file");
	    }
	}
	close(ENG_LOG);

	&$System::perform("/bin/mv $Filesystem::MERGE_DIR/engineering.txt $Filesystem::DARTS_MISSION/$Dates::year/$Dates::month/packet_check/engineering.$Dates::year$Dates::month$Dates::day.txt");
	#
	# Generate cal study summary file from fits here?
	#  ./fits_cal_study.pl > ~/work/localdata/log/mission/cal_studies_list.txt
	#
    }
    else {
	&$System::comment("No engineering summary file");
    }
    # Copy the engineering database to the staging area even if it was not updated
    #log_msg(*LOG, $state, "/bin/cp $pipeline_log/engineering_name_dbase $darts_staging/logs/");

###    &$System::perform("/bin/cp $pipeline_log/engineering_name_dbase $System::DARTS_STAGING_LOGS");
    
}

sub populate_mission_data {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Mission::populate_mission_data : Moving mission data files to soda");

    if ($Flags::NO_SODA_FLAG or $Flags::TESTING or ($Flags::SPECIAL eq "special")) {
	&$System::comment("Not moving mission data files to soda due to flags set");
	return;
    }
    
    &$System::run_stage(\&Mission::populate_calibration_data, "Mission::populate_calibration_data : Move engineering files to calibration area");
    &$System::run_stage(\&Mission::populate_soda, "Mission::populate_soda : Moving mission data files to soda");
#    populate_calibration_data();
#    populate_soda();
}

sub populate_soda {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Mission::populate_soda : Moving mission data files to soda");

    #
    # Filenames:
    #	eis_l0_yyyymmdd_hhmmss.fits
    #

    &$System::stage_step("List the files in $Filesystem::TEMP_FITS_DIR");
###    my @files = `/bin/ls $System::TEMP_FITS_DIR`;
    my @files = &$System::list($Filesystem::TEMP_FITS_DIR, "eis_l0*");
    if (@files) {
	&$System::stage_step("Move files to $Filesystem::SODA_DIR");
	foreach my $file (@files) {
	    next if !($file =~ /l0/);
	    chomp $file;
	    # Match destination directory with filename
	    my $year  = substr $file,  7, 4;
	    my $month = substr $file, 11, 2;
	    my $day   = substr $file, 13, 2;
	    
	    # DEBUG
	    $year = 2019;
	    $month = 10;
	    $day = 22;

	    ###    log_msg(*LOG, $state,  "/bin/cp $temp_fits/$file $darts_mission/$darts_year/$darts_month/$darts_day/");
	    
	    #    system("/bin/cp $temp_fits/$file $darts_mission/$darts_year/$darts_month/$darts_day/");
	    #    system("/bin/cp $temp_fits/$file $soda_darts_mission/$darts_year/$darts_month/$darts_day/");

	    if (! -d $Filesystem::SODA_DIR/$year) {
		&$System::perform("/bin/mkdir $Filesystem::SODA_DIR/$year");
	    }
	    if (! -d $Filsystem::SODA_DIR/$year/$month) {
		&$System::perform("/bin/mkdir $Filesystem::SODA_DIR/$year/$month");
	    }
	    if (! -d $Filsystem::SODA_DIR/$year/$month/$day) {
		&$System::perform("/bin/mkdir $Filesystem::SODA_DIR/$year/$month/$day");
	    }
		
########	    &$System::perform("/bin/cp $System::TEMP_FITS_DIR/$file $System::SODA_DIR/$year/$month/$day/");
	    &$System::perform("/bin/cp $file $Filesystem::SODA_DIR/$year/$month/$day/");
	}
	
	# ???? $file is out of scope here...
	###&$System::perform("/bin/cp $System::TEMP_FITS/$file $System::DARTS_STAGING/mission/special") if $Flags::SPECIAL eq "special";
    }
    else {
	&$System::comment("No fits files to move");
    }
}
=cut


sub generate_summary_files {
    Trace::trace((caller(0))[3]);

#    &$System::stage_title("Mission::generate_summary_files : Generating summary files");

    # TEMP
#    my $HOME = "/Users/mcrw";
    my $year  = $Dates::syear;  #2019;
    my $month = $Dates::smonth; #"08";
    my $day   = $Dates::sday;   #22;
    my $syear  = $year;  #2019;
    my $smonth = $month; #"08";
    my $sday   = $day;   #22;

    my $rescue_translation_log = "foo";
    my $data_loss_log = "data_loss";
    my @post_reformat = [1,2,3];
    my $number_missing = 0;
#    my $number_pre_decompression = 100;
#    my $number_post_decompression = 99;

    my $ccsds_missing_file = "$Filesystem::DARTS_MISSION/$Dates::year/$Dates::month/packet_check/ccsds_hdrs.$Dates::start_date_string.txt";

    # Already done to read in the data
#    &$System::stage_step("Check for existence of a plan file");
    # This will be set to 1 if the file exists, 0 otherwise
#    my ($eis_plan_found, $plan_file) = Mission::get_eis_plan();

    &$System::stage_step("Estimate number of planned rasters (files)");
####    my $expected_number_of_rasters = Mission::get_expected_number_of_rasters($eis_plan_found, $plan_file);
    my $expected_number_of_rasters = ($plan_file) ? Plan::estimate_rasters($plan_file) : 0;
    &$System::comment("Number of estimated rasters: $expected_number_of_rasters");

    # What's all this then?
    my $plan_index = 0;
    if(open PLN, "< $HOME/tmp/rasters_for_plan.txt") {
	while(<PLN>) {
            chomp;
            next if /^TL/;
            my ($sd, $st, $ed, $et) = split; # ??????
        }
        close PLN;
    }

    &$System::stage_step("Count number of exposures");
       # Output format: filename   packets_per_exposure    number_of_exposures     timeline_id     reps_req        reps_done       RID     MID     Fx      Fy      ExpPerPos       data_volume     acronym
####    &$System::perform("$Program::EXPOSURE_COUNT < $Filesystem::DARTS_MISSION/$year/$month/packet_check/md_hdrs.$year$month$day.html > $HOME/tmp/packets_per_exposure.txt");
    open(FH, "> $Filesystem::PACKETS_PER_EXPOSURE_FILE");
    Html::exposure_count("$Filesystem::DARTS_MISSION/$year/$month/packet_check/md_hdrs.$year$month$day.html", \*FH);
    close FH;

    &$System::stage_step("Get ccsds packet missing summary");
    # Output format: filename   packets_received        number_missing          number_of_gaps  date
    &$System::perform("$Program::CCSDS_MISSING_SUMMARY $year$month$day $ccsds_missing_file > $Filesystem::LOCAL_CCSDS_MISSING_FILE");
    my $total_ccsds_packets         = `awk '{ tot += \$2 } END { print tot }' $Filesystem::LOCAL_CCSDS_MISSING_FILE`;
    my $total_ccsds_packets_missing = `awk '{ tot += \$3 } END { print tot }' $Filesystem::LOCAL_CCSDS_MISSING_FILE`;
    my $total_gaps                  = `awk '{ tot += \$4 } END { print tot }' $Filesystem::LOCAL_CCSDS_MISSING_FILE`;
 ###   my $total_files                 = `/usr/bin/grep eis_md ~/tmp/missing.txt | wc -l`;
    my $total_files                 = `$Program::GREP eis_md $Filesystem::LOCAL_CCSDS_MISSING_FILE | wc -l`;
    chomp $total_files;
    chomp $total_ccsds_packets;
    chomp $total_ccsds_packets_missing;
    chomp $total_gaps;
####    my ($total_ccsds_packets, $total_ccsds_packets_missing, $total_gaps, $total_files) = Ccsds::missing_summary("$ccsds_missing_file");

    #
    # put in exposures_missing_packets.pl output here, send to fold_reports.pl
    #
    # Output: filename  hdrs
    &$System::stage_step("Count number of exposures missing");
    &$System::perform("$Program::EXPOSURES_MISSING_PACKETS < $ccsds_missing_file > $HOME/tmp/exp_missing.txt");
###    Ccsds::exposures_missing_packets($ccsds_missing_file);

    &$System::stage_step("Get sequence count continuity check");
    &$System::perform("$Program::SEQUENCE_CONT_CHECK < $Filesystem::DARTS_MISSION/$year/$month/packet_check/sequence_counts_$year$month$day.txt > $HOME/tmp/seq_cont.txt");
###    Ccsds::sequence_count_continuity_check("$Filesystem::DARTS_MISSION/$year/$month/packet_check/sequence_counts_$year$month$day.txt");

    &$System::stage_step("Combine reports");
    if($Flags::RESCUE_MOD) {
	#    $rescue_translation_log = "$darts_staging/logs/md_translation/rescue/md_translation_rescue_" . "$sdate" . "_" . "$eday" . ".txt";
        &$System::perform("$Program::FOLD_REPORTS_MOD $Filesystem::LOCAL_CCSDS_MISSING_FILE $HOME/tmp/packets_per_exposure.txt $Data::translate_log $HOME/tmp/exp_missing.txt $HOME/tmp/reformat_summary.txt $HOME/tmp/seq_cont.txt $rescue_translation_log $data_loss_log");
    }
    else {
        &$System::perform("$Program::FOLD_REPORTS $Filesystem::LOCAL_CCSDS_MISSING_FILE $HOME/tmp/packets_per_exposure.txt $Data::translate_log $HOME/tmp/exp_missing.txt $HOME/tmp/reformat_summary.txt $HOME/tmp/seq_cont.txt");
    }

    #??                                                                                                           
    #perform(*LOG, $state, "/bin/mv ~/tmp/missing.txt $staging/packet_summary/summary_$syear$smonth$sday.txt");

    # Get total number of exposures expected and got
    my $total_exps_expected = `awk '{ tot += \$3 * \$11 } END { print tot }' $HOME/tmp/packets_per_exposure.txt`;
####    my $total_exps_expected = Html::total_exposures_expected();
    $total_exps_expected = -1 if $total_exps_expected == 0;

    my $total_exps_got = `awk '/^Filename/ { next } { tot += \$8 } END { print tot }' $HOME/tmp/reformat_summary.txt`;
    chomp $total_exps_got;

    &$System::stage_step("Create summary");
    #if(open SUMMARY, "$staging/packet_summary/summary_$syear$smonth$sday.txt") {
    if(open SUMMARY, "> $HOME/tmp/ref_sum.txt") {
        #    print SUMMARY "Summary for the plan from $sd $st to $ed $et\n";
        print SUMMARY "Summary for the plan from $Dates::sdate $Dates::stime to $Dates::edate $Dates::etime\n\n";
        my $fits_num = scalar(@post_reformat);
        chomp $fits_num;
        if($eis_plan_found) {
            print SUMMARY "Rasters Planned          : ", sprintf("%6u", $expected_number_of_rasters), "\n";
        }
        else {
            print SUMMARY "\nNo EIS plan file was available. A complete summary cannot be generated.\n\n";
        }
	print SUMMARY "Rasters (files) Received : ", sprintf("%6u", $total_files), "\n";
        print SUMMARY "Number Of Damaged Files  : ", sprintf("%6u", $number_missing), "\n";
        print SUMMARY "File Damage Rate         : ", sprintf("%6.2f", ($total_files == 0) ? 0.0 : ($number_missing / $total_files) * 100.0), "%\n";
        print SUMMARY "Files Pre Decompression  : ", sprintf("%6u", $Data::number_pre_decompression), "\n";
        print SUMMARY "Files Post Decompression : ", sprintf("%6u", $Data::number_post_decompression), "\n";
        print SUMMARY "Number Of Fits Files     : ", sprintf("%6u", $fits_num), "\n";
	print SUMMARY "Expected Exposures       : ", sprintf("%6u", $total_exps_expected), "\n";
        print SUMMARY "Actual Exposures         : ", sprintf("%6u", $total_exps_got), "\n";
        print SUMMARY "Exposure Loss            : ", sprintf("%6.2f", ($total_exps_expected == 0) ? 0.0 : 100.0 - ($total_exps_got / $total_exps_expected) * 100.0), "%\n";;
        print SUMMARY "Total Ccsds Packets      : ", sprintf("%6u", $total_ccsds_packets), "\n";
        print SUMMARY "Ccsds Packets Missing    : ", sprintf("%6u", $total_ccsds_packets_missing), "\n";
        print SUMMARY "Ccsds Packets Loss Rate  : ", sprintf("%6.2f", ($total_ccsds_packets == 0) ? 0.0 : ($total_ccsds_packets_missing / $total_ccsds_packets) * 100.0), "%\n";
	print SUMMARY "Number Of Gaps           : ", sprintf("%6u", $total_gaps), "\n\n";
        close SUMMARY;
    }

    &$System::stage_step("Copy reports to DARTS");
    if($Flags::TESTING) {
	&$System::perform("/bin/cat $HOME/tmp/ref_sum.txt $HOME/tmp/reformat_summary.txt > $Filesystem::DARTS_STAGING_DIR/reformat_summary/summary_$syear$smonth$sday" . "_TEST.txt");
    }
    else {
        &$System::perform("/bin/cat $HOME/tmp/ref_sum.txt $HOME/tmp/reformat_summary.txt > $Filesystem::DARTS_STAGING_DIR/reformat_summary/summary_$syear$smonth$sday.txt");
        &$System::perform("/bin/cat $HOME/tmp/ref_sum.txt $HOME/tmp/reformat_summary.txt > $Filesystem::DARTS_STAGING_DIR/reformat_summary/$syear/summary_$syear$smonth$sday.txt");
    }

    &$System::stage_step("Remove temporary file");
    &$System::perform("/bin/rm $HOME/tmp/reformat_summary.txt");

    ###perform(*LOG, $state, "/bin/rm $HOME/tmp/ref_sum.txt $HOME/tmp/reformat_summary.txt $HOME/tmp/packets_per_exposure.txt $HOME/tmp/missing.txt $HOME/tmp/exp_missing.txt $HOME/tmp/rasters_for_plan.txt");

    # Where is pending file dealt with?
    &$System::stage_step("Update latest reformat file");
    &$System::perform("/bin/echo $Dates::sdate $Dates::edate $Dates::stime $Dates::etime > $Filesystem::MISSION_REFORMAT_FILE") unless $Flags::TESTING;

}

sub get_date_time_from_orl_file {
    Trace::trace((caller(0))[3]);

    my $prev_end_date = shift;

    # If start date orl file exists then search up to 9 days further for the end orl file
    # This might mean the reformatter gets stuck with the same start date if it can't find the end orl
    # file 9 days after the start date... solutions?
    $start_orl_file = $Filesystem::ORL_DIR . "/EIS_" . $prev_end_date . "????.orl";
    my $end_time = "";
    my $next_date = "";
    print "Looking for $start_orl_file\n";
    #if (-e $start_orl_file) {  # Doesn't deal with globbing, so ...
    my (@file_list) = glob $start_orl_file;
    if (@file_list) {
###     Pipeline::main_log_message("Found start orl file - $start_orl_file " . __FILE__ . " " . __LINE__);
	Pipeline::main_log_message("Found start orl file : $start_orl_file");
        for my $i (1 .. 9) {
            $next_date = Dates::add_day($prev_end_date, $i);
            print "next_date = $next_date\n";
            $end_orl_file = $Filesystem::ORL_DIR . "/EIS_" . $next_date . "????.orl";
#           Pipeline::main_log_message("Looking for end orl file on $next_date");
            (@file_list) = glob $end_orl_file;
            if (@file_list) {
		    #if (-e $System::ORL_DIR . "/" . $end_orl_file) {
                # If the end orl file exists then parse the orl files for end time
                $end_time = parse_orl_file($file_list[0]);
                # Check end time
                if ($end_time =~ /^\d{4}/) {
###                 Pipeline::main_log_message("End orl file found for $next_date, end time is $end_time");
		    Pipeline::main_log_message("End orl file found   : $end_orl_file");
                    last;
		}
                else {
		    Pipeline::pipeline_warn(-101, "Orl parse error: $end_time in file for $next_date");
		}
            }
###         Pipeline::pipeline_warn(-102, "Can't find end orl file for $next_date");
	}
        #Pipeline::pipeline_die(-105, "Can't find end orl file") unless $end_time;
	Pipeline::pipeline_warn(-105, "Can't find end orl file") unless $end_time;
    }
    else {
        #Pipeline::pipeline_die(-110, "Can't open start orl file for $prev_end_date");
	Pipeline::pipeline_warn(-110, "Can't open start orl file for $prev_end_date");
    }

#    print "$prev_end_date, $next_date, $prev_end_time, $end_time\n";
    return ($end_time, $next_date);
}

sub parse_orl_file {
    Trace::trace((caller(0))[3]);
#    return "9876";

    my $file = shift;

    Pipeline::log("parse_orl_file: opening $file");

    my $line = "";
    my $found = 0;
    if(open(ORL, "< $file")) {
        while(<ORL>) {
            chomp;

            # Changed mcrw 20111124 to use the start time after the obstbl dump.
            if(/^START/) {
                ++$found;
                if($found == 3) {
                    $line = $_;
                    last;
                }
            }
            last if (/^DEFSEQ/);

            #       # orl file format has changed, with extra STARTs before the obstbl dump start
            #       # Skip past these.
            #       next if /^START:OPOG_UPLOAD_TI/;
            #       if(/^START/) {
            #
            #           # Read 3 more lines to skip past dump obstbl line
            #           <ORL>;
            #           <ORL>;
            #           <ORL>;
            #
	        #           $line = $_;
            #           last;
            #       }
            #       next;
        }
        close(ORL);
    }
    else {
	return "Failed to open";
    }
    
    if($line eq "") {
        return "Empty line";
    }
    #
    # $line should be like: START:2007/02/13.10:00:00 { SEQ:EIS_LOAD_OBSTBL_REAL ;}
    # Return hhmm portion
    #
    my $hh = substr $line, 17, 2;
    my $mm = substr $line, 20, 2;

    return "Hour parse error"   unless $hh =~ m/([0-1][0-9]|2[0-3])/;
    return "Minute parse error" unless $mm =~ m/[0-5][0-9]/;

    return "$hh$mm";
}

sub read_schedule_file {
    Trace::trace((caller(0))[3]);

    my ($prev_start_date, $prev_end_date, $prev_start_time, $prev_end_time);

    # Open schedule file and get end date to use as new start date
    if(open(FH, "< $Filesystem::CRON_SCHEDULE_FILE")) {
        my $line = <FH>;
	chomp $line;
        ($prev_start_date, $prev_end_date, $prev_start_time, $prev_end_time) = split / /, $line;
        close FH;
	Pipeline::main_log_message("Read schedule file");
        print "$prev_start_date, $prev_end_date, $prev_start_time, $prev_end_time\n";
    }
    else {
        print "Can't open schedule file ($Filesystem::CRON_SCHEDULE_FILE)\n";
        #Pipeline::pipeline_die(-100, "Can't open schedule file ($System::CRON_SCHEDULE_FILE)");
        #Pipeline::pipeline_die($Pipeline::message{$System::SCHED_OPEN_FAIL});
	Pipeline::pipeline_warn(-100, "Can't open schedule file ($Filesystem::CRON_SCHEDULE_FILE)");
    }

    my ($end_time, $next_date) = get_date_time_from_orl_file($prev_end_date);


    $Dates::sdate  = $prev_end_date;
    $Dates::edate  = $next_date;
    $Dates::stime  = $prev_end_time;
    $Dates::etime  = $end_time;

    $Dates::start_date_string = $prev_end_date;
}

sub read_plan_file {
    Trace::trace((caller(0))[3]);

    ($eis_plan_found, $plan_file) = Mission::find_eis_plan();
#    ($Dates::sdate, $Dates::stime, $Dates::edate, $Dates::etime) = Plan::parse_plan($plan_file) if $eis_plan_found;
    my ($sdate, $stime, $edate, $etime) = Plan::parse_plan($plan_file) if $eis_plan_found;

    $Dates::sdate = Dates::convert_plan_date($sdate);
    $Dates::edate = Dates::convert_plan_date($edate);
    $Dates::stime = Dates::convert_plan_time($stime);
    $Dates::etime = Dates::convert_plan_time($etime);

    # Debug!
    Dates::dump_dates_and_times();

    return $eis_plan_found;
}

# First draft:  go back x days from today and search forward
# Second draft: use log to record plan done and search forward from there
sub find_eis_plan {
    Trace::trace((caller(0))[3]);

    print "start day offset = ", Constants::START_DAY_OFFSET, "\n";
    print "end   day offset = ", Constants::END_DAY_OFFSET, "\n";

    my $offset = Constants::START_DAY_OFFSET;
    my $find_date;
    my $plan_file;
    foreach my $attempt (0 .. Constants::MAX_ATTEMPTS) {
        $find_date = Dates::other_date($offset + $attempt, as_string => 1);
	$plan_file = $Filesystem::PLAN_DIR . "/eis_plan_" . $find_date . ".txt";
        print "Looking for $plan_file\n";
	last if ($eis_plan_found = stat $plan_file);
#       if ($eis_plan_found = stat $Filesystem::PLAN_DIR . "/eis_plan_" . $find_date . ".txt") {
#           print "FOUND PLAN $find_date ($eis_plan_found)\n";
#           last;
#       }
    }
    print "FOUND PLAN $find_date ($eis_plan_found, $plan_file)\n";
    return ($eis_plan_found, $plan_file);
}

sub read_orl_file {
    Trace::trace((caller(0))[3]);

    #####<<<<<<
=pod
    # If start date orl file exists then search up to 9 days further for the end orl file
    # This might mean the reformatter gets stuck with the same start date if it can't find the end orl
    # file 9 days after the start date... solutions?
    $start_orl_file = $Filesystem::ORL_DIR . "/EIS_" . $prev_end_date . "????.orl";
    my $end_time = "";
    my $next_date = "";
    print "Looking for $start_orl_file\n";
    #if (-e $start_orl_file) {	# Doesn't deal with globbing, so ...
    my (@file_list) = glob $start_orl_file;
    if (@file_list) {
	###	Pipeline::main_log_message("Found start orl file - $start_orl_file " . __FILE__ . " " . __LINE__);
	Pipeline::main_log_message("Found start orl file : $start_orl_file");
	for my $i (1 .. 9) {
	    $next_date = Dates::add_day($prev_end_date, $i);
	    print "next_date = $next_date\n";
	    $end_orl_file = $Filesystem::ORL_DIR . "/EIS_" . $next_date . "????.orl";
	    #	    Pipeline::main_log_message("Looking for end orl file on $next_date");
	    (@file_list) = glob $end_orl_file;
	    if (@file_list) {
		#if (-e $System::ORL_DIR . "/" . $end_orl_file) {
		# If the end orl file exists then parse the orl files for end time
		$end_time = parse_orl_file($file_list[0]);
		# Check end time
		if ($end_time =~ /^\d{4}/) {
		    ###		    Pipeline::main_log_message("End orl file found for $next_date, end time is $end_time");
		    Pipeline::main_log_message("End orl file found   : $end_orl_file");
		    last;
		}
		else {
		    Pipeline::pipeline_warn(-101, "Orl parse error: $end_time in file for $next_date");
		}
	    }
	    ###	    Pipeline::pipeline_warn(-102, "Can't find end orl file for $next_date");
	}
	#Pipeline::pipeline_die(-105, "Can't find end orl file") unless $end_time;
	Pipeline::pipeline_warn(-105, "Can't find end orl file") unless $end_time;
    }
    else {
		#Pipeline::pipeline_die(-110, "Can't open start orl file for $prev_end_date");
	Pipeline::pipeline_warn(-110, "Can't open start orl file for $prev_end_date");
    }
    
    #    print "$prev_end_date, $next_date, $prev_end_time, $end_time\n";
=cut
    ######>>>>>
}


# Format changed - deal with this
#sub parse_plan_file {
#    my $plan_file = shift;
#    
#    Trace::trace(__PACKAGE__."::parse_plan_file");
#
#    # Return format: 24-Feb-2022 12:00:00 26-Feb-2022 07:53:34 for eg
#    my ($sdate, $stime, $edate, $etime) = Plan::parse_plan($plan_file);
#    
#}


sub cron_finished {
    my $code = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);

    &$System::perform("/bin/echo $Dates::sdate $Dates::edate $Dates::stime $Dates::etime > $Filesystem::CRON_SCHEDULE_FILE");
}

sub open_local_log {
    Trace::trace((caller(0))[3]);

    $mission_log = $Filesystem::MISSION_LOG . $Dates::sdate . '_' . $Dates::edate . ".txt";
    open(LOG, ">> $mission_log"), $mission_log_open = 1 || pipeline_die(-2, "Mission::open_local_log (" . __LINE__ . ") : Can't open pipeline_mission_log.txt for writing: $!");
    System::dprint("Starting logger for $Pipeline::state\n");
    System::init(*LOG, $Pipeline::state);
    #init1(*LOG, $start_flag);                                                                                    
    return *LOG;
}

sub save_log {
    my $string = shift;

    Trace::trace((caller(0))[3]);

    &$System::perform("/bin/mv $mission_log $Filesystem::DARTS_MISSION_LOG_DIR") if defined($mission_log);

    &$System::log("$string") if $mission_log_open;
    &$System::log("\n--------------------------------\n") if $mission_log_open;
}

sub pipeline_exit {
    my $junk = shift;
    my $code = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);

#    &$System::perform("/bin/mv $mission_log $Filesystem::DARTS_STATUS_LOGS_DIR");

    my $string = "*** " . scalar(localtime) . " (JST) PIPELINE EXIT: ($code) $message\n";
####    &$System::log($string);
    save_log($string);
#    print "DIE:  $code ($message)\n";
#    main_log_message(scalar(localtime) . " (JST) EXIT:  $code ($message)");
    Pipeline::_main_log_message($string);
#    if ($code == 0) {
#       print $MLOG "*** " . $string
#    }
#    else{
#       print $MLOG $string;
    #    }
#    close $MLOG;
#    close $LOG;
    #    exit $code;
    return $code;
}

1;

__END__

