package Pipeline;

#print "HINODE/EIS/EISPIPELINE/EISMISSION/PIPELINE.PM\n";

use strict;
use warnings;
use Time::Local;

use Hinode::EIS::EisPipeline::EisMission::System;
use Hinode::EIS::EisPipeline::EisMission::Data;
use Hinode::EIS::EisPipeline::EisMission::Dates;
use Hinode::EIS::EisPipeline::EisMission::Flags;
use Hinode::EIS::EisPipeline::EisMission::Args;
use Hinode::EIS::EisPipeline::EisMission::Program;
use Hinode::EIS::EisPipeline::EisMission::Rasters;
use Hinode::EIS::EisPipeline::EisMission::Filesystem;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisMission/Pipeline\n";
}

# In ../Pipeline.pm
#our $state = "interactive";
#our $kick_string = "";

#our $HOME = $ENV{'HOME'};

#my $ROOT = $HOME;
#my $WORK = $HOME . "/work";
#my $DATA = $HOME . "/data";
#
#my $LOCALDATA = $WORK . "/localdata";
#
#my $SDTP    = $LOCALDATA . "/sdtp";			# ${HOME}/work/localdata/sdtp
#my $MERGE   = $SDTP . "/merge";
#my $MISSION = $MERGE . "/mission";
#
#my $PIPELINE         = $LOCALDATA . "/pipeline";
#my $MISSION_PIPELINE = $PIPELINE . "/mission";
#
#our $RECEIVED_DIR     = $MISSION . "/received";
#our $DECOMPRESSED_DIR = $MISSION . "/decompressed";
#our $JOIN_DIR         = $MISSION . "/joined";
#our $SPLIT_DIR        = $MISSION . "/split";
#our $CHECK_TABLE_DIR  = $MISSION . "/chk";
#our $LOCAL_LOG        = $MISSION . "/logs";
#
#our $FITS_DIR = $MISSION_PIPELINE . "/fits";
#
#our $DARTS              = $DATA;
#our $DARTS_MISSION      = $DARTS . "/mission";
#our $DARTS_STAGING      = $DARTS . "/staging";
#our $DARTS_STAGING_LOGS = $DARTS_STAGING . "/logs";
#our $LOGS_STAGING_DIR   = $DARTS_STAGING . "/logs";
#
#my $DARTS_STAGING_CHECK_TABLE_DIR = $DARTS_STAGING_LOGS . "/check_tables";
#
#our $SODA_DIR     = "/soda/hinode/eis/level0";
#our $SODA_CAL_DIR = $SODA_DIR . "/cal";
#
#our $TEMP_IDL  = $MISSION_PIPELINE . "/idl";
#our $LOCAL_IDL = $WORK . "/idl";
#
#my $STAGING  = $DATA . "/staging";
#our $ORL_DIR = $STAGING . "/orl";
#
#
#my $LOG   = $LOCALDATA . "/logs";				# ${HOME}/work/localdata/logs
#my $TRACK = $System::PIPELINE . "/track";		# ${HOME}/work/localdata/pipeline/mission/track
#my $DARTS_MISSION_DIR = $System::DARTS . "/mission";
#my $LOG_DIRECTORY     = $ROOT . "/logs";
#
##our $MERGE_DIR = $SDTP . "/merge";
##our $MERGE_DIR = $System::MISSION;
#
##our $RESCUE_DIR       = $MERGE_DIR . "/rescue";
##our $ORPHANS_DIR      = $MERGE_DIR . "/orphans";
#our $NURSERY_DIR             = $MERGE_DIR . "/nursery";
#our $RESCUE_DECOMPRESSED_DIR = $NURSERY_DIR . "/decompressed";
#our $RESCUE_FITS_DIR         = $NURSERY_DIR . "/fits";
#our $INCOMPLETE_DIR          = $MERGE_DIR . "/incomplete";
#
#our $TEMP_FITS_DIR    = $SDTP . "/tmp_fits";
#our $LOGS_STAGING_DIR = $System::HOME . "/data/staging/logs";
our $mission_log      = ""; #$LOG_DIRECTORY . "/pipeline_mission_log_";
#our $PIPELINE_LOG_DIR = $LOG_DIRECTORY;
#
#our $RECEIVED_FILES_LOG     = $MERGE_DIR . "/received_files.txt";
#our $MISSING_PACKETS_LOG    = $MERGE_DIR . "/missing_packets.txt";
#our $HEADLESS_PACKETS_LOG   = $MERGE_DIR . "/headless_packets.txt";
#our $INCOMPLETE_PACKETS_LOG = $MERGE_DIR . "/incomplete_packets.txt";
#our $SEQUENCE_COUNTS_LOG    = $MERGE_DIR . "/sequence_counts.txt";
#our $MD_SPLIT_CHECK_LOG     = $MERGE_DIR . "/md_split_check.txt";
#our $JOINED_FILES_LOG       = $MERGE_DIR . "/joined_files.txt";
#our $MD_HEADER_CHECK_LOG    = $MERGE_DIR . "/md_hdr_check.txt";
#our $CCSDS_PACKET_CHECK_LOG = $MERGE_DIR . "/ccsds_hdr_check.txt";
#
##our $TEMP_IDL  = $System::LOCAL_PIPELINE . "/idl";
#
#our $MISSION_PENDING_FILE        = $TRACK . "/mission_pending.txt";
#my $MISSION_LATEST_REFORMAT_FILE = $TRACK . "/latest_mission_reformat.txt";
#our $STATUS_PENDING_FILE          = $TRACK . "/status_pending.txt";
#our $STATUS_REFORMAT_FILE         = $TRACK . "/latest_status_reformat.txt";
#
#our $CRON_SCHEDULE_FILE          = $TRACK . "/cron_start_schedule.txt";
#    
#our $DECOMPRESSION_RECORD_LOG = $LOG . "/decompression/merge_decomp_record.txt";
#our $LOCAL_DECOMPRESSION_LOG  = $LOG . "/decompression/md_decompress_";
#
#our $LOCAL_MD_TRANSLATION_LOG = $LOG . "/reformat/md_translation_";
#our $LOCAL_MD_REFORMAT_LOG    = $LOG . "/reformat/md_reformat_";
#
#our $LOCAL_FITS_DUMP_LOG      = $LOG . "/pipeline/fits_dump_";
#our $LOCAL_FITS_HEADERS_LOG   = $LOG . "/pipeline/fits_headers_";
#
#our $LOCAL_SHUTTER_LOG     = $LOG . "/shutter/shutter.txt";
#our $DARTS_SHUTTER_LOG_DIR = $System::HOME . "/data/staging/logs/shutter";

#our $SCHED_OPEN_FAIL      = -100;
#our $NO_END_ORL_FILE      = -105;
#our $OPEN_ORL_FAIL        = -110;
#our $NOT_ENOUGH_ARGUMENTS = -10;
#our $NO_START_DATE        = 10;
#our $NO_END_DATE          = 11;
#our $NO_START_TIME        = 12;
#
#our $NO_HK = 100;
#
#our %message = (
#    $SCHED_OPEN_FAIL => ($SCHED_OPEN_FAIL, "Can't open schedule file ($CRON_SCHEDULE_FILE)"),
#    $NO_END_ORL_FILE => ($NO_END_ORL_FILE, "Can't find end orl file"),
#    $OPEN_ORL_FAIL   => ($OPEN_ORL_FAIL, "Can't open start orl file"),
#);


#my $pipeline_log = "pipeline_log.txt";


#print "PIPELINE LOG = $pipeline_log\n";

# In ../Pipeline.pm
#my $MLOG;
my $announce = scalar(localtime) . " (JST) daily_merge_mission3 started";

=pod 
sub gen_fh {
    my $fh = shift;
    return sub { $fh; };
}

sub logger {
    my $stdout = shift;
    my $fh = shift;
    if($stdout == 1) {
	return sub {
	    my $msg = shift;
	    print STDOUT "$msg\n";
	    print $fh "$msg\n";
	};
    }
    return sub {
	my $msg = shift;
	print $fh "$msg\n";
    };
}

# Return the (log, perform, title) functions for interactive or cron modes
sub init_system {
    my $filehandle = shift;
    my $state      = shift;
    my $fh = gen_fh($filehandle);
    my $out_fh = ($state eq "interactive") ? 1 : 0;
    my $log_it = logger($out_fh, $filehandle);
    return (
	
	sub {
	    my $msg = shift;
	    &$log_it("\t# " . $msg);
	},

	sub {
	    my $cmd = shift;
	    &$log_it("\t" . $cmd);
#################################################	    system($cmd);
	},
	# Perform with title message
	#	     sub {
	#	         my $title = shift;
	#		 my $cmd = shift;
	#		 &$log_it("\t# " . $title);
	#		 &$log_it("\t" . $cmd);
	#		 system($cmd);
	#	     },

	sub {
	    my $title = shift;
	    my $ct  = scalar(localtime);
	    my $cts = "$ct (JST) - ";
	    my $ntitle = "$cts $title";
	    &$log_it("\n--------------------------------");
	    &$log_it($ntitle);
	});
}

sub init1 {
    my $filehandle = shift;
    my $state      = shift;

    print "System::init\n";
    our ($log, $perform, $stage_title) = init_system($filehandle, $state);
    #    &log("Foo");
    #print $log;
}

=cut

=pod
sub start {
#    print "Pipeline::init\n";
    System::dprint("Pipeline::start");
    open_pipeline_log();
}

sub init {
#    print "Pipeline::init\n";
    System::dprint("Pipeline::init");

#    pipeline_die(-1, "No bin environment variable detected (HINODE_BIN)") unless $ENV{'HINODE_BIN'};
#    pipeline_die(-1, "No sswidl environment variable detected (SSWIDL)") unless $ENV{'SSWIDL'};

    print STDERR "Pipeline::init : No bin environment variable detected (HINODE_BIN)\n" unless $ENV{'HINODE_BIN'};
    print STDERR "Pipeline::init : No sswidl environment variable detected (SSWIDL)\n" unless $ENV{'SSWIDL'};

    pipeline_warn(100, "Pipeline::init (line " . __LINE__ . ") : No bin environment variable detected (HINODE_BIN)") unless $ENV{'HINODE_BIN'};
    pipeline_warn(101, "Pipeline::init (line " . __LINE__ . ") : No sswidl environment variable detected (SSWIDL))") unless $ENV{'SSWIDL'};
###    pipeline_die(101, "Pipeline::init (line " . __LINE__ . ") : No sswidl environment variable detected (SSWIDL))") unless $ENV{'SSWIDL'};
}

# In ../Pipeline.pm
#sub open_pipeline_log {
##    print "Opening pipeline log ($System::PIPELINE_LOG)\n";
#    System::dprint("Opening pipeline log ($Filesystem::PIPELINE_LOG)");
#
####    open($MLOG, ">>$System::PIPELINE_LOG") || pipeline_die(-1, "Can't open main pipeline log: $!");
#    open($MLOG, ">>$Filesystem::PIPELINE_LOG") || die "Can't open main pipeline log: $!";
#
##    open($MLOG, ">>$System::PIPELINE_LOG") || pipeline_send_mail("Can't open main pipeline log: $!");
##    pipeline_send_mail("Got main pipeline log");
#}

sub open_mission_log {
#    my $start_flag = shift;
#    my $start_flag = $state;

    $mission_log = $Filesystem::MISSION_LOG . $Dates::sdate . '_' . $Dates::edate . ".txt";
    open(LOG, ">> $mission_log"), $System::mission_log_open = 1 || pipeline_die(-2, "Pipeline::open_mission_log (" . __LINE__ . ") : Can't open pipeline_mission_log.txt for writing: $!");
    System::dprint("Starting logger for $state\n");
    System::init(*LOG, $state);
    #init1(*LOG, $start_flag);
}

# In ../Pipeline.pm
#sub local_announce {
#    &$System::log("\n*** $announce $kick_string");
#    &$System::log("\t" . $Args::command_line);
#}

# In ../Pipeline.pm
#sub announce {
#    _main_log_message("\n*** " . $announce . " $kick_string");
#}

# In ../Pipeline.pm
#sub log {
#    my $msg = shift;
#    print "\t" . $msg . "\n";
#}

#sub main_log_message {
#    my $msg = shift;
#    System::dprint("\t" . $msg . "\n");
#    _main_log_message("\t$msg");
#}

# In ../Pipeline.pm
#sub _main_log_message {
#    my $msg = shift;
#    print $MLOG "$msg\n" if $MLOG;
#}

#sub mission_log_message {
#    my $msg = shift;
#    print $MLOG "\t" . $msg . "\n"
#}

# In ../Pipeline.pm
#sub pipeline_warn {
#    my $code = shift;
#    my $message = shift;
#
#    _main_log_message("\tWARN: ($code) $message");
#}
=cut

# Write out dates to schedule file
sub cron_finished {
    my $code = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);
    
    &$System::log("\tPipeline::cron_finished : Updating cron schedule file");
    &$System::perform("/bin/echo $Dates::sdate $Dates::edate $Dates::stime $Dates::etime > $Filesystem::CRON_SCHEDULE_FILE");
    pipeline_exit($code, $message);
}

sub save_log {
    my $string = shift;

    #Trace::trace((caller(0))[3]);
    Trace::trace(__PACKAGE__."::save_log");

    $pipeline->save_log($string);
    return;
    
    my $log_open = (is_mission_pipeline()) ? $System::mission_log_open : $System::status_log_open;
    &$System::perform("/bin/mv $mission_log $Filesystem::DARTS_MISSION_LOG_DIR");

    &$System::log("$string") if $log_open;
    &$System::log("\n--------------------------------\n") if $log_open;
}

# In ../Pipeline.pm but needs to be "overridden"
sub pipeline_die {
    #my $pipeline = shift;
    my $code = shift;
    my $message = shift;

    &$System::perform("/bin/mv $mission_log $Filesystem::DARTS_MISSION_LOG_DIR");

    my $string = scalar(localtime) . " (JST) DIE : ($code) $message";
    System::dprint("DIE: $code ($message)\n");
    &$System::log("*** $string") if $System::mission_log_open;
    _main_log_message("*** $string");
    exit $code;
}

=pod
sub pipeline_exit {
    my $code = shift;
    my $message = shift;

    &$System::perform("/bin/mv $mission_log $Filesystem::DARTS_MISSION_LOG_DIR");

    my $string = "*** " . scalar(localtime) . " (JST) EXIT: ($code) $message\n"; 
####    &$System::log($string);
    save_log($string);
#    print "DIE:  $code ($message)\n";
#    main_log_message(scalar(localtime) . " (JST) EXIT:  $code ($message)");
    _main_log_message($string);
#    if ($code == 0) {
#	print $MLOG "*** " . $string
#    }
#    else{
#	print $MLOG $string;
    #    }
    close $MLOG;
    close $LOG;
    exit $code;
}
=cut

sub populate_calibration_data {
    &$System::stage_title("Pipeline::populate_calibration_data : Move engineering files to calibration area");

    if(open(ENG_LOG, "< $Filesystem::MERGE_DIR/engineering.txt")) {
	my $line = <ENG_LOG>;				# Read title
	while($line = <ENG_LOG>) {			# Read ccsds packet filename
	    last if $line =~ /^$/;			# Finish on a blank line
	    chop $line;				# Remove \n
	    my ($path, $type) = split(/:/, $line);	# Get filename and type of engineering study
	    &$System::comment_msg("(path,type) = ($path, $type)");
	    my @path = split(/\//, $path);		# Split up filename path
	    my $ccsds_file = $path[-1];		# Get the ccsds filename
	    
	    my $fits_file = $Data::translate{$ccsds_file};	# Get fits filename from ccsds filename
	    #my $fits_file = $temp{$ccsds_file};	# Get fits filename from ccsds filename
	    #		$ok_fits = $etrans{$ccsds_file};	# Get fits filename from ccsds filename
	    #		$rescued_fits = $temp{$ccsds_file};	# Get fits filename from ccsds filename
	    
	    #		$fits_file = $ok_fits if $ok_fits;
	    #		$fits_file = $rescued_fits if $rescued_fits;
	    
	    # Must set source directory accordingly (if ok or rescued)
	    
	    if($fits_file) {
		###$eng_dbase{$fits_file} = $type if $eng_dbase;	# Update engineering database
		my $destination = Rasters::eng_path($type);		# Get where to copy the fits file and copy it
		my $source = $System::TEMP_FITS_DIR . "/"  . $fits_file . ".gz";
		if($destination ne "") {
		    my $dest1 = "$Filesystem::DARTS_MISSION" . $destination;
		    my $dest2 = "$Filesystem::SODA_CAL_DIR" . $destination;
		    &$System::comment("Moving $source to $dest1 and $dest2");
		    # mcrw 25/07/07 - Move instead of copy so engineering files don't appear in science area
		    # mcrw 19/09/08 - Copy them now, not move
		    &$System::perform("/bin/cp $source $dest1");
		    &$System::perform("/bin/cp $source $dest2");
		}
		else {
		    &$System::comment("No destination found for $fits_file ($type)");
		}
	    }
	    else {
		&$System::comment("No translation found for $ccsds_file");
	    }
	}
	close(ENG_LOG);

	&$System::perform("/bin/mv $Filesystem::MERGE_DIR/engineering.txt $Filesystem::DARTS_MISSION/$Dates::year/$Dates::month/packet_check/engineering.$Dates::year$Dates::month$Dates::day.txt");
	#
	# Generate cal study summary file from fits here?
	#  ./fits_cal_study.pl > ~/work/localdata/log/mission/cal_studies_list.txt
	#
    }
    else {
	&$System::comment("No engineering summary file");
    }
    # Copy the engineering database to the staging area even if it was not updated
    #log_msg(*LOG, $state, "/bin/cp $pipeline_log/engineering_name_dbase $darts_staging/logs/");

###    &$System::perform("/bin/cp $pipeline_log/engineering_name_dbase $System::DARTS_STAGING_LOGS");
    
}

sub populate_soda {
    &$System::stage_title("Pipeline::populate_soda : Moving mission data files to soda");

    #
    # Filenames:
    #	eis_l0_yyyymmdd_hhmmss.fits
    #

    &$System::stage_step("List the files in $Filesystem::TEMP_FITS_DIR");
###    my @files = `/bin/ls $System::TEMP_FITS_DIR`;
    my @files = &$System::list($Filesystem::TEMP_FITS_DIR, "eis_l0*");
    if (@files) {
	&$System::stage_step("Move files to $Filesystem::SODA_DIR");
	foreach my $file (@files) {
	    next if !($file =~ /l0/);
	    chomp $file;
	    # Match destination directory with filename
	    my $year  = substr $file,  7, 4;
	    my $month = substr $file, 11, 2;
	    my $day   = substr $file, 13, 2;
	    
	    # DEBUG
	    $year = 2019;
	    $month = 10;
	    $day = 22;

	    ###    log_msg(*LOG, $state,  "/bin/cp $temp_fits/$file $darts_mission/$darts_year/$darts_month/$darts_day/");
	    
	    #    system("/bin/cp $temp_fits/$file $darts_mission/$darts_year/$darts_month/$darts_day/");
	    #    system("/bin/cp $temp_fits/$file $soda_darts_mission/$darts_year/$darts_month/$darts_day/");
	    
########	    &$System::perform("/bin/cp $System::TEMP_FITS_DIR/$file $System::SODA_DIR/$year/$month/$day/");
	    &$System::perform("/bin/cp $file $Filesystem::SODA_DIR/$year/$month/$day/");
	}
	
	# ???? $file is out of scope here...
	###&$System::perform("/bin/cp $System::TEMP_FITS/$file $System::DARTS_STAGING/mission/special") if $Flags::SPECIAL eq "special";
    }
    else {
	&$System::comment("No fits files to move");
    }
}

# In ../Pipeline.pm
#sub clean_up {
#    &$System::stage_title("Pipeline::clean_up : Cleaning up");
#
#}

sub remove_quicklook {
    &$System::stage_title("Pipeline::remove_quicklook : Removing quicklook mission data for $Dates::start_date_string");

    my $start_days = Dates::date_to_days("start");
    my $end_days   = Dates::date_to_days("end");
#    &$System::comment("start_days = $start_days, end_days = $end_days");
#    my $start_days = Date::Calc::Date_to_Days($syear, $smonth, $sday);
#    my $end_days = Date::Calc::Date_to_Days($eyear, $emonth, $eday);
    &$System::stage_step("Remove quicklook data from $Dates::syear/$Dates::smonth/$Dates::sday to $Dates::eyear/$Dates::emonth/$Dates::eday");

###    foreach my $diff (-1 .. $end_days - $start_days - 1) {
    foreach my $diff (0 .. $end_days - $start_days) {
	my ($nyear, $nm, $nd) = Dates::add_days($Dates::syear,$Dates::smonth,$Dates::sday, $diff);
#	my ($nyear, $nm, $nd) = Date::Calc::Add_Delta_Days($syear,$smonth,$sday, $diff);
	my $nmonth = sprintf "%02u", $nm;
	my $nday = sprintf "%02u", $nd;
	print "Doing $diff -> $nyear, $nmonth, $nday\n";
	
	# Remove directory in DARTS if it exists
	my $ql_dir = $Filesystem::DARTS_STAGING_MISSION_QUICKLOOK . "/$nyear/$nmonth/$nday";
	&$System::comment("Removing $ql_dir");
	if(-e "$ql_dir") {
	    &$System::perform("/bin/rm -rf $ql_dir");
	}
	else {
	    &$System::comment("Directory $ql_dir does not exist");
	}
	
	# Remove md directory in sdtp if it exists
	$ql_dir = $Filesystem::LOCAL_MISSION_QUICKLOOK . "/$nyear/$nmonth/$nday";
	&$System::comment("Removing $ql_dir");
	if(-e "$ql_dir") {
	    &$System::perform("/bin/rm -rf $ql_dir");
	}
	else {
	    &$System::comment("Directory $ql_dir does not exist");
	}
	
	# Remove md fits directory in sdtp if it exists
	$ql_dir = $Filesystem::LOCAL_MISSION_QUICKLOOK_FITS . "/$nyear/$nmonth/$nday";
	&$System::comment("Removing $ql_dir");
	if(-e "$ql_dir") {
	    &$System::perform("/bin/rm -rf $ql_dir");
	}
	else {
	    &$System::comment("Directory $ql_dir does not exist");
	}
    }
}

=pod
sub generate_summary_files {
    &$System::stage_title("Pipeline::generate_summary_files : Generating summary files");

    # TEMP
    my $HOME = "/Users/mcrw";
    my $year = 2019;
    my $month = "08";
    my $day = 22;
    my $syear = 2019;
    my $smonth = "08";
    my $sday = 22;
    my $rescue_translation_log = "foo";
    my $data_loss_log = "data_loss";
    my @post_reformat = [1,2,3];
    my $number_missing = 10;
#    my $number_pre_decompression = 100;
#    my $number_post_decompression = 99;
    my $eis_plan_found_msg = "EIS plan found";

    
    my $expected_number_of_rasters;
    my $ccsds_missing_file = "$Filesystem::DARTS_MISSION/$Dates::year/$Dates::month/packet_check/ccsds_hdrs.$Dates::start_date_string.txt";
    my $plan_file = "$Filesystem::DARTS_STAGING/eis_plan/eis_plan_$Dates::start_date_string.txt";

    &$System::stage_step("Check for existence of a plan file");
    # This will be set to 1 if the file exists, 0 otherwise
    my $eis_plan_found = stat $plan_file;
    #goto skip_summary_header if ! $continue_summary;
    $eis_plan_found_msg = "No EIS plan found" unless $eis_plan_found;
    &$System::comment($eis_plan_found_msg);

    &$System::stage_step("Estimate number of planned rasters (files)");
    if($eis_plan_found) {
	$expected_number_of_rasters = `$Program::PLANNED_RASTERS $plan_file`;
	chomp $expected_number_of_rasters;
	
	&$System::perform("$Program::ESTIMATE_RASTERS $plan_file > ~/tmp/rasters_for_plan.txt");
    }
    else {
	$expected_number_of_rasters = 0;
    }
    &$System::comment("Number of estimated rasters: $expected_number_of_rasters");

    my $plan_index = 0;
    if(open PLN, "< $HOME/tmp/rasters_for_plan.txt") {
	while(<PLN>) {
	    chomp;
	    next if /^TL/;
	    my ($sd, $st, $ed, $et) = split; # ??????
	}
	close PLN;
    }
    
    &$System::stage_step("Count number of exposures");
    # Output format: filename	packets_per_exposure	number_of_exposures	timeline_id	reps_req	reps_done	RID	MID	Fx	Fy	ExpPerPos	data_volume	acronym
    &$System::perform("$Program::EXPOSURE_COUNT < $Filesystem::DARTS_MISSION/$year/$month/packet_check/md_hdrs.$year$month$day.html > $HOME/tmp/packets_per_exposure.txt");
    
    &$System::stage_step("Get ccsds packet missing summary");
    # Output format: filename	packets_received	number_missing		number_of_gaps	date
    &$System::perform("$Program::CCSDS_MISSING_SUMMARY $year$month$day $ccsds_missing_file > ~/tmp/missing.txt");
    my $total_ccsds_packets         = `awk '{ tot += \$2 } END { print tot }' ~/tmp/missing.txt`;
    my $total_ccsds_packets_missing = `awk '{ tot += \$3 } END { print tot }' ~/tmp/missing.txt`;
    my $total_gaps                  = `awk '{ tot += \$4 } END { print tot }' ~/tmp/missing.txt`;
    my $total_files                 = `/usr/bin/grep eis_md ~/tmp/missing.txt | wc -l`;
    chomp $total_files;
    chomp $total_ccsds_packets;
    chomp $total_ccsds_packets_missing;
    chomp $total_gaps;
        
    #
    # put in exposures_missing_packets.pl output here, send to fold_reports.pl
    #
    # Output: filename	hdrs
    &$System::stage_step("Count number of exposures missing");
    &$System::perform("$Program::EXPOSURES_MISSING_PACKETS < $ccsds_missing_file > $HOME/tmp/exp_missing.txt");
    &$System::stage_step("Get sequence count continuity check");
    &$System::perform("$Program::SEQUENCE_CONT_CHECK < $Filesystem::DARTS_MISSION/$year/$month/packet_check/sequence_counts_$year$month$day.txt > $HOME/tmp/seq_cont.txt");
    &$System::stage_step("Combine reports");    
    if($Flags::RESCUE_MOD) {
	#    $rescue_translation_log = "$darts_staging/logs/md_translation/rescue/md_translation_rescue_" . "$sdate" . "_" . "$eday" . ".txt";
	&$System::perform("$Program::FOLD_REPORTS_MOD $HOME/tmp/missing.txt $HOME/tmp/packets_per_exposure.txt $Data::translate_log $HOME/tmp/exp_missing.txt $HOME/tmp/reformat_summary.txt $HOME/tmp/seq_cont.txt $rescue_translation_log $data_loss_log");
    }
    else {
	&$System::perform("$Program::FOLD_REPORTS $HOME/tmp/missing.txt $HOME/tmp/packets_per_exposure.txt $Data::translate_log $HOME/tmp/exp_missing.txt $HOME/tmp/reformat_summary.txt $HOME/tmp/seq_cont.txt");
    }
    
    
    #??
    #perform(*LOG, $state, "/bin/mv ~/tmp/missing.txt $staging/packet_summary/summary_$syear$smonth$sday.txt");
    
    # Get total number of exposures expected and got
    my $total_exps_expected = `awk '{ tot += \$3 * \$11 } END { print tot }' $HOME/tmp/packets_per_exposure.txt`;
    $total_exps_expected = -1 if $total_exps_expected == 0;
    
    my $total_exps_got = `awk '/^Filename/ { next } { tot += \$8 } END { print tot }' $HOME/tmp/reformat_summary.txt`;
    chomp $total_exps_got;
    
    
    &$System::stage_step("Create summary");
    #if(open SUMMARY, "$staging/packet_summary/summary_$syear$smonth$sday.txt") {
    if(open SUMMARY, "> $HOME/tmp/ref_sum.txt") {
	#    print SUMMARY "Summary for the plan from $sd $st to $ed $et\n";
	print SUMMARY "Summary for the plan from $Dates::sdate $Dates::stime to $Dates::edate $Dates::etime\n\n";
	my $fits_num = scalar(@post_reformat);
	chomp $fits_num;
	if($eis_plan_found) {
	    print SUMMARY "Rasters Planned          : ", sprintf("%6u", $expected_number_of_rasters), "\n";
	}
	else {
	    print SUMMARY "\nNo EIS plan file was available. A complete summary cannot be generated.\n\n";
	}
	print SUMMARY "Rasters (files) Received : ", sprintf("%6u", $total_files), "\n";
	print SUMMARY "Number Of Damaged Files  : ", sprintf("%6u", $number_missing), "\n";
	print SUMMARY "File Damage Rate         : ", sprintf("%6.2f", ($total_files == 0) ? 0.0 : ($number_missing / $total_files) * 100.0), "%\n";
	print SUMMARY "Files Pre Decompression  : ", sprintf("%6u", $Data::number_pre_decompression), "\n";
	print SUMMARY "Files Post Decompression : ", sprintf("%6u", $Data::number_post_decompression), "\n";
	print SUMMARY "Number Of Fits Files     : ", sprintf("%6u", $fits_num), "\n";
	print SUMMARY "Expected Exposures       : ", sprintf("%6u", $total_exps_expected), "\n";
	print SUMMARY "Actual Exposures         : ", sprintf("%6u", $total_exps_got), "\n";
	print SUMMARY "Exposure Loss            : ", sprintf("%6.2f", ($total_exps_expected == 0) ? 0.0 : 100.0 - ($total_exps_got / $total_exps_expected) * 100.0), "%\n";; 
	print SUMMARY "Total Ccsds Packets      : ", sprintf("%6u", $total_ccsds_packets), "\n";
	print SUMMARY "Ccsds Packets Missing    : ", sprintf("%6u", $total_ccsds_packets_missing), "\n";
	print SUMMARY "Ccsds Packets Loss Rate  : ", sprintf("%6.2f", ($total_ccsds_packets == 0) ? 0.0 : ($total_ccsds_packets_missing / $total_ccsds_packets) * 100.0), "%\n";
	print SUMMARY "Number Of Gaps           : ", sprintf("%6u", $total_gaps), "\n\n";
	close SUMMARY;
    }
    
    &$System::stage_step("Copy reports to DARTS");
    if($Flags::TESTING) {
	&$System::perform("/bin/cat $HOME/tmp/ref_sum.txt $HOME/tmp/reformat_summary.txt > $Filesystem::DARTS_STAGING/reformat_summary/summary_$syear$smonth$sday" . "_TEST.txt");
    }
    else {
	&$System::perform("/bin/cat $HOME/tmp/ref_sum.txt $HOME/tmp/reformat_summary.txt > $Filesystem::DARTS_STAGING/reformat_summary/summary_$syear$smonth$sday.txt");
	&$System::perform("/bin/cat $HOME/tmp/ref_sum.txt $HOME/tmp/reformat_summary.txt > $Filesystem::DARTS_STAGING/reformat_summary/$syear/summary_$syear$smonth$sday.txt");
    }

    &$System::stage_step("Remove temporary file");
    &$System::perform("/bin/rm $HOME/tmp/reformat_summary.txt");
    
    ###perform(*LOG, $state, "/bin/rm $HOME/tmp/ref_sum.txt $HOME/tmp/reformat_summary.txt $HOME/tmp/packets_per_exposure.txt $HOME/tmp/missing.txt $HOME/tmp/exp_missing.txt $HOME/tmp/rasters_for_plan.txt");
    
    &$System::stage_step("Update latest reformat file");
    &$System::perform("/bin/echo $Dates::sdate $Dates::edate $Dates::stime $Dates::etime > $Filesystem::MISSION_LATEST_REFORMAT_FILE") unless $Flags::TESTING;
    
}
=cut

=pod
sub eng_path {
    my $type = shift;

    return "/cal/dark/long/"         if $type eq "Long Darks";
    return "/cal/dark/short/"        if $type eq "Short Darks";
    return "/cal/flat/long/"         if $type eq "Long Flats";
    return "/cal/flat/short/"        if $type eq "Short Flats";
    return "/cal/flat/EUV/"          if $type eq "EUV";
    return "/cal/adc/"               if $type eq "ADC Offset";
    return "/cal/intensity/"         if $type eq "Intensity Calibration";
    return "/cal/dark/bottom_100s/"  if $type eq "Dark Bottom";
    return "/cal/dark/top_100s/"     if $type eq "Dark Top";
    return "/cal/dark/bottom_0s/"    if $type eq "Dark Bottom 0s";
    return "/cal/dark/top_0s/"       if $type eq "Dark Top 0s";
    return "/cal/flat/overscan/"     if $type eq "Flat Oscn";
#    return "/cal/alignment/"	     if $type eq "Pointing and Alignment";
    return "/cal/dark/reduced_long/" if $type eq "Reduced Long";
    return "/cal/dark/prescan/"      if $type eq "Dark Prescan";
    return "/cal/dark/0s_100s/"	     if $type eq "Dark Daily";
    return "/cal/flat/1exp_100ms/"   if $type eq "1exp_100ms";
    return "/cal/flat/2exps_80ms/"   if $type eq "2exps_80ms";
    return "";
}
=cut

# In ../Pipeline.pm
#sub exit_pipeline {
#    my $code = shift;
#    my $message = shift;
#    
#    &$System::stage_title("Pipeline::exit_pipeline : Exiting");
#
#    if (($Flags::cron) && (! $Flags::cron_pending)) {
#	cron_finished($code, $message);
#    }
#    pipeline_exit($code, $message);
#}

=pod
sub pipeline_send_mail {
    my $message = shift;

    my $to = 'misterfluff@me.com';
    my $from = 'misterfluff@me.com';
    my $subject = 'Test Email';
 
    if (open(MAIL, "|/usr/sbin/sendmail -t")) {
 
# Email Header
	print MAIL "To: $to\n";
	print MAIL "From: $from\n";
	print MAIL "Subject: $subject\n\n";
# Email Body
	print MAIL $message;

	close(MAIL);
	print "Email Sent Successfully\n";
    }
    else {
	print "Couldn't send email: $!\n";
    }
}
=cut

1;
