package Plan;

# A lot of stuff moved to Mission.pm

print "HINODE/EIS/EISPIPELINE/EISMISSION/PLAN.PM\n";

use strict;
use warnings;

use Trace::Trace;

use Hinode::EIS::EisPipeline::Dates;                                                                                    
use Hinode::EIS::EisPipeline::EisMission::Constants;                                                                    
use Hinode::EIS::EisPipeline::EisMission::Dates;                                                                        
use Hinode::EIS::EisPipeline::EisMission::Mission;                                                                      
use Hinode::EIS::EisPlan::Plan;
use Hinode::EIS::EisRasters::Rasters;

sub parse_plan {
#    my $self = shift;                                                                                                  
    Trace::trace((caller(0))[3]);

    ($eis_plan_found, $plan_file) = Mission::find_eis_plan();
#    ($Dates::sdate, $Dates::stime, $Dates::edate, $Dates::etime) = Plan::parse_plan($plan_file) if $eis_plan_found;    
    my ($sdate, $stime, $edate, $etime) = Plan::parse_plan($plan_file) if $eis_plan_found;

}

sub read_plan_file {
    Trace::trace((caller(0))[3]);

    ($eis_plan_found, $plan_file) = Mission::find_eis_plan();
#    ($Dates::sdate, $Dates::stime, $Dates::edate, $Dates::etime) = Plan::parse_plan($plan_file) if $eis_plan_found;    
    my ($sdate, $stime, $edate, $etime) = Plan::parse_plan($plan_file) if $eis_plan_found;

    $Dates::sdate = Dates::convert_plan_date($sdate);
    $Dates::edate = Dates::convert_plan_date($edate);
    $Dates::stime = Dates::convert_plan_time($stime);
    $Dates::etime = Dates::convert_plan_time($etime);

    # Debug!                                                                                                            
    Dates::dump_dates_and_times();

    return $eis_plan_found;
}

# First draft:  go back x days from today and search forward                                                            
# Second draft: use log to record plan done and search forward from there                                               
sub find_eis_plan {
    Trace::trace((caller(0))[3]);

    print "start day offset = ", Constants::START_DAY_OFFSET, "\n";
    print "end   day offset = ", Constants::END_DAY_OFFSET, "\n";

    my $offset = Constants::START_DAY_OFFSET;
    my $find_date;
    my $plan_file;
    foreach my $attempt (0 .. Constants::MAX_ATTEMPTS) {
        $find_date = Dates::other_date($offset + $attempt, as_string => 1);
        $plan_file = $Filesystem::PLAN_DIR . "/eis_plan_" . $find_date . ".txt";
        print "Looking for $plan_file\n";
        last if ($eis_plan_found = stat $plan_file);
#       if ($eis_plan_found = stat $Filesystem::PLAN_DIR . "/eis_plan_" . $find_date . ".txt") {                        
#           print "FOUND PLAN $find_date ($eis_plan_found)\n";                                                          
#           last;                                                                                                       
#       }                                                                                                               
    }
    print "FOUND PLAN $find_date ($eis_plan_found, $plan_file)\n";
    return ($eis_plan_found, $plan_file);
}



1;
