package Program;

#print "HINODE/EIS/EISPIPELINE/EISMISSION/PROGRAM.PM\n";

use strict;
use warnings;

use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::Program;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisMission/Program\n";
}

our $MD_SPLIT_CHECK            = $Program::BIN . "/ccsds_merge_md_split_check";
our $MD_JOIN                   = $Program::BIN . "/md_join_merge.py";
our $MD_HEADER_DUMP            = $Program::BIN . "/pipeline_md_hdr_dump";
our $CCSDS_PACKET_CHECK        = $Program::BIN . "/pipeline_ccsds_check";

our $SLIM                      = $Program::BIN . "/slim.pl";
our $ALT_SLIM                  = $Program::BIN . "/slim.awk";
our $SLIM_RESCUE               = $Program::BIN . "/slim_rescue.awk";

our $FITS_STUDY_METRIC         = $Program::BIN . "/fits_study_metric.pl";
our $FITS_HEADER_DUMP          = $Program::BIN . "/fits_header_dump";

our $PLANNED_RASTERS           = $Program::BIN . "/rasters_for_plan.sh";
our $ESTIMATE_RASTERS          = $Program::BIN . "/estimate_rasters1.pl";
our $EXPOSURE_COUNT            = $Program::BIN . "/exposure_count.pl";
our $CCSDS_MISSING_SUMMARY     = $Program::BIN . "/ccsds_missing_summary1.pl";
our $EXPOSURES_MISSING_PACKETS = $Program::BIN . "/exposures_missing_packets.pl";
our $SEQUENCE_CONT_CHECK       = $Program::BIN . "/sequence_count_continuity_check.pl";
our $FOLD_REPORTS_MOD          = $Program::BIN . "/fold_reports1.pl";
our $FOLD_REPORTS              = $Program::BIN . "/fold_reports.pl";

our $CHECK_TABLE_RESCUE       = $Program::BIN . "/rescue_chk_tbl.sh -m ";
our $RESCUE                   = $Program::BIN . "/rescue.sh -m ";
our $NEW_RESCUE               = $Program::BIN . "/new_rescue";

our $MD_DECOMP                = $Filesystem::TEMP_IDL . "/md_decomp.pro";
our $RESCUE_DECOMP            = $Filesystem::TEMP_IDL . "/rescue_md_decomp.pro";
our $DECOMP_ALT               = $Filesystem::TEMP_IDL . "/md_decomp_alt.pro";
our $MD_REFORMAT              = $Filesystem::TEMP_IDL . "/md_reformat.pro";
our $DATA_LOSS                = $Filesystem::TEMP_IDL . "/dl.pro";
our $CHECK_DUMP               = $Filesystem::TEMP_IDL . "/chk.pro";
our $MD_FITS                  = $Filesystem::TEMP_IDL . "/md_fits.pro";

our @schedule_readers = [\&Mission::read_orl_file, \&Mission::read_schedule_file];

our %schedule_reader = ("v1" => \&Mission::read_orl_file,
#                       "v2" => \&Mission::read_schedule_file);
                        "v2" => \&Mission::read_plan_file);

1;
