#!/usr/bin/perl

# The home directory on the pgN machines
#$HOME="/san_solar/disk2/home/sbukeis";
#$WORK="/san_solar/disk3/work/eis";

# 20080821 mcrw - changed for new machine
$HOME="/home/sbukeis";
$WORK="/nasA_solar1/work/eis";


# Local stuff
###$eis_local    = "$HOME/work";
$eis_local    = "$WORK";

# Pipeline log
#$pipeline_log = "$eis_local/localdata/log/pipeline/pipeline_log.txt";
$pipeline_log = "$eis_local/localdata/log/pipeline";

# Shutter open/close log
$shutter_log = "$eis_local/localdata/log/shutter";

# Pipeline directories
$eis_pipeline = "$eis_local/localdata/pipeline";
$temp_fits    = "$eis_pipeline/fits";
$temp_idl     = "$eis_pipeline/idl";
$temp_plots   = "$eis_pipeline/plots";

# Pass list directory
$pass_list_dir = "$eis_local/pass_list";

# Pass list directory
$orl_dir = "$eis_local/orl_list";

$drl_dir = "$eis_local/dr_list";

# Orbit events list directory
$obev_dir = "$eis_local/orbit_events";

# Where sswidl is on the pgN machines
$sswidl = "/san_darts/solar/ssw/gen/setup/ssw_idl";

# Local idl routines
$local_idl = "$eis_local/idl";

# Root local telemetry directory
$sdtp = "$eis_local/localdata/sdtp";

# Quicklook area on pg4
$ql_mission      = "$sdtp/md";
$ql_status       = "$sdtp/status";
$ql_mission_fits = "$sdtp/fits/mission";
$ql_status_fits  = "$sdtp/fits/status";
$ql_status_plots = "$sdtp/plots";

# The directory where telemetry files got by daily_merge.pl are temporarily written
$merge_dir = "$sdtp/merge";

# The directory where rescued incomplete files are put
$rescue_dir = "$merge_dir/rescued";

# The DARTS root directory
$darts   = "$HOME/data";
$staging = "$darts/staging";

# Quicklook area on DARTS
$darts_quicklook  = "$darts/quicklook";
$darts_mission_ql = "$darts_quicklook/mission";
$darts_status_ql  = "$darts_quicklook/status";

# The mission branch
$darts_mission = "$darts/mission";

# The status branch
$darts_status = "$darts/status";

# The staging area
$darts_staging = "$darts/staging";

# The new merge telemetry DARTS area
$soda_darts = "/soda/hinode/eis";

# The new mission branch
$soda_darts_mission = "$soda_darts/level0";

# The new status branch
$soda_darts_status = "$soda_darts/status";

# Scratch area for spliced md archives (created by ccsds_md_splice)
$splice_dir = "$sdtp/md/scratch";

# Decompression track
# Decompression directory
$pd_decompression_dir = "$eis_local/localdata/log/decompression";

# Monthly records
$pd_monthly_records = "$pd_decompression_dir/monthly/records";

# Monthly track
$pd_monthly_tracks = "$pd_decompression_dir/monthly/track";

# Running average
$pd_type_average = "$pd_decompression_dir/factors";

# Decompression record
$pd_record_name = "merge_decomp_record";

# Add text argument
sub pipeline_exit {
    my $pipeline = shift;
    my $exit_code = shift;

    print LOG "---------\n\n";
    close LOG;
 
    print MLOG scalar(localtime), " (JST) finished.\n";
    print MLOG "---------\n\n";
    close MLOG;

    system("/bin/cp $pipeline_log/pipeline_log.txt $staging/logs/")        if(($pipeline eq "mission") || ($pipeline eq "status"));
    system("/bin/cp $pipeline_log/pipeline_log_rescue.txt $staging/logs/") if($pipeline eq "rescue");
    system("/bin/cp $pipeline_status_log $staging/logs/pipeline_status")   if($pipeline eq "status");
    system("/bin/cp $pipeline_mission_log $staging/logs/pipeline_mission") if(($pipeline eq "mission") || ($pipeline eq "rescue"));

    exit $exit_code;
}

sub pipeline_die {
    my $pipeline = shift;
    my $code = shift;
    my $str = shift;

    print MLOG "$str\n";
    pipeline_exit($pipeline, $code);
}

sub date_to_natural_lang {
    my $year = shift;
    my $month = shift;

    my @months = ('','January','February','March','April','May','June','July','August','September','October','November','December');

    return "$months[$month] " . "$year";
}

sub stage_title {
    my $fh  = shift;
    my $int = shift;
    my $str = shift;
    my $ct  = scalar(localtime);
    my $cts = "$ct (JST) - ";

    print STDOUT "$cts" . "$str\n" if $int eq "interactive";
    print $fh    "\n$cts" . "$str\n";
}

sub perform {
    my $fh  = shift;
    my $int = shift;
    my $str = shift;

    log_msg($fh, $int, $str);
    system("$str");
}

sub log_msg {
    my $fh   = shift;
    my $mode = shift;
    my $msg  = shift;

    print STDOUT "$msg\n" if $mode eq "interactive";
    print $fh  "\t$msg\n";
}

sub gen_fh {
    my $fh = shift;
    return sub { $fh; };
}

sub logger {
    my $stdout = shift;
    my $fh = shift;
    if($stdout == 1) {
	return sub {
	    my $msg = shift;
	    print STDOUT "$msg\n";
	    print $fh "$msg\n";
	};
    }
    return sub {
	my $msg = shift;
	print $fh "$msg\n";
    };
}

# Return the (log, perform, title) functions for interactive or cron modes
#sub init_logger {
sub init_log_and_perform {
    my $filehandle = shift;
    my $state      = shift;
    my $fh = gen_fh($filehandle);
    my $out_fh = ($state eq "interactive") ? 1 : 0;
    my $log_it = logger($out_fh, $filehandle);
    return ( 
	     sub {
		 my $msg = shift;
		 &$log_it("\t" . $msg);
	     },
	     sub {
		 my $cmd = shift;
		 &$log_it("\t" . $cmd);
		 system($cmd);
	     },
	     sub {
		 my $title = shift;
		 &$log_it($title);
	     });
}

sub eng_path {
    my $type = shift;

    return "/cal/dark/long/"        if $type eq "Long Darks";
    return "/cal/dark/short/"       if $type eq "Short Darks";
    return "/cal/flat/long/"        if $type eq "Long Flats";
    return "/cal/flat/short/"       if $type eq "Short Flats";
    return "/cal/flat/EUV/"         if $type eq "EUV";
    return "/cal/adc/"              if $type eq "ADC Offset";
    return "/cal/intensity/"        if $type eq "Intensity Calibration";
    return "/cal/dark/bottom_100s/"      if $type eq "Dark Bottom";
    return "/cal/dark/top_100s/"         if $type eq "Dark Top";
    return "/cal/dark/bottom_0s/"      if $type eq "Dark Bottom 0s";
    return "/cal/dark/top_0s/"         if $type eq "Dark Top 0s";
    return "/cal/flat/overscan/"    if $type eq "Flat Oscn";
#    return "/cal/alignment/"	    if $type eq "Pointing and Alignment";
    return "/cal/dark/reduced_long/" if $type eq "Reduced Long";
    return "/cal/dark/prescan/"      if $type eq "Dark Prescan";
    return "/cal/dark/0s_100s/"	     if $type eq "Dark Daily";
    return "/cal/flat/1exp_100ms/"    if $type eq "1exp_100ms";
    return "/cal/flat/2exps_80ms/"    if $type eq "2exps_80ms";
    return "";
}

sub html_header {
    my $title = shift;

    my $hdr;

    $hdr = <<HERE;
    <!--
    <?xml version="1.0" encoding="ISO-8859-1" ?>
    -->
      
    <!DOCTYPE HTML PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
      
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
      
    <head>
    <meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
    <script type="text/javascript" src="stripe.js"></script>

    <title>
    $title
    </title>

    </head>
HERE
return $hdr;
}

sub html_end {
    print "</body>\n</html>\n";
}

1;
