package Data;

print "HINODE/EIS/EISPIPELINE/EISSTATUS/DATA.PM\n";

use strict;
use warnings;

use File::Basename;

use Trace::Trace;

use Hinode::EIS::EisCcsds::EisStatus;

use Hinode::EIS::EisPipeline::Common;
use Hinode::EIS::EisPipeline::Dates;
use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::Flags;
use Hinode::EIS::EisPipeline::Pipeline;
use Hinode::EIS::EisPipeline::Program;
use Hinode::EIS::EisPipeline::System;
use Hinode::EIS::EisPipeline::Util;

use Hinode::EIS::EisPipeline::EisStatus::Dates;
use Hinode::EIS::EisPipeline::EisStatus::Filesystem;
use Hinode::EIS::EisPipeline::EisStatus::Program;
use Hinode::EIS::EisPipeline::EisStatus::Status;

#use LibCcsds::CcsdsReader;
use LibCcsds::CcsdsWriter;
use LibCcsds::GapCcsdsReader;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisStatus/Data\n";
}

#my @received_files = ();
#my @joined_files = ();
#my @damaged_files = ();

#our $translate_log = "";
#our $translate_rescue_log = "";
#our %translate = ();

#our @empty_files = ();

#our @non_compressed_files = ();
#our $number_pre_decompression = 0;
#our $number_post_decompression = 0;

#our %create_reformat_idl_program = (
#    'v1' => \&create_v1_reformat_idl_program,
#    'v2' => \&create_v2_reformat_idl_program,
#    );

# Fetch ccsds packets from SIRIUS
# Stage function.
sub fetch {

    Trace::trace((caller(0))[3]);

    my $ant  = 'usc34';	# Not needed for merge as sdtp will substitute merge antenna
    my $band = 3;	# Merge telemetry
    my $mode = 'status_merge';	# Merge telemetry

###    &$System::stage_title("Data::fetch : Fetch data and place in the received directory");

    &$System::stage_step("Fetch ccsds packets");
    my $index = 0;

    foreach my $start (@Dates::stimes) {
	# To be able to use receive_dir need to change sdtp.pl
	my $end_date_string = ($index == 15) ? $Dates::edate : $Dates::sdate;
	&$System::perform("$Program::SDTP_FETCH $mode $ant band=$band sdate=$Dates::sdate edate=$end_date_string stime=$start etime=$Dates::etimes[$index]");
	++$index;
    }

    # Remove mission files
    &$System::stage_step("Remove mission packets if any");
    my @received_files = &$System::list($Filesystem::MERGE_DIR, "eis_md*");
    if (@received_files) {
	&$System::perform("/bin/rm $Filesystem::MERGE_DIR/eis_md*");
	# Log success
    }
    # Log no files to remove
    
    # Remove dmp files
#    &$System::stage_step("Remove memory dump packets");
#    &$System::perform("/bin/rm $System::MERGE_DIR/eis_dmp*");

    if ($Flags::FETCH_ONLY_FLAG) {
	&$System::comment("Exiting because the FETCH_ONLY_FLAG is set");
	return;
    }
}


# Ccsds packet checks
# Stage function
sub check {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Data::check : Status data check");

    &$System::stage_step("Count number of received status files");
    my @received_files = &$System::list($Filesystem::MERGE_DIR, "eis_sts*");
    my $nreceived_files = @received_files;

    System::dprint("Received $nreceived_files status files");

    if(! @received_files) {
	&$System::comment("No ccsds status data files");

	# Alternative method                                                                                            
        # Read entire pending file                                                                                      
        open FH, "< $Common::STATUS_PENDING_FILE" or Pipeline::pipeline_die(999, "Can't open pending file: $!");
        my @text = <FH>;
        close FH;

        # Get number of entries in file                                                                                 
        my $n_entries = scalar @text;

        # If there are no entries then just put this straight into the file                                             
        if ($n_entries == 0) {
            ### FIX ME &$System::perform("/bin/echo '1 -p $Dates::sdate $Dates::edate >> $Common::STATUS_PENDING_FILE'");
        }
        else {
            # Loop through text, try to match existing entry                                                            
            foreach my $line (@text) {
                chomp $line;
                my @items = split / /, $line;
                my $n_items = scalar @items;
                my $field = 0;
                $field = $n_items - 2 if (($n_items == 4) || ($n_items == 3));
                if ($items[$field] eq $Dates::sdate) {
                    ###my $n = $items[0];
                    my $n = $items[0];
                    if ($n < 14) {
                        ++$n;
                        ### FIX ME &$System::perform("/bin/echo $n -p $Dates::sdate $Dates::edate >> $Common::STATUS_PENDING_FILE");
                    }
                    else {
			Pipeline::main_log_message("No ccsds packets available for 14 days - giving up on plan.");
                    }
                    last;
                }
            }
        }
        # End of alternative version

	# Does the current date already exist in the controller file?
	my $exists = `$Program::GREP -n '$Dates::sdate $Dates::edate' $Common::STATUS_PENDING_FILE`;
	
#	if(Delta_Days($syear1,$smonth1,$sday1,$today[5],$today[4],$today[3]) < 14) {
#	    # Write out start/end date to controlling file if not
#	    `/bin/echo $sdate $edate $stime $etime >> ~/track/mission_pending.txt` if $exists eq "";
#	}
#	else {
#	    print MLOG "\t*** Giving up with plan for $sdate $edate $stime $etime - no ccsds packets ***\n";
#	}

###	`/bin/echo $Dates::sdate $Dates::edate >> $Filesystem::STATUS_PENDING_FILE` if $exists eq "";
	&$System::stage_step("Reschedule status reformatter");
	### FIX ME &$System::perform("/bin/echo -p $Dates::sdate $Dates::edate >> $Common::STATUS_PENDING_FILE") if $exists eq "";
	&$System::stage_step("Copy pending file to DARTS");
	### FIX ME &$System::perform("/bin/cp $Common::STATUS_PENDING_FILE $Filesystem::DARTS_LOGS_DIR");

	Pipeline::main_log_message("No ccsds packets available");
	#Pipeline::pipeline_exit(1, "No ccsds packets available");
	Pipeline::pipeline_die(1, "No ccsds packets available");
	#Pipeline::pipeline_warn(1, "No ccsds packets available");
    }

    &$System::comment("Received $nreceived_files ccsds status data files");

=pod
    # Does this at end after sucessful run
    &$System::stage_step("Update latest reformat file and copy to DARTS");
    &$System::perform("unset noclobber");
    ### &$System::perform("/bin/echo $Dates::sdate > $Common::STATUS_REFORMAT_FILE");
    ### &$System::perform("/bin/cp $Common::STATUS_REFORMAT_FILE $Filesystem::DATA_STAGING_LOGS_DIR");
    &$System::perform("set noclobber");
=cut

    Pipeline::pipeline_exit(0, "FORCE_REFORMAT flag set") if $Flags::FORCE_REFORMAT;
}


# Stage function.
sub split_status_files {
    Trace::trace((caller(0))[3]);

#############    &$System::stage_title("Data::split_status_files : Split status files into types");
    
    &$System::stage_step("Get a list of all received status files");
    my @files = &$System::list($Filesystem::MERGE_DIR, "eis_sts*");
    my $nstatus_files = @files;

    &$System::log("Number of received status files is $nstatus_files");
    System::dprint("Number of received status files is $nstatus_files");

###    return; # TEMP!

#    my $reader = GapCcsdsReader->new(packet_type => 'Eis');
    my $reader = CcsdsReader->new(packet_type => 'Eis');
    my $writer = CcsdsWriter->new(packet_type => 'Eis');

    $reader->trace_off();
    &$System::stage_step("Split received ccsds files into status types");
    foreach my $file (@files) {
	chomp $file;
	if ($reader->open($file)) {
	    #foreach my $status_type (@EisCcsds::status_types) {
	    foreach my $status_type (@EisStatus::status_types) {
		my $base = basename($file);
		#my $of = $Filesystem::SPLIT_DIR . "/" . $base . "_" . $EisCcsds::status_suffix{$status_type};
		my $of = $Filesystem::SPLIT_DIR . "/" . $base . "_" . $EisStatus::status_suffix{$status_type};
		if ($writer->open($of)) {
		    &$System::comment("Split $file to $of");
		    while (1) {
			#last unless $reader->nextPacketWithApid($EisCcsds::status_apids{$status_type});
			last unless $reader->nextPacketWithApid($EisStatus::status_apids{$status_type});
			$writer->writePacket($reader->packet());
#			$reader->packet()->printPrimaryHeader();
		    }
		    $writer->closeOutput();
		    $reader->rewind();
		}
		else {
		    &$System::comment("Failed to open $of for writing");
		}
	    }
	    $reader->closeInput();
	}
	else {
	    &$System::comment("Data::split : failed to open $file for reading");
	}
    }
}

# STS1_20200604_0000.log
sub split_timing_files {
    Trace::trace((caller(0))[3]);

########    &$System::stage_title("Data::split_timing_files : Split status timing files into types");

    &$System::stage_step("Get a list of all received timing files");
    my @files = &$System::list($Filesystem::TIMING_LOG_DIR, "*.log");
    my $ntiming_files = @files;

    &$System::log("Number of timing files in $Filesystem::TIMING_LOG_DIR is $ntiming_files");
    System::dprint("Number of timing files in $Filesystem::TIMING_LOG_DIR is $ntiming_files");
###    return; # TEMP!

    &$System::stage_step("Split timing files according to status type");

#    print "FILES: @files\n";

#    print "Status types: @EisStatus::status_types\n";

    foreach my $file (@files) {
	chomp $file;
	my $f = basename($file);
	my ($file1, $dir, $ext) = fileparse($f, qr/\..*/);
#	print "FILE1, DIR, EXT = $file1, $dir, $ext\n";
	#foreach my $type (@EisCcsds::status_types) {
	    #my $f1 = $EisCcsds::status_logs_suffix{$type} . "_" . $file1 . ".log";
	foreach my $type (@EisStatus::status_types) {
	    my $f1 = $EisStatus::status_logs_suffix{$type} . "_" . $file1 . ".log";
#	    print "f1 = $f1\n";
#	    print "Performing `(awk '/$type/ { print \$11 }' < $file | uniq) > $Filesystem::TIMING_OUTPUT_DIR/$f1`";
	    #System::dprint("Performing `(awk '/$type/ { print \$11 }' < $file | uniq) > $Filesystem::TIMING_OUTPUT_DIR/$f1`");
	    &$System::perform("`(awk '/$type/ { print \$11 }' < $file | uniq) > $Filesystem::TIMING_OUTPUT_DIR/$f1`");
	}
    }    
}

# Stage function.
sub prepare_timing_files {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Data::prepare_timing_files : Split status timing files into types");

    if ($Flags::REFORMAT_VERSION eq "v1") {
	&$System::log("Skipping stage as REFORMAT_VERSION flag is set to v1");
	return;
    }

    &$System::run_stage(\&Data::split_timing_files, "Data::split_timing_files : split the status timing files...");
    &$System::run_stage(\&Data::split_status_files, "Data::split_status_files : split the status files...");
#    split_timing_files();
#    split_status_files();
}

# Sun Jun 28 23:21:38 2020 (JST) - Copying status ccsds files to DARTS (TEMPORARY)
#/bin/mkdir /home/sbukeis/data/status/2020/06/24/ccsds
#    /bin/mv /home/sbukeis/work/localdata/sdtp/merge/eis_sts* /home/sbukeis/data/status/2020/06/24/ccsds
#    /bin/mv /home/sbukeis/work/localdata/sdtp/merge/eis_dmp* /home/sbukeis/data/status/2020/06/24/ccsds
#    (cd /home/sbukeis/data/status/2020/06/24/ccsds/ ; status_sequence_counts.pl eis_sts* > 20200624_sequence_counts.txt)gzip -f /home/sbukeis/data/status/2020/06/24/ccsds/eis_sts*
#    gzip -f /home/sbukeis/data/status/2020/06/24/ccsds/eis_dmp*

sub process_ccsds_files {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Data::process_ccsds_files : Get sequence count info and move the ccsds status files and dmp files (if any) to DARTS");

    my $dest_dir = Util::makePath($Filesystem::DARTS_STATUS_DIR, $Dates::syear, $Dates::smonth, $Dates::sday, "ccsds");

    my $seq_count_file = $dest_dir . "/" . $Dates::start_date_string . "_sequence_counts.txt";

    &$System::stage_step("Create directory on DARTS for the ccsds files");
    &$System::perform("/bin/mkdir $dest_dir");

    &$System::stage_step("Get the sequence count info");
    &$System::perform("cd $Filesystem::MERGE_DIR && $Status::PROGRAM->{STATUS_SEQ_COUNT} eis_sts* > $seq_count_file");
###    &$System::perform("cd $Filesystem::MERGE_DIR && $Program::STATUS_SEQ_COUNT eis_sts* > $seq_count_file");

    &$System::stage_step("Gzip ccsds files");
    &$System::perform("gzip -f $Filesystem::MERGE_DIR" . "/eis_*");

    &$System::stage_step("Move ccsds status files to directory...");
    &$System::perform("/bin/mv $Filesystem::MERGE_DIR" . "/eis_sts* " . $dest_dir);

    &$System::stage_step("Move ccsds dmp files to directory...");
    &$System::perform("/bin/mv $Filesystem::MERGE_DIR" . "/eis_dmp* " . $dest_dir);
}


sub create_v2_reformat_idl_program {
    my $log_file = shift;

    #Trace::trace(__PACKAGE__."::create_reformat_idl_program");
    Trace::trace((caller(0))[3]);

    &$System::stage_step("Create IDL program");
    my $output = "!quiet=0\n";
    $output .= "run_status_reformatter, start_date='$Dates::sdate', end_date='$Dates::edate', log='$log_file'\n";

#    &$System::stage_step("Write to IDL program $Status::STS_REFORMAT");
#    open(STS_FITS, "> $Status::STS_REFORMAT");
    &$System::stage_step("Write to IDL program $Status::PROGRAM->{STS_REFORMAT}");
    open(STS_FITS, "> $Status::PROGRAM->{STS_REFORMAT}");
###    &$System::stage_step("Write to IDL program $Program::STS_REFORMAT");
###    open(STS_FITS, "> $Program::STS_REFORMAT");
    print STS_FITS $output;
    close STS_FITS;
    
    &$System::comment("IDL file:\n$output");    
}

sub create_v1_reformat_idl_program {
    my $log_file = shift;

    Trace::trace((caller(0))[3]);

    &$System::comment("(IDL) auto_mk_fits, '$Filesystem::MERGE_DIR', '$Filesystem::TEMP_FITS_DIR/'");
    &$System::stage_step("Create IDL program");
    my $output = "!quiet=1\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_ccsds_interface__define\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_make_status_fits\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_ti2utc\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/auto_mk_fits\n";
    $output .= "auto_mk_fits, '$Filesystem::MERGE_DIR', '$Filesystem::TEMP_FITS_DIR/'\n";
    &$System::stage_step("Write to IDL program $Status::PROGRAM->{STS_REFORMAT}");
    open(STS_FITS, "> $Status::PROGRAM->{STS_REFORMAT}");
###    &$System::stage_step("Write to IDL program $Program::STS_REFORMAT");
###    open(STS_FITS, "> $Program::STS_REFORMAT");
    print STS_FITS $output;
    close STS_FITS;
    
    &$System::comment("IDL file:\n$output");    
}

# gdl < status_reformatter_runner.pro
#  run_status_reformatter,start_date='20200604',end_date='20200605',log='/Users/mcrw/Desktop/local_run.txt'
# Kick off the FITS reformat process
sub reformat {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Data::reformat : Status data reformat");

    # FIXME
    my $log_file = $Filesystem::LOCAL_STS_REFORMAT_LOG . "$Dates::start_date_string.txt";

=pod
    if ($Flags::REFORMAT_VERSION eq "v1") {
	&$System::comment("REFORMAT_VERSION flag set to \"v1\", performing v1 reformat");
	create_v1_reformat_idl_program($log_file);
    }
    else {
	&$System::comment("REFORMAT_VERSION flag set to \"v2\", performing v2 reformat");
	create_v2_reformat_idl_program($log_file);
    }
=cut

    &$System::comment("REFORMAT_VERSION flag set to '$Flags::REFORMAT_VERSION', performing $Flags::REFORMAT_VERSION reformat");
#    print("DEBUG: ", $create_reformat_idl_program{$Flags::REFORMAT_VERSION}, "\n");
#    my $idl_program = $create_reformat_idl_program{$Flags::REFORMAT_VERSION};
#    &$idl_program($log_file);
    &{$Program::create_reformat_idl_program{$Flags::REFORMAT_VERSION}}($log_file);

####???    &$System::comment("(IDL) fits_script, '$Filesystem::DECOMPRESSED_DIR', '$Filesystem::FITS_DIR'");

#    my $reformat_log = $System::LOCAL_STS_REFORMAT_LOG . "$Dates::start_date_string" . ".txt";
    #$reformat_log = "/dev/null";
    
    &$System::stage_step("Run IDL program $Program::STS_REFORMAT");
    &$System::perform("$Program::SSWIDL < $Program::STS_REFORMAT 2 >&1 $log_file");
    
    # Changed cp to mv
    &$System::stage_step("Move reformat log to DARTS");
###    &$System::perform("/bin/mv $log_file $Filesystem::DARTS_STAGING/logs/sts_reformat/$Dates::year");
    &$System::perform("/bin/mv $log_file $Filesystem::DARTS_REFORMAT_LOG");	# CHECK!!!
    
    # Get a count of number of status data files here
    &$System::stage_step("Get count of number of fits files");
    my @post_reformat = &$System::list($Filesystem::LOCALDATA_FITS_DIR, "eis_*.fits");
    &$System::comment("Number of reformatted files: " . scalar(@post_reformat) . " (\@post_reformat)");
    
    # TODO: Compare the number of output files with the number of decompressed files. If not the same
    # then restart the reformat after separating out the done from the pending. Assume the first pending
    # file caused the reformat to crash and move that file to a nursery somewhere.
    
}


#Sun Jun 28 23:21:47 2020 (JST) - Removing quicklook status data for 2020/06/24
#    /bin/rm -rf /home/sbukeis/data/quicklook/status/2020/06/24
#    /bin/rm -rf /home/sbukeis/work/localdata/sdtp/status/20200624
#    /bin/rm -rf /home/sbukeis/work/localdata/sdtp/fits/status/20200624
#    /bin/rm -rf /home/sbukeis/work/localdata/sdtp/plots/20200624
=pod
sub remove_quicklook {
    Trace::trace((caller(0))[3]);
    
    my $date_string = Util::makePath($Dates::syear, $Dates::smonth, $Dates::sday);

    &$System::stage_title("Data::remove_quicklook : remove quicklook data for $date_string");

    &$System::stage_step("Remove quicklook files from DARTS");
    &$System::perform("/bin/rm -rf $Filesystem::DARTS_STAGING_STATUS_QUICKLOOK" . "/" . $date_string);
    &$System::stage_step("Remove quicklook files from the local sdtp directory");
    &$System::perform("/bin/rm -rf $Filesystem::SDTP_STATUS_DIR" . "/" . $date_string);
    &$System::perform("/bin/rm -rf $Filesystem::SDTP_STATUS_FITS_DIR" . "/" . $date_string);
    &$System::perform("/bin/rm -rf $Filesystem::SDTP_STATUS_PLOTS_DIR" . "/" . $date_string);
}
=cut

1;

__END__                                                                                                                             
                                                                                                                                    
=head2 NAME                                                                                                                         
                                                                                                                                    
=over 4                                                                                                                             
                                                                                                                                    
=item F<Data.pm>                                                                                                                    
                                                                                                                                    
=back                                                                                                                               
                                                                                                                                    
=head3 VERSION                                                                                                                      
                                                                                                                                    
=over 4                                                                                                                             
                                                                                                                                    
=item 0.1                                                                                                                           
                                                                                                                                    
=back                                                                                                                               
                                                                                                                                    
=head3 SYNOPSIS                                                                                                                     
                                                                                                                                    
=head3 DESCRIPTION                                                                                                                  
                                                                                                                                    
This package provides functions for manipulating the received status data.                                                          
                                                                                                                                    
=head3 PACKAGE VARIABLES                                                                                                            
                                                                                                                                    
=head4 Private                                                                                                                      
                                                                                                                                    
=head4 Exported                                                                                                                     
                                                                                                                                    
=head3 PACKAGE FUNCTIONS                                                                                                            
                                                                                                                                    
=head4 fetch                                                                                                                        
                                                                                                                                    
=over 4                                                                                                                             
                                                                                                                                    
=item Fetch ccsds packets from SIRIUS.                                                                                              
                                                                                                                                    
This is a stage of the pipeline.                                                                                                    
                                                                                                                                    
=back                                                                                                                               
                                                                                                                                    
=cut                                                                                                                                
                                                                                                                                    
=head4 check                                                                                                                        
                                                                                                                                    
=over 4                                                                                                                             
                                                                                                                                    
=item Check the received ccsds packets.

This is a stage of the pipeline.                                                                                                    
                                                                                                                                    
=back                                                                                                                               
                                                                                                                                    
=head3 DIAGNOSTICS                                                                                                                  
                                                                                                                                    
=head3 CONFIGURATION                                                                                                                
                                                                                                                                    
=head3 DEPENDENCIES                                                                                                                 
                                                                                                                                    
=item use File::Basename;                                                                                                           
                                                                                                                                    
=item use Trace::Trace;                                                                                                             
                                                                                                                                    
=item use Hinode::EIS::EisCcsds::EisStatus;                                                                                         
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::Util;                                                                                           
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::Flags;                                                                                          
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::Dates;                                                                                          
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::System;                                                                                         
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::Pipeline;                                                                                       
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::Program;                                                                                        
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::Filesystem;                                                                                     
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::Common;

=item use Hinode::EIS::EisPipeline::EisStatus::Status;                                                                              
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::EisStatus::Dates;                                                                               
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::EisStatus::Program;                                                                             
                                                                                                                                    
=item use Hinode::EIS::EisPipeline::EisStatus::Filesystem;                                                                          
                                                                                                                                    
=item use LibCcsds::GapCcsdsReader;                                                                                                 
                                                                                                                                    
=item use LibCcsds::CcsdsWriter;                                                                                                    
                                                                                                                                    
=head3 INCOMPATIBILITIES                                                                                                            
                                                                                                                                    
=head3 BUGS and LIMITATIONS                                                                                                         
                                                                                                                                    
=head3 AUTHOR                                                                                                                       
                                                                                                                                    
=head4 INSTITUTION                                                                                                                  
                                                                                                                                    
=head4 LICENCE and COPYRIGHT                                                                                                        
                                                                                                                                    
=head4 DISCLAIMER of WARRANTY                                                                                                       
                                                                                                                                    
=cut
