package Filesystem;

#print "HINODE/EIS/EISPIPELINE/EISSTATUS/FILESYSTEM.PM\n";

use strict;
use warnings;

use Hinode::EIS::EisPipeline::System;
use Hinode::EIS::EisPipeline::Filesystem;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisStatus/Filesystem\n";
}

our $program_name = "daily_merge_status_v2.pl";

our $STATUS_TRACE_FILE = $Filesystem::TMP_DIR . "/status_trace.txt";

our $DARTS_LOGS_DIR        = $Filesystem::DATA_STAGING_LOGS_DIR;				# $HOME/work/localdata/log/

our $DARTS_STATUS_LOGS_DIR = $Filesystem::DATA_STAGING_LOGS_DIR . "/pipeline_status";		# $HOME/work/localdata/log/pipeline_status
our $STATUS_LOG            = $Filesystem::LOCALDATA_LOG_DIR     . "/pipeline_status_log_v2";	# $HOME/work/localdata/log/pipeline_status_log_ ???
												# $HOME/work/localdata/log/status

our $STATUS_CRON_SCHEDULE_FILE = $Filesystem::TRACK_DIR . "/cron_status_start_schedule.txt";	# $HOME/track/cron_status_start_schedule.txt

# Directories
our $DARTS_STATUS_DIR   = $Filesystem::DATA_DIR          . "/status";				# $HOME/data/status
our $DARTS_REFORMAT_LOG = $Filesystem::LOCALDATA_LOG_DIR . "/status/darts_reformat_log";	# $HOME/work/localdata/log/ ???

our $DARTS_STAGING_STATUS_QUICKLOOK = $Filesystem::DATA_DIR . "/quicklook/status";		# $HOME/ ???

# Timing
our $TIMING_LOG_DIR     = $Filesystem::LOCALDATA_DIR . "/log/merge";				# $HOME/work/localdata/log/merge
our $TIMING_LOG_TMP_DIR = $TIMING_LOG_DIR            . "/tmp";                                  # $HOME/work/localdata/log/merge/tmp                  
#our $TIMING_LOG_TMP_DIR = $TIMING_LOG_DIR        . "/tmp";                                      # $HOME/work/localdata/log/merge/tmp
our $TIMING_OUTPUT_DIR  = $TIMING_LOG_DIR        . "/files";					# $HOME/work/localdata/sdtp/merge/timing/files
our $STAGING_TIMING_DIR = $Filesystem::DATA_DIR  . "/staging/timing";				# $HOME/work/localdata/timing ???
our $SPLIT_DIR          = $Filesystem::MERGE_DIR . "/split/tmp";				# $HOME/work/localdata/sdtp/merge/split/tmp

# Trends
our $DARTS_TRENDS_DIR     = $DARTS_STATUS_DIR;							# $HOME/data/status
our $LOCAL_TRENDS_LOG_DIR = $Filesystem::LOCALDATA_DIR . "/log/status/trends";			# $HOME/work/localdata/log/status/trends
our $LOCAL_TRENDS_IDL     = $Filesystem::LOCAL_IDL     . "/trends";				# $HOME/work/idl/trends ???

# Plots
our $TEMP_PLOTS           = $Filesystem::LOCALDATA_DIR          . "/pipeline/plots";		# $HOME/work/localdata/pipeline/plots
our $LOCALDATA_PLOTS_DIR  = $Filesystem::LOCALDATA_PIPELINE_DIR . "/plots";			# $HOME/work/localdata/pipeline/plots

our $LOCAL_STATUS_LOG_DIR = $Filesystem::LOCALDATA_LOG_DIR . "/status";				# $HOME/work/localdata/log/status

# Qcm
my  $QCM_LOG_DIR           = $LOCAL_STATUS_LOG_DIR . "/qcm";					# $HOME/work/localdata/log/status/qcm
our $LOCALDATA_QCM_LOG_DIR = $QCM_LOG_DIR;							# $HOME/work/localdata/log/status/qcm
our $LOCAL_QCM_LOG_DIR     = $QCM_LOG_DIR;							# $HOME/work/localdata/log/status/qcm

# Trends
our $LOCALDATA_TRENDS_LOG_DIR = $Filesystem::LOCALDATA_LOG_DIR . "/trends";			# $HOME/work/localdata/log/trends
our $LOCALDATA_PDFS_DIR       = $Filesystem::LOCALDATA_LOG_DIR . "/pdfs";			# $HOME/work/localdata/log/pdfs

												# $HOME/work/localdata/pdfs ???

# Fits
our $LOCALDATA_TEMP_FITS1_DIR = $Filesystem::LOCALDATA_PIPELINE_DIR . "/temp_fits1";		# $HOME/work/localdata/pipeline/temp_fits1
#####our $LOCAL_STATUS_QUICKLOOK_FITS     = $LOCAL_QUICKLOOK                 . "/fits/status";	# $HOME/work/localdata/sdtp/fits/status

# Quicklook
our $DATA_QL_STATUS_DIR = $Filesystem::DATA_QUICKLOOK_DIR . "/status";				# $HOME/data/quicklook/status
# not used? From Status.pm
my $LOCAL_QUICKLOOK              = $Filesystem::LOCALDATA_DIR . "/sdtp";			# $HOME/work/localdata/sdtp
our $LOCAL_STATUS_QUICKLOOK      = $LOCAL_QUICKLOOK           . "/status";			# $HOME/work/localdata/sdtp/status
our $LOCAL_STATUS_QUICKLOOK_FITS = $LOCAL_QUICKLOOK           . "/fits/status";			# $HOME/work/localdata/sdtp/fits/status

our $SDTP_STATUS_DIR        = $Filesystem::LOCALDATA_DIR . "/sdtp/status";			# $HOME/work/localdata/sdtp/status
our $SDTP_STATUS_FITS_DIR   = $SDTP_STATUS_DIR           . "/fits/status";			# $HOME/work/localdata/sdtp/status/fits/status
our $SDTP_STATUS_PLOTS_DIR  = $SDTP_STATUS_DIR           . "/plots";				# $HOME/work/localdata/sdtp/status/plots

# Files
#my  $QCM_LOG_DIR   = $Filesystem::LOCAL_LOG_DIR . "/status/qcm";
my  $QCM1_LOG_FILE = "qcm1_log.txt";
my  $QCM2_LOG_FILE = "qcm2_log.txt";

our $LOCAL_QCM1_LOG   = $QCM_LOG_DIR      . "/" . $QCM1_LOG_FILE;
our $LOCAL_QCM2_LOG   = $QCM_LOG_DIR      . "/" . $QCM2_LOG_FILE;
our $STAGING_QCM1_LOG = $DARTS_STATUS_DIR . "/" . $QCM1_LOG_FILE;
our $STAGING_QCM2_LOG = $DARTS_STATUS_DIR . "/" . $QCM2_LOG_FILE;

###our $LOCAL_STS_REFORMAT_LOG = "*** LOCAL_STS_REFORMAT_LOG ***"; #$Filesystem::REFORMAT_LOG_DIR . "/sts_reformat_";
our $LOCAL_STS_REFORMAT_LOG = $Filesystem::LOCALDATA_LOG_DIR . "/status/reformat/status_reformat_";

our $LOCAL_SS_MOVES_LOG = "ss_moves_";

our $STS_CHECK_LOG = "??? STS_CHECK_LOG Updated by Fits::daily_check ???";    # Gets updated by Fits::daily_check

our $DAILY_CHECK_LOG = "DAILY_CHECK_LOG";

#our $STATUS_LOG = $Filesystem::LOCAL_LOG_DIR . "/pipeline_status_log_";			# $HOME/work/localdata/log/pipeline_status_log_

my @n = qw(DARTS_STATUS_LOGS_DIR DARTS_STATUS_DIR DARTS_STAGING_STATUS_QUICKLOOK TIMING_LOG_DIR TIMING_OUTPUT_DIR STAGING_TIMING_DIR DARTS_TRENDS_DIR LOCAL_TRENDS_LOG_DIR LOCAL_TRENDS_IDL TEMP_PLOTS LOCAL_STATUS_LOG_DIR LOCAL_QCM_LOG_DIR SDTP_STATUS_DIR SDTP_STATUS_FITS_DIR SDTP_STATUS_PLOTS_DIR SPLIT_DIR LOCALDATA_PLOTS_DIR LOCALDATA_QCM_LOG_DIR LOCALDATA_TRENDS_LOG_DIR LOCALDATA_PDFS_DIR LOCALDATA_TEMP_FITS1_DIR DATA_QL_STATUS_DIR);

my @logs = qw(STATUS_LOG STATUS_CRON_SCHEDULE_FILE DARTS_REFORMAT_LOG LOCAL_QCM1_LOG LOCAL_QCM2_LOG STAGING_QCM1_LOG STAGING_QCM2_LOG LOCAL_STS_REFORMAT_LOG LOCAL_SS_MOVES_LOG STS_CHECK_LOG DAILY_CHECK_LOG);


our $dir;
our $status;
our $name;

sub status_file_dump {
    my %h;

    select((select(STATUS),
	    $~ = "STDOUT",
#	    $^ = "My_Top_Format"
	   )[0]);
    
    foreach my $f (@logs) {
	$h{$f} = eval "\$" . $f;
	#$h{$f} = eval $f;
    }
    foreach my $f (sort keys %h) {
	my $stat = "ERROR";
	$dir = $h{$f} || "Unknown";
	$name = $f;
###	print "$f $dir\n";
	$stat = "OK" if ((-f $dir) || (-e $dir));
	$status = $stat;
###	write STATUS;
	write;
    }

}

sub status_path_dump {
    my %h;

    select((select(STATUS),
	    $~ = "STDOUT",
#	    $^ = "My_Top_Format"
	   )[0]);
    
    foreach my $f (@n) {
	$h{$f} = eval "\$" . $f;
	#$h{$f} = eval $f;
    }
    foreach my $f (sort keys %h) {
	my $stat = "ERROR";
	$dir = $h{$f} || "Unknown";
	$name = $f;
###	print "$f $dir\n";
	$stat = "OK" if ((-d $dir) || (-e $dir));
	$status = $stat;
###	write STATUS;
	write;
    }

}

format STATUS =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @>>>>
$name, $dir, $status
.


1;
