package Fits;

#print "HINODE/EIS/EISPIPELINE/EISSTATUS/FITS.PM\n";

use strict;
use warnings;

use Trace::Trace;

use Hinode::EIS::EisPipeline::Util;
use Hinode::EIS::EisPipeline::System;
use Hinode::EIS::EisPipeline::Dates;
use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::Program;
use Hinode::EIS::EisPipeline::EisStatus::Status;
use Hinode::EIS::EisPipeline::EisStatus::Program;
use Hinode::EIS::EisPipeline::EisStatus::Filesystem;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisStatus/Fits\n";
}

my $date_string1;
my @trend_files = ();

=pod
# Status trend files
my $ccd_temp_trend_file     = $Status::LOCAL_TRENDS_LOG_DIR . "/eis_ccd_temp_trend_";
my $str_temp_trend_file     = $Status::LOCAL_TRENDS_LOG_DIR . "/eis_str_temp_trend_";
my $mbus_pwr_trend_file     = $Status::LOCAL_TRENDS_LOG_DIR . "/eis_mbus_pwr_trend_";
my $icu_psu_pwr_trend_file  = $Status::LOCAL_TRENDS_LOG_DIR . "/eis_icu_psu_pwr_trend_";
my $mhc_gp0_temp_trend_file = $Status::LOCAL_TRENDS_LOG_DIR . "/mhc_gp0_temp_trend_";
my $mhc_gp2_temp_trend_file = $Status::LOCAL_TRENDS_LOG_DIR . "/mhc_gp2_temp_trend_";
my $cam_pwr_trend_file      = $Status::LOCAL_TRENDS_LOG_DIR . "/eis_cam_pwr_trend_";
my $mhc_psu_pwr_trend_file  = $Status::LOCAL_TRENDS_LOG_DIR . "/eis_mhc_psu_pwr_trend_";
my $cam_temp_trend_file     = $Status::LOCAL_TRENDS_LOG_DIR . "/eis_cam_temp_trend_";
=cut

sub init {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Fits::init : initialise the fits module");

    $date_string1 = $Dates::syear . $Dates::smonth . ".txt";

    foreach my $file (qw(eis_ccd_temp_trend_    eis_str_temp_trend_    eis_mbus_pwr_trend_
			 eis_icu_psu_pwr_trend_ mhc_gp0_temp_trend_    mhc_gp2_temp_trend_
			 eis_cam_pwr_trend_     eis_mhc_psu_pwr_trend_ eis_cam_temp_trend_)) {
	push(@trend_files, Util::makePath($Filesystem::LOCAL_TRENDS_LOG_DIR, $file . $date_string1));
    }
#    print "trend_files = @trend_files\n";
}

=pod
sub create_reformat_idl_program {
    my $log_file = shift;

    #Trace::trace(__PACKAGE__."::create_reformat_idl_program");
    Trace::trace((caller(0))[3]);
    &$System::stage_step("Create IDL program");
    my $output = "!quiet=0\n";
    $output .= "run_status_reformatter, start_date='$Dates::sdate', end_date='$Dates::edate', log='$log_file'\n";

    &$System::stage_step("Write to IDL program $StatusProgram::STS_REFORMAT");
    open(STS_FITS, "> $StatusProgram::STS_REFORMAT");
    print STS_FITS $output;
    close STS_FITS;
    
    &$System::comment("IDL file:\n$output");    
}

# gdl < status_reformatter_runner.pro
#  run_status_reformatter,start_date='20200604',end_date='20200605',log='/Users/mcrw/Desktop/local_run.txt'
# Kick off the FITS reformat process
sub reformat {
    Trace::trace((caller(0))[3]);
    &$System::stage_title("Fits::reformat : Status data reformat");
    
    &$System::comment("(IDL) fits_script, '$Filesystem::DECOMPRESSED_DIR', '$Filesystem::FITS_DIR'");

    my $log_file = $Filesystem::LOCAL_STS_REFORMAT_LOG . "$Dates::start_date_string.txt";

    create_reformat_idl_program($log_file);
    
#    my $reformat_log = $System::LOCAL_STS_REFORMAT_LOG . "$Dates::start_date_string" . ".txt";
    #$reformat_log = "/dev/null";
    
    # Changed cp to mv
    &$System::comment("Run IDL program $StatusProgram::STS_REFORMAT");
#    &$System::perform("$System::SSWIDL < $Program::STS_REFORMAT >& $log_file");
    &$System::perform("$System::SSWIDL < $StatusProgram::STS_REFORMAT");
###!!!    system("$System::SSWIDL < $Program::STS_REFORMAT");
    
    &$System::stage_step("Move reformat log to DARTS");
    &$System::perform("/bin/mv $log_file $Filesystem::DARTS_STAGING/logs/sts_reformat/$Dates::year");
    
    # Get a count of number of mission data files here
    &$System::stage_step("Get count of number of fits files");
    my @post_reformat = &$System::list($Filesystem::FITS_DIR, "eis_*.fits");
    &$System::comment("Number of reformatted files: " . scalar(@post_reformat));
    
    # TODO: Compare the number of output files with the number of decompressed files. If not the same
    # then restart the reformat after separating out the done from the pending. Assume the first pending
    # file caused the reformat to crash and move that file to a nursery somewhere.
    
}
=cut

#eis_daily_plots,'/home/sbukeis/work/localdata/pipeline/fits/','/home/sbukeis/work/localdata/pipeline/plots/'

sub create_daily_plots_idl_program {
    Trace::trace((caller(0))[3]);

    &$System::stage_step("Create IDL program $Program::DAILY_PLOTS");

    my $output = "!quiet=0\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_status_sts2_conversions\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_convert_mhc_temperature\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_status_sts3_conversions\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_status_mdp_conversions\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_daily_plots\n";

    $output .= "eis_daily_plots, '$Filesystem::LOCALDATA_FITS_DIR', '$Filesystem::TEMP_PLOTS'\n";

    &$System::stage_step("Write to IDL program $Program::DAILY_PLOTS");
    open(FH, "> $Program::DAILY_PLOTS");
    print FH $output;
    close FH;
    
    &$System::comment("IDL file:\n$output");
}


sub daily_plots {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Fits::daily_plots : Create the daily plots");

    &$System::comment("IDL : eis_daily_plots, '$Filesystem::LOCALDATA_FITS_DIR', '$Filesystem::TEMP_PLOTS'");

    &$System::stage_step("Create IDL program");
    create_daily_plots_idl_program();
    
    &$System::stage_step("Run IDL program");
    &$System::perform("$Program::SSWIDL < $Program::DAILY_PLOTS");

    &$System::stage_step("Convert plots from ps to pdf");
    &$System::perform("Fits::convert_plots_to_pdf()");
}


# /home/sbukeis/bin/daily_pdfs /home/sbukeis/work/localdata/pipeline/plots /home/sbukeis/work/localdata/pipeline/plots
# gzip -f /home/sbukeis/work/localdata/pipeline/plots/*pdf

#Sun Jun 28 23:18:24 2020 (JST) - Moving pdfs to DARTS
#    /bin/mkdir /home/sbukeis/data/status/2020/06/24/plots
#    /bin/mv /home/sbukeis/work/localdata/pipeline/plots/*gz /home/sbukeis/data/status/2020/06/24/plots

sub convert_plots_to_pdf {
    Trace::trace((caller(0))[3]);

    &$System::stage_title("Fits::convert_plots_to_pdf : Convert ps plots to pdf plots");

    &$System::stage_step("Convert plots from ps to pdf");
    &$System::perform("$Program::DAILY_PDFS $Filesystem::TEMP_PLOTS $Filesystem::TEMP_PLOTS");

    &$System::stage_step("Gzip pdf files");
    &$System::perform("gzip -f $Filesystem::TEMP_PLOTS/*pdf");
}


sub create_daily_check_idl_program {
    Trace::trace((caller(0))[3]);

    &$System::stage_step("Write to IDL program $Program::DAILY_CHECK");

    my $report_name = Util::makePath($Filesystem::TEMP_PLOTS, Util::makeString($Dates::start_date_string, "_check.txt"));
    $Filesystem::STS_CHECK_LOG = Util::makePath($Filesystem::PIPELINE_LOG_DIR, Util::makeString("sts_check_", $Dates::start_date_string, ".txt"));

    my $fits_dir = ($Flags::CHECK_ONLY_FLAG) ? Util::makePath($Filesystem::DARTS_STATUS_DIR, $Dates::syear, $Dates::smonth, $Dates::sday) : $Filesystem::LOCALDATA_FITS_DIR;

#    &$System::comment("IDL : eis_daily_check, '$Filesystem::LOCALDATA_FITS_DIR', '$report_name'");
    &$System::comment("IDL : eis_daily_check, '$fits_dir', '$report_name'");

    my $output = "!quiet=0\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_count_check\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_num2str\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_min_max_str\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_param_string\n";
#    $output .= "; Temporary!\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_convert_mhc_temperature\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_status_sts1_check\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_status_sts2_check\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_status_sts3_check\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_status_hk1_check\n";
#    $output .= ".comp $Filesystem::LOCAL_IDL/eis_daily_check\n";
#    $output .= "eis_daily_check,'$Filesystem::LOCALDATA_FITS_DIR/','$report_name'\n";
    $output .= "eis_daily_check,'$fits_dir/','$report_name'\n";

    open(PLOT, "> $Program::DAILY_CHECK");
    print PLOT $output;
    close PLOT;

    &$System::comment("IDL file:\n$output");
}


# Confusing in daily_merge_status1.pl
#(IDL) eis_daily_check, '/home/sbukeis/work/localdata/pipeline/fits/','/home/sbukeis/work/localdata/pipeline/plots/20200624_check.txt'
# /bin/rm /home/sbukeis/work/localdata/log/pipeline/sts_check_20200624.txt
sub daily_check {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Fits::daily_check : Create the check files");

    create_daily_check_idl_program();

    &$System::stage_step("Run IDL");
    &$System::perform("$Program::SSWIDL < $Program::DAILY_CHECK > $Filesystem::STS_CHECK_LOG");

    &$System::stage_step("Move log to DARTS");
    &$System::comment("Log not useful - delete this step");

    &$System::stage_step("Delete log");
    &$System::perform("/bin/rm $Filesystem::STS_CHECK_LOG");
#Sun Jun 28 23:20:17 2020 (JST) - Moving daily check report to DARTS
#    /bin/mv /home/sbukeis/work/localdata/pipeline/plots/*txt /home/sbukeis/data/status/2020/06/24/plots
}

=pod
sub update_trend_filenames {
    Trace::trace((caller(0))[3]);

    my $date_string = $Dates::syear . $Dates::smonth . ".txt";
    
    $ccd_temp_trend_file     .= $date_string;
    $str_temp_trend_file     .= $date_string;
    $mbus_pwr_trend_file     .= $date_string;
    $icu_psu_pwr_trend_file  .= $date_string;
    $mhc_gp0_temp_trend_file .= $date_string;
    $mhc_gp2_temp_trend_file .= $date_string;
    $cam_pwr_trend_file      .= $date_string;
    $mhc_psu_pwr_trend_file  .= $date_string;
    $cam_temp_trend_file     .= $date_string;
}
=cut

# eis_monthly_trends, '/home/sbukeis/data/status/2020/06', '202006'
# eis_plot_trends, '202006', 'June 2020', '/home/sbukeis/work/localdata/log/status/trends/'
# eis_mhc_mech_moves, '/home/sbukeis/data/status/2020/06', log='/home/sbukeis/work/localdata/log/status/ss/ss_moves_202006.txt'

sub create_trends_idl_program {
    my $src = shift;
    my $trend = shift;

    Trace::trace((caller(0))[3]);

    my $plot_title = Dates::date_to_natural_lang();
    $Filesystem::LOCAL_SS_MOVES_LOG .= Util::makeString($Dates::syear, $Dates::smonth, $Dates::sday, ".txt");

    my $output = "!quiet=0\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_no_data_string\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_ccd_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_mbus_pwr_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_mhc_gp0_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_mhc_gp2_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_str_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_icu_psu_pwr_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_cam_pwr_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_mhc_psu_pwr_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_cam_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_monthly_trends\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_trend_data\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_ccd_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_mbus_pwr_trend\n";
    $output .= "; Temporary!\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_convert_mhc_temperature\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_mhc_gp0_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_mhc_gp2_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_str_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_cam_pwr_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_icu_psu_pwr_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_mhc_psu_pwr_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_cam_temp_trend\n";
    $output .= ".comp $Filesystem::LOCAL_TRENDS_IDL/eis_plot_trends\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_count_check\n";
    $output .= ".comp $Filesystem::LOCAL_IDL/eis_mhc_mech_moves\n";
    $output .= "eis_monthly_trends, '$src', '$trend'\n";
    $output .= "eis_plot_trends, '$trend', '$plot_title', '$Filesystem::LOCAL_TRENDS_LOG_DIR'\n";
##    $output .= "eis_mhc_mech_moves, '$src', log='$Status::LOCAL_SS_MOVES_LOG.txt'\n";
    $output .= "eis_mhc_mech_moves, '$src', log='$Filesystem::LOCAL_SS_MOVES_LOG'\n";

    open(MONTH_TREND, "> $Program::MONTHLY_TRENDS\n");
    print MONTH_TREND $output;
    close MONTH_TREND;

    &$System::comment("IDL file:\n$output");
#    return $output;
}


# Sun Jun 28 23:20:17 2020 (JST) - Starting monthly trends
# (IDL) eis_monthly_trends, '/home/sbukeis/data/status/2020/06', '202006'
sub monthly_trends {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Fits::monthly_trends : Update the monthly trends files");

    &$System::stage_step("Init the fits module");
    Fits::init();
    
#    update_trend_filenames();

    my $src_dir = Util::makePath($Filesystem::DARTS_STATUS_DIR, $Dates::syear, $Dates::smonth);
    my $trend_filename = $Dates::syear . $Dates::smonth;

    &$System::comment("IDL : eis_monthly_trends, '$src_dir', '$trend_filename'");

    &$System::stage_step("Write IDL program");
    create_trends_idl_program($src_dir, $trend_filename);

    &$System::stage_step("Run IDL $Program::MONTHLY_TRENDS");
    &$System::perform("$Program::SSWIDL < $Program::MONTHLY_TRENDS");

    &$System::perform("Fits::update_darts_trends()");
}


sub update_darts_trends {
    Trace::trace((caller(0))[3]);

    &$System::stage_title("Fits::update_darts_trends : Move trends files to DARTS");

    if ($Flags::NO_UPDATE_DARTS_TRENDS) {
	&$System::comment("NO_UPDATE_DARTS_TRENDS flag set, skipping this stage");
	return;
    }

    $Filesystem::DARTS_TRENDS_DIR .= ("/" . $Dates::syear . "/" . $Dates::smonth . "/trends");

    &$System::stage_step("Update QCM files");
    &$System::perform("/bin/sort $Filesystem::LOCAL_QCM1_LOG | uniq > $Filesystem::STAGING_QCM1_LOG");
    &$System::perform("/bin/sort $Filesystem::LOCAL_QCM2_LOG | uniq > $Filesystem::STAGING_QCM2_LOG");

    my $dest_dir = Util::makePath($Filesystem::DARTS_TRENDS_DIR, $Dates::syear, $Dates::smonth, "trends");
    &$System::stage_step("Move trends files to DARTS");

    for my $file (@trend_files) {
	&$System::perform("/bin/mv $file $dest_dir");
    }

    &$System::perform("/bin/mv $Filesystem::LOCAL_SS_MOVES_LOG $dest_dir");
    
#    &$System::perform("/bin/mv $ccd_temp_trend_file $dest_dir");
#    &$System::perform("/bin/mv $str_temp_trend_file $dest_dir");
#    &$System::perform("/bin/mv $mbus_pwr_trend_file $dest_dir");
#    &$System::perform("/bin/mv $icu_psu_pwr_trend_file $dest_dir");
#    &$System::perform("/bin/mv $mhc_gp0_temp_trend_file $dest_dir");
#    &$System::perform("/bin/mv $mhc_gp2_temp_trend_file $dest_dir");
#    &$System::perform("/bin/mv $cam_pwr_trend_file $dest_dir");
#    &$System::perform("/bin/mv $mhc_psu_pwr_trend_file $dest_dir");
#    &$System::perform("/bin/mv $cam_temp_trend_file $dest_dir");
}


sub compress_files {
    Trace::trace((caller(0))[3]);

###    &$System::stage_title("Fits::compress_files : Compress the status fits files");

    &$System::stage_step("gzip fits files in $Filesystem::LOCALDATA_FITS_DIR");
    &$System::perform("gzip -f $Filesystem::LOCALDATA_FITS_DIR/*");
}


sub populate_darts {
    Trace::trace((caller(0))[3]);

    ###    &$System::stage_title("Fits::populate_darts : Move the fits files, plot files and trend files to DARTS");
###    &$System::stage_title("Fits::populate_darts : Move the fits files to DARTS");

    if ($Flags::NO_UPDATE_DARTS) {
	&$System::log("no_darts flag set, skipping this stage");
	return;
    }
    
    &$System::stage_step("Get a list of all the status fits files");
    my @files = &$System::list($Filesystem::LOCALDATA_FITS_DIR, "*.fits.gz");		# Returns fullpath filenames

    &$System::stage_step("Move them to the staging directory");

    my $dest = Util::makePath($Filesystem::DARTS_STATUS_DIR, $Dates::syear, $Dates::smonth, $Dates::sday);
    foreach my $file (@files) {
	chomp $file;
	&$System::perform("/bin/mv $file $dest");
    }
    &$System::stage_step("Get a list of all the plot pdf files");
    &$System::stage_step("Move them to the staging directory");
#    &$System::stage_step("Get a list of all the trend plot files");
#    &$System::stage_step("Move them to the staging directory");
#    &$System::stage_step("Get a list of all the trend text files");
#    &$System::stage_step("Move them to the staging directory");
}

#Sun Jun 28 23:21:47 2020 (JST) - Removing quicklook status data for 2020/06/24
#    /bin/rm -rf /home/sbukeis/data/quicklook/status/2020/06/24
#    /bin/rm -rf /home/sbukeis/work/localdata/sdtp/status/20200624
#    /bin/rm -rf /home/sbukeis/work/localdata/sdtp/fits/status/20200624
#    /bin/rm -rf /home/sbukeis/work/localdata/sdtp/plots/20200624
sub remove_quicklook {
    Trace::trace((caller(0))[3]);
    
    my $date_string = Util::makePath($Dates::syear, $Dates::smonth, $Dates::sday);

    System::dprint("syear, smonth, sday = $Dates::syear, $Dates::smonth, $Dates::sday\n");
    
###    &$System::stage_title((caller(0))[3] . " : remove quicklook data for $date_string");

#    &$System::stage_step("Remove quicklook files from DARTS",
#			 "/bin/rm -rf $Filesystem::DARTS_STAGING_STATUS_QUICKLOOK" . "/" . $date_string);
    
    &$System::stage_step("Remove quicklook files from DARTS");
    &$System::perform("/bin/rm -rf $Filesystem::DARTS_STAGING_STATUS_QUICKLOOK" . "/" . $date_string);

    &$System::stage_step("Remove quicklook files from the local sdtp directory");
    &$System::perform("/bin/rm -rf $Filesystem::SDTP_STATUS_DIR"       . "/" . $date_string); # dir not found
    &$System::perform("/bin/rm -rf $Filesystem::SDTP_STATUS_FITS_DIR"  . "/" . $date_string);
    &$System::perform("/bin/rm -rf $Filesystem::SDTP_STATUS_PLOTS_DIR" . "/" . $date_string);
}

1;
