package Pipeline;

print "HINODE/EIS/EISPIPELINE/EISSTATUS/PIPELINE.PM\n";

use strict;
use warnings;
use Time::Local;

use Hinode::EIS::EisPipeline::EisStatus::System;
use Hinode::EIS::EisPipeline::Eis::StatusData;
use Hinode::EIS::EisPipeline::Eis::StatusDates;
use Hinode::EIS::EisPipeline::Eis::StatusFlags;
use Hinode::EIS::EisPipeline::Eis::StatusArgs;
use Hinode::EIS::EisPipeline::Eis::StatusProgram;
#use Hinode::EIS::EisPipeline::EisMission::Rasters;
use Hinode::EIS::EisPipeline::Eis::Filesystem;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisStatus/Pipeline\n";
}

my $announce = scalar(localtime) . " (JST) daily_merge_mission3 started";
our $status_log      = ""; # $ LOG_DIRECTORY . "/pipeline_mission_log_";


sub open_status_log {
#    my $start_flag = shift;
#    my $start_flag = $state;

    #Trace::trace(__PACKAGE__."::open_status_log");
    Trace::trace((caller(0))[3]);

    $status_log = $Filesystem::STATUS_LOG . $Dates::sdate . '_' . $Dates::edate . ".txt";
    open(LOG, ">> $status_log"), $System::status_log_open = 1 || pipeline_die(-2, "Pipeline::open_status_log (" . __LINE__ . ") : Can't open pipeline_status_log.txt for writing: $!");
    System::dprint("Starting logger for $state ($System::status_log_open)\n");
    System::init(*LOG, $state);
    #init1(*LOG, $start_flag);
}


# Write out dates to schedule file
sub cron_finished {
    my $code = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);
    
    &$System::log("\tPipeline::cron_finished : Updating cron schedule file");
    &$System::perform("/bin/echo $Dates::sdate $Dates::edate $Dates::stime $Dates::etime > $Filesystem::CRON_SCHEDULE_FILE");
    pipeline_exit($code, $message);
}

sub save_log {
    my $string = shift;

    #Trace::trace((caller(0))[3]);
    Trace::trace(__PACKAGE__."::save_log");

    $pipeline->save_log($string);
    return;
    
    my $log_open = (is_mission_pipeline()) ? $System::mission_log_open : $System::status_log_open;
    &$System::perform("/bin/mv $mission_log $Filesystem::DARTS_MISSION_LOG_DIR");

    &$System::log("$string") if $log_open;
    &$System::log("\n--------------------------------\n") if $log_open;
}

# In ../Pipeline.pm but needs to be "overridden"
sub pipeline_die {
    #my $pipeline = shift;
    my $code = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);

    &$System::perform("/bin/mv $status_log $Filesystem::DARTS_STATUS_LOGS_DIR");

    my $string = scalar(localtime) . " (JST) DIE : ($code) $message";
    System::dprint("DIE: $code ($message)\n");
    &$System::log("*** $string") if $System::status_log_open;
    _main_log_message("*** $string");
    exit $code;
}



1;
