package Program;

#print "HINODE/EIS/EISPIPELINE/EISSTATUS/PROGRAM.PM\n";

use strict;
use warnings;

use Hinode::EIS::EisPipeline::Program;
use Hinode::EIS::EisPipeline::Filesystem;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisStatus/Program\n";
}

my $BIN = $Filesystem::BIN_DIR;

#our $CCSDS_PACKET_CHECK = $Program::BIN . "/pipeline_ccsds_check";
###our $CCSDS_PACKET_CHECK = $BIN . "/pipeline_ccsds_check"; # In ../Program.pm

our $STS_REFORMAT   = $Filesystem::TEMP_IDL . "/sts_reformat.pro";

our $DAILY_CHECK    = $Filesystem::TEMP_IDL . "/daily_check.pro";
our $DAILY_PLOTS    = $Filesystem::TEMP_IDL . "/daily_plots.pro";
our $MONTHLY_TRENDS = $Filesystem::TEMP_IDL . "/monthly_trends.pro";
#our $DAILY_PDFS     = $Program::BIN         . "/daily_pdfs";
our $DAILY_PDFS     = $BIN         . "/daily_pdfs";

#our $STATUS_SEQ_COUNT      = $Program::BIN . "/status_sequence_counts.pl";
#our $CCSDS_MISSING_SUMMARY = $Program::BIN . "/ccsds_missing_summary1.pl";
#our $SEQUENCE_CONT_CHECK   = $Program::BIN . "/sequence_count_continuity_check.pl";
our $STATUS_SEQ_COUNT      = $BIN . "/status_sequence_counts.pl";
our $CCSDS_MISSING_SUMMARY = $BIN . "/ccsds_missing_summary1.pl";
our $SEQUENCE_CONT_CHECK   = $BIN . "/sequence_count_continuity_check.pl";

our %schedule_reader = (
    'v1' => \&Status::calculate_start,
    'v2' => \&Status::read_schedule_file
    );

our %create_reformat_idl_program = (
    'v1' => \&Data::create_v1_reformat_idl_program,
    'v2' => \&Data::create_v2_reformat_idl_program,
    );

1;
