package Status;

#print "HINODE/EIS/EISPIPELINE/EISSTATUS/STATUS.PM\n";

use strict;
use warnings;

use Getopt::Long qw(GetOptionsFromArray);

use Trace::Trace;

use Hinode::EIS::EisPipeline::System;
use Hinode::EIS::EisPipeline::Pipeline;
use Hinode::EIS::EisPipeline::Dates;
use Hinode::EIS::EisPipeline::Flags;
use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::Program;
use Hinode::EIS::EisPipeline::EisStatus::Filesystem;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/EisStatus/Status\n";
}

# not used?
#my $LOCAL_QUICKLOOK              = $Filesystem::LOCALDATA . "/sdtp";              # $HOME/work/localdata/sdtp
#our $LOCAL_STATUS_QUICKLOOK      = $LOCAL_QUICKLOOK       . "/status";            # $HOME/work/localdata/sdtp/status
#our $LOCAL_STATUS_QUICKLOOK_FITS = $LOCAL_QUICKLOOK       . "/fits/status";       # $HOME/work/localdata/sdtp/fits/status

# Directories
our $DARTS_DIR = {
    STATUS => $Filesystem::DATA_DIR . "/status",
};

# Files
#our $LOCAL_SS_MOVES_LOG = "ss_moves_";

# Programs
our $PROGRAM = {
    STATUS_SEQ_COUNT      => $Program::BIN . "/status_sequence_counts.pl",
    CCSDS_MISSING_SUMMARY => $Program::BIN . "/ccsds_missing_summary1.pl",
    SEQUENCE_CONT_CHECK   => $Program::BIN . "/sequence_count_continuity_check.pl",
    DAILY_PDFS            => $Program::BIN . "/daily_pdfs",
    STS_REFORMAT          => $Filesystem::TEMP_IDL . "/sts_reformat.pro",
    DAILY_CHECK           => $Filesystem::TEMP_IDL . "/daily_check.pro",
    DAILY_PLOTS           => $Filesystem::TEMP_IDL . "/daily_plots.pro",
    MONTHLY_TRENDS        => $Filesystem::TEMP_IDL . "/monthly_trends.pro",
};
### $Status::PROGRAM->{STATUS_SEQ_COUNT};

our $FILESYSTEM = {
    LOCAL => {
	LOG_DIR       => $Filesystem::WORK_LOG_STATUS,
	PDF_DIR       => $Filesystem::WORK_PDFS,
	SDTP_FITS_DIR => $Filesystem::WORK_LOCALDATA_SDTP_FITS,
	PENDING_FILE  => $Filesystem::HOME_TRACK_STATUS_PENDING,
	LATEST_FILE   => $Filesystem::HOME_TRACK_STATUS_LATEST,
	
    },
    STAGING => {
	QUICKLOOK_DIR => $Filesystem::DATA_QUICKLOOK_STATUS,
    },
};
###$Status::FILESYSTEM->{LOCAL}->{LOG_DIR};

my $status_log;
my $status_log_open = 0;

# Does nothing - needed for compatability with Mission.pm
#sub init {
#    print "Status init\n";
#    Filesystem::status_path_dump();
#    print "\n";
#    Filesystem::status_file_dump();
#}

my $HOME = "";

sub init {
    Trace::trace((caller(0))[3]);

    print "Status init\n";
    Filesystem::status_path_dump();
    print "\n";
    Filesystem::status_file_dump();
    $HOME = Filesystem::home();
    print "Status HOME = $HOME\n";
}

#								s/be $#ARGV $#ARGV @ARGV
# status daily_merge_status_v2.pl				-1		0	1
# status daily_merge_status_v2.pl -c				 0		1	2
# status daily_merge_status_v2.pl -p 20210101 20210102		 2		3	4

# status daily_merge_status_v2.pl 20210101 20210102		 1		2	3
# status daily_merge_status_v2.pl v1 20210101 20210102		 2		3	4
# status daily_merge_status_v2.pl v1 TEST 20210101 20210102	 3		4	5
=pod

# @ARGV gets the name of this module as it's first argument.
# $#ARGV gives the perlian number of parameters ( == n_parameters - 1).
# $n = @ARGV gives the actual number of parameters.
# Passing @ARGV to the next routine removes the first parameter, I don't know why.
=cut

# @ARGV gets the name of this module as it's first argument.
# $#ARGV gives the perlian number of parameters ( == n_parameters - 1).
# $n = @ARGV gives the actual number of parameters.
# Passing @ARGV to the next routine removes the first parameter, I don't know why.
sub arg_check {
    my @ARGV = @_;

    Trace::trace((caller(0))[3]);

    my $args = join ' ', @ARGV;

    my $ret = GetOptionsFromArray(\@ARGV,
                                  'no_darts'   => \$Flags::NO_UPDATE_DARTS,
                                  'no_trends'  => \$Flags::NO_UPDATE_DARTS_TRENDS,
				  'check_only' => \$Flags::CHECK_ONLY_FLAG,
                                  'no_check'   => \$Flags::NO_CHECK,
                                  'fits_only'  => \$Flags::FITS_ONLY_FLAG,
                                  '<>'         => \&Args::catchall);

#    while (@ARGV) {
#	my $flag = shift @ARGV;	# = [-c|fetch|fits_only|...]
#	System::dprint("FLAG = $flag\n");
#	$Flags::NO_UPDATE_DARTS        = 1 if $flag eq "no_darts";
#	$Flags::NO_UPDATE_DARTS_TRENDS = 1 if $flag eq "no_trends";
#	if ($flag =~ /(\d)(\d)(\d)(\d)/) {
#	    unshift	@ARGV, $flag;
#	    last;
#	}
#    }

#    if ( ($Flags::cron) || ($Flags::cron_pending) || ($args eq "") ) {
#	System::dprint("CRON : $args\n");
    if (($Flags::cron) || ($Flags::cron_pending)) {
	System::dprint("CRON\n");
#       cron_check(@ARGV);                                                                                                                                 
        cron_check();
    }
    else {
#	interactive_check(@ARGV);
	interactive_check();
    }
    
    Dates::init_status();
    Pipeline::check_pipeline();
}

# Wheres the checking of the dates?
sub interactive_check {
#    my $package = shift;
##    my @ARGV = @_;

    Trace::trace((caller(0))[3]);
#    Trace::trace("Status::interactive_check");
##    System::dprint("Status: \@ARGV = @ARGV\n");
##    System::dprint("Status: ARGV = $#ARGV\n");

    ### ???
###    $System::program_name = $0;

    # Debug
    $Flags::Foo = 1;
  
    ($Pipeline::kick_string, $Pipeline::state) = ($Flags::cron) ? ("by cron from tracking file", "cron") : ("manually", "interactive");
    Pipeline::announce();
    Pipeline::main_log_message("Status interactive_check: $Args::command_line");

#    Pipeline::pipeline_die(10, "No start date") if ! Dates::check_date($sdate);
#    Pipeline::pipeline_die(11, "No end date")   if ! Dates::check_date($edate);

    Pipeline::open_local_log();
    Pipeline::main_log_message("Status interactive_check: Logging to $status_log");
    Pipeline::local_announce();

###  Pipeline::check_pipeline();

=pod  
    if ($#ARGV > 0 ) {

	my $sdate = shift @ARGV;
	my $edate = shift @ARGV;

#	Pipeline::warn(-20, "Dates don't check out") if (!Dates::check_start_end_dates($sdate, $edate));
	Dates::set_start_end_dates($sdate, $edate);

	($Pipeline::kick_string, $Pipeline::state) = ($Flags::cron) ? ("by cron from tracking file", "cron") : ("manually", "interactive");
	Pipeline::announce();
	Pipeline::main_log_message("Status interactive_check: $Args::command_line");
	
	Pipeline::pipeline_die(10, "No start date") if ! Dates::check_date($sdate);
	Pipeline::pipeline_die(11, "No end date")   if ! Dates::check_date($edate);
	
	Pipeline::open_local_log();
	Pipeline::main_log_message("Status interactive_check: Logging to $status_log");
	Pipeline::local_announce();
    }
    else {
	$Pipeline::kick_string = ($Flags::cron) ? "by cron from tracking file" : "manually";
	$Pipeline::state = ($Flags::cron) ? "cron" : "interactive";
	Pipeline::announce();
	Pipeline::main_log_message($Args::command_line);
	Pipeline::pipeline_die(-10, "Not enough arguments");
    }
    # Temporary debugging
#    print "Value for flag cron = ", Flags::flag_value('cron'), "\n";
#    print "Value for flag Foo = $flags::Foo\n";
#    print "KDFHODSFHOSDHDDOU\n";
=cut

}


sub cron_check {
    Trace::trace((caller(0))[3]);

#    my $package = shift;
##    my @ARGV = @_;

##    System::dprint("STATUS cron_check: @ARGV\n");
    System::dprint("STATUS cron_check\n");

#    my ($prev_start_date, $prev_end_date);

    ### ???
###    $System::program_name = $0;

    if ($Flags::cron_pending) {
	System::dprint("PENDING\n");
	$Pipeline::kick_string = ($Flags::cron) ? "by cron from tracking file" : "manually";
	$Pipeline::state = ($Flags::cron) ? "cron" : "interactive";
	Pipeline::announce();
##	Dates::set_start_end_dates($ARGV[0], $ARGV[1]);
    }
    else {
	$Pipeline::kick_string = "by cron";
	$Pipeline::state = "cron";
	Pipeline::announce();

        print "schedule_reader...\n";
        &{$Program::schedule_reader{$Flags::REFORMAT_VERSION}};
=pod
	if ($Flags::REFORMAT_VERSION eq "v1") {
	    System::dprint("V1 processing\n");
	    Dates::today();					# Initialise
	    my @start_day = Dates::other_date(-4);		# Go back 4 days
	    my @next_day  = Dates::other_date(-3);         # Go back 3 days
	    
	    my $syear  = sprintf "%04u", $start_day[5];    # Get starting year
	    my $smonth = sprintf "%02u", $start_day[4];    # Get starting month
	    my $sday   = sprintf "%02u", $start_day[3];    # Get starting day
	    my $eyear  = sprintf "%04u", $next_day[5];     # Get ending year
	    my $emonth = sprintf "%02u", $next_day[4];     # Get ending month
	    my $eday   = sprintf "%02u", $next_day[3];     # Get ending day
	    
	    my $sdate = "$syear$smonth$sday";
	    my $edate = "$eyear$emonth$eday";
	    #Dates::set_start_end_dates($sdate, $edate);
	    Dates::set_dates_cron($sdate);
	}
	else {
	    # Open schedule file and get end date to use as new start date
	    System::dprint("Opening $Filesystem::STATUS_CRON_SCHEDULE_FILE");
	    if(open(FH, "< $Filesystem::STATUS_CRON_SCHEDULE_FILE")) {
		my $line = <FH>;
		chomp $line;
		($prev_start_date, $prev_end_date) = split / /, $line;
		close FH;
		Pipeline::main_log_message("Status cron_check: Read schedule file");
		System::dprint("$prev_start_date, $prev_end_date");
		Dates::set_dates_cron($prev_end_date);
	    }
	    else {
		System::dprint("Cant open $Filesystem::STATUS_CRON_SCHEDULE_FILE");
		#Pipeline::pipeline_die(-100, "Can't open schedule file ($System::STATUS_CRON_SCHEDULE_FILE)");
		#Pipeline::pipeline_die($Pipeline::message{$System::SCHED_OPEN_FAIL});
		Pipeline::pipeline_warn(-100, "Can't open schedule file ($Filesystem::STATUS_CRON_SCHEDULE_FILE)");
		# FOR TESTING ONLY
		$prev_start_date = '20210102';
		$prev_end_date   = '20210103';
		Dates::set_dates_cron($prev_end_date);
	    }
	}
=cut
    }
    
    Pipeline::open_local_log();

    # This is missing info - flags are missing
    Pipeline::main_log_message("Status cron_check: $Args::command_line");
    Pipeline::main_log_message("Status cron_check: Logging to $status_log");
    Pipeline::local_announce();
}

sub calculate_start {
    Trace::trace((caller(0))[3]);

    System::dprint("V1 processing\n");
    Dates::today();                                     # Initialise
    my @start_day = Dates::other_date(-4);              # Go back 4 days
    my @next_day  = Dates::other_date(-3);         # Go back 3 days

    my $syear  = sprintf "%04u", $start_day[5];    # Get starting year
    my $smonth = sprintf "%02u", $start_day[4];    # Get starting month
    my $sday   = sprintf "%02u", $start_day[3];    # Get starting day
    my $eyear  = sprintf "%04u", $next_day[5];     # Get ending year
    my $emonth = sprintf "%02u", $next_day[4];     # Get ending month
    my $eday   = sprintf "%02u", $next_day[3];     # Get ending day

    my $sdate = "$syear$smonth$sday";
    my $edate = "$eyear$emonth$eday";
    #Dates::set_start_end_dates($sdate, $edate);
    Dates::set_dates_cron($sdate);
}

sub read_schedule_file {
    Trace::trace((caller(0))[3]);

    my ($prev_start_date, $prev_end_date);

    System::dprint("Opening $Filesystem::STATUS_CRON_SCHEDULE_FILE");
    if(open(FH, "< $Filesystem::STATUS_CRON_SCHEDULE_FILE")) {
        my $line = <FH>;
        chomp $line;
        ($prev_start_date, $prev_end_date) = split / /, $line;
        close FH;
	Pipeline::main_log_message("Status cron_check: Read schedule file");
	System::dprint("$prev_start_date, $prev_end_date");
	Dates::set_dates_cron($prev_end_date);
    }
    else {
	System::dprint("Cant open $Filesystem::STATUS_CRON_SCHEDULE_FILE");
        #Pipeline::pipeline_die(-100, "Can't open schedule file ($System::STATUS_CRON_SCHEDULE_FILE)");
        #Pipeline::pipeline_die($Pipeline::message{$System::SCHED_OPEN_FAIL});
	Pipeline::pipeline_warn(-100, "Can't open schedule file ($Filesystem::STATUS_CRON_SCHEDULE_FILE)");
        # FOR TESTING ONLY
        $prev_start_date = '20210102';
        $prev_end_date   = '20210103';
	Dates::set_dates_cron($prev_end_date);
    }
}


# Remove any junk left over from previous pipeline execution
sub clean {
    Trace::trace((caller(0))[3]);

    # This is done by System::run_stage if called that way
######    &$System::stage_title("Data::clean : Removing old data");

    # Remove old timing files
=pod
    if ($Flags::REFORMAT_VERSION eq "v2") {
	&$System::stage_step("Remove old timing files");
	&$System::perform("/bin/rm $Filesystem::TIMING_LOG_DIR" . "/*");
	&$System::perform("/bin/rm $Filesystem::STAGING_TIMING_DIR" . "/*");
    }
=cut    
    # Remove any old temporary program files

    System::dprint("Done EisStatus clean\n");
}

sub clean_up {
    Trace::trace((caller(0))[3]);
    
    &$System::stage_step("Remove temporary plot files");
    &$System::perform("/bin/rm $Filesystem::TEMP_PLOTS" . "/*");
}


# Update record if run finished ok or needs to run again
sub cron_finished {
    my $code = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);

    &$System::perform("/bin/echo $Dates::sdate $Dates::edate > $Filesystem::STATUS_CRON_SCHEDULE_FILE");
}


sub open_local_log {
    Trace::trace((caller(0))[3]);

    $status_log = $Filesystem::STATUS_LOG . '_' . $Dates::sdate . '_' . $Dates::edate . ".txt";
    open(LOG, ">> $status_log"), $status_log_open = 1 || pipeline_die(-2, "Status::open_local_log (" . __LINE__ . ") : Can't open pipeline_status_log.txt for writing: $!");
    System::dprint("Starting logger for $Pipeline::state ($status_log_open)\n");

    # DEBUG!!!!
    $Pipeline::state = "interactive";

    System::init(*LOG, $Pipeline::state);
    #init1(*LOG, $start_flag);
    return *LOG;
}


sub save_log {
    my $junk = shift;
    my $string = shift;

    Trace::trace((caller(0))[3]);

###    &$System::perform("/bin/mv $status_log $Filesystem::DARTS_STATUS_LOGS_DIR") if (defined($status_log));
    &$System::perform("/bin/mv $status_log $Filesystem::DARTS_STATUS_LOGS_DIR") if (defined($status_log));

    if ($status_log_open) {
	&$System::log("$string");
	&$System::log("\n--------------------------------\n");
    }
    
    Pipeline::close_local_log();
}

sub pipeline_exit {
    my $junk = shift;
    my $code = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);

    System::dprint("Status::pipeline_exit: $code, $message\n");
#    &$System::perform("/bin/mv $status_log $Filesystem::DARTS_STATUS_LOGS_DIR");

    my $string = "*** " . scalar(localtime) . " (JST) PIPELINE EXIT: ($code) $message\n"; 
####    &$System::log($string);
    save_log($string);
#    print "DIE:  $code ($message)\n";
#    main_log_message(scalar(localtime) . " (JST) EXIT:  $code ($message)");
    Pipeline::_main_log_message($string);
#    if ($code == 0) {
#	print $MLOG "*** " . $string
#    }
#    else{
#	print $MLOG $string;
    #    }
#    close $MLOG;
#    close $LOG;
    #    exit $code;
    
    System::dprint("Status::pipeline_exit: returning $code\n");
    return $code;
}

1;
