package Filesystem;

#print "HINODE/EIS/EISPIPELINE/FILESYSTEM.PM\n";

use strict;
use warnings;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/Filesystem\n";
}

# Move or remove - in EisStatus/Filesystem
#our $program_name = "daily_merge_status_v2.pl";

#our $HOME = $ENV{'HOME'};								# $HOME
my $HOME = $ENV{'HOME'};								# $HOME

our $BIN_DIR                     = $HOME                   	. "/bin";		# $HOME/bin

our $DATA_DIR                    = $HOME                   	. "/data";		# $HOME/data

our $DATA_QUICKLOOK_DIR          = $DATA_DIR               	. "/quicklook";		# $HOME/data/quicklook

#my  $DATA_STAGING_DIR            = $DATA_DIR               	. "/staging";	       	# $HOME/data/staging
our $DATA_STAGING_DIR            = $DATA_DIR			. "/staging";		# $HOME/data/staging
our $DARTS_STAGING_DIR           = $DATA_STAGING_DIR;					# $HOME/data/staging
our $DATA_STAGING_LOGS_DIR       = $DATA_STAGING_DIR       	. "/logs";		# $HOME/data/staging/logs

#our $DATA_LOGS_DIR               = $DATA_STAGING_LOGS_DIR;				# $HOME/data/staging/logs

our $TMP_DIR                     = $HOME                   	. "/tmp";		# $HOME/tmp

our $TRACK_DIR                   = $HOME                   	. "/track";		# $HOME/track

our $WORK_DIR                    = $HOME                   	. "/work";		# $HOME/work
#my  $IDL_DIR                     = $WORK_DIR               	. "/idl";		# $HOME/work/idl
our $LOCAL_IDL                   = $WORK_DIR               	. "/idl";		# $HOME/work/idl
our $LOCALDATA_DIR               = $WORK_DIR               	. "/localdata";		# $HOME/work/localdata
#our $LOCALDATA                   = $LOCALDATA_DIR;					# $HOME/work/localdata
our $LOCALDATA_LOG_DIR           = $LOCALDATA_DIR          	. "/log";		# $HOME/work/localdata/log
#our $LOCAL_LOG_DIR               = $LOCALDATA_LOG_DIR;					# $HOME/work/localdata/log
											# $HOME/work/localdata/log/dr
											# $HOME/work/localdata/log/late
#my  $LOCALDATA_TIMING_DIR        = $LOCALDATA_DIR		. "/merge";		# $HOME/work/localdata/log/merge
#our $LOCAL_LOG_MERGE_DIR         = $LOCALDATA_LOG_DIR          	. "/merge";		# $HOME/work/localdata/log/merge
											# $HOME/work/localdata/log/old
our $PIPELINE_LOG_DIR            = $LOCALDATA_LOG_DIR          	. "/pipeline";		# $HOME/work/localdata/log/pipeline

#our $LOCAL_LOG_MERGE_TMP_DIR     = $LOCALDATA_LOG_DIR    	. "/tmp" ;		# $HOME/work/localdata/log/tmp ???
our $LOCALDATA_PIPELINE_DIR      = $LOCALDATA_DIR          	. "/pipeline";		# $HOME/work/localdata/pipeline
#my  $LOCALDATA_PIPELINE_FITS_DIR = $LOCALDATA_PIPELINE_DIR 	. "/fits";		# $HOME/work/localdata/pipeline/fits
our $LOCALDATA_FITS_DIR          = $LOCALDATA_PIPELINE_DIR 	. "/fits";		# $HOME/work/localdata/pipeline/fits
#our $LOCALDATA_PIPELINE_IDL_DIR  = $LOCALDATA_PIPELINE_DIR 	. "/idl";		# $HOME/work/localdata/pipeline/idl
our $TEMP_IDL                    = $LOCALDATA_PIPELINE_DIR      . "/idl";		# $HOME/work/localdata/pipeline/idl
my  $LOCALDATA_TEMP_FITS_DIR     = $LOCALDATA_PIPELINE_DIR 	. "/temp_fits";		# $HOME/work/localdata/pipeline/temp_fits

my  $LOCALDATA_SDTP_DIR          = $LOCALDATA_DIR          	. "/sdtp";		# $HOME/work/localdata/sdtp
###my  $LOCALDATA_SDTP_DIR          = $LOCALDATA_DIR          	. "/sdtp_v2";		# $HOME/work/localdata/sdtp

my  $LOCAL_QUICKLOOK             = $LOCALDATA_SDTP_DIR;					# $HOME/work/localdata/sdtp ???
#my  $LOCALDATA_DMP_DIR           = $LOCALDATA_SDTP_DIR 	. "/dmp";		# $HOME/work/localdata/sdtp/dmp
my  $LOCALDATA_SDTP_FITS_DIR     = $LOCALDATA_SDTP_DIR     	. "/fits";		# $HOME/work/localdata/sdtp/fits
my  $LOCALDATA_MERGE_DIR         = $LOCALDATA_SDTP_DIR     	. "/merge";		# $HOME/work/localdata/sdtp/merge
our $MERGE_DIR                   = $LOCALDATA_MERGE_DIR;				# $HOME/work/localdata/sdtp/merge
our $RECEIVED_DIR                = $MERGE_DIR;						# $HOME/work/localdata/sdtp/merge
our $TEMP_FITS_DIR               = $LOCALDATA_TEMP_FITS_DIR;				# $HOME/work/localdata/sdtp/tmp_fits ???

#our $CHECK_TABLE_DIR              = $MERGE_DIR . "/chk";

our $NOWHERE = "/dev/null";

### Files ###

our $PIPELINE_LOG = $PIPELINE_LOG_DIR . "/pipeline_log_version2.txt";			# $HOME/work/localdata/log/pipeline/pipeline_log.txt

our $UNKNOWN = "UKNOWN";

###our $mission_log_open = 0;
my $local_log_open = 0;

sub home {
    return $HOME;
}

our $dir;
our $status;
our $name;

sub module_path_dump {
    my $module_name = shift;
    my @paths = @_;

    my %paths;
    foreach my $fa (@paths) {
#	my @f = @{$fa};
#	my $fn = $f[0];
#	my $fp = $f[1];
#	local ($ff, $fff) = @$fa;
	my ($fn, $fp) = @$fa;
#	print "f = $fn $fp\n";
	$paths{$fn} = $fp;
#	print "f = $fn, $f\n";
    }

    foreach my $f (sort keys %paths) {
	my $stat = "ERROR";
	$dir = $paths{$f};
	$stat = "OK" if ((-d $dir) || (-e $dir));
	$name = $f;
	$status = $stat;
#	write;
	print "$module_name: $f $dir $status\n";
    }

}

sub dump_paths {
    my @modules = qw(Args);
    foreach my $module (@modules) {
	print "Module: $module\n";
	#my $cmd = "&\$" . "$module" . "::mod_path_dump();";
	my $cmd =  "$module" . "::mod_path_dump();";
#	print "cmd = $cmd\n";
	eval $cmd;
#	my $foo = eval "2 + 2";
#	print "foo = $foo\n";
    }
}

#our $dir;
#our $status;
#our $name;
#my $dir;
#my $status;
#my $name;

sub path_dump {

    my @n = qw(HOME BIN_DIR DATA_DIR DATA_QUICKLOOK_DIR DATA_STAGING_DIR DARTS_STAGING_DIR DATA_STAGING_LOGS_DIR TMP_DIR TRACK_DIR WORK_DIR LOCAL_IDL LOCALDATA_DIR LOCALDATA_LOG_DIR PIPELINE_LOG_DIR LOCALDATA_PIPELINE_DIR TEMP_IDL MERGE_DIR RECEIVED_DIR TEMP_FITS_DIR);

    my %h;
    
    foreach my $f (@n) {
	$h{$f} = eval "\$" . $f;
	#$h{$f} = eval $f;
    }
    foreach my $f (sort keys %h) {
	my $stat = "ERROR";
	$dir = $h{$f} || "Unknown";
	$name = $f;
###	print "$f $dir\n";
	$stat = "OK" if ((-d $dir) || (-e $dir));
	$status = $stat;
	#write STDOUT;
	write;
    }
    
}

format STDOUT =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @>>>>
$name, $dir, $status
.


#=cut

    
1;
