package Flags;

#print "HINODE/EIS/EISPIPELINE/FLAGS.PM\n";

use strict;
use warnings;

use Trace::Trace;

use Hinode::EIS::EisPipeline::System;

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/Flags\n";
}

our $cron         = 0;
our $cron_pending = 0;

our $TESTING        = 1 - 1;
my  $FORCE_REFORMAT = 1 - 1;
my  $RESCUE_MOD     = 1;
my  $USE_NEW_RESCUE = 1;
my  $SPECIAL        = "";

my  $NO_FETCH_FLAG   = 0;
my  $FETCH_ONLY_FLAG = 0;
my  $JUST_FITS_FLAG  = 0;

our $REFORMAT_VERSION = "v1";

my %flags = (
    testing                => 1 - 1,
    force_reformat         => 1 - 1,
    rescue_mod             => 1,
    use_new_rescue         => 1,
    special                => "",

    cron                   => 0,
    cron_pending           => 0,

    no_fetch               => $NO_FETCH_FLAG,
    fetch_only_flag        => $FETCH_ONLY_FLAG,
    just_fits_flag         => $JUST_FITS_FLAG,
#    reformat_version       => 'v1',
    reformat_version       => $REFORMAT_VERSION,
#    recover_test_flag      => 0,
#    no_rescue_flag         => 0,
#    fits_only_flag         => 0,
#    no_soda_flag           => 0,
#    old_seq_flag           => 0,
#    skip_hk                => 0,
#    no_update_darts_trends => 0,
#    status_reformat        => "v2",
    );

sub flag_test {
    my $flag = shift;

    Trace::trace((caller(0))[3]);

    my $ret = ! flag_resetp(lc $flag);
    &$System::comment("Skipping stage because $flag is set") if $ret;
    return $ret;
}

sub flag_value {
    my $flag = shift;

    Trace::trace((caller(0))[3]);

    return $flags{lc($flag)} if defined($flags{lc($flag)});
    return "";
}

sub set_flag_value {
    my $flag = shift;
    my $value = shift;

    Trace::trace((caller(0))[3]);
    print "set_flag_value: setting flag $flag to $value\n";
    
    $flags{lc($flag)} = $value; # if defined($flags{lc($flag)});
}

sub flag_resetp {
    my $flag = shift;

    Trace::trace((caller(0))[3]);
    return (defined($flags{lc($flag)})) ? $flags{lc($flag)} == 0 : 0;
}

sub flag_setp {
    my $flag = shift;
    my $label = shift;

    Trace::trace((caller(0))[3]);

    &$System::comment(uc($flag) .  " set, skipping to $label") if ! flag_resetp($flags{$flag});
    return ! flag_resetp($flag);
    return (defined($flags{lc($flag)})) ? $flags{lc($flag)} : 0;
}

sub reset_flag {
    my $flag = shift;

    Trace::trace((caller(0))[3]);
    $flags{lc($flag)} = 0 if defined($flags{lc($flag)});
}

sub set_flag {
    my $flag = shift;

    Trace::trace((caller(0))[3]);
    $flags{lc($flag)} = 1 if defined($flags{lc($flag)});
}

1;

