package Pipeline;

#print "HINODE/EIS/EISPIPELINE/PIPELINE.PM\n";

use strict;
use warnings;
use Time::Local;

use Trace::Trace;

use Hinode::EIS::EisPipeline::Args;
use Hinode::EIS::EisPipeline::Dates;
use Hinode::EIS::EisPipeline::Errors;
use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::Flags;
use Hinode::EIS::EisPipeline::System;


my $program_name = "daily_merge_pipeline_v2.pl";
my $version = "0.1b";

BEGIN {
    my $name = $0;
    $name =~ s/^\.\///;
    $program_name = $name;
    print "BEGIN Hinode/EIS/EisPipeline/Pipeline $program_name\n";
    my $junk = `unalias -a ls`;
}

END {
    print "END Hinode/EIS/EisPipeline/Pipeline $program_name\n";
}

my $pipeline;
my $local_pipeline;

our $state = "interactive";
our $kick_string = "";

#our $mission_log     = "";
#our $status_log      = ""; # $ LOG_DIRECTORY . "/pipeline_mission_log_";

my $MLOG;
my $main_log_open = 0;

my $LOCAL_LOG;
my $local_log_open = 0;

my $announce = ""; #scalar(localtime) . " $System::timezone $System::program_name started";


sub prepare_announce {
    #Trace::trace(__PACKAGE__."::prepare_announce");
    Trace::trace((caller(0))[3]);

###    $announce = scalar(localtime) . " $System::timezone $System::program_name started";
    $announce = scalar(localtime) . " $System::timezone $program_name version $version started";
}


sub is_mission_pipeline {
    Trace::trace((caller(0))[3]);

    return $pipeline eq "Mission";
}


sub is_status_pipeline {
    Trace::trace((caller(0))[3]);

    return $pipeline eq "Status";
}


sub pipeline {
    Trace::trace((caller(0))[3]);

    return $pipeline;
}


sub local_pipeline {
    Trace::trace((caller(0))[3]);

    return $local_pipeline;
}


sub start_log {
    #Trace::trace(__PACKAGE__."::start_log");
    Trace::trace((caller(0))[3]);

    open_pipeline_log();
}


sub create {
    Trace::trace((caller(0))[3]);

    $pipeline = shift;

    $pipeline->init();

    open_pipeline_log();

    check_pipeline($pipeline);
###    check_pipeline();

    Dates::today();

################    pipeline_die(-1000, "Invalid pipeline ($pipeline)") unless check_pipeline($pipeline);
    
#    pipeline_die(-1, "No bin environment variable detected (HINODE_BIN)") unless $ENV{'HINODE_BIN'};
#    pipeline_die(-1, "No sswidl environment variable detected (SSWIDL)") unless $ENV{'SSWIDL'};

#    print STDERR "Pipeline::create : No bin environment variable detected (HINODE_BIN)\n" unless $ENV{'HINODE_BIN'};
#    print STDERR "Pipeline::create : No sswidl environment variable detected (SSWIDL)\n" unless $ENV{'SSWIDL'};
=pod
###    pipeline_warn(100, "Pipeline::create (line " . __LINE__ . ") : No bin environment variable detected (HINODE_BIN)") unless $ENV{'HINODE_BIN'};
    pipeline_die(100, "Pipeline::create (line " . __LINE__ . ") : No bin environment variable detected (HINODE_BIN)") unless $ENV{'HINODE_BIN'};
###    pipeline_warn(101, "Pipeline::create (line " . __LINE__ . ") : No sswidl environment variable detected (SSWIDL))") unless $ENV{'SSWIDL'};
    pipeline_die(101, "Pipeline::create (line " . __LINE__ . ") : No sswidl environment variable detected (SSWIDL))") unless $ENV{'SSWIDL'};
=cut
}


sub open_pipeline_log {
    #System::dprint("Opening pipeline log ($Filesystem::PIPELINE_LOG)");
    #Trace::trace(__PACKAGE__."::open_pipeline_log");
    Trace::trace((caller(0))[3]);

###    open($MLOG, ">>$System::PIPELINE_LOG") || pipeline_die(-1, "Can't open main pipeline log: $!");
    open($MLOG, ">> $Filesystem::PIPELINE_LOG") || die "Can't open main pipeline log: $!";
    $main_log_open = 1;
#    open($MLOG, ">>$System::PIPELINE_LOG") || pipeline_send_mail("Can't open main pipeline log: $!");
#    pipeline_send_mail("Got main pipeline log");
}

=pod
sub open_mission_log {
    #Trace::trace(__PACKAGE__."::open_mission_log");
    Trace::trace((caller(0))[3]);

    $mission_log = $Filesystem::MISSION_LOG . $Dates::sdate . '_' . $Dates::edate . ".txt";
    open(LOG, ">> $mission_log"), $System::mission_log_open = 1 || pipeline_die(-2, "Pipeline::open_mission_log (" . __LINE__ . ") : Can't open pipeline_mission_log.txt for writing: $!");
    System::dprint("Starting logger for $state\n");
    System::init(*LOG, $state);
    #init1(*LOG, $start_flag);
}
=cut

=pod
sub open_status_log {
#    my $start_flag = shift;
#    my $start_flag = $state;

    #Trace::trace(__PACKAGE__."::open_status_log");
    Trace::trace((caller(0))[3]);

    $status_log = $Filesystem::STATUS_LOG . $Dates::sdate . '_' . $Dates::edate . ".txt";
    open(LOG, ">> $status_log"), $System::status_log_open = 1 || pipeline_die(-2, "Pipeline::open_status_log (" . __LINE__ . ") : Can't open pipeline_status_log.txt for writing: $!");
    System::dprint("Starting logger for $state ($System::status_log_open)\n");
    System::init(*LOG, $state);
    #init1(*LOG, $start_flag);
}
=cut

sub open_local_log {
    Trace::trace((caller(0))[3]);

    $LOCAL_LOG      = $pipeline->open_local_log();
    $local_log_open = 1 if $LOCAL_LOG;
}

sub close_local_log {
    Trace::trace((caller(0))[3]);

    close $LOCAL_LOG;
    $local_log_open = 0;
}

sub local_announce {
    #Trace::trace(__PACKAGE__."::local_announce");
    Trace::trace((caller(0))[3]);

    my $msg = shift;

    prepare_announce();
#    print "LOCAL ANNOUNCE $announce, $kick_string, $Args::command_line\n";
    &$System::log("\n*** $announce $kick_string");
    &$System::log("\t" . $Args::command_line);
    &$System::log("\t" . $msg) if $msg;
}


sub announce {
    #Trace::trace(__PACKAGE__."::announce");
    Trace::trace((caller(0))[3]);

    prepare_announce();
    _main_log_message("\n" . $announce . " $kick_string");
    # Temporary
    print "\nTEMPORARY*** " . $announce . " $kick_string\n";
}


sub log {
    my $msg = shift;

    #Trace::trace(__PACKAGE__."::log");
    Trace::trace((caller(0))[3]);

    print "\t" . $msg . "\n";
}


sub main_log_message {
    my $msg = shift;

    #Trace::trace(__PACKAGE__."::main_log_message");
    Trace::trace((caller(0))[3]);
    System::dprint("\t" . $msg . "\n");

    _main_log_message("\t$msg");
}


sub _main_log_message {
    my $msg = shift;

    Trace::trace((caller(0))[3]);

# Uncomment when working properly
    print $MLOG "$msg\n" if $MLOG;
}

sub pipeline_warn {
    my $code    = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);

    print "Warning: $code : $message\n";
    &$System::comment("WARN: $code : $message") if $System::local_log_open;
    _main_log_message("\tWARN: ($code) $message");
}


sub cron_finished {
    Trace::trace((caller(0))[3]);
}

# In EisStatus/Pipeline.pm and EisMission/Pipeline.pm
# Write out dates to schedule file
=pod
sub cron_finished {
#    my $pipeline = shift;
    my $code = shift;
    my $message = shift;

    #Trace::trace(__PACKAGE__."::cron_finished");
    Trace::trace((caller(0))[3]);
    
    &$System::log("\tPipeline::cron_finished : Updating cron schedule file");
    $pipeline->cron_finished($code, $message);
    pipeline_exit($code, $message);
    return;
    
    if (is_mission_pipeline()) {
	&$System::perform("/bin/echo $Dates::sdate $Dates::edate $Dates::stime $Dates::etime > $Filesystem::CRON_SCHEDULE_FILE");
    }
    else {
	&$System::perform("/bin/echo $Dates::sdate $Dates::edate > $Filesystem::STATUS_CRON_SCHEDULE_FILE");
    }
    pipeline_exit($code, $message);
}
=cut

=pod
sub save_log {
    my $string = shift;

    #Trace::trace((caller(0))[3]);
    Trace::trace(__PACKAGE__."::save_log");

    $pipeline->save_log($string);
    return;
    
    my $log_open = (is_mission_pipeline()) ? $System::mission_log_open : $System::status_log_open;
    if (is_mission_pipeline()) {
	# Where is move file?
	&$System::perform("/bin/mv $mission_log $Filesystem::DARTS_MISSION_LOG_DIR");
    }
    else {
	&$System::perform("/bin/mv $status_log $Filesystem::DARTS_STATUS_LOGS_DIR");
    }
    &$System::log("$string") if $log_open;
    &$System::log("\n--------------------------------\n") if $log_open;
}
=cut

sub pipeline_die {
    my $code    = shift;
    my $message = shift;

    Trace::trace((caller(0))[3]);

    my $string = scalar(localtime) . " $System::timezone DIE : ($code) $message";
#    System::dprint("DIE: $code ($message)\n");
    &$System::comment(scalar(localtime) . " DIE: Code $code : $message") if $System::local_log_open;

    Pipeline::pipeline_exit($code, $message);
    return;

    clean_up();
    $pipeline->save_log($string) if defined($pipeline);
#    _main_log_message("*** $string\n");
    exit_pipeline($code, $message)
#    exit $code;
}


sub pipeline_exit {
    my $code    = shift;
    my $message = shift;

    Trace::trace((caller(0))[3], "$code : $message");

    &$System::stage_title("Pipeline::pipeline_exit : Exiting");

###    my $code = pipeline()->pipeline_exit(@_);
############    my $code1 = pipeline()->pipeline_exit($code, $message);

###my $string = "\n*** " . scalar(localtime) . " (JST) EXIT: ($code) $message\n"; 
    my $string = "\n*** " . scalar(localtime) . " $System::timezone - PIPELINE EXIT: ($code) $message\n"; 
#    Pipeline::_main_log_message($string);

    clean_up();
 
    $pipeline->save_log($string);
  
###    pipeline()->save_log();

    exit_pipeline($code, $message)
}


# Sun Jun 28 23:21:46 2020 (JST) - Cleaning up
#/bin/rm /home/sbukeis/work/localdata/pipeline/fits/*
#    /bin/rm /home/sbukeis/work/localdata/pipeline/plots/*
#    /bin/rm /home/sbukeis/work/localdata/sdtp/merge/eis_md*

sub clean_up {
    Trace::trace((caller(0))[3]);

    &$System::stage_title("Pipeline::clean_up : Cleaning up");
    &$System::perform("/bin/rm $Filesystem::LOCALDATA_FITS_DIR" . "/*");

    my $func = \$pipeline->clean_up;
#    &$System::run_stage($func, "Clean up") if defined($pipeline);                                                
#    &$System::run_stage(\&$pipeline->clean_up(), "Clean up") if defined($pipeline);
    $pipeline->clean_up() if defined($pipeline);
}


sub check_pipeline {
    Trace::trace((caller(0))[3]);

###    pipeline_die($Errors::NO_HINODE_BIN_CODE, sprintf($Errors::NO_HINODE_BIN_MSG, __LINE__)) unless $ENV{'HINODE_BIN'};
    pipeline_warn(100, "Pipeline::create (line " . __LINE__ . ") : No bin environment variable detected (HINODE_BIN)") unless $ENV{'HINODE_BIN'};
###    pipeline_die($Errors::NO_SSWIDL_CODE, sprintf($Errors::NO_SSWIDL_MSG, __LINE__)) unless $ENV{'SSW'};
    pipeline_warn($Errors::NO_SSWIDL_CODE, sprintf($Errors::NO_SSWIDL_MSG, __LINE__)) unless $ENV{'SSW'};

    my $ret = ($pipeline eq "Status") || ($pipeline eq "Mission");
    pipeline_die($Errors::NO_PIPELINE_CODE, sprintf($Errors::NO_PIPELINE_MSG, __LINE__, $pipeline)) unless $ret;
}


sub exit_pipeline {
    my $code    = shift;
    my $message = shift;

    #Trace::trace(__PACKAGE__."::exit_pipeline");
    Trace::trace((caller(0))[3]);

    print "exit_pipeline: $code, $message\n";
    
    if (($Flags::cron) && (! $Flags::cron_pending)) {
	cron_finished($code, $message);
    }
    
    # Copy log to darts
    close $MLOG;
    system("/bin/cp $Filesystem::PIPELINE_LOG $Filesystem::DATA_STAGING_LOGS_DIR");
    exit $code;
}

=pod
sub pipeline_send_mail {
    my $message = shift;

    my $to = 'misterfluff@me.com';
    my $from = 'misterfluff@me.com';
    my $subject = 'Test Email';
 
    Trace::trace("EisPipeline::pipeline_send_mail");

    if (open(MAIL, "|/usr/sbin/sendmail -t")) {
 
# Email Header
	print MAIL "To: $to\n";
	print MAIL "From: $from\n";
	print MAIL "Subject: $subject\n\n";
# Email Body
	print MAIL $message;

	close(MAIL);
	print "Email Sent Successfully\n";
    }
    else {
	print "Couldn't send email: $!\n";
    }
}
=cut

1;
