package System;

#print "HINODE/EIS/EISPIPELINE/SYSTEM.PM\n";

use strict;
use warnings;

use Trace::Trace;

use Hinode::EIS::EisPipeline::Filesystem;
use Hinode::EIS::EisPipeline::EisMission::Hk;
#use Hinode::EIS::EisPipeline::Trace;


###our $program_name = "";

sub BEGIN {
    print STDOUT "BEGIN Hinode/EIS/EisPipeline/System\n";
}

#our $program_name = "daily_merge_status_v2.pl";

my $DEBUG_PRINT = 1;

#our $HOME = $ENV{'HOME'};								# $HOME
#my $HOME = $Filesystem::HOME;								# $HOME
#our $SSWIDL = $HOME . "/ssw_idl";


###our $mission_log_open = 0;
my $local_log_open = 0;

our $timezone = "(JST)";

my %stage = (
    0 => [\&Hk::check_availability, "Hk::check_availability : Status coverage check"],
    1 => [\&Hk::check_sat_rot,      "Hk::check_sat_rot : Check whether the sat rot csv files cover reformat period"],
    );

# Debugging
sub set_debug {
    my $on_off = shift;
    Trace::trace("System::set_debug");
    $DEBUG_PRINT = $on_off;
}

sub debug_on {
    Trace::trace("System::debug_on");
    set_debug(1);
}

sub debug_off {
    Trace::trace("System::debug_off");
    set_debug(0);
}

sub dprint {
    my $msg = shift;
    Trace::trace("System::dprint");
    print "DPRINT : $msg\n" if $DEBUG_PRINT;
}

sub set_timezone_string {
    $timezone = shift;
    Trace::trace("System::set_timezone_string");
}

# Generate filehandle closure
sub gen_fh {
    my $fh = shift;
    Trace::trace("System::gen_fh");
    return sub { $fh; };
}

# Logger closure
sub logger {
    my $stdout = shift;
    my $fh = shift;
    Trace::trace("System::logger");
    if($stdout == 1) {
	return sub {
	    my $msg = shift;
	    if ($local_log_open) {
		print STDOUT "$msg\n";
		print $fh "$msg\n";
	    }
	};
    }
    return sub {
	my $msg = shift;
	print $fh "$msg\n" if $local_log_open;
	print STDOUT "$msg\n";  ### TEMP!!!! Remove this to make cron jobs work as required...
    };
}

# Stage closure
sub start_stage {
    Trace::trace("System::start_stage");
    my $stage = 0;
    return sub { $stage++ };
}

# Stage steps closures
my $step = 0;
sub next_step {
    Trace::trace("System::next_step");
    return sub { $step++ };
}

sub reset_step {
    Trace::trace("System::reset_step");
    return sub { $step = 0; };
}

# Return the (log, perform, title) closures for interactive or cron modes
sub init_system {
    my $filehandle = shift;
    my $state      = shift;
    my $fh         = gen_fh($filehandle);
    my $out_fh     = ($state eq "interactive") ? 1 : 0;
    my $log_it     = logger($out_fh, $filehandle);
    my $next_stage = start_stage();
    my $step       = next_step();
    my $step_reset = reset_step();
    $local_log_open = 1;
    Trace::trace("System::init_system");
    return (

	# log
	sub {
	    my $msg = shift;
	    Trace::trace("System::log");
#	    &$log_it("\t" . $msg);
	    &$log_it($msg);
	},
	
	# comment
	sub {
	    my $msg = shift;
	    Trace::trace("System::comment");
	    &$log_it("\t# " . $msg);
	    return 1;
	},
	
	# code log
	sub {
	    my $msg = shift;
	    Trace::trace("System::code_log");
	    &$log_it("\t" . $msg);
	},
	
	# perform
	sub {
	    my $cmd = shift;
	    Trace::trace("System::perform");
	    &$log_it("\t" . $cmd);
	    system($cmd);
	},

	# Perform with title message
	#	     sub {
	#	         my $title = shift;
	#		 my $cmd = shift;
	#		 &$log_it("\t# " . $title);
	#		 &$log_it("\t" . $cmd);
	#		 system($cmd);
	#	     },
	
	# Step
	sub {
	    my $msg = shift;
	    Trace::trace("System::step");
	    &$log_it("\t# Step " . $step->() . " - $msg");
	    ### Experiment
	    my $cmd = shift;
	    #	    perform($cmd) if $cmd;
	    if ($cmd) { &$log_it("\t" . $cmd);
			####			system($cmd);
	    }
	},

	# reset
	sub {
	    Trace::trace("System::step_reset");
	    $step_reset->();
	},

	# stage_title
	sub {
	    my $title = shift;
	    my $ct  = scalar(localtime);
	    Trace::trace("System::stage_title");
	    ##my $option = "(JST)";
	    #my $cts = "$ct (JST) - ";
	    my $cts = "$ct $timezone - ";
	    my $ntitle = "$cts Stage " . $next_stage->() . " : $title";
	    &$log_it("\n--------------------------------\n");
	    &$log_it($ntitle);
	    &$step_reset();
	}

    );
}

sub init_system1 {
    Trace::trace("System::init_system1");
    return (
	sub {
	    my $function = shift;
	    my $message  = shift;
	    #	    print "RUN_STAGE: $message\n";
	    Trace::trace("System::run_stage");
	    &$System::stage_title($message);
	    &$function();
	});
}

sub init_list {
    Trace::trace("System::init_list");
    return (
	sub {
	    my $dir = shift;
	    my $file_spec = shift;
	    my $line = "$dir/$file_spec";
	    System::dprint("list : $dir, $file_spec\n");
#	    print "count: $line\n";
	    &$System::code_log("\@files = `/bin/ls $line`");
	    my @files = `/bin/ls $line`;
	    return @files;
	});
}

sub init_debug {
    Trace::trace("System::init_debug");
    return (
	sub {
	    my $message = shift;
	    print "<<< $message >>>\n";
	});
}

sub init {
    my $filehandle = shift;
    my $state      = shift;

    Trace::trace("System::init");
    ###print "System::init\n";
    our ($log, $comment, $code_log, $perform, $stage_step, $zero_steps, $stage_title) = init_system($filehandle, $state);
    our $run_stage = init_system1();
    our $debug     = init_debug();
    our $list      = init_list();
}
    
1;
