package Ccsds;

use strict;
use warnings;

our (@ISA, @EXPORT, $VERSION);
@ISA = qw(Exporter);
@EXPORT = ();
$VERSION = 1.00;

sub BEGIN {
    print STDOUT "BEGIN LibCcsds/Ccsds\n";
}

$Ccsds::startPacket        = 1;
$Ccsds::continuationPacket = 0;
$Ccsds::lastPacket         = 2;
$Ccsds::standalonePacket   = 3;

%Ccsds::endianString     = ("big"   => "n3",
			    "small" => "v3");

%Ccsds::timeEndianString = ("big"   => "n2",
			    "small" => "v2");

%Ccsds::packet_types     = (''      => 'CcsdsPacket',
			    'Eis'   => 'EisCcsdsPacket');

$Ccsds::NOK = 0;
$Ccsds::OK  = 1;
$Ccsds::EOF = 2;

$Ccsds::MAX_SEQUENCE_COUNT      = 0x3FFF;
$Ccsds::MAX_SEQUENCE_COUNT_MASK = $Ccsds::MAX_SEQUENCE_COUNT + 1;

sub packetTypeForString {
    my $string = shift;
    if (defined($Ccsds::packet_types{$string})) {
	return $Ccsds::packet_types{$string};
    }
    else {
	return 'CcsdsPacket';
    }
}

sub isFirstPacketOfSequence {
    my $flag = shift;
    return $flag == $Ccsds::startPacket;
}

sub isLastPacketOfSequence {
    my $flag = shift;
    return $flag == $Ccsds::lastPacket;
}

sub isMiddlePacketOfSequence {
    my $flag = shift;
    return $flag == $Ccsds::continuationPacket;
}

sub isStandAlonePacketOfSequence {
    my $flag = shift;
    return $flag == $Ccsds::standalonePacket;
}

1;
