package CcsdsInterface;

use IO::Handle;

use strict;
use warnings;

use Base::Base;
#use Trace::Trace;

#use vars qw(@ISA @EXPORT $VERSION); # Deprecated: use our
our (@ISA, @EXPORT, $VERSION);

@ISA = qw(Exporter Base);
#my @EXPORT = qw(setEndian nextPacket printPrimaryHeader);
@EXPORT = ();
$VERSION = 1.00;


sub BEGIN {
###    print STDOUT "BEGIN LibCcsds/CcsdsInterface\n";
}

sub new {

    # Either of next 2 lines works
#    my ($classname) = @_;
    my $classname = shift;

    my $self = $classname->SUPER::new(@_);
    $self->trace("CcsdsInterface::new $classname");
    $self->ccsdsInterface_init(@_);
    bless $self, $classname; 
    return $self;
}

sub ccsdsInterface_init {
    my $self = shift;

    $self->trace((caller(0))[3]);
#    $self->trace("CcsdsInterface::init");
#    Trace::trace((caller(0))[3]);
    $self->{_fileHandle} = undef;
    $self->{_mark} = 0;
    $self->{_markedPos} = 0;
 }

sub debug {
    my $self = shift;

    $self->trace((caller(0))[3]);

    print "*** LibCcsds/CcsdsInterface::debug start ***\n";
    print "\tMark : $self->{_mark}\n";
    $self->SUPER::debug();
    print "--- LibCcsds/CcsdsInterface::debug end ---\n";
}

sub rewind {
    my $self = shift;

    $self->trace("CcsdsInterface::rewind");
    seek($self->{_fileHandle}, 0, 0);
}

sub fileHandle {
    my $self = shift;

    $self->trace("CcsdsInterface::fileHandle");
    return $self->{_fileHandle};
}

sub openForWriting {    
    my $self = shift;
    my $file = shift;
    
    $self->trace("CcsdsInterface::openForWriting $file");
    if(open(OFILE_HANDLE, "> $file")) {
	binmode OFILE_HANDLE;
	$self->{_fileHandle} = *OFILE_HANDLE;
	return 1;
    }
    else {
	return 0;
    }
}

sub openForReading {
    my $self = shift;
    my $file = shift;

    $self->trace("CcsdsInterface::openForReading $file");
    if(open(FILE_HANDLE, "< $file")) {
	$self->{_fileHandle} = *FILE_HANDLE;
	$self->{_mark} = 1;
	return 1;
    }
    else {
	return 0;
    }
}

sub closeFile {
    my $self = shift;

    $self->trace("CcsdsInterface::closeFile");
    close $self->{_fileHandle};
}

sub mark {
    my $self = shift;

    $self->{_markedPos} = tell();
    $self->{_mark} = 1;
}

sub clear_mark {
    my $self = shift;

    $self->{_mark} = 0;
}

sub un_read {
    my $self = shift;

    seek $self->{_fileHandle}, $self->{_markedPos}, 0;
    $self->clear_mark();
}

1;
