package CcsdsPacket;

use strict;
use warnings;
use Exporter;

use Base::Base;
use LibCcsds::Ccsds;

# Deprecated
# use vars qw(@ISA @EXPORT);
our (@ISA, @EXPORT, $VERSION);
@ISA = qw(Exporter Base);
@EXPORT = (); #qw(setHeaderInfo data);
$VERSION = 0.1;

sub BEGIN {
    print "BEGIN LibCcsds/CcsdsPacket\n";
}

#sub new {
####    my ($class) = @_;
##    my $classname = shift;
##    my $self = $classname->SUPER::new(@_);
##    $self->_init(@_);
##    return $self;
#
#    my ($class) = @_;
#    my $self = {
#		_header => undef,
#	};
#    bless $self, $class; 
#    return $self;
#}
#
#sub _init {
#    my $self = shift;
#    $self->{_header} = undef,
#}

# Never called, even when packet created with CcsdsPacket::create. This is because a sub-class object is
# created and that object's init method is called.
sub init {
    my $self = shift;
    my %options = @_;

    $self->trace("CcsdsPacket::init %options");
    foreach my $k (sort keys %options) {
	print "$k = ", $options{$k}, "\n";
    }
    $self->{_secondaryHeaderLength} = $options{'secondary_header_length'} || 0;
    $self->{_hasSecondaryHeader} = $options{'has_secondary_header'} || $self->{_secondaryHeaderLength} > 0 || 0;
    $self->{_endian} = $options{'endian'} || "big";
}

# Not really needed.
sub create {
    my $class = shift;
    my %options = @_;

    my $self = CcsdsPacket::new($class);
    $self->trace("CcsdsPacket::create $class %options");
    $self->init(%options);
    return $self;
}

sub new {
    #    my ($classname) = @_;
    my $classname = shift;
    my %options = @_;
    
    my $self = $classname->SUPER::new(@_);

    $self->trace("CcsdsPacket::new $classname");
    $self->ccsdsPacket_init();
###    $self->ccsdsPacket_init(%options);
    bless $self, $classname; 
    return $self;
}

sub ccsdsPacket_init {
    my $self = shift;
    
    $self->trace("CcsdsPacket::_init");
    $self->{_header} = undef;

    $self->{_primaryHeaderLength} = 6;
    $self->{_capacity} = 0;
	
    $self->{_primaryHeader} = "";
    $self->{_packetDataField} = "";

    $self->{_hasSecondaryHeader} = 0;
    $self->{_secondaryHeaderLength} = 0;

    $self->{_hasTimeCodeField} = 0;
    $self->{_timeCodeFieldLength} = 0;

    $self->{_hasAncillaryDataField} = 0;
    $self->{_ancillaryDataFieldLength} = 0;

    $self->{_endian} = "big";
	
    $self->{_packetVersion} = undef;
    $self->{_packetType} = undef;

    $self->{_packetSec_hdr} = undef;

    $self->{_packetApid} = undef;
    $self->{_packetSeq_flag} = undef;
    $self->{_packetSeq_count} = undef;
    $self->{_packetLength} = undef;
	
    $self->{_packetValid} = 0;
	
    $self->{_mark} = 0;
}

sub hasSecondaryHeader {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    $self->subclassResponsibility("$self hasSecondaryHeader");
    return $self->{_hasSecondaryHeader};
}

sub secondaryHeaderLength {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_secondaryHeaderLength};
}

sub readPrimaryHeader {
    my $self = shift;
    my $FH = shift;
    
    $self->trace((caller(0))[3]);

#    $self->trace("CcsdsPacket::readPrimaryHeader");
    my $res = read($FH,
		   $self->{_primaryHeader},
		   $self->{_primaryHeaderLength});
    if(!defined($res)) {
	print STDERR "Bad header read\n";
	return 0;
    }
    if ($res == 0) { $self->{_error} = $Ccsds::EOF; }
    return 0 if($res == 0);
    $self->header_decode();
    return 1;
}

sub readSecondaryHeader {
    my $self = shift;
    my $FH = shift;

    $self->trace((caller(0))[3]);

    $self->subclassResponsibility("readSecondaryHeader");

    my $res = read($FH,
		   $self->{_secondaryHeader},
		   $self->{_secondaryHeaderLength});    
    return(defined($res)) if(!defined($res));
    return 0 if($res == 0);
    $self->time_decode();
    return 1;
}

#sub readUserData {
#    my $self = shift;
#    my $FH = shift;
#    my $res = read($FH,
#		   $self->{_userDataField},
#		   #$self->{_packetLength} - 3);
#		   $self->packetLength());
#    return(defined($res)) if(!defined($res));
#    return ($res == 0) ? 0 : 1;
#}
sub readPacketDataField {
    my $self = shift;
    my $FH = shift;

    $self->trace((caller(0))[3]);

    my $res = read($FH,
		   $self->{_packetDataField},
		   $self->correctedPacketLength());
    return(defined($res)) if(!defined($res));
    return ($res == 0) ? 0 : 1;
}

sub writePacket {
    my $self = shift;
    my $FH = shift;

    $self->trace((caller(0))[3]);

#    print $self->printPrimaryHeader()
##    print $FH pack('C*', $self->packet());
    print $FH $self->packet();
}

# == 0 : Bad read
#  > 0 : Good read
sub nextPacket {
    my $self = shift;
    my $FH = shift;

    $self->trace((caller(0))[3]);

    $self->{_readPrimary} = 0;
    $self->{_readUserData} = 0;
    $self->{_packetValid} = 0;

    if($self->readPrimaryHeader($FH)) {
	$self->{_readPrimary} = 1;
	if($self->readPacketDataField($FH)) {
	    $self->{_readUserData} = 1;
	    ++$self->{_numberOfPackets};
	    $self->{_packetValid} = 1;
#	    print "CcsdsPacket : nextPacket : Returning ", sprintf("%X", $self->{_packetApid}), "\n";
	    return sprintf("%u", $self->{_packetApid});
	}
    }    
###    print STDERR "$self packet::nextPacket returning 0\n";
    return 0;
}

sub primaryHeaderLength {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_primaryHeaderLength};
}

sub setPrimaryHeaderLength {
    my $self = shift;
    my $len = shift;

    $self->trace((caller(0))[3]);

    $self->{_primaryHeaderLength} = $len if($len > 0);
}

sub setSecondaryHeaderLength {
    my $self = shift;
    my $len = shift;

    $self->trace((caller(0))[3]);
    
    $self->{_secondaryHeaderLength} = $len if($len > 0);
}

sub setEndian {
    my $self = shift;
    my $endianess = shift;

    $self->trace((caller(0))[3]);

    $self->{_endian} = $endianess if(($endianess eq "big") || ($endianess eq "small"));
}

sub endian {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_endian};
}

sub header {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_header};
}

sub packetDataField {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_packetDataField};
}

sub userDataField {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_userDataField};
}

sub packet {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    return join('', $self->{_primaryHeader}, $self->{_secondaryHeader}, $self->{_userDataField});
    return join('', $self->{_primaryHeader}, $self->{_packetDataField});
}

sub packetIsValid {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_packetValid};
}

sub getPrimaryHeader {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_primaryHeader};
}

#sub getSecondaryHeader {
#    my $self = shift;
#    return $self->{_secondaryHeader};
#}

sub getHeaders {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_primaryHeader} . $self->{_secondaryHeader};
}

sub printPrimaryHeader {
    my $self = shift;
#    my $FH = shift;
    my $tmp;
 
#    my $old_channel = $~;
#    my $old_filehandle = select $FH if $FH;

#    if ($FH) {
#	select $FH;
#    }
    
    $self->trace((caller(0))[3]);

    print "Version [", $self->{_packetVersion}, "] ";
    print "Type [", $self->{_packetType}, "] ";
    print "Sec  [", $self->{_packetSec_hdr}, "] ";
    $tmp = sprintf("0x%04X", $self->{_packetApid});
    print "APID [$tmp] ";
    print "Seq flg [", $self->{_packetSeq_flag}, "] ";
    $tmp = sprintf("0x%04X", $self->{_packetSeq_count});
    print "Seq cnt [$tmp] ";
    print "Len [", $self->{_packetLength}, "]\n";
=pod
#    if (defined($FH)) {
	print $FH "Version [", $self->{_packetVersion}, "] ";
	print $FH "Type [", $self->{_packetType}, "] ";
	print $FH "Sec  [", $self->{_packetSec_hdr}, "] ";
	$tmp = sprintf("0x%04X", $self->{_packetApid});
	print $FH "APID [$tmp] ";
	print $FH "Seq flg [", $self->{_packetSeq_flag}, "] ";
	$tmp = sprintf("0x%04X", $self->{_packetSeq_count});
	print $FH "Seq cnt [$tmp] ";
	print $FH "Len [", $self->{_packetLength}, "]\n";
#    $tmp = sprintf("0x%08X", $header->{'sc_time'});
#    print STDOUT "Sc time [$tmp]\n";

    }
    else {
	print STDOUT "Version [", $self->{_packetVersion}, "] ";
	print STDOUT "Type [", $self->{_packetType}, "] ";
	print STDOUT "Sec  [", $self->{_packetSec_hdr}, "] ";
	$tmp = sprintf("0x%04X", $self->{_packetApid});
	print STDOUT "APID [$tmp] ";
	print STDOUT "Seq flg [", $self->{_packetSeq_flag}, "] ";
	$tmp = sprintf("0x%04X", $self->{_packetSeq_count});
	print STDOUT "Seq cnt [$tmp] ";
	print STDOUT "Len [", $self->{_packetLength}, "]\n";
#	$tmp = sprintf("0x%08X", $header->{'sc_time'});
#	print STDOUT "Sc time [$tmp]\n";
    }
=cut
#    select $old_channel;
#    $~ = $old_channel;

#    select STDOUT;
}

sub printHeaders {
    my $self = shift;
    my $FH = shift;

    $self->trace((caller(0))[3]);

    select $FH if $FH;

    print "S/c time [", $self->{_spacecraftTime}, "] ";
###    $self->printPrimaryHeader($FH);
    $self->printPrimaryHeader();

    select STDOUT;
}

sub dumpHeaders {
    my $self = shift;
#    my $FH = shift;

    $self->trace((caller(0))[3]);

#    select $FH if $FH;

    print "$self->{_spacecraftTime},";
###    $self->printPrimaryHeader($FH);
    $self->dumpPrimaryHeader();

#    select STDOUT;
}

sub dumpPrimaryHeader {
    my $self = shift;
#    my $FH = shift;
    my $tmp;
 
#    my $old_channel = $~;
#    my $old_filehandle = select $FH if $FH;

#    if ($FH) {
#	select $FH;
#    }

    $self->trace((caller(0))[3]);

    print "$self->{_packetVersion},";
    print "$self->{_packetType},";
    print "$self->{_packetSec_hdr},";
    $tmp = sprintf("0x%04X", $self->{_packetApid});
    print "$tmp,";
    print "$self->{_packetSeq_flag},";
    $tmp = sprintf("0x%04X", $self->{_packetSeq_count});
    print "$tmp,";
    print "$self->{_packetLength}\n";
#    print "BAR";
    return;
}

sub printPrimaryHeaderSummary {
    my $self = shift;
#    my $FH = shift;
    my $tmp;

    $self->trace((caller(0))[3]);

#    select $FH if $FH;

    print $self->{_packetVersion}, ",";
    print $self->{_packetType}, ",";
    print $self->{_packetSec_hdr}, ",";
    print $self->{_packetApid}, ",";
#    $tmp = sprintf("%04X", $self->{_packetApid});
#    print STDOUT "$tmp,";
    print $self->{_packetSeq_flag}, ",";
    print $self->{_packetSeq_count},",";
#    $tmp = sprintf("%04X", $self->{_packetSeq_count});
#    print STDOUT "$tmp,";
    print $self->{_packetLength}, "\n";
#    $tmp = sprintf("0x%08X", $header->{'sc_time'});
#    print STDOUT "Sc time [$tmp]\n";

#    select STDOUT;
}

sub printHeadersSummary {
    my $self = shift;
    my $FH = shift;

    $self->trace((caller(0))[3]);

    select $FH if $FH;

    print $self->{_spacecraftTime}, ",";
###    $self->printPrimaryHeaderSummary($FH);
    $self->printPrimaryHeaderSummary();

    select STDOUT;
}

sub printSecondaryHeader {
    my $self = shift;
    my $tmp = sprintf("0x%08X", $self->{_spacecraftTime});

    $self->trace((caller(0))[3]);

    $self->subclassResponsibility("printSecondaryHeader");
    print STDOUT "$tmp\n";
}

#sub report {
#    my $self = shift;
#    print STDOUT $self->{_numberOfPackets}, " ccsds packets\n";
#}

sub header_decode {
    my $self = shift;
    my @data;

    $self->trace((caller(0))[3]);

#    @data = unpack($endianString{$self->{_endian}}, $self->{_primaryHeader});
    @data = unpack($Ccsds::endianString{$self->{_endian}}, $self->{_primaryHeader});
    $self->{_packetVersion}   = ($data[0] >> 13);
    $self->{_packetType}      = ($data[0] >> 12);
    $self->{_packetSec_hdr}   = ($data[0] >> 11);
    $self->{_packetApid}      = ($data[0] & 0x7FF);
#    $self->{_packetApid}      = sprintf("%04X", ($data[0] & 0x7FF));
    $self->{_packetSeq_flag}  = ($data[1] >> 14);
    $self->{_packetSeq_count} = ($data[1] & 0x3FFF);
    $self->{_packetLength}    = $data[2];

#    $self->{_startPacketOfSequence} = 0;
#    $self->{_isStartPacketOfSequence} = 0;
#    $self->{_middlePacketOfSequence} = 0;
#    $self->{_lastPacketOfSequence} = 0;
#    $self->{_isLastPacketOfSequence} = 0;
#    $self->{_standAlonePacket} = 0;

    if(($self->{_packetSeq_flag} == 1) && ($self->{_mark} == 1)) {
#	$self->{_startPacketOfSequence} = 1;
#	$self->{_isStartPacketOfSequence} = 1;
#	$self->{_mark} = 0;
    }
#    $self->{_middlePacketOfSequence} = 1 if($self->{_packetSeq_flag} == 0);
#    $self->{_isLastPacketOfSequence} = 1 if($self->{_packetSeq_flag} == 2);
#    $self->{_lastPacketOfSequence} = $self->{_packetSeq_flag};
#    $self->{_standAlonePacket} = 1 if($self->{_packetSeq_flag} == 3);
}

sub packetVersion {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_packetVersion};
}

sub packetType {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_packetType};
}

# ???
sub packetSec_hdr {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_packetSec_hdr};
}

sub packetApid {
    my $self = shift;
    my %options = @_;

    $self->trace((caller(0))[3]);

    if ($options{'decoded'}) {
	return sprintf "%x", hex($self->{_packetApid});
    }
    return $self->{_packetApid};
}

sub packetSequenceFlag {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_packetSeq_flag};
}

sub getSequenceCount {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return($self->{_packetSeq_count});
}

sub packetLength {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    
##    return $self->{_packetLength};
    return $self->{_packetLength} + 1;
    $self->subclassResponsibility("packetLength");
    die "Suclass responsibility";
}

sub correctedPacketLength {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    
##    return $self->{_packetLength};
    return $self->{_packetLength} + 1;
    $self->subclassResponsibility("packetLength");
    die "Suclass responsibility";
}

# ???
sub getTime {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_spacecraftTime};
}

sub isFirstPacketOfSequence {
    my $self = shift;
#    return $self->{_packetSeq_flag} == $Ccsds::startPacket;

    $self->trace((caller(0))[3]);

    return Ccsds::isFirstPacketOfSequence($self->{_packetSeq_flag});
}

sub firstPacketOfSequence {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    return $self->{_packetSeq_flag} == $Ccsds::startPacket;
    return Ccsds::isFirstPacketOfSequence($self->{_packetSeq_flag});
}

sub isMiddlePacketOfSequence {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    return $self->{_packetSeq_flag} == $Ccsds::continuationPacket;
    return Ccsds::isMiddlePacketOfSequence($self->{_packetSeq_flag});
}

sub isLastPacketOfSequence {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    return $self->{_packetSeq_flag} == $Ccsds::lastPacket;
    return Ccsds::isLastPacketOfSequence($self->{_packetSeq_flag});
}

sub lastPacketOfSequence {
    my $self = shift;
}

sub isStandAlonePacketOfSequence {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    return $self->{_packetSeq_flag} == $Ccsds::standalonePacket;
    return Ccsds::isStandAlonePacketOfSequence($self->{_packetSeq_flag});
}

sub time_decode {
    my $self = shift;

    $self->trace((caller(0))[3]);

    $self->subclassResponsibility("time_decode");
#    my @data = unpack($timeEndianString{$self->{_endian}}, $self->{_secondaryHeader});
    my @data = unpack($Ccsds::timeEndianString{$self->{_endian}}, $self->{_secondaryHeader});
#    $self->{_spacecraftTime} = sprintf "%08X", (($data[0] << 16) | $data[1]);

    $self->{_spacecraftTime} = sprintf "%10u", (($data[0] << 16) | $data[1]);
}

sub setHeader {
    my $self = shift;
    my $apid = shift;
    my $seq_count = shift;
    my $flag = shift;
    my $len = shift;
    my $buf;
    my @data;

    $self->trace((caller(0))[3]);

    $len += 3;

#    $data[0] = 1;
#    $data[1] = 2;
#    $data[2] = 3;
#    $data[3] = 4;
#    $data[4] = 5;
#    $data[5] = 6;
## Spacecraft time
#    $data[6] = 7;
#    $data[7] = 8;
#    $data[8] = 9;
#    $data[9] = 10;

    $data[0] = (8 | (($apid & 0x7FF) >> 8));
    $data[1] = ($apid & 0xFF);
    $data[2] = (($flag << 6) | (($seq_count & 0x3F00) >> 8));
    $data[3] = ($seq_count & 0xFF);
    $data[4] = (($len & 0xFF00) >> 8);
    $data[5] = ($len & 0xFF);
## Spacecraft time
#    $data[6] = 1;
#    $data[7] = 2;
#    $data[8] = 3;
#    $data[9] = 4;

#    $self->{_header} = pack "C10", @data;
    $self->{_header} = pack "C$self->{_primaryHeaderLength}", @data;
}

1;
