#package CcsdsPacket::EisCcsdsPacket;
package EisCcsdsPacket;

use strict;
use warnings;

#use CCSDS::Ccsds;
use LibCcsds::Ccsds;

#use parent 'CcsdsPacket';
our (@ISA, @EXPORT, $VERSION);
@ISA = qw(Exporter CcsdsPacket);
@EXPORT = ();
$VERSION = 1.00;

sub BEGIN {
    print "BEGIN LibCcsds/CcsdsPacket/EisCcsdsPacket\n";
}

#sub new {
####    my ($class) = @_;
##    my $classname = shift;
##    my $self = $classname->SUPER::new(@_);
##    $self->_init(@_);
##    return $self;
#
#    my ($class) = @_;
#    my $self = {
#		_header => undef,
#	};
#    bless $self, $class; 
#    return $self;
#}
#
#sub _init {
#    my $self = shift;
#    $self->{_header} = undef,
#}

sub eisCcsdsPacket_init {
    my $self = shift;
    my %options = @_;

#    $self->trace("EisCcsdsPacket::init %options");
    my @keys = keys %options;
    my @vals = values %options;
    $self->trace("EisCcsdsPacket::init (@keys : @vals)");
    $self->{_hasSecondaryHeader} = $options{'has_secondary_header'} || 0;
    $self->{_secondaryHeaderLength} = $options{'secondary_header_length'} || 0;
    $self->{_endian} = $options{'endian'} || "big";
    $self->{_spacecraftTime} = "";
    $self->{_secondaryHeader} = "";
#    print "SecondaryHeaderLength: ", $self->{_secondaryHeaderLength}, "\n";
}

#sub create {
#    my $class = shift;
#    my %options = @_;
#    my $self = CcsdsPacket::new($class);
#    $self->init(%options);
#    return $self;
#}

sub new {
    my $classname = shift;
    my $self = $classname->SUPER::new(@_);
#    my $self = $classname->SUPER::create(@_);
    $self->set_trace_flag(1);
    $self->trace("EisCcsdsPacket::new $classname");
#    print "SecondaryHeaderLength: ", $self->{_secondaryHeaderLength}, "\n";
# If SUPER::create used then need this next line
    $self->eisCcsdsPacket_init((hasSecondaryHeader => 1, secondary_header_length => 4));
####    $self->_init((hasSecondaryHeader => 1, secondary_header_length => 4));
    return $self;
}

#sub hasSecondaryHeader {
#    my $self = shift;
#    return $self->{_hasSecondaryHeader};
#}

sub secondaryHeaderLength {
    my $self = shift;
#    print "EisCcsdsPacket: secondaryHeaderLength\n";
    return $self->{_secondaryHeaderLength};
}

sub packetLength {
    my $self = shift;
    
    return ($self->{_packetLength} - 3);
    return ($self->{_packetLength} - ($self->secondaryHeaderLength() - 1));
}

sub readSecondaryHeader {
    my $self = shift;
    my $FH = shift;
    my $res = read($FH,
		   $self->{_secondaryHeader},
		   $self->{_secondaryHeaderLength});    
    return(defined($res)) if(!defined($res));
    return 0 if($res == 0);
    time_decode($self);
    return 1;
}

sub time_decode {
    my $self = shift;
#    my @data = unpack($timeEndianString{$self->{_endian}}, $self->{_secondaryHeader});
    my @data = unpack($Ccsds::timeEndianString{$self->{_endian}}, $self->{_secondaryHeader});
#    $self->{_spacecraftTime} = sprintf "%08X", (($data[0] << 16) | $data[1]);
    $self->{_spacecraftTime} = sprintf "%10u", (($data[0] << 16) | $data[1]);
}

=pod
sub getTime {
    my $self = shift;
    return $self->{_spacecraftTime};
}


sub time_decode {
    my $self = shift;
#    my @data = unpack($timeEndianString{$self->{_endian}}, $self->{_secondaryHeader});
    my @data = unpack($Ccsds::timeEndianString{$self->{_endian}}, $self->{_secondaryHeader});
#    $self->{_spacecraftTime} = sprintf "%08X", (($data[0] << 16) | $data[1]);
    $self->{_spacecraftTime} = sprintf "%10u", (($data[0] << 16) | $data[1]);
}
=cut

sub setHeader {
    my $self = shift;
    my $apid = shift;
    my $seq_count = shift;
    my $flag = shift;
    my $len = shift;
    my $buf;
    my @data;

#    $len += 3;
    $len += ($self->{_secondaryHeaderLength} - 1);

#    $data[0] = 1;
#    $data[1] = 2;
#    $data[2] = 3;
#    $data[3] = 4;
#    $data[4] = 5;
#    $data[5] = 6;
## Spacecraft time
#    $data[6] = 7;
#    $data[7] = 8;
#    $data[8] = 9;
#    $data[9] = 10;

    $data[0] = (8 | (($apid & 0x7FF) >> 8));
    $data[1] = ($apid & 0xFF);
    $data[2] = (($flag << 6) | (($seq_count & 0x3F00) >> 8));
    $data[3] = ($seq_count & 0xFF);
    $data[4] = (($len & 0xFF00) >> 8);
    $data[5] = ($len & 0xFF);
## Spacecraft time
    my $nbytes = $self->{_primaryHeaderLength} + $self->{_secondaryHeaderLength};
    $data[6] = 1;
    $data[7] = 2;
    $data[8] = 3;
    $data[9] = 4;

    $self->{_header} = pack "C$nbytes", @data;
}

1;
