package CcsdsReader;

use strict;
use warnings;

#use IO::Handle;

#use CCSDS::Ccsds;
use LibCcsds::Ccsds;
use LibCcsds::CcsdsInterface;
use LibCcsds::CcsdsPacket;
###use LibCcsds::CcsdsPacket::EisCcsdsPacket;
use Hinode::EIS::EisCcsds::EisCcsdsPacket;
#use CCSDS::Packet::EisPacket;

#use vars qw(@ISA @EXPORT $VERSION); # deprecated
our (@ISA, @EXPORT, $VERSION);
@ISA = qw(Exporter CcsdsInterface);
@EXPORT = (); #qw(setEndian nextPacket printPrimaryHeader);
$VERSION = 1.00;

sub BEGIN {
    print STDOUT "BEGIN LibCcsds/CcsdsReader\n";
}

sub new {
    my $n_args = scalar(@_);
#    my ($classname) = @_;
    my $classname = shift;
    my %options = @_;
#
# Experimental bit if this is inherits from CcsdsInterface
#
    my $self = $classname->SUPER::new(@_);

###    $self->trace_on();
    $self->trace("CcsdsReader::new $classname");

#    print "CcsdsReader new\n";

#    $self->ccsdsReader_init(@_);
    $self->ccsdsReader_init(%options);

    bless $self, $classname; 
#    print "CcsdsReader ($self) new\n";
    return $self;
}

sub ccsdsReader_init {
    my $self = shift;

    my %options = @_;

    my @keys = keys %options;
    my @vals = values %options;

#############    $self->trace("CcsdsReader init : (@keys : @vals)");
    
#    print "CcsdsReader $self init : (@keys : @vals)\n";

#    my $packet;
#    my $instance;
#    if ($n_args == 2) {
##	my $constructor = globals()[$_[1]];
##	$instance = $%constructor();
#    }

    $self->{_packet} = $Ccsds::packet_types{$options{'packet_type'}}->new();
    $self->{_numberOfPackets} = 0;
    $self->{_packetValid} = 0;
    $self->{_firstSequenceCount} = -1;
    $self->{_sequenceCount} = -1;
    if (defined($options{trace})) {
	$self->trace_on() if ($options{trace});
    }
}

sub debug {
    my $self = shift;

    $self->trace((caller(0))[3]);

    print "*** LibCcsds/CcsdsReader::debug start ***\n";
    print "\tNumber of packets    : $self->{_numberOfPackets}\n";
    print "\tPacket valid         : $self->{_packetValid}\n";
    print "\tFirst Sequence count : $self->{_firstSequenceCount}\n";
    print "\tLast Sequence count  : $self->{_sequenceCount}\n";
    $self->SUPER::debug();
    print "--- LibCcsds/CcsdsReader::debug end ---\n";
}

sub gotLastPacketOfSequence {
    my $self = shift;

    $self->trace((caller(0))[3]);

#    my $seq_flag = $self->{_packet}->{_packetSeq_flag};
    my $ret = Ccsds::isLastPacketOfSequence($self->{_packet}->{_packetSeq_flag});
#    print "gotLastPacketOfSequence = $ret ($seq_flag)\n";
    return $ret;
    return Ccsds::isLastPacketOfSequence($self->{_packet}->{_packetSeq_flag});
    return Ccsds::isLastPacketOfSequence($self->{_packet}->packetSequenceFlag());
}

sub test {
    my $self = shift;

    $self->trace((caller(0))[3]);

    print STDOUT "CcsdsReader::test()\n";
}

sub packet {
    my $self = shift;

    $self->trace((caller(0))[3]);

    return $self->{_packet};
}

sub open {
    my $self = shift;
    my $file = shift;

#    print "CcsdsReader: open: verbose = ", $self->verbose(), "\n";
#    $self->set_trace_flag(1);
    $self->trace((caller(0))[3]);
#    $self->trace("CcsdsReader::open $file");

#    print "CcsdsReader: open: trace = ", $self->{_trace_flag}, "\n";
    #$self->debug();
    if ($self->openForReading($file)) {
	$self->{_numberOfPackets} = 0;
	return 1;
    }
    else {
	return 0;
    }
}

# Returns 0 on fail
# Returns 1 on success
sub nextPacket {
    my $self = shift;

    $self->trace((caller(0))[3]);
#    $self->trace("CcsdsReader::nextPacket");

    $self->{_packetValid} = 0;
#    $self->{_packetValid} = $Ccsds::NOK;
    if ($self->{_packet}->nextPacket($self->{_fileHandle})) {
	++$self->{_numberOfPackets};
	$self->{_packetValid} = 1;
	#return sprintf("%u", $self->{_packet}->{_apid});
	$self->{_sequenceCount} = $self->{_packet}->getSequenceCount();
	$self->{_firstSequenceCount} = $self->{_sequenceCount} if $self->{_firstSequenceCount} == -1;
	$self->{_packetValid} = sprintf("%u", $self->{_packet}->packetApid());
#	return sprintf("%u", $self->{_packet}->packetApid());
    }
    # Debug
#    print STDERR "$self nextPacket got 0\n";
#    return 0;
    return $self->{_packetValid};
}

sub nextPacketWithApid {
    my $self = shift;
    my $apid = shift;

    $self->trace((caller(0))[3]);
#    $self->trace("CcsdsReader::nextPacketWithApid");

    while(1) {
	return 0 if($self->nextPacket() == 0);
########	$self->{_sequenceCount} = $self->{_packet}->getSequenceCount();
#$self->{_sequenceCount} = 20;
	last if($self->{_packet}->{_packetApid} == $apid);
    }
    return 1;
}

sub numberOfPackets {
    my $self = shift;

    $self->trace((caller(0))[3]);
#    $self->trace("CcsdsReader::numberOfPackets");

    return $self->{_numberOfPackets};
}

sub closeInput {
    my $self = shift;

    $self->trace((caller(0))[3]);
#    $self->trace("CcsdsReader::closeInput");

    $self->closeFile();
}

sub dumpPacketHeaderTitles {
    my $self = shift;
    my $filename = shift;

    $self->trace((caller(0))[3]);
#    $self->trace("CcsdsReader::dumpPacketHeaderTitles");

    print "$filename\n";
    print "Time, Version, Type, Sec, APID, Flg, Count, Len\n";
}

1;
