package GapCcsdsReader;

use strict;
use warnings;

#use IO::Handle;

#use CCSDS::Ccsds;
use LibCcsds::Ccsds;
use LibCcsds::CcsdsInterface;
use LibCcsds::CcsdsPacket;
use LibCcsds::CcsdsReader;
#use LibCcsds::CcsdsPacket::EisCcsdsPacket;
#use CCSDS::Packet::EisPacket;

#use vars qw(@ISA @EXPORT $VERSION); # deprecated
our (@ISA, @EXPORT, $VERSION);
@ISA = qw(Exporter CcsdsReader);
@EXPORT = (); #qw(setEndian nextPacket printPrimaryHeader);
$VERSION = 1.00;

sub BEGIN {
    print STDOUT "BEGIN LibCcsds/GapCcsdsReader\n";
}

sub new {
    my $n_args = scalar(@_);
#    my ($classname) = @_;
    my $classname = shift;
#    my %options = shift;
#
# Experimental bit if this is inherits from CcsdsInterface
#
#    print "GapCcsdsReader new\n";
    my $self = $classname->SUPER::new(@_);
    $self->trace("GapCcsdsReader::new $classname");
    $self->gapCcsdsReader_init();

    bless $self, $classname; 
#    print "CcsdsReader ($self) new\n";
    return $self;
}

sub gapCcsdsReader_init {
    my $self = shift;

    $self->{_nCcsdsMissing} = 0;
    $self->{_nGaps} = 0;
    $self->{_diff} = 0;
    $self->{_nCcsdsIgnored} = 0;	# Ccsds packets thrown away at start of damaged archive
}

sub debug {
    my $self = shift;

    $self->trace((caller(0))[3]);

    print "*** LibCcsds/GapCcsdsReader::debug start ***\n";
    print "\tPackets missing : $self->{_nCcsdsMissing}\n";
    print "\tPackets ignored : $self->{_nCcsdsIgnored}\n";
    print "\tNumber of gaps  : $self->{_nGaps}\n";
    $self->SUPER::debug();
    print "--- LibCcsds/GapCcsdsReader::debug end ---\n";
}


# This ok for reading mission data archives, not for status archives.
sub nextPacket {
    my $self = shift;

###    Trace::trace((caller(0))[3]);
    $self->trace((caller(0))[3]);
    
#    $self->trace("GapCcsdsReader::nextPacket");

    my $previous_seq_count = $self->{_sequenceCount};
    my $status = $self->SUPER::nextPacket();	# Updates sequenceCount
    return $status if $status == $Ccsds::NOK;
    return $status if ($previous_seq_count == -1);
    my $diff = 0;
    if ($self->{_sequenceCount} < $previous_seq_count) {
	$diff = ($self->{_sequenceCount} + 0x3FFF) - $previous_seq_count;
    }
    else {
	$diff = $self->{_sequenceCount} - $previous_seq_count;
    }
#print "DIFF = $diff ($self->{_sequenceCount}, $previous_seq_count)\n";
#    my $diff = $previous_seq_count - $self->{_sequence_count};
    --$diff;
    $self->{_diff} = $diff;

    return $status if (abs($diff) == $Ccsds::MAX_SEQUENCE_COUNT);
    return $status if ($diff == 0); # Wrap around from max count to 0

    if ($diff != 0) {
	$self->{_nCcsdsMissing} += $diff;
###	print "DIFF = $diff ($self->{_sequenceCount}, $previous_seq_count)\n";
	++$self->{_nGaps};
    }
    return $status;
}

# Good for status packet archives
sub nextPacketWithApid {
    my $self = shift;
    my $apid = shift;
    my $status = 0;

    $self->trace((caller(0))[3]);

#print "GapCcsdsReader : nextPacketWithApid : Looking for $apid\n";
#    $self->trace("GapCcsdsReader::nextPacketWithApid");
    my $previous_seq_count_start = $self->{_sequenceCount};

    while(1) {
	$status = $self->SUPER::nextPacket();	# Updates sequenceCount
	last if ($status == 0);
	if ($self->{_packet}->{_packetApid} == $apid) {
#	    $status = $self->SUPER::nextPacket();
	    last if $status == $Ccsds::NOK;
	    last if ($previous_seq_count_start == -1);
#	    my $previous_seq_count = $self->{_sequenceCount};
	    my $previous_seq_count = $previous_seq_count_start;
	    my $diff = $self->{_sequenceCount} - $previous_seq_count;
#print "DIFF = $diff ($self->{_sequenceCount}, $previous_seq_count)\n";
	    $previous_seq_count_start = $previous_seq_count;
#    my $diff = $previous_seq_count - $self->{_sequence_count};
	    last if (abs($diff) == $Ccsds::MAX_SEQUENCE_COUNT);
	    if ($diff != 1) {
		$self->{_nCcsdsMissing} += $diff;
		++$self->{_nGaps};
	    }
	    last;
#	    return $status;
	}
    }
    return $status;
    return 1;
=pod
    # Can't do this as perl will call GapCcsdsReader->nextPacket()... so have to repeat SUPER's code here...
    $status = $self->SUPER::nextPacketWithApid($apid);

    return $status;

    return $status if $status == 0; #$Ccsds::NOK;
    if($status == 1) {
	return $status if ($previous_seq_count == -1);
	my $diff = $self->{_sequenceCount} - $previous_seq_count;
	print "DIFF = $diff ($self->{_nCcsdsMissing})\n";
	return $status if (abs($diff) == $Ccsds::MAX_SEQUENCE_COUNT);
	if ($diff != 1) {
	    $self->{_nCcsdsMissing} += $diff;
	}
    }
    return $status;
=cut
}

=pod
sub numberOfPackets {
    my $self = shift;
    $self->trace("CcsdsReader::numberOfPackets");
    return $self->{_numberOfPackets};
}

sub closeInput {
    my $self = shift;

    $self->trace("CcsdsReader::closeInput");
    $self->closeFile();
}
=cut

sub dumpHeaders {
    my $self = shift;
#    my $FH   = shift;

    $self->trace((caller(0))[3]);

###    select $FH if $FH;
    if ($self->{_diff} != 0) {
	my $str = ($self->{_diff} == 1) ? "packet" : "packets";
	print "*** $self->{_diff} $str missing\n" unless $self->{_diff} == 0;
#	return;
    }
    print $self->{_packet}->dumpHeaders();

#    select STDOUT;
}

sub dumpStats {
    my $self = shift;
#    my $FH   = shift;

    $self->trace((caller(0))[3]);

#    select $FH if $FH;

    print "$self->{_numberOfPackets} ccsds packets\n";
    print "Number of gaps: $self->{_nGaps}\n";
    print "Number of packets missing: $self->{_nCcsdsMissing}\n\n";

#    select STDOUT;
}

1;
