#!/usr/bin/env perl

use strict;
use warnings;

#use LibCcsds;
#use LibCcsds::CcsdsPacket;
use LibCcsds::CcsdsReader;
use LibCcsds::GapCcsdsReader;
#use LibCcsds::CcsdsPacket::EisCcsdsPacket;
use Hinode::EIS::EisCcsds::EisCcsdsPacket;

print "\nCreating reader with CcsdsReader->new(packet_type => 'Eis');\n";
my $reader = CcsdsReader->new(packet_type => 'Eis');

print "primary header len ", $reader->{_packet}->primaryHeaderLength(), "\n";
print "secondary header len ", $reader->{_packet}->secondaryHeaderLength(), "\n";

if ($reader->open("/Users/mcrw/work/localdata/md/decompression/output/eis_md_20150404_2003206678")) {
    print "Opened\n";
    my $count = 0;
    while(1) {
	last unless $reader->nextPacket();
#	$reader->packet()->printHeaders();
	$reader->{_packet}->printHeaders();
	++$count;
    }
    $reader->closeInput();
    print "Closed\n";
    print "$count ccsds packets\n";
}
$reader->debug();

if ($reader->open("/Users/mcrw/work/localdata/sdtp/merge/data/received/md/eis_md_20150404_2003206678")) {
    print "Opened\n";
    my $count = 0;
    while(1) {
	last unless $reader->nextPacket();
#	$reader->packet()->printHeaders();
	$reader->{_packet}->printHeaders();
	++$count;
    }
    $reader->closeInput();
    print "Closed\n";
    print "$count ccsds packets\n";
}
$reader->debug();
